# generated by datamodel-codegen:
#   filename:  system/message.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional

from pydantic import BaseModel, Field


class Name(Enum):
    job = "job"
    unit = "unit"


class Probe(Enum):
    monitor = "monitor"
    postprocessor = "postprocessor"


class Entity(BaseModel):
    field_id: str = Field(..., alias="_id")
    """
    job identifier
    """
    name: Name
    """
    entity name.
    """
    flowchartId: Optional[str] = None
    """
    unit identifier within the workflow
    """
    probe: Optional[Probe] = None
    """
    source of the message.
    """


class Header(BaseModel):
    entity: Entity
    version: str
    """
    Rupy-Webapp communication schema version.
    """
    timestamp: float
    """
    Timestamp of the message.
    """


class MessageSchema(BaseModel):
    header: Header
    payload: Dict[str, Any]
    """
    Actual payload of the message.
    """
