# generated by datamodel-codegen:
#   filename:  workflow/unit/io/object_storage.json
#   version:   0.28.5

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, ConfigDict, Field


class ObjectStorageContainerData(BaseModel):
    CONTAINER: Optional[str] = None
    """
    Object storage container for the file
    """
    NAME: Optional[str] = None
    """
    Name of the file inside the object storage bucket
    """
    PROVIDER: Optional[str] = None
    """
    Object storage provider
    """
    REGION: Optional[str] = None
    """
    Region for the object container specified in Container
    """
    SIZE: Optional[int] = None
    """
    Size of the file in bytes
    """
    TIMESTAMP: Optional[str] = None
    """
    Unix timestamp showing when the file was last modified
    """


class ObjectStorageIoSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    objectData: ObjectStorageContainerData = Field(..., title="Object Storage Container Data")
    overwrite: Optional[bool] = False
    """
    if a file with the same filename already exists, whether to overwrite the old file
    """
    pathname: Optional[str] = None
    """
    Relative path to the directory that contains the file.
    """
    basename: Optional[str] = None
    """
    Basename of the file
    """
    filetype: Optional[str] = None
    """
    What kind of file this is, e.g. image / text
    """
