# generated by datamodel-codegen:
#   filename:  workflow/unit/map.json
#   version:   0.28.5

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field


class Type(Enum):
    map = "map"


class Input(BaseModel):
    target: str
    """
    Name of the target variable to substitute using the values below. e.g. K_POINTS
    """
    scope: Optional[str] = None
    """
    Scope to retrieve `values` from, global or flowchartId. Optional if `values` is given.
    """
    name: Optional[str] = None
    """
    Name of the variable inside the scope to retrieve `values` from. Optional if `values` is given.
    """
    values: Optional[List[Union[str, float, Dict[str, Any]]]] = None
    """
    Sequence of values for the target Jinja variable. Optional if `scope` and `name` are given. This can be used for map-reduce type parallel execution
    """
    useValues: Optional[bool] = None


class Status(Enum):
    idle = "idle"
    active = "active"
    warning = "warning"
    error = "error"
    finished = "finished"


class NameResultSchema(BaseModel):
    name: str
    """
    The name of this item. e.g. scf_accuracy
    """


class StatusTrackItem(BaseModel):
    trackedAt: float
    status: str
    repetition: Optional[float] = None


class MapUnitSchema(BaseModel):
    model_config = ConfigDict(
        extra="allow",
    )
    type: Type
    """
    type of the unit
    """
    workflowId: str
    """
    Id of workflow to run inside map
    """
    input: Input
    """
    Input information for map.
    """
    field_id: Optional[str] = Field(None, alias="_id")
    """
    entity identity
    """
    isDraft: Optional[bool] = None
    name: Optional[str] = None
    """
    name of the unit. e.g. pw_scf
    """
    status: Optional[Status] = None
    """
    Status of the unit.
    """
    head: Optional[bool] = None
    """
    Whether this unit is the first one to be executed.
    """
    flowchartId: str
    """
    Identity of the unit in the workflow. Used to trace the execution flow of the workflow.
    """
    next: Optional[str] = None
    """
    Next unit's flowchartId. If empty, the current unit is the last.
    """
    enableRender: Optional[bool] = None
    """
    Whether Rupy should attempt to use Jinja templating to add context variables into the unit
    """
    context: Optional[Dict[str, Any]] = None
    slug: Optional[str] = None
    """
    entity slug
    """
    systemName: Optional[str] = None
    schemaVersion: Optional[str] = "2022.8.16"
    """
    entity's schema version. Used to distinct between different schemas.
    """
    isDefault: Optional[bool] = False
    """
    Identifies that entity is defaultable
    """
    preProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the pre-processors for this calculation
    """
    postProcessors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the post-processors for this calculation
    """
    monitors: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the monitors for this calculation
    """
    results: Optional[List[Union[NameResultSchema, str]]] = None
    """
    names of the results for this calculation
    """
    tags: Optional[List[str]] = None
    """
    entity tags
    """
    statusTrack: Optional[List[StatusTrackItem]] = None
