Dynamical Network Analysis
===========================

![last release](https://img.shields.io/gitlab/v/release/comp-biochem-csu/dynetan)
[![PyPI](https://img.shields.io/pypi/v/dynetan)](https://pypi.org/project/dynetan/)
[![Read-The-Docs Status](https://readthedocs.org/projects/dynamical-network-analysis/badge/?version=latest)](https://dynamical-network-analysis.readthedocs.io/en/latest/?badge=latest)
[![CI/CD Status](https://img.shields.io/gitlab/pipeline-status/comp-biochem-csu/dynetan)](https://gitlab.com/comp-biochem-csu/dynetan/-/pipelines)
[![Codecov](https://codecov.io/gl/comp-biochem-csu/dynetan/branch/master/graph/badge.svg)](https://codecov.io/gl/comp-biochem-csu/dynetan)
![License](https://img.shields.io/gitlab/license/comp-biochem-csu/dynetan)


The Python implementation of Dynamical Network Analysis was built to provide all
functionalities necessary to the analysis of Molecular Dynamics (MD) simulations
using the Dynamical Network Analysis method.

Install
-------

Install the latest version of Dynamical Network Analysis:

    $ pip install dynetan

For additional details, please see `INSTALL.md`.

Tutorial
--------

Several jupyter notebook tutorials have been prepared as an introduction to this package and were released in an independent repository:

https://gitlab.com/comp-biochem-csu/dynetan_tutorial

Documentation
------------------------

The full documentation can be found at
https://dynamical-network-analysis.readthedocs.io/en/latest/index.html

Resources and References
------------------------

For the background on Dynamical Network Analysis, see the following papers that
describe its development:

* [Generalized correlation-based dynamical network analysis: a new
high-performance approach for identifying allosteric communications in molecular
dynamics trajectories. J. Chem. Phys. (2020).
DOI: 10.1063/5.0018980](https://doi.org/10.1063/5.0018980)

* [Experimental and computational determination of tRNA dynamics. FEBS Letters
(2010). DOI: 10.1016/j.febslet.2009.11.061](https://doi.org/10.1016/j.febslet.2009.11.061)

* [Exit strategies for charged tRNA from GluRS. JMB (2010).
DOI: 10.1016/j.jmb.2010.02.003](https://doi.org/10.1016/j.jmb.2010.02.003)

* [Dynamical Networks in tRNA:protein complexes. PNAS (2009).
DOI: 10.1073/pnas.0810961106](https://doi.org/10.1073/pnas.0810961106)
