#!/usr/bin/env python
# -*- coding: utf-8 -*-

from notmm.dbapi.orm import decorators
from notmm.http.decorators import post_required
from notmm.utils.template import direct_to_template

@post_required
@decorators.with_schevo_database('moviereviews')
def test_schevo_database(request, **kwds):
    db = request.environ['schevo.db.moviereviews']
    assert request.method is 'POST', request.method
    assert 'schevo.db.moviereviews' in request.environ.keys()
    assert db.format == 2, 'invalid db format: %d' % db.format
    assert hasattr(db, 'Q'), 'db has no Q attribute!'
    
    #Q = db.Q
    #movies = (item for item in db.Movie.find())
    db.close()
    return direct_to_template(request, template_name='sandbox/test.mako', 
        status=200)
    
