![booklab_logo](../pictures/booklab_logo.png){ width="55" align=left }
<small markdown>**BookLab System**<br>
*(c) 2023 RENware Software Systems*
</small><br><br>


# TMPL sablon carte noua


***Cuprins:***

[TOC]

***

## Sablonul pentru o carte noua

Acesta reprezinta sablonul (template) folosit in procesul de creare a unei carti noi (proces `NEWB`). Acest sablon contine urmatoarele elemente:

* *sectiunile (documentele) de start ale cartii* - pagina de `index.md` si documentul PDF final, ambele goale dar minim necesare in inceperea cartii

* *scripturile comenzi management carte* - reprezinta scripturile cu comenzile necesare pentru managementul si "operarea" acelei carti:
    * generarea temporara (de lucru) a cartii pentru previzualizare
    * generarea si asamblarea finala a cartii
    * pornirea serverului de previzualizare (server local HTTP)
    * monitorizarea fisierelor locale in timpul previzualizarii pentru a detectat eventuale modificari facute de utilizator

* *baza de date a cartii* este baza de date cu detaliile unei carti, baza de date ce este referentiata din [sectiunea catalogul cartilor](#catalogul-cartilor-baza-de-date). Continutul brut al [bazei de date cu catalogul cartilor](../data/books_catalog.json)

!!! info "Localizarea modulului"
    Acest modul este localizat in directorul `book_<cod_carte>` numele acestuia construit in felul urmator:

    * prefixul `book_` este un sir de caractere constant
    * sufixul `<cod_carte>` este reprezentat de atributul (cheia) `"code"` din baza de date de carti (`data/books_catalog.json`) iar **case-ul = majuscule, minuscule** NU CONTEAZA - se va considera (coverti) intodeauna la minuscule (lowercase)

    Acest director va fi numit generic **`<book_directory>`** in materiale / documentatie.




## Scripturile executabile pentru carte

Aceasta sectiune enumera si descrie sumar fisierele ce contin scripturile (comenzile) executabile aferente unei carti. Aceste comenzi sunt aceleasi pentru orice carte (motiv pentru care se gasesc in sablonul de carte).

Fiecare script (comanda) poate primi ca parametru de intrare (si daca il primeste este *pozitional si primul*) **identificatorul cartii sub forma atributului / cheii `code`** din baza de date cu carti (`<PROJECT_ROOT>/data/books_catalog.json`).

Fisierele ce contin comenzi executabile sunt *localizate in radacinta sablonului* si au *numele* de forma **`bkcmd_...`** iar *extensia* corespunzatoare limbajului de programare in care sunt scrise (py, sh, etc). Toate aceste fisiere subt direct executabile (`chmod +x`) si respecta conventia `Bash Linux` referitoare la *prima linie respectiv "shebang" (`#!`)*.

Lista fisierelor cu comenzi executabile (listare in ordine alfanumerica):

**`bkcmd_assembly_cfg_file.sh`**
: asambleaza fisierul de configurare a cartii din partile componente, [vezi sectiunea "Fisierul de configurare a cartii"](#fisierul-de-configurare-a-cartii)

**`bkcmd_gen_final_book.py`**
: wip...tbd... <!---#TODO...-->

**`bkcmd_render_cfg_file.py`**
: randeaza (*engl: rendering*) fisierul de configurare a cartii (`book_mkdocs.yml.tmpl`) transformind toate cimpurile *Jinja* in valorile finale aduse din baza de date a cartii rezultind fisierul **`book_mkdocs.yml`**

**`bkcmd_start_book_preview.py`**
: wip...tbd... <!---#TODO...-->

**`bkcmd_start_book_preview.sh`**
: wip...tbd... <!---#TODO...-->

<!--
**`#TODO another script here...`**
: -#TODO...
-->


<!-- #FIXME - drop image when finish -->
![wip page](../pictures/under_maintenance.png){ width="200" } ...UPCOMING new scripts...





## Directoarele de lucru

Sablonul cartii contine urmatoarele directoare (ordine alfanumerica):

* **`<directory_root>`** - contine [scripturile executabile aferente cartii](#scripturile-executabile-pentru-carte) si [fisierul de configurare a acesteia](#fisierul-de-configurare-a-cartii)

* **`book_config_parts`** - contine parti (sectiuni) din fisierul de configurare a cartii ce permit o mai usoara modificare a sectiunilor - acestea vor fi asamblate intr-un singur fisier (`book_mkdocs.yml`)

* **`my_book`** - va contine cartea final generata sub forma de site static utilizabil ca atare (prin copiere in directorul "`www root`" al serverului HTTP)

* **`preview_book`** - contine generari temporare ale cartiii asamblate si este utilizat in scop de *pre-vizualizare* a cartii in timpul lucrului la aceasta - ca optiune, directorul este monitorizat de serverul HTTP local de prevzualizare astfel incit modificarile in "sursa cartii" sa fie prezentate live

* **`raw_source_docs`** - contine fisierele "sursa" a cartii (in principiu fisiere Markdown si Jupiter Notebook)









## Fisierul de configurare a cartii

### Asamblarea fisierului de configurare a cartii

Fisierul de configurare a cartii este format din mai multe fisiere / parti (ce contin sectiuni distincte) ce permit o mai usoara modificare a sectiunilor - acestea vor fi asamblate intr-un singur fisier (book_mkdocs.yml). Procesul de generare a fisierului de configurare comporta mai multe faze:

* asamblarea fisierului din partile componente si crearea unui fisier care este o forma intermediara de "template `Jinja`". Acesta contine coduri `Jinja` ce vor fi inlocuite mai triziu cu valorile reale din baza de date (pe masura ce sunt disponibile)

* randarea fisierului intermediar "template `Jinja`" si obtinerea fisierului de configurare FINAL cu informatiile reale

* cei doi pasi ai procesului sunt reprezentati de comenzi diferite astfel incit pot fi utilizate independent in functie de necesitati

* **Localizarea fisierelor** de configurare a cartii
    * *fisierul FINAL de configurare*: `<book_directory>/book_mkdocs.yml`
    * *fisierul temporar de configurare*: `<book_directory>/book_mkdocs.yml.tmpl` <small markdown>(*NOTA:* acest fisier este in mod normal sters dupa generarea fisierului final de configurare)</small>



### Sectiunea "HEAD" (informatii generale si copyright)

>**LOCALIZARE:** `<book_directory>/book_config_parts/cfg_01_head_yml_section.yml`

Aceasta sectiune contine partea de informatii generale despre carte (nume, autor) si informatia referitoare la copyright-ul cartii (ce va apare in subsolul acesteia). Aceste informatii sunt sub forma unor cimpuri Jinja ce vor fi actualizate (rendering) la generarea cartii efective.

!!! info "Informatiile tip sablon Jinja din fisierul de configurare"
    Aceste informatii sunt prezentate mai jos.Se indica si cheia din fisierul de date JSON aferente:

    {% raw %}
    * `{{ book.short_desc }}` == JSON short_desc
    * `{{ book.site_author }}` == JSON site_author
    * `{{ book.copyright }}` == JSON copyright
    {% endraw %}



### Sectiunea "NAVIGATION" (strutura meniu navigare)

>**LOCALIZARE:** `<book_directory>/book_config_parts/cfg_02_nav_yml_section.yml`

Aceasta sectiune contine elementele de navigare ce vor apare in `navigation bar(s) - top, left si right`:

* denumirile ce vor apare in meniuri si fisierele PDF
* link-urile catre documentele (paginile) chemate sau catre alte site-uri (URL-uri externe)
* ordinea de afisare a acestora atit in meniu cit si cuprinsul in documentele PDF asamblate

<!-- #TODO describe efective details -->

![wip page](../pictures/under_maintenance.png){ width="200" }

-#TODO... UPCOMING with detailed information...



### Sectiunea "EXTENSIONS" (extensiile si modulele Python)

>**LOCALIZARE:** `<book_directory>/book_config_parts/cfg_03_extension_yml_section.yml`

Aceasta sectiune contine partea de module / extensii Python necesare pentru renderingul fisierelor `markdown` (diverse extensii si add-on-uri la formatul markdoen standard).

<!-- #TODO describe efective details -->

![wip page](../pictures/under_maintenance.png){ width="200" }

-#TODO... UPCOMING with detailed information...



### Sectiunea "WORK DIRECTORIES" (directoarele de lucru)

>**LOCALIZARE:** `<book_directory>/book_config_parts/cfg_04_dirs_yml_section.yml`

Aceasta sectiune contine numele directoarelor de lucru ale "sistemului `mkdocs`" cele mai importante fiind directorul de generare temporara (pentru verificare) si directorul de generare si asamblare finala site carte si PDF "bun de tipar"

<!-- #TODO describe efective details -->

![wip page](../pictures/under_maintenance.png){ width="200" }

-#TODO... UPCOMING with detailed information...




## Alte fisiere

In directorul ce contine sablonul cartii se mai gasesc urmatoarele fisiere:

* CNAME ...#TODO
* ...#TODO

![wip page](../pictures/under_maintenance.png){ width="200" }

-#TODO... UPCOMING...



