[TOC]

booklab"></a>

# booklab

**booklab** main python package for Booklab system

Consists of the following sub-packages:

- `booklab-cli` which is a CLI application to manage system
- `booklabd` designed to serve `/api/.../` system routes that need database write access
- `conf` containing configuration files for different system components including infrastructure ones like gunicorn or nginx
- `doc_src` contains the source of static site directory as Markdown files
- `docs/` contains rhe static site compiled and "ready to use as-is" with any standard HTTP server
- `doc-techical` containing system usage documentation (aka api interface)
- `my_books` contains the end user created & generated books and `books_catalog.json` with info about all user books


- `scripts/` contains various scrpts usefull in system administrarion (install, maintain, confifure, etc)

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.booklab_cli"></a>

# booklab.booklab\_cli

Booklab CLI module to assure system operatins as command line.

Usage:

    booklab -v
    booklab setup <options>
    booklab init <options>
    booklab server (run|stop|restart)
    booklab catalog
    booklab status <my-book>
    booklab new
    booklab build <my-book>
    booklab preview <my-book>
    booklab deploy <my-book>
    booklab page-edit <my-book>
    booklab page-upload <my-book>
    booklab page-upload <my-book>
    vooklab edit-nav[igation] <my-book>
    booklab pack <my-book>

Options:

    -l, --list    List books catalog
    -s, --status  Display detailes about a book
    -v, --version Display booklab application version




Architecture; Linux standard (POSIX) CLI

Author; Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.booklab_cli.cmd_xxx"></a>

# booklab.booklab\_cli.cmd\_xxx

Command xxx definition.

<a id="booklab.booklab_cli.param_types"></a>

# booklab.booklab\_cli.param\_types

Define parameters used by CLI app.

Parameters definition as used by
`Typer` framework in parameters definition
and described through `Annotated` class.

<a id="booklab.conf"></a>

# booklab.conf

Cnfigurations component contains various system components configuration files:

- `gunicorn` WSGI web server
- `nginx` local proxy HTTP

Notes / remarks:

- files wirh `.py` extension are considered Python files and can be imported accordingly as longas they are valid Python-code.
- all files from here are assumed to be _text files_. Any deviation from this rule is assumed to be treated accordingly in code.

Author; Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.conf.gunicorn_config"></a>

# booklab.conf.gunicorn\_config

Configuration file for gunicorn in serving `booklabd` server application

This is a Python file that will be executed by gunicorn at run-time.
As consequence declare all assignements as valid Python code.

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.conf.booklab_ext_url"></a>

# booklab.conf.booklab\_ext\_url

This Python file contains external access URL information.
By external access is understood all URL parts necessary to expose Booklab application:

* EXT_SERVER - the external exposed server name and port if diffrent than standard default (80 or 443) (example: "booklab.mydomain.ro")
* EXT_PATH - the external exposed URL of configured start locations through a LAN main proxy (example: "/booklab/" for a complete external URL like http://booklab.mydomain.ro:5002/booklab/)

_NOTE: all information are of string type_

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.my_books.book_template"></a>

# booklab.my\_books.book\_template

Contains the book template used when create a new book (`newb` funxtion, `/api/newb/` booklabd route).

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.my_books"></a>

# booklab.my\_books

This component contains all defined books as individual directories, each one with all definions initiated from `book_template/` directory

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.my_books.books_manager"></a>

# booklab.my\_books.books\_manager

<a id="booklab.my_books.books_manager.MyBook"></a>

## MyBook Objects

```python
class MyBook()
```

Class that manage end user books.

**Important properties:**

- `MY_BOOK_URL`: url to redirect to access book static site (preview book)
- `MY_BOOK_PATH`: file-parh to book root location

author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.my_books.books_manager.MyBook.__init__"></a>

#### \_\_init\_\_

```python
def __init__(flask_app: Flask, db: pysondb, book_code: str)
```

Init an instance of class MyBook

<a id="booklab.my_books.books_manager.MyBook.getBook"></a>

#### getBook

```python
def getBook() -> dict | None
```

Check for a given book code that is not None, exists in database and is exactly 1 record.

**Returns**:

  
  - `dict` with found record or `None` if any of conditiona is not met

<a id="booklab.my_books.books_manager.MyBook.getBookNav"></a>

#### getBookNav

```python
def getBookNav(format=None) -> None | dict | str
```

Get book navigation.

Navigation info is retrieved from `book_navigation.json` data-file
identified by `self.db_book_nav` pysondb handler.

**Returns**:

  
  - `python dict` using `format = "dict"` (default option)
  - `JSON str` using `format = "json"`
  - `YAML str` using `format = "yaml"`
  - `None` if not known format

<a id="booklab.my_books.books_manager.MyBook.wrBookNav"></a>

#### wrBookNav

```python
def wrBookNav() -> bool
```

Write out file "book_navigation.yml"

**Returns**:

  
  - `True` if file was written
  - `False` if file was not written doesn't matter why (usual problem is source file)

<a id="booklab.my_books.books_manager.MyBook.getBookPath"></a>

#### getBookPath

```python
def getBookPath() -> str
```

Get absolute path of current book root directory.

<a id="booklab.my_books.books_manager.MyBook.getBookURL"></a>

#### getBookURL

```python
def getBookURL() -> str
```

Get preview URL (redirectable as is) for current book_code.

<a id="booklab.my_books.books_manager.MyBook.renderBookConfig"></a>

#### renderBookConfig

```python
def renderBookConfig(out_file: str = "mkdocs.yml") -> bool
```

Render current book configuration file used in static site generation.

<a id="booklab.doc_src"></a>

# booklab.doc\_src

Booklab master static site:

* `doc_src/` markdown source files
* `docs/` generated static site ready to be used as is with any standard HTTP server

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.scripts"></a>

# booklab.scripts

Booklab utility scripts that solve various aspects in installing, configuring and running Booklab system / application.

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.__version__"></a>

# booklab.\_\_version\_\_

**__version__.py** module that contains Booklab aplication version number.

NOTE: this module is imported and made "public" in `booklab._init__.py`

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.booklabd.publisher"></a>

# booklab.booklabd.publisher

<a id="booklab.booklabd.publisher.publish"></a>

#### publish

```python
def publish()
```

Decorator the publishes the Flask function, wiring up arguments to the incoming request.

The function arguments are inspected and used to extract the values from the request
GET/POST data (via request.values).  If type annotations are specified, the incoming
values will be instantiated as that type.  If "**kwargs" is included, remaining GET/POST
values are placed there, otherwise they are ignored.

**Example**:

  
  @app.route("/somewhere")
  @publish()
  def somewhere(gender:str, age:int=None):
  return jsonify(gender=gender, age=age)

<a id="booklab.booklabd.routes"></a>

# booklab.booklabd.routes

Module that serve `booklabd` interface api-functions as HTTP routes

Important variables:

- `booklab.boolabd.api_app`: web application object (aka Flask.app)

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.booklabd.routes.api_newb"></a>

#### api\_newb

```python
@api_app.route("/api/newb/")
def api_newb()
```

Serve _New book (newb)_ functionality.

<a id="booklab.booklabd.routes.api_bstatus"></a>

#### api\_bstatus

```python
@api_app.route("/api/bstatus/")
def api_bstatus(book_code: str = ...)
```

Serve _Book status (bstatus)_ functionality.

**Query parameters:** `code` for database `boook_code`

<a id="booklab.booklabd.routes.api_edtb"></a>

#### api\_edtb

```python
@api_app.route("/api/edtb/")
def api_edtb(book_code: str = ...)
```

Serve _Book edit (edtb)_ functionality.

**Query parameters:** `code` for database `boook_code`

<a id="booklab.booklabd.routes.api_orgm"></a>

#### api\_orgm

```python
@api_app.route("/api/orgm/")
def api_orgm(book_code: str = ...)
```

Serve _Book structure & navigation organization (orgm)_ functionality.

**Query parameters:** `code` for database `boook_code`

<a id="booklab.booklabd.routes.api_prvb"></a>

#### api\_prvb

```python
@api_app.route("/api/prvb/")
def api_prvb(book_code: str = ...)
```

Serve _Book preview (prvb)_ functionality.

**Query parameters:** `code` for database `boook_code`

<a id="booklab.booklabd.routes.api_bbld"></a>

#### api\_bbld

```python
@api_app.route("/api/bbld/")
def api_bbld(book_code: str = ...)
```

Serve _Book build (bbld)_ functionality.

**Query parameters:** `code` for database `boook_code`

<a id="booklab.booklabd.routes.api_dplb"></a>

#### api\_dplb

```python
@api_app.route("/api/dplb/")
def api_dplb(book_code: str = ...)
```

Serve _Book delivery (dplb)_ functionality.

**Query parameters:** `code` for database `boook_code`

<a id="booklab.booklabd.routes.api_bcat"></a>

#### api\_bcat

```python
@api_app.route("/api/bcat/")
def api_bcat()
```

Serve _Books catalog (bcat)_ functionality.

<a id="booklab.booklabd.routes.version"></a>

#### version

```python
@api_app.route("/api/version/")
def version()
```

Return Booklab application version as pure plain raw text (no html).

<a id="booklab.booklabd.routes.index"></a>

#### index

```python
@api_app.route("/")
def index()
```

Serve accessing Home route.
This route is an alternate option way (but usually the expected one from an end user) to access static site main / home page.

<a id="booklab.booklabd.routes.about"></a>

#### about

```python
@api_app.route("/api/about/")
def about()
```

Construct and request for "About Booklab" page.

<a id="booklab.booklabd.app_init"></a>

# booklab.booklabd.app\_init

**app_init** module that initialize `booklabd` application

This module is designed to initialize the main web application object `api_app`.

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.booklabd.app_init.init_app"></a>

#### init\_app

```python
def init_app(app_name: str, static_site_dir: str, templates_dir: str,
             pjroot_location: str) -> Flask
```

Create Flask application object and return it

**Arguments**:

  
- ``app_name`` - name of web application objwcr
- ``static_site_dir`` - directory used by Flask app to render Jinja templates
- ``templates_dir`` - directory name where templates are to becfound (relative to pjroot_location)
- ``pjroot_location`` - project root directory (relative to pjroot_location)
  

**Returns**:

  
  web application object

<a id="booklab.booklabd"></a>

# booklab.booklabd

booklabd - Booklab API server module

Main functionalities:
* operate & manage JSON database file
* provide necessary http API routes fir book functionalities that need write & dynamic (run-time) behavior

Architecture; HTTP WSGI

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.docs"></a>

# booklab.docs

Booklab master static site:

* `doc_src/` markdown source files
* `docs/` generated static site ready to be used as is with any standard HTTP server

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.__main__"></a>

# booklab.\_\_main\_\_

... wip ...
modules to be launched at package call with `-m` option

<a id="booklab.db_init"></a>

# booklab.db\_init

Module that initialize `booklabd` database (more JSON files)

This module is designed to initialize database objects `db_books` and `db_system`.

Author: Petre Iordanescu (petre.iordanescu@gmail.com)

<a id="booklab.db_init.init_db"></a>

#### init\_db

```python
def init_db() -> tuple[pysondb]
```

Create db_books, db_system objects and return them as tuple

**Returns**:

  
  `(db_books, db_system)` tuple of pysondb object

