import aglfn
import string

import pytest

values_to_test = [
    ("A", "A"),
    ("AE", "Æ"),
    ("AEacute", "Ǽ"),
    ("Aacute", "Á"),
    ("Abreve", "Ă"),
    ("Acircumflex", "Â"),
    ("Adieresis", "Ä"),
    ("Agrave", "À"),
    ("Alpha", "Α"),
    ("Alphatonos", "Ά"),
    ("Amacron", "Ā"),
    ("Aogonek", "Ą"),
    ("Aring", "Å"),
    ("Aringacute", "Ǻ"),
    ("Atilde", "Ã"),
    ("B", "B"),
    ("Beta", "Β"),
    ("C", "C"),
    ("Cacute", "Ć"),
    ("Ccaron", "Č"),
    ("Ccedilla", "Ç"),
    ("Ccircumflex", "Ĉ"),
    ("Cdotaccent", "Ċ"),
    ("Chi", "Χ"),
    ("D", "D"),
    ("Dcaron", "Ď"),
    ("Dcroat", "Đ"),
    ("Delta", "∆"),
    ("E", "E"),
    ("Eacute", "É"),
    ("Ebreve", "Ĕ"),
    ("Ecaron", "Ě"),
    ("Ecircumflex", "Ê"),
    ("Edieresis", "Ë"),
    ("Edotaccent", "Ė"),
    ("Egrave", "È"),
    ("Emacron", "Ē"),
    ("Eng", "Ŋ"),
    ("Eogonek", "Ę"),
    ("Epsilon", "Ε"),
    ("Epsilontonos", "Έ"),
    ("Eta", "Η"),
    ("Etatonos", "Ή"),
    ("Eth", "Ð"),
    ("Euro", "€"),
    ("F", "F"),
    ("G", "G"),
    ("Gamma", "Γ"),
    ("Gbreve", "Ğ"),
    ("Gcaron", "Ǧ"),
    ("Gcircumflex", "Ĝ"),
    ("Gdotaccent", "Ġ"),
    ("H", "H"),
    ("H18533", "●"),
    ("H18543", "▪"),
    ("H18551", "▫"),
    ("H22073", "□"),
    ("Hbar", "Ħ"),
    ("Hcircumflex", "Ĥ"),
    ("I", "I"),
    ("IJ", "Ĳ"),
    ("Iacute", "Í"),
    ("Ibreve", "Ĭ"),
    ("Icircumflex", "Î"),
    ("Idieresis", "Ï"),
    ("Idotaccent", "İ"),
    ("Ifraktur", "ℑ"),
    ("Igrave", "Ì"),
    ("Imacron", "Ī"),
    ("Iogonek", "Į"),
    ("Iota", "Ι"),
    ("Iotadieresis", "Ϊ"),
    ("Iotatonos", "Ί"),
    ("Itilde", "Ĩ"),
    ("J", "J"),
    ("Jcircumflex", "Ĵ"),
    ("K", "K"),
    ("Kappa", "Κ"),
    ("L", "L"),
    ("Lacute", "Ĺ"),
    ("Lambda", "Λ"),
    ("Lcaron", "Ľ"),
    ("Ldot", "Ŀ"),
    ("Lslash", "Ł"),
    ("M", "M"),
    ("Mu", "Μ"),
    ("N", "N"),
    ("Nacute", "Ń"),
    ("Ncaron", "Ň"),
    ("Ntilde", "Ñ"),
    ("Nu", "Ν"),
    ("O", "O"),
    ("OE", "Œ"),
    ("Oacute", "Ó"),
    ("Obreve", "Ŏ"),
    ("Ocircumflex", "Ô"),
    ("Odieresis", "Ö"),
    ("Ograve", "Ò"),
    ("Ohorn", "Ơ"),
    ("Ohungarumlaut", "Ő"),
    ("Omacron", "Ō"),
    ("Omega", "Ω"),
    ("Omegatonos", "Ώ"),
    ("Omicron", "Ο"),
    ("Omicrontonos", "Ό"),
    ("Oslash", "Ø"),
    ("Oslashacute", "Ǿ"),
    ("Otilde", "Õ"),
    ("P", "P"),
    ("Phi", "Φ"),
    ("Pi", "Π"),
    ("Psi", "Ψ"),
    ("Q", "Q"),
    ("R", "R"),
    ("Racute", "Ŕ"),
    ("Rcaron", "Ř"),
    ("Rfraktur", "ℜ"),
    ("Rho", "Ρ"),
    ("S", "S"),
    ("SF010000", "┌"),
    ("SF020000", "└"),
    ("SF030000", "┐"),
    ("SF040000", "┘"),
    ("SF050000", "┼"),
    ("SF060000", "┬"),
    ("SF070000", "┴"),
    ("SF080000", "├"),
    ("SF090000", "┤"),
    ("SF100000", "─"),
    ("SF110000", "│"),
    ("SF190000", "╡"),
    ("SF200000", "╢"),
    ("SF210000", "╖"),
    ("SF220000", "╕"),
    ("SF230000", "╣"),
    ("SF240000", "║"),
    ("SF250000", "╗"),
    ("SF260000", "╝"),
    ("SF270000", "╜"),
    ("SF280000", "╛"),
    ("SF360000", "╞"),
    ("SF370000", "╟"),
    ("SF380000", "╚"),
    ("SF390000", "╔"),
    ("SF400000", "╩"),
    ("SF410000", "╦"),
    ("SF420000", "╠"),
    ("SF430000", "═"),
    ("SF440000", "╬"),
    ("SF450000", "╧"),
    ("SF460000", "╨"),
    ("SF470000", "╤"),
    ("SF480000", "╥"),
    ("SF490000", "╙"),
    ("SF500000", "╘"),
    ("SF510000", "╒"),
    ("SF520000", "╓"),
    ("SF530000", "╫"),
    ("SF540000", "╪"),
    ("Sacute", "Ś"),
    ("Scaron", "Š"),
    ("Scedilla", "Ş"),
    ("Scircumflex", "Ŝ"),
    ("Sigma", "Σ"),
    ("T", "T"),
    ("Tau", "Τ"),
    ("Tbar", "Ŧ"),
    ("Tcaron", "Ť"),
    ("Theta", "Θ"),
    ("Thorn", "Þ"),
    ("U", "U"),
    ("Uacute", "Ú"),
    ("Ubreve", "Ŭ"),
    ("Ucircumflex", "Û"),
    ("Udieresis", "Ü"),
    ("Ugrave", "Ù"),
    ("Uhorn", "Ư"),
    ("Uhungarumlaut", "Ű"),
    ("Umacron", "Ū"),
    ("Uogonek", "Ų"),
    ("Upsilon", "Υ"),
    ("Upsilon1", "ϒ"),
    ("Upsilondieresis", "Ϋ"),
    ("Upsilontonos", "Ύ"),
    ("Uring", "Ů"),
    ("Utilde", "Ũ"),
    ("V", "V"),
    ("W", "W"),
    ("Wacute", "Ẃ"),
    ("Wcircumflex", "Ŵ"),
    ("Wdieresis", "Ẅ"),
    ("Wgrave", "Ẁ"),
    ("X", "X"),
    ("Xi", "Ξ"),
    ("Y", "Y"),
    ("Yacute", "Ý"),
    ("Ycircumflex", "Ŷ"),
    ("Ydieresis", "Ÿ"),
    ("Ygrave", "Ỳ"),
    ("Z", "Z"),
    ("Zacute", "Ź"),
    ("Zcaron", "Ž"),
    ("Zdotaccent", "Ż"),
    ("Zeta", "Ζ"),
    ("a", "a"),
    ("aacute", "á"),
    ("abreve", "ă"),
    ("acircumflex", "â"),
    ("acute", "´"),
    ("acutecomb", "́"),
    ("adieresis", "ä"),
    ("ae", "æ"),
    ("aeacute", "ǽ"),
    ("agrave", "à"),
    ("aleph", "ℵ"),
    ("alpha", "α"),
    ("alphatonos", "ά"),
    ("amacron", "ā"),
    ("ampersand", "&"),
    ("angle", "∠"),
    ("angleleft", "〈"),
    ("angleright", "〉"),
    ("anoteleia", "·"),
    ("aogonek", "ą"),
    ("approxequal", "≈"),
    ("aring", "å"),
    ("aringacute", "ǻ"),
    ("arrowboth", "↔"),
    ("arrowdblboth", "⇔"),
    ("arrowdbldown", "⇓"),
    ("arrowdblleft", "⇐"),
    ("arrowdblright", "⇒"),
    ("arrowdblup", "⇑"),
    ("arrowdown", "↓"),
    ("arrowleft", "←"),
    ("arrowright", "→"),
    ("arrowup", "↑"),
    ("arrowupdn", "↕"),
    ("arrowupdnbse", "↨"),
    ("asciicircum", "^"),
    ("asciitilde", "~"),
    ("asterisk", "*"),
    ("asteriskmath", "∗"),
    ("at", "@"),
    ("atilde", "ã"),
    ("b", "b"),
    ("backslash", "\\"),
    ("bar", "|"),
    ("beta", "β"),
    ("block", "█"),
    ("braceleft", "{"),
    ("braceright", "}"),
    ("bracketleft", "["),
    ("bracketright", "]"),
    ("breve", "˘"),
    ("brokenbar", "¦"),
    ("bullet", "•"),
    ("c", "c"),
    ("cacute", "ć"),
    ("caron", "ˇ"),
    ("carriagereturn", "↵"),
    ("ccaron", "č"),
    ("ccedilla", "ç"),
    ("ccircumflex", "ĉ"),
    ("cdotaccent", "ċ"),
    ("cedilla", "¸"),
    ("cent", "¢"),
    ("chi", "χ"),
    ("circle", "○"),
    ("circlemultiply", "⊗"),
    ("circleplus", "⊕"),
    ("circumflex", "ˆ"),
    ("club", "♣"),
    ("colon", ":"),
    ("colonmonetary", "₡"),
    ("comma", ","),
    ("congruent", "≅"),
    ("copyright", "©"),
    ("currency", "¤"),
    ("d", "d"),
    ("dagger", "†"),
    ("daggerdbl", "‡"),
    ("dcaron", "ď"),
    ("dcroat", "đ"),
    ("degree", "°"),
    ("delta", "δ"),
    ("diamond", "♦"),
    ("dieresis", "¨"),
    ("dieresistonos", "΅"),
    ("divide", "÷"),
    ("dkshade", "▓"),
    ("dnblock", "▄"),
    ("dollar", "$"),
    ("dong", "₫"),
    ("dotaccent", "˙"),
    ("dotbelowcomb", "̣"),
    ("dotlessi", "ı"),
    ("dotmath", "⋅"),
    ("e", "e"),
    ("eacute", "é"),
    ("ebreve", "ĕ"),
    ("ecaron", "ě"),
    ("ecircumflex", "ê"),
    ("edieresis", "ë"),
    ("edotaccent", "ė"),
    ("egrave", "è"),
    ("eight", "8"),
    ("element", "∈"),
    ("ellipsis", "…"),
    ("emacron", "ē"),
    ("emdash", "—"),
    ("emptyset", "∅"),
    ("endash", "–"),
    ("eng", "ŋ"),
    ("eogonek", "ę"),
    ("epsilon", "ε"),
    ("epsilontonos", "έ"),
    ("equal", "="),
    ("equivalence", "≡"),
    ("estimated", "℮"),
    ("eta", "η"),
    ("etatonos", "ή"),
    ("eth", "ð"),
    ("exclam", "!"),
    ("exclamdbl", "‼"),
    ("exclamdown", "¡"),
    ("existential", "∃"),
    ("f", "f"),
    ("female", "♀"),
    ("figuredash", "‒"),
    ("filledbox", "■"),
    ("filledrect", "▬"),
    ("five", "5"),
    ("fiveeighths", "⅝"),
    ("florin", "ƒ"),
    ("four", "4"),
    ("fraction", "⁄"),
    ("franc", "₣"),
    ("g", "g"),
    ("gamma", "γ"),
    ("gbreve", "ğ"),
    ("gcaron", "ǧ"),
    ("gcircumflex", "ĝ"),
    ("gdotaccent", "ġ"),
    ("germandbls", "ß"),
    ("gradient", "∇"),
    ("grave", "`"),
    ("gravecomb", "̀"),
    ("greater", ">"),
    ("greaterequal", "≥"),
    ("guillemotleft", "«"),
    ("guillemotright", "»"),
    ("guilsinglleft", "‹"),
    ("guilsinglright", "›"),
    ("h", "h"),
    ("hbar", "ħ"),
    ("hcircumflex", "ĥ"),
    ("heart", "♥"),
    ("hookabovecomb", "̉"),
    ("house", "⌂"),
    ("hungarumlaut", "˝"),
    ("hyphen", "-"),
    ("i", "i"),
    ("iacute", "í"),
    ("ibreve", "ĭ"),
    ("icircumflex", "î"),
    ("idieresis", "ï"),
    ("igrave", "ì"),
    ("ij", "ĳ"),
    ("imacron", "ī"),
    ("infinity", "∞"),
    ("integral", "∫"),
    ("integralbt", "⌡"),
    ("integraltp", "⌠"),
    ("intersection", "∩"),
    ("invbullet", "◘"),
    ("invcircle", "◙"),
    ("invsmileface", "☻"),
    ("iogonek", "į"),
    ("iota", "ι"),
    ("iotadieresis", "ϊ"),
    ("iotadieresistonos", "ΐ"),
    ("iotatonos", "ί"),
    ("itilde", "ĩ"),
    ("j", "j"),
    ("jcircumflex", "ĵ"),
    ("k", "k"),
    ("kappa", "κ"),
    ("kgreenlandic", "ĸ"),
    ("l", "l"),
    ("lacute", "ĺ"),
    ("lambda", "λ"),
    ("lcaron", "ľ"),
    ("ldot", "ŀ"),
    ("less", "<"),
    ("lessequal", "≤"),
    ("lfblock", "▌"),
    ("lira", "₤"),
    ("logicaland", "∧"),
    ("logicalnot", "¬"),
    ("logicalor", "∨"),
    ("longs", "ſ"),
    ("lozenge", "◊"),
    ("lslash", "ł"),
    ("ltshade", "░"),
    ("m", "m"),
    ("macron", "¯"),
    ("male", "♂"),
    ("minus", "−"),
    ("minute", "′"),
    ("mu", "µ"),
    ("multiply", "×"),
    ("musicalnote", "♪"),
    ("musicalnotedbl", "♫"),
    ("n", "n"),
    ("nacute", "ń"),
    ("napostrophe", "ŉ"),
    ("ncaron", "ň"),
    ("nine", "9"),
    ("notelement", "∉"),
    ("notequal", "≠"),
    ("notsubset", "⊄"),
    ("ntilde", "ñ"),
    ("nu", "ν"),
    ("numbersign", "#"),
    ("o", "o"),
    ("oacute", "ó"),
    ("obreve", "ŏ"),
    ("ocircumflex", "ô"),
    ("odieresis", "ö"),
    ("oe", "œ"),
    ("ogonek", "˛"),
    ("ograve", "ò"),
    ("ohorn", "ơ"),
    ("ohungarumlaut", "ő"),
    ("omacron", "ō"),
    ("omega", "ω"),
    ("omega1", "ϖ"),
    ("omegatonos", "ώ"),
    ("omicron", "ο"),
    ("omicrontonos", "ό"),
    ("one", "1"),
    ("onedotenleader", "․"),
    ("oneeighth", "⅛"),
    ("onehalf", "½"),
    ("onequarter", "¼"),
    ("onethird", "⅓"),
    ("openbullet", "◦"),
    ("ordfeminine", "ª"),
    ("ordmasculine", "º"),
    ("orthogonal", "∟"),
    ("oslash", "ø"),
    ("oslashacute", "ǿ"),
    ("otilde", "õ"),
    ("p", "p"),
    ("paragraph", "¶"),
    ("parenleft", "("),
    ("parenright", ")"),
    ("partialdiff", "∂"),
    ("percent", "%"),
    ("period", "."),
    ("periodcentered", "·"),
    ("perpendicular", "⊥"),
    ("perthousand", "‰"),
    ("peseta", "₧"),
    ("phi", "φ"),
    ("phi1", "ϕ"),
    ("pi", "π"),
    ("plus", "+"),
    ("plusminus", "±"),
    ("prescription", "℞"),
    ("product", "∏"),
    ("propersubset", "⊂"),
    ("propersuperset", "⊃"),
    ("proportional", "∝"),
    ("psi", "ψ"),
    ("q", "q"),
    ("question", "?"),
    ("questiondown", "¿"),
    ("quotedbl", "\""),
    ("quotedblbase", "„"),
    ("quotedblleft", "“"),
    ("quotedblright", "”"),
    ("quoteleft", "‘"),
    ("quotereversed", "‛"),
    ("quoteright", "’"),
    ("quotesinglbase", "‚"),
    ("quotesingle", "'"),
    ("r", "r"),
    ("racute", "ŕ"),
    ("radical", "√"),
    ("rcaron", "ř"),
    ("reflexsubset", "⊆"),
    ("reflexsuperset", "⊇"),
    ("registered", "®"),
    ("revlogicalnot", "⌐"),
    ("rho", "ρ"),
    ("ring", "˚"),
    ("rtblock", "▐"),
    ("s", "s"),
    ("sacute", "ś"),
    ("scaron", "š"),
    ("scedilla", "ş"),
    ("scircumflex", "ŝ"),
    ("second", "″"),
    ("section", "§"),
    ("semicolon", ";"),
    ("seven", "7"),
    ("seveneighths", "⅞"),
    ("shade", "▒"),
    ("sigma", "σ"),
    ("sigma1", "ς"),
    ("similar", "∼"),
    ("six", "6"),
    ("slash", "/"),
    ("smileface", "☺"),
    ("space", " "),
    ("spade", "♠"),
    ("sterling", "£"),
    ("suchthat", "∋"),
    ("summation", "∑"),
    ("sun", "☼"),
    ("t", "t"),
    ("tau", "τ"),
    ("tbar", "ŧ"),
    ("tcaron", "ť"),
    ("therefore", "∴"),
    ("theta", "θ"),
    ("theta1", "ϑ"),
    ("thorn", "þ"),
    ("three", "3"),
    ("threeeighths", "⅜"),
    ("threequarters", "¾"),
    ("tilde", "˜"),
    ("tildecomb", "̃"),
    ("tonos", "΄"),
    ("trademark", "™"),
    ("triagdn", "▼"),
    ("triaglf", "◄"),
    ("triagrt", "►"),
    ("triagup", "▲"),
    ("two", "2"),
    ("twodotenleader", "‥"),
    ("twothirds", "⅔"),
    ("u", "u"),
    ("uacute", "ú"),
    ("ubreve", "ŭ"),
    ("ucircumflex", "û"),
    ("udieresis", "ü"),
    ("ugrave", "ù"),
    ("uhorn", "ư"),
    ("uhungarumlaut", "ű"),
    ("umacron", "ū"),
    ("underscore", "_"),
    ("underscoredbl", "‗"),
    ("union", "∪"),
    ("universal", "∀"),
    ("uogonek", "ų"),
    ("upblock", "▀"),
    ("upsilon", "υ"),
    ("upsilondieresis", "ϋ"),
    ("upsilondieresistonos", "ΰ"),
    ("upsilontonos", "ύ"),
    ("uring", "ů"),
    ("utilde", "ũ"),
    ("v", "v"),
    ("w", "w"),
    ("wacute", "ẃ"),
    ("wcircumflex", "ŵ"),
    ("wdieresis", "ẅ"),
    ("weierstrass", "℘"),
    ("wgrave", "ẁ"),
    ("x", "x"),
    ("xi", "ξ"),
    ("y", "y"),
    ("yacute", "ý"),
    ("ycircumflex", "ŷ"),
    ("ydieresis", "ÿ"),
    ("yen", "¥"),
    ("ygrave", "ỳ"),
    ("z", "z"),
    ("zacute", "ź"),
    ("zcaron", "ž"),
    ("zdotaccent", "ż"),
    ("zero", "0"),
    ("zeta", "ζ")]


def test_names():
    assert aglfn.names
    assert len(aglfn.names) == 586
    assert type(aglfn.names) is list


def test_name():
    for c in string.ascii_letters:
        assert c == aglfn.name(c)

    for c in string.digits:
        assert c != aglfn.name(c)

    assert aglfn.name('') is None


@pytest.mark.parametrize('value, expected', values_to_test)
def test_name_all(value, expected):
    assert value == aglfn.name(expected)


@pytest.mark.parametrize('value, expected', values_to_test)
def test_to_glyph(value, expected):
    assert expected == aglfn.to_glyph(value)


def test_glyphs():
    assert aglfn.glyphs
    assert len(aglfn.glyphs) == 586
    assert type(aglfn.glyphs) is list


