# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'BranchCommitArgs',
    'BranchProtectionAllowedToMergeArgs',
    'BranchProtectionAllowedToPushArgs',
    'BranchProtectionAllowedToUnprotectArgs',
    'GroupEpicBoardListArgs',
    'GroupIssueBoardListArgs',
    'GroupProtectedEnvironmentApprovalRuleArgs',
    'GroupProtectedEnvironmentDeployAccessLevelArgs',
    'GroupPushRulesArgs',
    'ProjectContainerExpirationPolicyArgs',
    'ProjectIssueBoardListArgs',
    'ProjectIssueTaskCompletionStatusArgs',
    'ProjectProtectedEnvironmentApprovalRuleArgs',
    'ProjectProtectedEnvironmentDeployAccessLevelArgs',
    'ProjectPushRulesArgs',
    'ProjectTagCommitArgs',
    'ProjectTagReleaseArgs',
    'TagProtectionAllowedToCreateArgs',
    'GetProjectProtectedBranchMergeAccessLevelArgs',
    'GetProjectProtectedBranchPushAccessLevelArgs',
    'GetProjectProtectedBranchesProtectedBranchArgs',
    'GetProjectProtectedBranchesProtectedBranchMergeAccessLevelArgs',
    'GetProjectProtectedBranchesProtectedBranchPushAccessLevelArgs',
]

@pulumi.input_type
class BranchCommitArgs:
    def __init__(__self__, *,
                 author_email: Optional[pulumi.Input[str]] = None,
                 author_name: Optional[pulumi.Input[str]] = None,
                 authored_date: Optional[pulumi.Input[str]] = None,
                 committed_date: Optional[pulumi.Input[str]] = None,
                 committer_email: Optional[pulumi.Input[str]] = None,
                 committer_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 parent_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 short_id: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        if author_email is not None:
            pulumi.set(__self__, "author_email", author_email)
        if author_name is not None:
            pulumi.set(__self__, "author_name", author_name)
        if authored_date is not None:
            pulumi.set(__self__, "authored_date", authored_date)
        if committed_date is not None:
            pulumi.set(__self__, "committed_date", committed_date)
        if committer_email is not None:
            pulumi.set(__self__, "committer_email", committer_email)
        if committer_name is not None:
            pulumi.set(__self__, "committer_name", committer_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if parent_ids is not None:
            pulumi.set(__self__, "parent_ids", parent_ids)
        if short_id is not None:
            pulumi.set(__self__, "short_id", short_id)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="authorEmail")
    def author_email(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "author_email")

    @author_email.setter
    def author_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author_email", value)

    @property
    @pulumi.getter(name="authorName")
    def author_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "author_name")

    @author_name.setter
    def author_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author_name", value)

    @property
    @pulumi.getter(name="authoredDate")
    def authored_date(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "authored_date")

    @authored_date.setter
    def authored_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authored_date", value)

    @property
    @pulumi.getter(name="committedDate")
    def committed_date(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "committed_date")

    @committed_date.setter
    def committed_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "committed_date", value)

    @property
    @pulumi.getter(name="committerEmail")
    def committer_email(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "committer_email")

    @committer_email.setter
    def committer_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "committer_email", value)

    @property
    @pulumi.getter(name="committerName")
    def committer_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "committer_name")

    @committer_name.setter
    def committer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "committer_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="parentIds")
    def parent_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "parent_ids")

    @parent_ids.setter
    def parent_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "parent_ids", value)

    @property
    @pulumi.getter(name="shortId")
    def short_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "short_id")

    @short_id.setter
    def short_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "short_id", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class BranchProtectionAllowedToMergeArgs:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_level_description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] access_level: Access levels allowed to merge to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        :param pulumi.Input[str] access_level_description: Readable description of access level.
        :param pulumi.Input[int] group_id: The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        :param pulumi.Input[int] user_id: The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_level_description is not None:
            pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Access levels allowed to merge to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> Optional[pulumi.Input[str]]:
        """
        Readable description of access level.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class BranchProtectionAllowedToPushArgs:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_level_description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] access_level: Access levels allowed to push to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        :param pulumi.Input[str] access_level_description: Readable description of access level.
        :param pulumi.Input[int] group_id: The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        :param pulumi.Input[int] user_id: The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_level_description is not None:
            pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Access levels allowed to push to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> Optional[pulumi.Input[str]]:
        """
        Readable description of access level.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class BranchProtectionAllowedToUnprotectArgs:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_level_description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] access_level: Access levels allowed to unprotect push to protected branch. Valid values are: `developer`, `maintainer`, `admin`.
        :param pulumi.Input[str] access_level_description: Readable description of access level.
        :param pulumi.Input[int] group_id: The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        :param pulumi.Input[int] user_id: The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_level_description is not None:
            pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Access levels allowed to unprotect push to protected branch. Valid values are: `developer`, `maintainer`, `admin`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> Optional[pulumi.Input[str]]:
        """
        Readable description of access level.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class GroupEpicBoardListArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[int]] = None,
                 label_id: Optional[pulumi.Input[int]] = None,
                 position: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] id: The ID of the list.
        :param pulumi.Input[int] label_id: The ID of the label the list should be scoped to.
        :param pulumi.Input[int] position: The position of the list within the board. The position for the list is sed on the its position in the `lists` array.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if label_id is not None:
            pulumi.set(__self__, "label_id", label_id)
        if position is not None:
            pulumi.set(__self__, "position", position)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the list.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="labelId")
    def label_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the label the list should be scoped to.
        """
        return pulumi.get(self, "label_id")

    @label_id.setter
    def label_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "label_id", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[int]]:
        """
        The position of the list within the board. The position for the list is sed on the its position in the `lists` array.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "position", value)


@pulumi.input_type
class GroupIssueBoardListArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[int]] = None,
                 label_id: Optional[pulumi.Input[int]] = None,
                 position: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] id: The ID of the list.
        :param pulumi.Input[int] label_id: The ID of the label the list should be scoped to.
        :param pulumi.Input[int] position: The explicit position of the list within the board, zero based.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if label_id is not None:
            pulumi.set(__self__, "label_id", label_id)
        if position is not None:
            pulumi.set(__self__, "position", position)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the list.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="labelId")
    def label_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the label the list should be scoped to.
        """
        return pulumi.get(self, "label_id")

    @label_id.setter
    def label_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "label_id", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[int]]:
        """
        The explicit position of the list within the board, zero based.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "position", value)


@pulumi.input_type
class GroupProtectedEnvironmentApprovalRuleArgs:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_level_description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[int]] = None,
                 required_approvals: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] access_level: Levels of access allowed to approve a deployment to this protected environment. Valid values are `developer`, `maintainer`.
        :param pulumi.Input[str] access_level_description: Readable description of level of access.
        :param pulumi.Input[int] group_id: The ID of the group allowed to approve a deployment to this protected environment. TThe group must be a sub-group under the given group. This is mutually exclusive with user_id.
        :param pulumi.Input[int] id: The unique ID of the Approval Rules object.
        :param pulumi.Input[int] required_approvals: The number of approval required to allow deployment to this protected environment. This is mutually exclusive with user_id.
        :param pulumi.Input[int] user_id: The ID of the user allowed to approve a deployment to this protected environment. The user must be a member of the group with Maintainer role or higher. This is mutually exclusive with group*id and required*approvals.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_level_description is not None:
            pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if required_approvals is not None:
            pulumi.set(__self__, "required_approvals", required_approvals)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Levels of access allowed to approve a deployment to this protected environment. Valid values are `developer`, `maintainer`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> Optional[pulumi.Input[str]]:
        """
        Readable description of level of access.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the group allowed to approve a deployment to this protected environment. TThe group must be a sub-group under the given group. This is mutually exclusive with user_id.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        """
        The unique ID of the Approval Rules object.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="requiredApprovals")
    def required_approvals(self) -> Optional[pulumi.Input[int]]:
        """
        The number of approval required to allow deployment to this protected environment. This is mutually exclusive with user_id.
        """
        return pulumi.get(self, "required_approvals")

    @required_approvals.setter
    def required_approvals(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "required_approvals", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the user allowed to approve a deployment to this protected environment. The user must be a member of the group with Maintainer role or higher. This is mutually exclusive with group*id and required*approvals.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class GroupProtectedEnvironmentDeployAccessLevelArgs:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_level_description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] access_level: Levels of access required to deploy to this protected environment. Valid values are `developer`, `maintainer`.
        :param pulumi.Input[str] access_level_description: Readable description of level of access.
        :param pulumi.Input[int] group_id: The ID of the group allowed to deploy to this protected environment. The group must be a sub-group under the given group.
        :param pulumi.Input[int] id: The unique ID of the Deploy Access Level object.
        :param pulumi.Input[int] user_id: The ID of the user allowed to deploy to this protected environment. The user must be a member of the group with Maintainer role or higher.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_level_description is not None:
            pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Levels of access required to deploy to this protected environment. Valid values are `developer`, `maintainer`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> Optional[pulumi.Input[str]]:
        """
        Readable description of level of access.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the group allowed to deploy to this protected environment. The group must be a sub-group under the given group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        """
        The unique ID of the Deploy Access Level object.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the user allowed to deploy to this protected environment. The user must be a member of the group with Maintainer role or higher.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class GroupPushRulesArgs:
    def __init__(__self__, *,
                 author_email_regex: Optional[pulumi.Input[str]] = None,
                 branch_name_regex: Optional[pulumi.Input[str]] = None,
                 commit_committer_check: Optional[pulumi.Input[bool]] = None,
                 commit_message_negative_regex: Optional[pulumi.Input[str]] = None,
                 commit_message_regex: Optional[pulumi.Input[str]] = None,
                 deny_delete_tag: Optional[pulumi.Input[bool]] = None,
                 file_name_regex: Optional[pulumi.Input[str]] = None,
                 max_file_size: Optional[pulumi.Input[int]] = None,
                 member_check: Optional[pulumi.Input[bool]] = None,
                 prevent_secrets: Optional[pulumi.Input[bool]] = None,
                 reject_unsigned_commits: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] author_email_regex: All commit author emails must match this regex, e.g. `@my-company.com$`.
        :param pulumi.Input[str] branch_name_regex: All branch names must match this regex, e.g. `(feature|hotfix)\\/*`.
        :param pulumi.Input[bool] commit_committer_check: Only commits pushed using verified emails are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
        :param pulumi.Input[str] commit_message_negative_regex: No commit message is allowed to match this regex, for example `ssh\\:\\/\\/`.
        :param pulumi.Input[str] commit_message_regex: All commit messages must match this regex, e.g. `Fixed \\d+\\..*`.
        :param pulumi.Input[bool] deny_delete_tag: Deny deleting a tag.
        :param pulumi.Input[str] file_name_regex: Filenames matching the regular expression provided in this attribute are not allowed, for example, `(jar|exe)$`.
        :param pulumi.Input[int] max_file_size: Maximum file size (MB) allowed.
        :param pulumi.Input[bool] member_check: Allows only GitLab users to author commits.
        :param pulumi.Input[bool] prevent_secrets: GitLab will reject any files that are likely to contain secrets.
        :param pulumi.Input[bool] reject_unsigned_commits: Only commits signed through GPG are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
        """
        if author_email_regex is not None:
            pulumi.set(__self__, "author_email_regex", author_email_regex)
        if branch_name_regex is not None:
            pulumi.set(__self__, "branch_name_regex", branch_name_regex)
        if commit_committer_check is not None:
            pulumi.set(__self__, "commit_committer_check", commit_committer_check)
        if commit_message_negative_regex is not None:
            pulumi.set(__self__, "commit_message_negative_regex", commit_message_negative_regex)
        if commit_message_regex is not None:
            pulumi.set(__self__, "commit_message_regex", commit_message_regex)
        if deny_delete_tag is not None:
            pulumi.set(__self__, "deny_delete_tag", deny_delete_tag)
        if file_name_regex is not None:
            pulumi.set(__self__, "file_name_regex", file_name_regex)
        if max_file_size is not None:
            pulumi.set(__self__, "max_file_size", max_file_size)
        if member_check is not None:
            pulumi.set(__self__, "member_check", member_check)
        if prevent_secrets is not None:
            pulumi.set(__self__, "prevent_secrets", prevent_secrets)
        if reject_unsigned_commits is not None:
            pulumi.set(__self__, "reject_unsigned_commits", reject_unsigned_commits)

    @property
    @pulumi.getter(name="authorEmailRegex")
    def author_email_regex(self) -> Optional[pulumi.Input[str]]:
        """
        All commit author emails must match this regex, e.g. `@my-company.com$`.
        """
        return pulumi.get(self, "author_email_regex")

    @author_email_regex.setter
    def author_email_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author_email_regex", value)

    @property
    @pulumi.getter(name="branchNameRegex")
    def branch_name_regex(self) -> Optional[pulumi.Input[str]]:
        """
        All branch names must match this regex, e.g. `(feature|hotfix)\\/*`.
        """
        return pulumi.get(self, "branch_name_regex")

    @branch_name_regex.setter
    def branch_name_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name_regex", value)

    @property
    @pulumi.getter(name="commitCommitterCheck")
    def commit_committer_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Only commits pushed using verified emails are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
        """
        return pulumi.get(self, "commit_committer_check")

    @commit_committer_check.setter
    def commit_committer_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "commit_committer_check", value)

    @property
    @pulumi.getter(name="commitMessageNegativeRegex")
    def commit_message_negative_regex(self) -> Optional[pulumi.Input[str]]:
        """
        No commit message is allowed to match this regex, for example `ssh\\:\\/\\/`.
        """
        return pulumi.get(self, "commit_message_negative_regex")

    @commit_message_negative_regex.setter
    def commit_message_negative_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_message_negative_regex", value)

    @property
    @pulumi.getter(name="commitMessageRegex")
    def commit_message_regex(self) -> Optional[pulumi.Input[str]]:
        """
        All commit messages must match this regex, e.g. `Fixed \\d+\\..*`.
        """
        return pulumi.get(self, "commit_message_regex")

    @commit_message_regex.setter
    def commit_message_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_message_regex", value)

    @property
    @pulumi.getter(name="denyDeleteTag")
    def deny_delete_tag(self) -> Optional[pulumi.Input[bool]]:
        """
        Deny deleting a tag.
        """
        return pulumi.get(self, "deny_delete_tag")

    @deny_delete_tag.setter
    def deny_delete_tag(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deny_delete_tag", value)

    @property
    @pulumi.getter(name="fileNameRegex")
    def file_name_regex(self) -> Optional[pulumi.Input[str]]:
        """
        Filenames matching the regular expression provided in this attribute are not allowed, for example, `(jar|exe)$`.
        """
        return pulumi.get(self, "file_name_regex")

    @file_name_regex.setter
    def file_name_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name_regex", value)

    @property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum file size (MB) allowed.
        """
        return pulumi.get(self, "max_file_size")

    @max_file_size.setter
    def max_file_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_file_size", value)

    @property
    @pulumi.getter(name="memberCheck")
    def member_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Allows only GitLab users to author commits.
        """
        return pulumi.get(self, "member_check")

    @member_check.setter
    def member_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "member_check", value)

    @property
    @pulumi.getter(name="preventSecrets")
    def prevent_secrets(self) -> Optional[pulumi.Input[bool]]:
        """
        GitLab will reject any files that are likely to contain secrets.
        """
        return pulumi.get(self, "prevent_secrets")

    @prevent_secrets.setter
    def prevent_secrets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prevent_secrets", value)

    @property
    @pulumi.getter(name="rejectUnsignedCommits")
    def reject_unsigned_commits(self) -> Optional[pulumi.Input[bool]]:
        """
        Only commits signed through GPG are allowed.  **Note** This attribute is only supported in GitLab versions >= 16.4.
        """
        return pulumi.get(self, "reject_unsigned_commits")

    @reject_unsigned_commits.setter
    def reject_unsigned_commits(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reject_unsigned_commits", value)


@pulumi.input_type
class ProjectContainerExpirationPolicyArgs:
    def __init__(__self__, *,
                 cadence: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 keep_n: Optional[pulumi.Input[int]] = None,
                 name_regex: Optional[pulumi.Input[str]] = None,
                 name_regex_delete: Optional[pulumi.Input[str]] = None,
                 name_regex_keep: Optional[pulumi.Input[str]] = None,
                 next_run_at: Optional[pulumi.Input[str]] = None,
                 older_than: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cadence: The cadence of the policy. Valid values are: `1d`, `7d`, `14d`, `1month`, `3month`.
        :param pulumi.Input[bool] enabled: If true, the policy is enabled.
        :param pulumi.Input[int] keep_n: The number of images to keep.
        :param pulumi.Input[str] name_regex: The regular expression to match image names to delete.
        :param pulumi.Input[str] name_regex_delete: The regular expression to match image names to delete.
        :param pulumi.Input[str] name_regex_keep: The regular expression to match image names to keep.
        :param pulumi.Input[str] next_run_at: The next time the policy will run.
        :param pulumi.Input[str] older_than: The number of days to keep images.
        """
        if cadence is not None:
            pulumi.set(__self__, "cadence", cadence)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if keep_n is not None:
            pulumi.set(__self__, "keep_n", keep_n)
        if name_regex is not None:
            warnings.warn("""`name_regex` has been deprecated. Use `name_regex_delete` instead.""", DeprecationWarning)
            pulumi.log.warn("""name_regex is deprecated: `name_regex` has been deprecated. Use `name_regex_delete` instead.""")
        if name_regex is not None:
            pulumi.set(__self__, "name_regex", name_regex)
        if name_regex_delete is not None:
            pulumi.set(__self__, "name_regex_delete", name_regex_delete)
        if name_regex_keep is not None:
            pulumi.set(__self__, "name_regex_keep", name_regex_keep)
        if next_run_at is not None:
            pulumi.set(__self__, "next_run_at", next_run_at)
        if older_than is not None:
            pulumi.set(__self__, "older_than", older_than)

    @property
    @pulumi.getter
    def cadence(self) -> Optional[pulumi.Input[str]]:
        """
        The cadence of the policy. Valid values are: `1d`, `7d`, `14d`, `1month`, `3month`.
        """
        return pulumi.get(self, "cadence")

    @cadence.setter
    def cadence(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cadence", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the policy is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="keepN")
    def keep_n(self) -> Optional[pulumi.Input[int]]:
        """
        The number of images to keep.
        """
        return pulumi.get(self, "keep_n")

    @keep_n.setter
    def keep_n(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "keep_n", value)

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[pulumi.Input[str]]:
        """
        The regular expression to match image names to delete.
        """
        warnings.warn("""`name_regex` has been deprecated. Use `name_regex_delete` instead.""", DeprecationWarning)
        pulumi.log.warn("""name_regex is deprecated: `name_regex` has been deprecated. Use `name_regex_delete` instead.""")

        return pulumi.get(self, "name_regex")

    @name_regex.setter
    def name_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_regex", value)

    @property
    @pulumi.getter(name="nameRegexDelete")
    def name_regex_delete(self) -> Optional[pulumi.Input[str]]:
        """
        The regular expression to match image names to delete.
        """
        return pulumi.get(self, "name_regex_delete")

    @name_regex_delete.setter
    def name_regex_delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_regex_delete", value)

    @property
    @pulumi.getter(name="nameRegexKeep")
    def name_regex_keep(self) -> Optional[pulumi.Input[str]]:
        """
        The regular expression to match image names to keep.
        """
        return pulumi.get(self, "name_regex_keep")

    @name_regex_keep.setter
    def name_regex_keep(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_regex_keep", value)

    @property
    @pulumi.getter(name="nextRunAt")
    def next_run_at(self) -> Optional[pulumi.Input[str]]:
        """
        The next time the policy will run.
        """
        return pulumi.get(self, "next_run_at")

    @next_run_at.setter
    def next_run_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_run_at", value)

    @property
    @pulumi.getter(name="olderThan")
    def older_than(self) -> Optional[pulumi.Input[str]]:
        """
        The number of days to keep images.
        """
        return pulumi.get(self, "older_than")

    @older_than.setter
    def older_than(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "older_than", value)


@pulumi.input_type
class ProjectIssueBoardListArgs:
    def __init__(__self__, *,
                 assignee_id: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[int]] = None,
                 iteration_id: Optional[pulumi.Input[int]] = None,
                 label_id: Optional[pulumi.Input[int]] = None,
                 milestone_id: Optional[pulumi.Input[int]] = None,
                 position: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] assignee_id: The ID of the assignee the list should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[int] id: The ID of the list
        :param pulumi.Input[int] iteration_id: The ID of the iteration the list should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[int] label_id: The ID of the label the list should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[int] milestone_id: The ID of the milestone the list should be scoped to. Requires a GitLab EE license.
        :param pulumi.Input[int] position: The position of the list within the board. The position for the list is based on the its position in the `lists` array.
        """
        if assignee_id is not None:
            pulumi.set(__self__, "assignee_id", assignee_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if iteration_id is not None:
            pulumi.set(__self__, "iteration_id", iteration_id)
        if label_id is not None:
            pulumi.set(__self__, "label_id", label_id)
        if milestone_id is not None:
            pulumi.set(__self__, "milestone_id", milestone_id)
        if position is not None:
            pulumi.set(__self__, "position", position)

    @property
    @pulumi.getter(name="assigneeId")
    def assignee_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the assignee the list should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "assignee_id")

    @assignee_id.setter
    def assignee_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "assignee_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the list
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="iterationId")
    def iteration_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the iteration the list should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "iteration_id")

    @iteration_id.setter
    def iteration_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iteration_id", value)

    @property
    @pulumi.getter(name="labelId")
    def label_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the label the list should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "label_id")

    @label_id.setter
    def label_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "label_id", value)

    @property
    @pulumi.getter(name="milestoneId")
    def milestone_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the milestone the list should be scoped to. Requires a GitLab EE license.
        """
        return pulumi.get(self, "milestone_id")

    @milestone_id.setter
    def milestone_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "milestone_id", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[int]]:
        """
        The position of the list within the board. The position for the list is based on the its position in the `lists` array.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "position", value)


@pulumi.input_type
class ProjectIssueTaskCompletionStatusArgs:
    def __init__(__self__, *,
                 completed_count: Optional[pulumi.Input[int]] = None,
                 count: Optional[pulumi.Input[int]] = None):
        if completed_count is not None:
            pulumi.set(__self__, "completed_count", completed_count)
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter(name="completedCount")
    def completed_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "completed_count")

    @completed_count.setter
    def completed_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "completed_count", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)


@pulumi.input_type
class ProjectProtectedEnvironmentApprovalRuleArgs:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_level_description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[int]] = None,
                 required_approvals: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] access_level: Levels of access allowed to approve a deployment to this protected environment. Valid values are `developer`, `maintainer`.
        :param pulumi.Input[str] access_level_description: Readable description of level of access.
        :param pulumi.Input[int] group_id: The ID of the group allowed to approve a deployment to this protected environment. The project must be shared with the group. This is mutually exclusive with user_id.
        :param pulumi.Input[int] id: The unique ID of the Approval Rules object.
        :param pulumi.Input[int] required_approvals: The number of approval required to allow deployment to this protected environment. This is mutually exclusive with user_id.
        :param pulumi.Input[int] user_id: The ID of the user allowed to approve a deployment to this protected environment. The user must be a member of the project. This is mutually exclusive with group*id and required*approvals.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_level_description is not None:
            pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if required_approvals is not None:
            pulumi.set(__self__, "required_approvals", required_approvals)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Levels of access allowed to approve a deployment to this protected environment. Valid values are `developer`, `maintainer`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> Optional[pulumi.Input[str]]:
        """
        Readable description of level of access.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the group allowed to approve a deployment to this protected environment. The project must be shared with the group. This is mutually exclusive with user_id.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        """
        The unique ID of the Approval Rules object.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="requiredApprovals")
    def required_approvals(self) -> Optional[pulumi.Input[int]]:
        """
        The number of approval required to allow deployment to this protected environment. This is mutually exclusive with user_id.
        """
        return pulumi.get(self, "required_approvals")

    @required_approvals.setter
    def required_approvals(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "required_approvals", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the user allowed to approve a deployment to this protected environment. The user must be a member of the project. This is mutually exclusive with group*id and required*approvals.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class ProjectProtectedEnvironmentDeployAccessLevelArgs:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_level_description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 id: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] access_level: Levels of access required to deploy to this protected environment. Valid values are `developer`, `maintainer`.
        :param pulumi.Input[str] access_level_description: Readable description of level of access.
        :param pulumi.Input[int] group_id: The ID of the group allowed to deploy to this protected environment. The project must be shared with the group.
        :param pulumi.Input[int] id: The unique ID of the Deploy Access Level object.
        :param pulumi.Input[int] user_id: The ID of the user allowed to deploy to this protected environment. The user must be a member of the project.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_level_description is not None:
            pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Levels of access required to deploy to this protected environment. Valid values are `developer`, `maintainer`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> Optional[pulumi.Input[str]]:
        """
        Readable description of level of access.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the group allowed to deploy to this protected environment. The project must be shared with the group.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[int]]:
        """
        The unique ID of the Deploy Access Level object.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the user allowed to deploy to this protected environment. The user must be a member of the project.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class ProjectPushRulesArgs:
    def __init__(__self__, *,
                 author_email_regex: Optional[pulumi.Input[str]] = None,
                 branch_name_regex: Optional[pulumi.Input[str]] = None,
                 commit_committer_check: Optional[pulumi.Input[bool]] = None,
                 commit_message_negative_regex: Optional[pulumi.Input[str]] = None,
                 commit_message_regex: Optional[pulumi.Input[str]] = None,
                 deny_delete_tag: Optional[pulumi.Input[bool]] = None,
                 file_name_regex: Optional[pulumi.Input[str]] = None,
                 max_file_size: Optional[pulumi.Input[int]] = None,
                 member_check: Optional[pulumi.Input[bool]] = None,
                 prevent_secrets: Optional[pulumi.Input[bool]] = None,
                 reject_unsigned_commits: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] author_email_regex: All commit author emails must match this regex, e.g. `@my-company.com$`.
        :param pulumi.Input[str] branch_name_regex: All branch names must match this regex, e.g. `(feature|hotfix)\\/*`.
        :param pulumi.Input[bool] commit_committer_check: Users can only push commits to this repository that were committed with one of their own verified emails.
        :param pulumi.Input[str] commit_message_negative_regex: No commit message is allowed to match this regex, for example `ssh\\:\\/\\/`.
        :param pulumi.Input[str] commit_message_regex: All commit messages must match this regex, e.g. `Fixed \\d+\\..*`.
        :param pulumi.Input[bool] deny_delete_tag: Deny deleting a tag.
        :param pulumi.Input[str] file_name_regex: All committed filenames must not match this regex, e.g. `(jar|exe)$`.
        :param pulumi.Input[int] max_file_size: Maximum file size (MB).
        :param pulumi.Input[bool] member_check: Restrict commits by author (email) to existing GitLab users.
        :param pulumi.Input[bool] prevent_secrets: GitLab will reject any files that are likely to contain secrets.
        :param pulumi.Input[bool] reject_unsigned_commits: Reject commit when it’s not signed through GPG.
        """
        if author_email_regex is not None:
            pulumi.set(__self__, "author_email_regex", author_email_regex)
        if branch_name_regex is not None:
            pulumi.set(__self__, "branch_name_regex", branch_name_regex)
        if commit_committer_check is not None:
            pulumi.set(__self__, "commit_committer_check", commit_committer_check)
        if commit_message_negative_regex is not None:
            pulumi.set(__self__, "commit_message_negative_regex", commit_message_negative_regex)
        if commit_message_regex is not None:
            pulumi.set(__self__, "commit_message_regex", commit_message_regex)
        if deny_delete_tag is not None:
            pulumi.set(__self__, "deny_delete_tag", deny_delete_tag)
        if file_name_regex is not None:
            pulumi.set(__self__, "file_name_regex", file_name_regex)
        if max_file_size is not None:
            pulumi.set(__self__, "max_file_size", max_file_size)
        if member_check is not None:
            pulumi.set(__self__, "member_check", member_check)
        if prevent_secrets is not None:
            pulumi.set(__self__, "prevent_secrets", prevent_secrets)
        if reject_unsigned_commits is not None:
            pulumi.set(__self__, "reject_unsigned_commits", reject_unsigned_commits)

    @property
    @pulumi.getter(name="authorEmailRegex")
    def author_email_regex(self) -> Optional[pulumi.Input[str]]:
        """
        All commit author emails must match this regex, e.g. `@my-company.com$`.
        """
        return pulumi.get(self, "author_email_regex")

    @author_email_regex.setter
    def author_email_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author_email_regex", value)

    @property
    @pulumi.getter(name="branchNameRegex")
    def branch_name_regex(self) -> Optional[pulumi.Input[str]]:
        """
        All branch names must match this regex, e.g. `(feature|hotfix)\\/*`.
        """
        return pulumi.get(self, "branch_name_regex")

    @branch_name_regex.setter
    def branch_name_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name_regex", value)

    @property
    @pulumi.getter(name="commitCommitterCheck")
    def commit_committer_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Users can only push commits to this repository that were committed with one of their own verified emails.
        """
        return pulumi.get(self, "commit_committer_check")

    @commit_committer_check.setter
    def commit_committer_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "commit_committer_check", value)

    @property
    @pulumi.getter(name="commitMessageNegativeRegex")
    def commit_message_negative_regex(self) -> Optional[pulumi.Input[str]]:
        """
        No commit message is allowed to match this regex, for example `ssh\\:\\/\\/`.
        """
        return pulumi.get(self, "commit_message_negative_regex")

    @commit_message_negative_regex.setter
    def commit_message_negative_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_message_negative_regex", value)

    @property
    @pulumi.getter(name="commitMessageRegex")
    def commit_message_regex(self) -> Optional[pulumi.Input[str]]:
        """
        All commit messages must match this regex, e.g. `Fixed \\d+\\..*`.
        """
        return pulumi.get(self, "commit_message_regex")

    @commit_message_regex.setter
    def commit_message_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_message_regex", value)

    @property
    @pulumi.getter(name="denyDeleteTag")
    def deny_delete_tag(self) -> Optional[pulumi.Input[bool]]:
        """
        Deny deleting a tag.
        """
        return pulumi.get(self, "deny_delete_tag")

    @deny_delete_tag.setter
    def deny_delete_tag(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deny_delete_tag", value)

    @property
    @pulumi.getter(name="fileNameRegex")
    def file_name_regex(self) -> Optional[pulumi.Input[str]]:
        """
        All committed filenames must not match this regex, e.g. `(jar|exe)$`.
        """
        return pulumi.get(self, "file_name_regex")

    @file_name_regex.setter
    def file_name_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name_regex", value)

    @property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum file size (MB).
        """
        return pulumi.get(self, "max_file_size")

    @max_file_size.setter
    def max_file_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_file_size", value)

    @property
    @pulumi.getter(name="memberCheck")
    def member_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Restrict commits by author (email) to existing GitLab users.
        """
        return pulumi.get(self, "member_check")

    @member_check.setter
    def member_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "member_check", value)

    @property
    @pulumi.getter(name="preventSecrets")
    def prevent_secrets(self) -> Optional[pulumi.Input[bool]]:
        """
        GitLab will reject any files that are likely to contain secrets.
        """
        return pulumi.get(self, "prevent_secrets")

    @prevent_secrets.setter
    def prevent_secrets(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prevent_secrets", value)

    @property
    @pulumi.getter(name="rejectUnsignedCommits")
    def reject_unsigned_commits(self) -> Optional[pulumi.Input[bool]]:
        """
        Reject commit when it’s not signed through GPG.
        """
        return pulumi.get(self, "reject_unsigned_commits")

    @reject_unsigned_commits.setter
    def reject_unsigned_commits(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reject_unsigned_commits", value)


@pulumi.input_type
class ProjectTagCommitArgs:
    def __init__(__self__, *,
                 author_email: Optional[pulumi.Input[str]] = None,
                 author_name: Optional[pulumi.Input[str]] = None,
                 authored_date: Optional[pulumi.Input[str]] = None,
                 committed_date: Optional[pulumi.Input[str]] = None,
                 committer_email: Optional[pulumi.Input[str]] = None,
                 committer_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 parent_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 short_id: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        if author_email is not None:
            pulumi.set(__self__, "author_email", author_email)
        if author_name is not None:
            pulumi.set(__self__, "author_name", author_name)
        if authored_date is not None:
            pulumi.set(__self__, "authored_date", authored_date)
        if committed_date is not None:
            pulumi.set(__self__, "committed_date", committed_date)
        if committer_email is not None:
            pulumi.set(__self__, "committer_email", committer_email)
        if committer_name is not None:
            pulumi.set(__self__, "committer_name", committer_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if parent_ids is not None:
            pulumi.set(__self__, "parent_ids", parent_ids)
        if short_id is not None:
            pulumi.set(__self__, "short_id", short_id)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="authorEmail")
    def author_email(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "author_email")

    @author_email.setter
    def author_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author_email", value)

    @property
    @pulumi.getter(name="authorName")
    def author_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "author_name")

    @author_name.setter
    def author_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "author_name", value)

    @property
    @pulumi.getter(name="authoredDate")
    def authored_date(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "authored_date")

    @authored_date.setter
    def authored_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authored_date", value)

    @property
    @pulumi.getter(name="committedDate")
    def committed_date(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "committed_date")

    @committed_date.setter
    def committed_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "committed_date", value)

    @property
    @pulumi.getter(name="committerEmail")
    def committer_email(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "committer_email")

    @committer_email.setter
    def committer_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "committer_email", value)

    @property
    @pulumi.getter(name="committerName")
    def committer_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "committer_name")

    @committer_name.setter
    def committer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "committer_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="parentIds")
    def parent_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "parent_ids")

    @parent_ids.setter
    def parent_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "parent_ids", value)

    @property
    @pulumi.getter(name="shortId")
    def short_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "short_id")

    @short_id.setter
    def short_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "short_id", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class ProjectTagReleaseArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 tag_name: Optional[pulumi.Input[str]] = None):
        if description is not None:
            pulumi.set(__self__, "description", description)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_name", value)


@pulumi.input_type
class TagProtectionAllowedToCreateArgs:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[str]] = None,
                 access_level_description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 user_id: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] access_level: Level of access.
        :param pulumi.Input[str] access_level_description: Readable description of level of access.
        :param pulumi.Input[int] group_id: The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        :param pulumi.Input[int] user_id: The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if access_level_description is not None:
            pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Level of access.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> Optional[pulumi.Input[str]]:
        """
        Readable description of level of access.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class GetProjectProtectedBranchMergeAccessLevelArgs:
    def __init__(__self__, *,
                 access_level: str,
                 access_level_description: str,
                 group_id: Optional[int] = None,
                 user_id: Optional[int] = None):
        """
        :param str access_level: Access levels allowed to merge to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        :param str access_level_description: Readable description of access level.
        :param int group_id: The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        :param int user_id: The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        """
        Access levels allowed to merge to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: str):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> str:
        """
        Readable description of access level.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: str):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[int]:
        """
        The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[int]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[int]:
        """
        The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[int]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class GetProjectProtectedBranchPushAccessLevelArgs:
    def __init__(__self__, *,
                 access_level: str,
                 access_level_description: str,
                 group_id: Optional[int] = None,
                 user_id: Optional[int] = None):
        """
        :param str access_level: Access levels allowed to push to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        :param str access_level_description: Readable description of access level.
        :param int group_id: The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        :param int user_id: The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        """
        Access levels allowed to push to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: str):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> str:
        """
        Readable description of access level.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: str):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[int]:
        """
        The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[int]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[int]:
        """
        The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[int]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class GetProjectProtectedBranchesProtectedBranchArgs:
    def __init__(__self__, *,
                 allow_force_push: bool,
                 code_owner_approval_required: bool,
                 id: int,
                 name: str,
                 merge_access_levels: Optional[Sequence['GetProjectProtectedBranchesProtectedBranchMergeAccessLevelArgs']] = None,
                 push_access_levels: Optional[Sequence['GetProjectProtectedBranchesProtectedBranchPushAccessLevelArgs']] = None):
        """
        :param bool allow_force_push: Whether force push is allowed.
        :param bool code_owner_approval_required: Reject code pushes that change files listed in the CODEOWNERS file.
        :param int id: The ID of this resource.
        :param str name: The name of the protected branch.
        :param Sequence['GetProjectProtectedBranchesProtectedBranchMergeAccessLevelArgs'] merge_access_levels: Array of access levels and user(s)/group(s) allowed to merge to protected branch.
        :param Sequence['GetProjectProtectedBranchesProtectedBranchPushAccessLevelArgs'] push_access_levels: Array of access levels and user(s)/group(s) allowed to push to protected branch.
        """
        pulumi.set(__self__, "allow_force_push", allow_force_push)
        pulumi.set(__self__, "code_owner_approval_required", code_owner_approval_required)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        if merge_access_levels is not None:
            pulumi.set(__self__, "merge_access_levels", merge_access_levels)
        if push_access_levels is not None:
            pulumi.set(__self__, "push_access_levels", push_access_levels)

    @property
    @pulumi.getter(name="allowForcePush")
    def allow_force_push(self) -> bool:
        """
        Whether force push is allowed.
        """
        return pulumi.get(self, "allow_force_push")

    @allow_force_push.setter
    def allow_force_push(self, value: bool):
        pulumi.set(self, "allow_force_push", value)

    @property
    @pulumi.getter(name="codeOwnerApprovalRequired")
    def code_owner_approval_required(self) -> bool:
        """
        Reject code pushes that change files listed in the CODEOWNERS file.
        """
        return pulumi.get(self, "code_owner_approval_required")

    @code_owner_approval_required.setter
    def code_owner_approval_required(self, value: bool):
        pulumi.set(self, "code_owner_approval_required", value)

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: int):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the protected branch.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="mergeAccessLevels")
    def merge_access_levels(self) -> Optional[Sequence['GetProjectProtectedBranchesProtectedBranchMergeAccessLevelArgs']]:
        """
        Array of access levels and user(s)/group(s) allowed to merge to protected branch.
        """
        return pulumi.get(self, "merge_access_levels")

    @merge_access_levels.setter
    def merge_access_levels(self, value: Optional[Sequence['GetProjectProtectedBranchesProtectedBranchMergeAccessLevelArgs']]):
        pulumi.set(self, "merge_access_levels", value)

    @property
    @pulumi.getter(name="pushAccessLevels")
    def push_access_levels(self) -> Optional[Sequence['GetProjectProtectedBranchesProtectedBranchPushAccessLevelArgs']]:
        """
        Array of access levels and user(s)/group(s) allowed to push to protected branch.
        """
        return pulumi.get(self, "push_access_levels")

    @push_access_levels.setter
    def push_access_levels(self, value: Optional[Sequence['GetProjectProtectedBranchesProtectedBranchPushAccessLevelArgs']]):
        pulumi.set(self, "push_access_levels", value)


@pulumi.input_type
class GetProjectProtectedBranchesProtectedBranchMergeAccessLevelArgs:
    def __init__(__self__, *,
                 access_level: str,
                 access_level_description: str,
                 group_id: Optional[int] = None,
                 user_id: Optional[int] = None):
        """
        :param str access_level: Access levels allowed to merge to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        :param str access_level_description: Readable description of access level.
        :param int group_id: The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        :param int user_id: The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        """
        Access levels allowed to merge to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: str):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> str:
        """
        Readable description of access level.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: str):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[int]:
        """
        The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[int]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[int]:
        """
        The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[int]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class GetProjectProtectedBranchesProtectedBranchPushAccessLevelArgs:
    def __init__(__self__, *,
                 access_level: str,
                 access_level_description: str,
                 group_id: Optional[int] = None,
                 user_id: Optional[int] = None):
        """
        :param str access_level: Access levels allowed to merge to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        :param str access_level_description: Readable description of access level.
        :param int group_id: The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        :param int user_id: The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        pulumi.set(__self__, "access_level", access_level)
        pulumi.set(__self__, "access_level_description", access_level_description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> str:
        """
        Access levels allowed to merge to protected branch. Valid values are: `no one`, `developer`, `maintainer`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: str):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter(name="accessLevelDescription")
    def access_level_description(self) -> str:
        """
        Readable description of access level.
        """
        return pulumi.get(self, "access_level_description")

    @access_level_description.setter
    def access_level_description(self, value: str):
        pulumi.set(self, "access_level_description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[int]:
        """
        The ID of a GitLab group allowed to perform the relevant action. Mutually exclusive with `user_id`.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[int]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[int]:
        """
        The ID of a GitLab user allowed to perform the relevant action. Mutually exclusive with `group_id`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[int]):
        pulumi.set(self, "user_id", value)


