# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetGroupSubgroupsResult',
    'AwaitableGetGroupSubgroupsResult',
    'get_group_subgroups',
    'get_group_subgroups_output',
]

@pulumi.output_type
class GetGroupSubgroupsResult:
    """
    A collection of values returned by getGroupSubgroups.
    """
    def __init__(__self__, all_available=None, group_id=None, id=None, min_access_level=None, order_by=None, owned=None, search=None, skip_groups=None, sort=None, statistics=None, subgroups=None, with_custom_attributes=None):
        if all_available and not isinstance(all_available, bool):
            raise TypeError("Expected argument 'all_available' to be a bool")
        pulumi.set(__self__, "all_available", all_available)
        if group_id and not isinstance(group_id, int):
            raise TypeError("Expected argument 'group_id' to be a int")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if min_access_level and not isinstance(min_access_level, str):
            raise TypeError("Expected argument 'min_access_level' to be a str")
        pulumi.set(__self__, "min_access_level", min_access_level)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if owned and not isinstance(owned, bool):
            raise TypeError("Expected argument 'owned' to be a bool")
        pulumi.set(__self__, "owned", owned)
        if search and not isinstance(search, str):
            raise TypeError("Expected argument 'search' to be a str")
        pulumi.set(__self__, "search", search)
        if skip_groups and not isinstance(skip_groups, list):
            raise TypeError("Expected argument 'skip_groups' to be a list")
        pulumi.set(__self__, "skip_groups", skip_groups)
        if sort and not isinstance(sort, str):
            raise TypeError("Expected argument 'sort' to be a str")
        pulumi.set(__self__, "sort", sort)
        if statistics and not isinstance(statistics, bool):
            raise TypeError("Expected argument 'statistics' to be a bool")
        pulumi.set(__self__, "statistics", statistics)
        if subgroups and not isinstance(subgroups, list):
            raise TypeError("Expected argument 'subgroups' to be a list")
        pulumi.set(__self__, "subgroups", subgroups)
        if with_custom_attributes and not isinstance(with_custom_attributes, bool):
            raise TypeError("Expected argument 'with_custom_attributes' to be a bool")
        pulumi.set(__self__, "with_custom_attributes", with_custom_attributes)

    @property
    @pulumi.getter(name="allAvailable")
    def all_available(self) -> bool:
        """
        Show all the groups you have access to.
        """
        return pulumi.get(self, "all_available")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> int:
        """
        The ID of the group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="minAccessLevel")
    def min_access_level(self) -> str:
        """
        Limit to groups where current user has at least this access level.
        """
        return pulumi.get(self, "min_access_level")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> str:
        """
        Order groups by name, path or id.
        """
        return pulumi.get(self, "order_by")

    @property
    @pulumi.getter
    def owned(self) -> bool:
        """
        Limit to groups explicitly owned by the current user.
        """
        return pulumi.get(self, "owned")

    @property
    @pulumi.getter
    def search(self) -> str:
        """
        Return the list of authorized groups matching the search criteria.
        """
        return pulumi.get(self, "search")

    @property
    @pulumi.getter(name="skipGroups")
    def skip_groups(self) -> Sequence[int]:
        """
        Skip the group IDs passed.
        """
        return pulumi.get(self, "skip_groups")

    @property
    @pulumi.getter
    def sort(self) -> str:
        """
        Order groups in asc or desc order.
        """
        return pulumi.get(self, "sort")

    @property
    @pulumi.getter
    def statistics(self) -> bool:
        """
        Include group statistics (administrators only).
        """
        return pulumi.get(self, "statistics")

    @property
    @pulumi.getter
    def subgroups(self) -> Sequence['outputs.GetGroupSubgroupsSubgroupResult']:
        """
        Subgroups of the parent group.
        """
        return pulumi.get(self, "subgroups")

    @property
    @pulumi.getter(name="withCustomAttributes")
    def with_custom_attributes(self) -> bool:
        """
        Include custom attributes in response (administrators only).
        """
        return pulumi.get(self, "with_custom_attributes")


class AwaitableGetGroupSubgroupsResult(GetGroupSubgroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupSubgroupsResult(
            all_available=self.all_available,
            group_id=self.group_id,
            id=self.id,
            min_access_level=self.min_access_level,
            order_by=self.order_by,
            owned=self.owned,
            search=self.search,
            skip_groups=self.skip_groups,
            sort=self.sort,
            statistics=self.statistics,
            subgroups=self.subgroups,
            with_custom_attributes=self.with_custom_attributes)


def get_group_subgroups(all_available: Optional[bool] = None,
                        group_id: Optional[int] = None,
                        min_access_level: Optional[str] = None,
                        order_by: Optional[str] = None,
                        owned: Optional[bool] = None,
                        search: Optional[str] = None,
                        skip_groups: Optional[Sequence[int]] = None,
                        sort: Optional[str] = None,
                        statistics: Optional[bool] = None,
                        with_custom_attributes: Optional[bool] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupSubgroupsResult:
    """
    The `get_group_subgroups` data source allows to get subgroups of a group.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#list-a-groups-subgroups)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    subgroups_group_subgroups = gitlab.get_group_subgroups(group_id=123456)
    pulumi.export("subgroups", subgroups_group_subgroups)
    ```


    :param bool all_available: Show all the groups you have access to.
    :param str min_access_level: Limit to groups where current user has at least this access level.
    :param str order_by: Order groups by name, path or id.
    :param bool owned: Limit to groups explicitly owned by the current user.
    :param str search: Return the list of authorized groups matching the search criteria.
    :param Sequence[int] skip_groups: Skip the group IDs passed.
    :param str sort: Order groups in asc or desc order.
    :param bool with_custom_attributes: Include custom attributes in response (administrators only).
    """
    __args__ = dict()
    __args__['allAvailable'] = all_available
    __args__['groupId'] = group_id
    __args__['minAccessLevel'] = min_access_level
    __args__['orderBy'] = order_by
    __args__['owned'] = owned
    __args__['search'] = search
    __args__['skipGroups'] = skip_groups
    __args__['sort'] = sort
    __args__['statistics'] = statistics
    __args__['withCustomAttributes'] = with_custom_attributes
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getGroupSubgroups:getGroupSubgroups', __args__, opts=opts, typ=GetGroupSubgroupsResult).value

    return AwaitableGetGroupSubgroupsResult(
        all_available=pulumi.get(__ret__, 'all_available'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        min_access_level=pulumi.get(__ret__, 'min_access_level'),
        order_by=pulumi.get(__ret__, 'order_by'),
        owned=pulumi.get(__ret__, 'owned'),
        search=pulumi.get(__ret__, 'search'),
        skip_groups=pulumi.get(__ret__, 'skip_groups'),
        sort=pulumi.get(__ret__, 'sort'),
        statistics=pulumi.get(__ret__, 'statistics'),
        subgroups=pulumi.get(__ret__, 'subgroups'),
        with_custom_attributes=pulumi.get(__ret__, 'with_custom_attributes'))


@_utilities.lift_output_func(get_group_subgroups)
def get_group_subgroups_output(all_available: Optional[pulumi.Input[Optional[bool]]] = None,
                               group_id: Optional[pulumi.Input[int]] = None,
                               min_access_level: Optional[pulumi.Input[Optional[str]]] = None,
                               order_by: Optional[pulumi.Input[Optional[str]]] = None,
                               owned: Optional[pulumi.Input[Optional[bool]]] = None,
                               search: Optional[pulumi.Input[Optional[str]]] = None,
                               skip_groups: Optional[pulumi.Input[Optional[Sequence[int]]]] = None,
                               sort: Optional[pulumi.Input[Optional[str]]] = None,
                               statistics: Optional[pulumi.Input[Optional[bool]]] = None,
                               with_custom_attributes: Optional[pulumi.Input[Optional[bool]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGroupSubgroupsResult]:
    """
    The `get_group_subgroups` data source allows to get subgroups of a group.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#list-a-groups-subgroups)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    subgroups_group_subgroups = gitlab.get_group_subgroups(group_id=123456)
    pulumi.export("subgroups", subgroups_group_subgroups)
    ```


    :param bool all_available: Show all the groups you have access to.
    :param str min_access_level: Limit to groups where current user has at least this access level.
    :param str order_by: Order groups by name, path or id.
    :param bool owned: Limit to groups explicitly owned by the current user.
    :param str search: Return the list of authorized groups matching the search criteria.
    :param Sequence[int] skip_groups: Skip the group IDs passed.
    :param str sort: Order groups in asc or desc order.
    :param bool with_custom_attributes: Include custom attributes in response (administrators only).
    """
    ...
