# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, analytics_access_level=None, archived=None, auto_cancel_pending_pipelines=None, auto_devops_deploy_strategy=None, auto_devops_enabled=None, autoclose_referenced_issues=None, build_git_strategy=None, build_timeout=None, builds_access_level=None, ci_config_path=None, ci_default_git_depth=None, ci_separated_caches=None, container_expiration_policies=None, container_registry_access_level=None, default_branch=None, description=None, emails_disabled=None, empty_repo=None, environments_access_level=None, external_authorization_classification_label=None, feature_flags_access_level=None, forking_access_level=None, http_url_to_repo=None, id=None, import_url=None, infrastructure_access_level=None, issues_access_level=None, issues_enabled=None, keep_latest_artifact=None, lfs_enabled=None, merge_commit_template=None, merge_pipelines_enabled=None, merge_requests_access_level=None, merge_requests_enabled=None, merge_trains_enabled=None, monitor_access_level=None, name=None, namespace_id=None, path=None, path_with_namespace=None, pipelines_enabled=None, printing_merge_request_link_enabled=None, public_builds=None, push_rules=None, releases_access_level=None, remove_source_branch_after_merge=None, repository_access_level=None, repository_storage=None, request_access_enabled=None, requirements_access_level=None, resolve_outdated_diff_discussions=None, restrict_user_defined_variables=None, runners_token=None, security_and_compliance_access_level=None, shared_with_groups=None, snippets_access_level=None, snippets_enabled=None, squash_commit_template=None, ssh_url_to_repo=None, suggestion_commit_message=None, topics=None, visibility_level=None, web_url=None, wiki_access_level=None, wiki_enabled=None):
        if analytics_access_level and not isinstance(analytics_access_level, str):
            raise TypeError("Expected argument 'analytics_access_level' to be a str")
        pulumi.set(__self__, "analytics_access_level", analytics_access_level)
        if archived and not isinstance(archived, bool):
            raise TypeError("Expected argument 'archived' to be a bool")
        pulumi.set(__self__, "archived", archived)
        if auto_cancel_pending_pipelines and not isinstance(auto_cancel_pending_pipelines, str):
            raise TypeError("Expected argument 'auto_cancel_pending_pipelines' to be a str")
        pulumi.set(__self__, "auto_cancel_pending_pipelines", auto_cancel_pending_pipelines)
        if auto_devops_deploy_strategy and not isinstance(auto_devops_deploy_strategy, str):
            raise TypeError("Expected argument 'auto_devops_deploy_strategy' to be a str")
        pulumi.set(__self__, "auto_devops_deploy_strategy", auto_devops_deploy_strategy)
        if auto_devops_enabled and not isinstance(auto_devops_enabled, bool):
            raise TypeError("Expected argument 'auto_devops_enabled' to be a bool")
        pulumi.set(__self__, "auto_devops_enabled", auto_devops_enabled)
        if autoclose_referenced_issues and not isinstance(autoclose_referenced_issues, bool):
            raise TypeError("Expected argument 'autoclose_referenced_issues' to be a bool")
        pulumi.set(__self__, "autoclose_referenced_issues", autoclose_referenced_issues)
        if build_git_strategy and not isinstance(build_git_strategy, str):
            raise TypeError("Expected argument 'build_git_strategy' to be a str")
        pulumi.set(__self__, "build_git_strategy", build_git_strategy)
        if build_timeout and not isinstance(build_timeout, int):
            raise TypeError("Expected argument 'build_timeout' to be a int")
        pulumi.set(__self__, "build_timeout", build_timeout)
        if builds_access_level and not isinstance(builds_access_level, str):
            raise TypeError("Expected argument 'builds_access_level' to be a str")
        pulumi.set(__self__, "builds_access_level", builds_access_level)
        if ci_config_path and not isinstance(ci_config_path, str):
            raise TypeError("Expected argument 'ci_config_path' to be a str")
        pulumi.set(__self__, "ci_config_path", ci_config_path)
        if ci_default_git_depth and not isinstance(ci_default_git_depth, int):
            raise TypeError("Expected argument 'ci_default_git_depth' to be a int")
        pulumi.set(__self__, "ci_default_git_depth", ci_default_git_depth)
        if ci_separated_caches and not isinstance(ci_separated_caches, bool):
            raise TypeError("Expected argument 'ci_separated_caches' to be a bool")
        pulumi.set(__self__, "ci_separated_caches", ci_separated_caches)
        if container_expiration_policies and not isinstance(container_expiration_policies, list):
            raise TypeError("Expected argument 'container_expiration_policies' to be a list")
        pulumi.set(__self__, "container_expiration_policies", container_expiration_policies)
        if container_registry_access_level and not isinstance(container_registry_access_level, str):
            raise TypeError("Expected argument 'container_registry_access_level' to be a str")
        pulumi.set(__self__, "container_registry_access_level", container_registry_access_level)
        if default_branch and not isinstance(default_branch, str):
            raise TypeError("Expected argument 'default_branch' to be a str")
        pulumi.set(__self__, "default_branch", default_branch)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if emails_disabled and not isinstance(emails_disabled, bool):
            raise TypeError("Expected argument 'emails_disabled' to be a bool")
        pulumi.set(__self__, "emails_disabled", emails_disabled)
        if empty_repo and not isinstance(empty_repo, bool):
            raise TypeError("Expected argument 'empty_repo' to be a bool")
        pulumi.set(__self__, "empty_repo", empty_repo)
        if environments_access_level and not isinstance(environments_access_level, str):
            raise TypeError("Expected argument 'environments_access_level' to be a str")
        pulumi.set(__self__, "environments_access_level", environments_access_level)
        if external_authorization_classification_label and not isinstance(external_authorization_classification_label, str):
            raise TypeError("Expected argument 'external_authorization_classification_label' to be a str")
        pulumi.set(__self__, "external_authorization_classification_label", external_authorization_classification_label)
        if feature_flags_access_level and not isinstance(feature_flags_access_level, str):
            raise TypeError("Expected argument 'feature_flags_access_level' to be a str")
        pulumi.set(__self__, "feature_flags_access_level", feature_flags_access_level)
        if forking_access_level and not isinstance(forking_access_level, str):
            raise TypeError("Expected argument 'forking_access_level' to be a str")
        pulumi.set(__self__, "forking_access_level", forking_access_level)
        if http_url_to_repo and not isinstance(http_url_to_repo, str):
            raise TypeError("Expected argument 'http_url_to_repo' to be a str")
        pulumi.set(__self__, "http_url_to_repo", http_url_to_repo)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if import_url and not isinstance(import_url, str):
            raise TypeError("Expected argument 'import_url' to be a str")
        pulumi.set(__self__, "import_url", import_url)
        if infrastructure_access_level and not isinstance(infrastructure_access_level, str):
            raise TypeError("Expected argument 'infrastructure_access_level' to be a str")
        pulumi.set(__self__, "infrastructure_access_level", infrastructure_access_level)
        if issues_access_level and not isinstance(issues_access_level, str):
            raise TypeError("Expected argument 'issues_access_level' to be a str")
        pulumi.set(__self__, "issues_access_level", issues_access_level)
        if issues_enabled and not isinstance(issues_enabled, bool):
            raise TypeError("Expected argument 'issues_enabled' to be a bool")
        pulumi.set(__self__, "issues_enabled", issues_enabled)
        if keep_latest_artifact and not isinstance(keep_latest_artifact, bool):
            raise TypeError("Expected argument 'keep_latest_artifact' to be a bool")
        pulumi.set(__self__, "keep_latest_artifact", keep_latest_artifact)
        if lfs_enabled and not isinstance(lfs_enabled, bool):
            raise TypeError("Expected argument 'lfs_enabled' to be a bool")
        pulumi.set(__self__, "lfs_enabled", lfs_enabled)
        if merge_commit_template and not isinstance(merge_commit_template, str):
            raise TypeError("Expected argument 'merge_commit_template' to be a str")
        pulumi.set(__self__, "merge_commit_template", merge_commit_template)
        if merge_pipelines_enabled and not isinstance(merge_pipelines_enabled, bool):
            raise TypeError("Expected argument 'merge_pipelines_enabled' to be a bool")
        pulumi.set(__self__, "merge_pipelines_enabled", merge_pipelines_enabled)
        if merge_requests_access_level and not isinstance(merge_requests_access_level, str):
            raise TypeError("Expected argument 'merge_requests_access_level' to be a str")
        pulumi.set(__self__, "merge_requests_access_level", merge_requests_access_level)
        if merge_requests_enabled and not isinstance(merge_requests_enabled, bool):
            raise TypeError("Expected argument 'merge_requests_enabled' to be a bool")
        pulumi.set(__self__, "merge_requests_enabled", merge_requests_enabled)
        if merge_trains_enabled and not isinstance(merge_trains_enabled, bool):
            raise TypeError("Expected argument 'merge_trains_enabled' to be a bool")
        pulumi.set(__self__, "merge_trains_enabled", merge_trains_enabled)
        if monitor_access_level and not isinstance(monitor_access_level, str):
            raise TypeError("Expected argument 'monitor_access_level' to be a str")
        pulumi.set(__self__, "monitor_access_level", monitor_access_level)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace_id and not isinstance(namespace_id, int):
            raise TypeError("Expected argument 'namespace_id' to be a int")
        pulumi.set(__self__, "namespace_id", namespace_id)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if path_with_namespace and not isinstance(path_with_namespace, str):
            raise TypeError("Expected argument 'path_with_namespace' to be a str")
        pulumi.set(__self__, "path_with_namespace", path_with_namespace)
        if pipelines_enabled and not isinstance(pipelines_enabled, bool):
            raise TypeError("Expected argument 'pipelines_enabled' to be a bool")
        pulumi.set(__self__, "pipelines_enabled", pipelines_enabled)
        if printing_merge_request_link_enabled and not isinstance(printing_merge_request_link_enabled, bool):
            raise TypeError("Expected argument 'printing_merge_request_link_enabled' to be a bool")
        pulumi.set(__self__, "printing_merge_request_link_enabled", printing_merge_request_link_enabled)
        if public_builds and not isinstance(public_builds, bool):
            raise TypeError("Expected argument 'public_builds' to be a bool")
        pulumi.set(__self__, "public_builds", public_builds)
        if push_rules and not isinstance(push_rules, list):
            raise TypeError("Expected argument 'push_rules' to be a list")
        pulumi.set(__self__, "push_rules", push_rules)
        if releases_access_level and not isinstance(releases_access_level, str):
            raise TypeError("Expected argument 'releases_access_level' to be a str")
        pulumi.set(__self__, "releases_access_level", releases_access_level)
        if remove_source_branch_after_merge and not isinstance(remove_source_branch_after_merge, bool):
            raise TypeError("Expected argument 'remove_source_branch_after_merge' to be a bool")
        pulumi.set(__self__, "remove_source_branch_after_merge", remove_source_branch_after_merge)
        if repository_access_level and not isinstance(repository_access_level, str):
            raise TypeError("Expected argument 'repository_access_level' to be a str")
        pulumi.set(__self__, "repository_access_level", repository_access_level)
        if repository_storage and not isinstance(repository_storage, str):
            raise TypeError("Expected argument 'repository_storage' to be a str")
        pulumi.set(__self__, "repository_storage", repository_storage)
        if request_access_enabled and not isinstance(request_access_enabled, bool):
            raise TypeError("Expected argument 'request_access_enabled' to be a bool")
        pulumi.set(__self__, "request_access_enabled", request_access_enabled)
        if requirements_access_level and not isinstance(requirements_access_level, str):
            raise TypeError("Expected argument 'requirements_access_level' to be a str")
        pulumi.set(__self__, "requirements_access_level", requirements_access_level)
        if resolve_outdated_diff_discussions and not isinstance(resolve_outdated_diff_discussions, bool):
            raise TypeError("Expected argument 'resolve_outdated_diff_discussions' to be a bool")
        pulumi.set(__self__, "resolve_outdated_diff_discussions", resolve_outdated_diff_discussions)
        if restrict_user_defined_variables and not isinstance(restrict_user_defined_variables, bool):
            raise TypeError("Expected argument 'restrict_user_defined_variables' to be a bool")
        pulumi.set(__self__, "restrict_user_defined_variables", restrict_user_defined_variables)
        if runners_token and not isinstance(runners_token, str):
            raise TypeError("Expected argument 'runners_token' to be a str")
        pulumi.set(__self__, "runners_token", runners_token)
        if security_and_compliance_access_level and not isinstance(security_and_compliance_access_level, str):
            raise TypeError("Expected argument 'security_and_compliance_access_level' to be a str")
        pulumi.set(__self__, "security_and_compliance_access_level", security_and_compliance_access_level)
        if shared_with_groups and not isinstance(shared_with_groups, list):
            raise TypeError("Expected argument 'shared_with_groups' to be a list")
        pulumi.set(__self__, "shared_with_groups", shared_with_groups)
        if snippets_access_level and not isinstance(snippets_access_level, str):
            raise TypeError("Expected argument 'snippets_access_level' to be a str")
        pulumi.set(__self__, "snippets_access_level", snippets_access_level)
        if snippets_enabled and not isinstance(snippets_enabled, bool):
            raise TypeError("Expected argument 'snippets_enabled' to be a bool")
        pulumi.set(__self__, "snippets_enabled", snippets_enabled)
        if squash_commit_template and not isinstance(squash_commit_template, str):
            raise TypeError("Expected argument 'squash_commit_template' to be a str")
        pulumi.set(__self__, "squash_commit_template", squash_commit_template)
        if ssh_url_to_repo and not isinstance(ssh_url_to_repo, str):
            raise TypeError("Expected argument 'ssh_url_to_repo' to be a str")
        pulumi.set(__self__, "ssh_url_to_repo", ssh_url_to_repo)
        if suggestion_commit_message and not isinstance(suggestion_commit_message, str):
            raise TypeError("Expected argument 'suggestion_commit_message' to be a str")
        pulumi.set(__self__, "suggestion_commit_message", suggestion_commit_message)
        if topics and not isinstance(topics, list):
            raise TypeError("Expected argument 'topics' to be a list")
        pulumi.set(__self__, "topics", topics)
        if visibility_level and not isinstance(visibility_level, str):
            raise TypeError("Expected argument 'visibility_level' to be a str")
        pulumi.set(__self__, "visibility_level", visibility_level)
        if web_url and not isinstance(web_url, str):
            raise TypeError("Expected argument 'web_url' to be a str")
        pulumi.set(__self__, "web_url", web_url)
        if wiki_access_level and not isinstance(wiki_access_level, str):
            raise TypeError("Expected argument 'wiki_access_level' to be a str")
        pulumi.set(__self__, "wiki_access_level", wiki_access_level)
        if wiki_enabled and not isinstance(wiki_enabled, bool):
            raise TypeError("Expected argument 'wiki_enabled' to be a bool")
        pulumi.set(__self__, "wiki_enabled", wiki_enabled)

    @property
    @pulumi.getter(name="analyticsAccessLevel")
    def analytics_access_level(self) -> str:
        """
        Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "analytics_access_level")

    @property
    @pulumi.getter
    def archived(self) -> bool:
        """
        Whether the project is in read-only mode (archived).
        """
        return pulumi.get(self, "archived")

    @property
    @pulumi.getter(name="autoCancelPendingPipelines")
    def auto_cancel_pending_pipelines(self) -> str:
        """
        Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        """
        return pulumi.get(self, "auto_cancel_pending_pipelines")

    @property
    @pulumi.getter(name="autoDevopsDeployStrategy")
    def auto_devops_deploy_strategy(self) -> str:
        """
        Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        """
        return pulumi.get(self, "auto_devops_deploy_strategy")

    @property
    @pulumi.getter(name="autoDevopsEnabled")
    def auto_devops_enabled(self) -> bool:
        """
        Enable Auto DevOps for this project.
        """
        return pulumi.get(self, "auto_devops_enabled")

    @property
    @pulumi.getter(name="autocloseReferencedIssues")
    def autoclose_referenced_issues(self) -> bool:
        """
        Set whether auto-closing referenced issues on default branch.
        """
        return pulumi.get(self, "autoclose_referenced_issues")

    @property
    @pulumi.getter(name="buildGitStrategy")
    def build_git_strategy(self) -> str:
        """
        The Git strategy. Defaults to fetch.
        """
        return pulumi.get(self, "build_git_strategy")

    @property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> int:
        """
        The maximum amount of time, in seconds, that a job can run.
        """
        return pulumi.get(self, "build_timeout")

    @property
    @pulumi.getter(name="buildsAccessLevel")
    def builds_access_level(self) -> str:
        """
        Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "builds_access_level")

    @property
    @pulumi.getter(name="ciConfigPath")
    def ci_config_path(self) -> str:
        """
        CI config file path for the project.
        """
        return pulumi.get(self, "ci_config_path")

    @property
    @pulumi.getter(name="ciDefaultGitDepth")
    def ci_default_git_depth(self) -> int:
        """
        Default number of revisions for shallow cloning.
        """
        return pulumi.get(self, "ci_default_git_depth")

    @property
    @pulumi.getter(name="ciSeparatedCaches")
    def ci_separated_caches(self) -> bool:
        """
        Use separate caches for protected branches.
        """
        return pulumi.get(self, "ci_separated_caches")

    @property
    @pulumi.getter(name="containerExpirationPolicies")
    def container_expiration_policies(self) -> Sequence['outputs.GetProjectContainerExpirationPolicyResult']:
        """
        Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        """
        return pulumi.get(self, "container_expiration_policies")

    @property
    @pulumi.getter(name="containerRegistryAccessLevel")
    def container_registry_access_level(self) -> str:
        """
        Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "container_registry_access_level")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> str:
        """
        The default branch for the project.
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailsDisabled")
    def emails_disabled(self) -> bool:
        """
        Disable email notifications.
        """
        return pulumi.get(self, "emails_disabled")

    @property
    @pulumi.getter(name="emptyRepo")
    def empty_repo(self) -> bool:
        """
        Whether the project is empty.
        """
        return pulumi.get(self, "empty_repo")

    @property
    @pulumi.getter(name="environmentsAccessLevel")
    def environments_access_level(self) -> str:
        """
        Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "environments_access_level")

    @property
    @pulumi.getter(name="externalAuthorizationClassificationLabel")
    def external_authorization_classification_label(self) -> str:
        """
        The classification label for the project.
        """
        return pulumi.get(self, "external_authorization_classification_label")

    @property
    @pulumi.getter(name="featureFlagsAccessLevel")
    def feature_flags_access_level(self) -> str:
        """
        Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "feature_flags_access_level")

    @property
    @pulumi.getter(name="forkingAccessLevel")
    def forking_access_level(self) -> str:
        """
        Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "forking_access_level")

    @property
    @pulumi.getter(name="httpUrlToRepo")
    def http_url_to_repo(self) -> str:
        """
        URL that can be provided to `git clone` to clone the
        """
        return pulumi.get(self, "http_url_to_repo")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The integer that uniquely identifies the project within the gitlab install.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="importUrl")
    def import_url(self) -> str:
        """
        URL the project was imported from.
        """
        return pulumi.get(self, "import_url")

    @property
    @pulumi.getter(name="infrastructureAccessLevel")
    def infrastructure_access_level(self) -> str:
        """
        Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "infrastructure_access_level")

    @property
    @pulumi.getter(name="issuesAccessLevel")
    def issues_access_level(self) -> str:
        """
        Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "issues_access_level")

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> bool:
        """
        Enable issue tracking for the project.
        """
        return pulumi.get(self, "issues_enabled")

    @property
    @pulumi.getter(name="keepLatestArtifact")
    def keep_latest_artifact(self) -> bool:
        """
        Disable or enable the ability to keep the latest artifact for this project.
        """
        return pulumi.get(self, "keep_latest_artifact")

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> bool:
        """
        Enable LFS for the project.
        """
        return pulumi.get(self, "lfs_enabled")

    @property
    @pulumi.getter(name="mergeCommitTemplate")
    def merge_commit_template(self) -> str:
        """
        Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
        """
        return pulumi.get(self, "merge_commit_template")

    @property
    @pulumi.getter(name="mergePipelinesEnabled")
    def merge_pipelines_enabled(self) -> bool:
        """
        Enable or disable merge pipelines.
        """
        return pulumi.get(self, "merge_pipelines_enabled")

    @property
    @pulumi.getter(name="mergeRequestsAccessLevel")
    def merge_requests_access_level(self) -> str:
        """
        Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "merge_requests_access_level")

    @property
    @pulumi.getter(name="mergeRequestsEnabled")
    def merge_requests_enabled(self) -> bool:
        """
        Enable merge requests for the project.
        """
        return pulumi.get(self, "merge_requests_enabled")

    @property
    @pulumi.getter(name="mergeTrainsEnabled")
    def merge_trains_enabled(self) -> bool:
        """
        Enable or disable merge trains.
        """
        return pulumi.get(self, "merge_trains_enabled")

    @property
    @pulumi.getter(name="monitorAccessLevel")
    def monitor_access_level(self) -> str:
        """
        Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "monitor_access_level")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> int:
        """
        The namespace (group or user) of the project. Defaults to your user.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path of the repository.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathWithNamespace")
    def path_with_namespace(self) -> str:
        """
        The path of the repository with namespace.
        """
        return pulumi.get(self, "path_with_namespace")

    @property
    @pulumi.getter(name="pipelinesEnabled")
    def pipelines_enabled(self) -> bool:
        """
        Enable pipelines for the project.
        """
        return pulumi.get(self, "pipelines_enabled")

    @property
    @pulumi.getter(name="printingMergeRequestLinkEnabled")
    def printing_merge_request_link_enabled(self) -> bool:
        """
        Show link to create/view merge request when pushing from the command line
        """
        return pulumi.get(self, "printing_merge_request_link_enabled")

    @property
    @pulumi.getter(name="publicBuilds")
    def public_builds(self) -> Optional[bool]:
        """
        If true, jobs can be viewed by non-project members.
        """
        return pulumi.get(self, "public_builds")

    @property
    @pulumi.getter(name="pushRules")
    def push_rules(self) -> Sequence['outputs.GetProjectPushRuleResult']:
        """
        Push rules for the project. Push rules are only available on Enterprise plans and if the authenticated has permissions to read them.
        """
        return pulumi.get(self, "push_rules")

    @property
    @pulumi.getter(name="releasesAccessLevel")
    def releases_access_level(self) -> str:
        """
        Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "releases_access_level")

    @property
    @pulumi.getter(name="removeSourceBranchAfterMerge")
    def remove_source_branch_after_merge(self) -> bool:
        """
        Enable `Delete source branch` option by default for all new merge requests
        """
        return pulumi.get(self, "remove_source_branch_after_merge")

    @property
    @pulumi.getter(name="repositoryAccessLevel")
    def repository_access_level(self) -> str:
        """
        Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "repository_access_level")

    @property
    @pulumi.getter(name="repositoryStorage")
    def repository_storage(self) -> str:
        """
        Which storage shard the repository is on. (administrator only)
        """
        return pulumi.get(self, "repository_storage")

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> bool:
        """
        Allow users to request member access.
        """
        return pulumi.get(self, "request_access_enabled")

    @property
    @pulumi.getter(name="requirementsAccessLevel")
    def requirements_access_level(self) -> str:
        """
        Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "requirements_access_level")

    @property
    @pulumi.getter(name="resolveOutdatedDiffDiscussions")
    def resolve_outdated_diff_discussions(self) -> bool:
        """
        Automatically resolve merge request diffs discussions on lines changed with a push.
        """
        return pulumi.get(self, "resolve_outdated_diff_discussions")

    @property
    @pulumi.getter(name="restrictUserDefinedVariables")
    def restrict_user_defined_variables(self) -> bool:
        """
        Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        """
        return pulumi.get(self, "restrict_user_defined_variables")

    @property
    @pulumi.getter(name="runnersToken")
    def runners_token(self) -> str:
        """
        Registration token to use during runner setup.
        """
        return pulumi.get(self, "runners_token")

    @property
    @pulumi.getter(name="securityAndComplianceAccessLevel")
    def security_and_compliance_access_level(self) -> str:
        """
        Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "security_and_compliance_access_level")

    @property
    @pulumi.getter(name="sharedWithGroups")
    def shared_with_groups(self) -> Sequence['outputs.GetProjectSharedWithGroupResult']:
        """
        Describes groups which have access shared to this project.
        """
        return pulumi.get(self, "shared_with_groups")

    @property
    @pulumi.getter(name="snippetsAccessLevel")
    def snippets_access_level(self) -> str:
        """
        Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "snippets_access_level")

    @property
    @pulumi.getter(name="snippetsEnabled")
    def snippets_enabled(self) -> bool:
        """
        Enable snippets for the project.
        """
        return pulumi.get(self, "snippets_enabled")

    @property
    @pulumi.getter(name="squashCommitTemplate")
    def squash_commit_template(self) -> str:
        """
        Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
        """
        return pulumi.get(self, "squash_commit_template")

    @property
    @pulumi.getter(name="sshUrlToRepo")
    def ssh_url_to_repo(self) -> str:
        """
        URL that can be provided to `git clone` to clone the
        """
        return pulumi.get(self, "ssh_url_to_repo")

    @property
    @pulumi.getter(name="suggestionCommitMessage")
    def suggestion_commit_message(self) -> str:
        """
        The commit message used to apply merge request suggestions.
        """
        return pulumi.get(self, "suggestion_commit_message")

    @property
    @pulumi.getter
    def topics(self) -> Sequence[str]:
        """
        The list of topics for the project.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter(name="visibilityLevel")
    def visibility_level(self) -> str:
        """
        Repositories are created as private by default.
        """
        return pulumi.get(self, "visibility_level")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> str:
        """
        URL that can be used to find the project in a browser.
        """
        return pulumi.get(self, "web_url")

    @property
    @pulumi.getter(name="wikiAccessLevel")
    def wiki_access_level(self) -> str:
        """
        Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "wiki_access_level")

    @property
    @pulumi.getter(name="wikiEnabled")
    def wiki_enabled(self) -> bool:
        """
        Enable wiki for the project.
        """
        return pulumi.get(self, "wiki_enabled")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            analytics_access_level=self.analytics_access_level,
            archived=self.archived,
            auto_cancel_pending_pipelines=self.auto_cancel_pending_pipelines,
            auto_devops_deploy_strategy=self.auto_devops_deploy_strategy,
            auto_devops_enabled=self.auto_devops_enabled,
            autoclose_referenced_issues=self.autoclose_referenced_issues,
            build_git_strategy=self.build_git_strategy,
            build_timeout=self.build_timeout,
            builds_access_level=self.builds_access_level,
            ci_config_path=self.ci_config_path,
            ci_default_git_depth=self.ci_default_git_depth,
            ci_separated_caches=self.ci_separated_caches,
            container_expiration_policies=self.container_expiration_policies,
            container_registry_access_level=self.container_registry_access_level,
            default_branch=self.default_branch,
            description=self.description,
            emails_disabled=self.emails_disabled,
            empty_repo=self.empty_repo,
            environments_access_level=self.environments_access_level,
            external_authorization_classification_label=self.external_authorization_classification_label,
            feature_flags_access_level=self.feature_flags_access_level,
            forking_access_level=self.forking_access_level,
            http_url_to_repo=self.http_url_to_repo,
            id=self.id,
            import_url=self.import_url,
            infrastructure_access_level=self.infrastructure_access_level,
            issues_access_level=self.issues_access_level,
            issues_enabled=self.issues_enabled,
            keep_latest_artifact=self.keep_latest_artifact,
            lfs_enabled=self.lfs_enabled,
            merge_commit_template=self.merge_commit_template,
            merge_pipelines_enabled=self.merge_pipelines_enabled,
            merge_requests_access_level=self.merge_requests_access_level,
            merge_requests_enabled=self.merge_requests_enabled,
            merge_trains_enabled=self.merge_trains_enabled,
            monitor_access_level=self.monitor_access_level,
            name=self.name,
            namespace_id=self.namespace_id,
            path=self.path,
            path_with_namespace=self.path_with_namespace,
            pipelines_enabled=self.pipelines_enabled,
            printing_merge_request_link_enabled=self.printing_merge_request_link_enabled,
            public_builds=self.public_builds,
            push_rules=self.push_rules,
            releases_access_level=self.releases_access_level,
            remove_source_branch_after_merge=self.remove_source_branch_after_merge,
            repository_access_level=self.repository_access_level,
            repository_storage=self.repository_storage,
            request_access_enabled=self.request_access_enabled,
            requirements_access_level=self.requirements_access_level,
            resolve_outdated_diff_discussions=self.resolve_outdated_diff_discussions,
            restrict_user_defined_variables=self.restrict_user_defined_variables,
            runners_token=self.runners_token,
            security_and_compliance_access_level=self.security_and_compliance_access_level,
            shared_with_groups=self.shared_with_groups,
            snippets_access_level=self.snippets_access_level,
            snippets_enabled=self.snippets_enabled,
            squash_commit_template=self.squash_commit_template,
            ssh_url_to_repo=self.ssh_url_to_repo,
            suggestion_commit_message=self.suggestion_commit_message,
            topics=self.topics,
            visibility_level=self.visibility_level,
            web_url=self.web_url,
            wiki_access_level=self.wiki_access_level,
            wiki_enabled=self.wiki_enabled)


def get_project(ci_default_git_depth: Optional[int] = None,
                id: Optional[str] = None,
                path_with_namespace: Optional[str] = None,
                public_builds: Optional[bool] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    The `Project` data source allows details of a project to be retrieved by either its ID or its path with namespace.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/projects.html#get-single-project)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_project(path_with_namespace="foo/bar/baz")
    ```


    :param int ci_default_git_depth: Default number of revisions for shallow cloning.
    :param str id: The integer that uniquely identifies the project within the gitlab install.
    :param str path_with_namespace: The path of the repository with namespace.
    :param bool public_builds: If true, jobs can be viewed by non-project members.
    """
    __args__ = dict()
    __args__['ciDefaultGitDepth'] = ci_default_git_depth
    __args__['id'] = id
    __args__['pathWithNamespace'] = path_with_namespace
    __args__['publicBuilds'] = public_builds
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        analytics_access_level=pulumi.get(__ret__, 'analytics_access_level'),
        archived=pulumi.get(__ret__, 'archived'),
        auto_cancel_pending_pipelines=pulumi.get(__ret__, 'auto_cancel_pending_pipelines'),
        auto_devops_deploy_strategy=pulumi.get(__ret__, 'auto_devops_deploy_strategy'),
        auto_devops_enabled=pulumi.get(__ret__, 'auto_devops_enabled'),
        autoclose_referenced_issues=pulumi.get(__ret__, 'autoclose_referenced_issues'),
        build_git_strategy=pulumi.get(__ret__, 'build_git_strategy'),
        build_timeout=pulumi.get(__ret__, 'build_timeout'),
        builds_access_level=pulumi.get(__ret__, 'builds_access_level'),
        ci_config_path=pulumi.get(__ret__, 'ci_config_path'),
        ci_default_git_depth=pulumi.get(__ret__, 'ci_default_git_depth'),
        ci_separated_caches=pulumi.get(__ret__, 'ci_separated_caches'),
        container_expiration_policies=pulumi.get(__ret__, 'container_expiration_policies'),
        container_registry_access_level=pulumi.get(__ret__, 'container_registry_access_level'),
        default_branch=pulumi.get(__ret__, 'default_branch'),
        description=pulumi.get(__ret__, 'description'),
        emails_disabled=pulumi.get(__ret__, 'emails_disabled'),
        empty_repo=pulumi.get(__ret__, 'empty_repo'),
        environments_access_level=pulumi.get(__ret__, 'environments_access_level'),
        external_authorization_classification_label=pulumi.get(__ret__, 'external_authorization_classification_label'),
        feature_flags_access_level=pulumi.get(__ret__, 'feature_flags_access_level'),
        forking_access_level=pulumi.get(__ret__, 'forking_access_level'),
        http_url_to_repo=pulumi.get(__ret__, 'http_url_to_repo'),
        id=pulumi.get(__ret__, 'id'),
        import_url=pulumi.get(__ret__, 'import_url'),
        infrastructure_access_level=pulumi.get(__ret__, 'infrastructure_access_level'),
        issues_access_level=pulumi.get(__ret__, 'issues_access_level'),
        issues_enabled=pulumi.get(__ret__, 'issues_enabled'),
        keep_latest_artifact=pulumi.get(__ret__, 'keep_latest_artifact'),
        lfs_enabled=pulumi.get(__ret__, 'lfs_enabled'),
        merge_commit_template=pulumi.get(__ret__, 'merge_commit_template'),
        merge_pipelines_enabled=pulumi.get(__ret__, 'merge_pipelines_enabled'),
        merge_requests_access_level=pulumi.get(__ret__, 'merge_requests_access_level'),
        merge_requests_enabled=pulumi.get(__ret__, 'merge_requests_enabled'),
        merge_trains_enabled=pulumi.get(__ret__, 'merge_trains_enabled'),
        monitor_access_level=pulumi.get(__ret__, 'monitor_access_level'),
        name=pulumi.get(__ret__, 'name'),
        namespace_id=pulumi.get(__ret__, 'namespace_id'),
        path=pulumi.get(__ret__, 'path'),
        path_with_namespace=pulumi.get(__ret__, 'path_with_namespace'),
        pipelines_enabled=pulumi.get(__ret__, 'pipelines_enabled'),
        printing_merge_request_link_enabled=pulumi.get(__ret__, 'printing_merge_request_link_enabled'),
        public_builds=pulumi.get(__ret__, 'public_builds'),
        push_rules=pulumi.get(__ret__, 'push_rules'),
        releases_access_level=pulumi.get(__ret__, 'releases_access_level'),
        remove_source_branch_after_merge=pulumi.get(__ret__, 'remove_source_branch_after_merge'),
        repository_access_level=pulumi.get(__ret__, 'repository_access_level'),
        repository_storage=pulumi.get(__ret__, 'repository_storage'),
        request_access_enabled=pulumi.get(__ret__, 'request_access_enabled'),
        requirements_access_level=pulumi.get(__ret__, 'requirements_access_level'),
        resolve_outdated_diff_discussions=pulumi.get(__ret__, 'resolve_outdated_diff_discussions'),
        restrict_user_defined_variables=pulumi.get(__ret__, 'restrict_user_defined_variables'),
        runners_token=pulumi.get(__ret__, 'runners_token'),
        security_and_compliance_access_level=pulumi.get(__ret__, 'security_and_compliance_access_level'),
        shared_with_groups=pulumi.get(__ret__, 'shared_with_groups'),
        snippets_access_level=pulumi.get(__ret__, 'snippets_access_level'),
        snippets_enabled=pulumi.get(__ret__, 'snippets_enabled'),
        squash_commit_template=pulumi.get(__ret__, 'squash_commit_template'),
        ssh_url_to_repo=pulumi.get(__ret__, 'ssh_url_to_repo'),
        suggestion_commit_message=pulumi.get(__ret__, 'suggestion_commit_message'),
        topics=pulumi.get(__ret__, 'topics'),
        visibility_level=pulumi.get(__ret__, 'visibility_level'),
        web_url=pulumi.get(__ret__, 'web_url'),
        wiki_access_level=pulumi.get(__ret__, 'wiki_access_level'),
        wiki_enabled=pulumi.get(__ret__, 'wiki_enabled'))


@_utilities.lift_output_func(get_project)
def get_project_output(ci_default_git_depth: Optional[pulumi.Input[Optional[int]]] = None,
                       id: Optional[pulumi.Input[Optional[str]]] = None,
                       path_with_namespace: Optional[pulumi.Input[Optional[str]]] = None,
                       public_builds: Optional[pulumi.Input[Optional[bool]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectResult]:
    """
    The `Project` data source allows details of a project to be retrieved by either its ID or its path with namespace.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/projects.html#get-single-project)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_project(path_with_namespace="foo/bar/baz")
    ```


    :param int ci_default_git_depth: Default number of revisions for shallow cloning.
    :param str id: The integer that uniquely identifies the project within the gitlab install.
    :param str path_with_namespace: The path of the repository with namespace.
    :param bool public_builds: If true, jobs can be viewed by non-project members.
    """
    ...
