# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 auto_devops_enabled: Optional[pulumi.Input[bool]] = None,
                 avatar: Optional[pulumi.Input[str]] = None,
                 avatar_hash: Optional[pulumi.Input[str]] = None,
                 default_branch_protection: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 emails_disabled: Optional[pulumi.Input[bool]] = None,
                 extra_shared_runners_minutes_limit: Optional[pulumi.Input[int]] = None,
                 ip_restriction_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lfs_enabled: Optional[pulumi.Input[bool]] = None,
                 membership_lock: Optional[pulumi.Input[bool]] = None,
                 mentions_disabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[int]] = None,
                 prevent_forking_outside_group: Optional[pulumi.Input[bool]] = None,
                 project_creation_level: Optional[pulumi.Input[str]] = None,
                 push_rules: Optional[pulumi.Input['GroupPushRulesArgs']] = None,
                 request_access_enabled: Optional[pulumi.Input[bool]] = None,
                 require_two_factor_authentication: Optional[pulumi.Input[bool]] = None,
                 share_with_group_lock: Optional[pulumi.Input[bool]] = None,
                 shared_runners_minutes_limit: Optional[pulumi.Input[int]] = None,
                 shared_runners_setting: Optional[pulumi.Input[str]] = None,
                 subgroup_creation_level: Optional[pulumi.Input[str]] = None,
                 two_factor_grace_period: Optional[pulumi.Input[int]] = None,
                 visibility_level: Optional[pulumi.Input[str]] = None,
                 wiki_access_level: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[str] path: The path of the group.
        :param pulumi.Input[bool] auto_devops_enabled: Default to Auto DevOps pipeline for all projects within this group.
        :param pulumi.Input[str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[int] default_branch_protection: See https://docs.gitlab.com/ee/api/groups.html#options-for-default*branch*protection. Valid values are: `0`, `1`, `2`, `3`, `4`.
        :param pulumi.Input[str] description: The group's description.
        :param pulumi.Input[bool] emails_disabled: Disable email notifications.
        :param pulumi.Input[int] extra_shared_runners_minutes_limit: Can be set by administrators only. Additional CI/CD minutes for this group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_restriction_ranges: A list of IP addresses or subnet masks to restrict group access. Will be concatenated together into a comma separated string. Only allowed on top level groups.
        :param pulumi.Input[bool] lfs_enabled: Enable/disable Large File Storage (LFS) for the projects in this group.
        :param pulumi.Input[bool] membership_lock: Users cannot be added to projects in this group.
        :param pulumi.Input[bool] mentions_disabled: Disable the capability of a group from getting mentioned.
        :param pulumi.Input[str] name: The name of the group.
        :param pulumi.Input[int] parent_id: Id of the parent group (creates a nested group).
        :param pulumi.Input[bool] prevent_forking_outside_group: Defaults to false. When enabled, users can not fork projects from this group to external namespaces.
        :param pulumi.Input[str] project_creation_level: Determine if developers can create projects in the group. Valid values are: `noone`, `maintainer`, `developer`
        :param pulumi.Input['GroupPushRulesArgs'] push_rules: Push rules for the group.
        :param pulumi.Input[bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[bool] require_two_factor_authentication: Require all users in this group to setup Two-factor authentication.
        :param pulumi.Input[bool] share_with_group_lock: Prevent sharing a project with another group within this group.
        :param pulumi.Input[int] shared_runners_minutes_limit: Can be set by administrators only. Maximum number of monthly CI/CD minutes for this group. Can be nil (default; inherit system default), 0 (unlimited), or > 0.
        :param pulumi.Input[str] shared_runners_setting: Enable or disable shared runners for a group’s subgroups and projects. Valid values are: `enabled`, `disabled_and_overridable`, `disabled_and_unoverridable`, `disabled_with_override`.
        :param pulumi.Input[str] subgroup_creation_level: Allowed to create subgroups. Valid values are: `owner`, `maintainer`.
        :param pulumi.Input[int] two_factor_grace_period: Defaults to 48. Time before Two-factor authentication is enforced (in hours).
        :param pulumi.Input[str] visibility_level: The group's visibility. Can be `private`, `internal`, or `public`. Valid values are: `private`, `internal`, `public`.
        :param pulumi.Input[str] wiki_access_level: The group's wiki access level. Only available on Premium and Ultimate plans. Valid values are `disabled`, `private`, `enabled`.
        """
        pulumi.set(__self__, "path", path)
        if auto_devops_enabled is not None:
            pulumi.set(__self__, "auto_devops_enabled", auto_devops_enabled)
        if avatar is not None:
            pulumi.set(__self__, "avatar", avatar)
        if avatar_hash is not None:
            pulumi.set(__self__, "avatar_hash", avatar_hash)
        if default_branch_protection is not None:
            pulumi.set(__self__, "default_branch_protection", default_branch_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if emails_disabled is not None:
            pulumi.set(__self__, "emails_disabled", emails_disabled)
        if extra_shared_runners_minutes_limit is not None:
            pulumi.set(__self__, "extra_shared_runners_minutes_limit", extra_shared_runners_minutes_limit)
        if ip_restriction_ranges is not None:
            pulumi.set(__self__, "ip_restriction_ranges", ip_restriction_ranges)
        if lfs_enabled is not None:
            pulumi.set(__self__, "lfs_enabled", lfs_enabled)
        if membership_lock is not None:
            pulumi.set(__self__, "membership_lock", membership_lock)
        if mentions_disabled is not None:
            pulumi.set(__self__, "mentions_disabled", mentions_disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if prevent_forking_outside_group is not None:
            pulumi.set(__self__, "prevent_forking_outside_group", prevent_forking_outside_group)
        if project_creation_level is not None:
            pulumi.set(__self__, "project_creation_level", project_creation_level)
        if push_rules is not None:
            pulumi.set(__self__, "push_rules", push_rules)
        if request_access_enabled is not None:
            pulumi.set(__self__, "request_access_enabled", request_access_enabled)
        if require_two_factor_authentication is not None:
            pulumi.set(__self__, "require_two_factor_authentication", require_two_factor_authentication)
        if share_with_group_lock is not None:
            pulumi.set(__self__, "share_with_group_lock", share_with_group_lock)
        if shared_runners_minutes_limit is not None:
            pulumi.set(__self__, "shared_runners_minutes_limit", shared_runners_minutes_limit)
        if shared_runners_setting is not None:
            pulumi.set(__self__, "shared_runners_setting", shared_runners_setting)
        if subgroup_creation_level is not None:
            pulumi.set(__self__, "subgroup_creation_level", subgroup_creation_level)
        if two_factor_grace_period is not None:
            pulumi.set(__self__, "two_factor_grace_period", two_factor_grace_period)
        if visibility_level is not None:
            pulumi.set(__self__, "visibility_level", visibility_level)
        if wiki_access_level is not None:
            pulumi.set(__self__, "wiki_access_level", wiki_access_level)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path of the group.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="autoDevopsEnabled")
    def auto_devops_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Default to Auto DevOps pipeline for all projects within this group.
        """
        return pulumi.get(self, "auto_devops_enabled")

    @auto_devops_enabled.setter
    def auto_devops_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_devops_enabled", value)

    @property
    @pulumi.getter
    def avatar(self) -> Optional[pulumi.Input[str]]:
        """
        A local path to the avatar image to upload. **Note**: not available for imported resources.
        """
        return pulumi.get(self, "avatar")

    @avatar.setter
    def avatar(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar", value)

    @property
    @pulumi.getter(name="avatarHash")
    def avatar_hash(self) -> Optional[pulumi.Input[str]]:
        """
        The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        """
        return pulumi.get(self, "avatar_hash")

    @avatar_hash.setter
    def avatar_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar_hash", value)

    @property
    @pulumi.getter(name="defaultBranchProtection")
    def default_branch_protection(self) -> Optional[pulumi.Input[int]]:
        """
        See https://docs.gitlab.com/ee/api/groups.html#options-for-default*branch*protection. Valid values are: `0`, `1`, `2`, `3`, `4`.
        """
        return pulumi.get(self, "default_branch_protection")

    @default_branch_protection.setter
    def default_branch_protection(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_branch_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The group's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailsDisabled")
    def emails_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable email notifications.
        """
        return pulumi.get(self, "emails_disabled")

    @emails_disabled.setter
    def emails_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "emails_disabled", value)

    @property
    @pulumi.getter(name="extraSharedRunnersMinutesLimit")
    def extra_shared_runners_minutes_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Can be set by administrators only. Additional CI/CD minutes for this group.
        """
        return pulumi.get(self, "extra_shared_runners_minutes_limit")

    @extra_shared_runners_minutes_limit.setter
    def extra_shared_runners_minutes_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "extra_shared_runners_minutes_limit", value)

    @property
    @pulumi.getter(name="ipRestrictionRanges")
    def ip_restriction_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IP addresses or subnet masks to restrict group access. Will be concatenated together into a comma separated string. Only allowed on top level groups.
        """
        return pulumi.get(self, "ip_restriction_ranges")

    @ip_restriction_ranges.setter
    def ip_restriction_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_restriction_ranges", value)

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/disable Large File Storage (LFS) for the projects in this group.
        """
        return pulumi.get(self, "lfs_enabled")

    @lfs_enabled.setter
    def lfs_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lfs_enabled", value)

    @property
    @pulumi.getter(name="membershipLock")
    def membership_lock(self) -> Optional[pulumi.Input[bool]]:
        """
        Users cannot be added to projects in this group.
        """
        return pulumi.get(self, "membership_lock")

    @membership_lock.setter
    def membership_lock(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "membership_lock", value)

    @property
    @pulumi.getter(name="mentionsDisabled")
    def mentions_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable the capability of a group from getting mentioned.
        """
        return pulumi.get(self, "mentions_disabled")

    @mentions_disabled.setter
    def mentions_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mentions_disabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[int]]:
        """
        Id of the parent group (creates a nested group).
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="preventForkingOutsideGroup")
    def prevent_forking_outside_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false. When enabled, users can not fork projects from this group to external namespaces.
        """
        return pulumi.get(self, "prevent_forking_outside_group")

    @prevent_forking_outside_group.setter
    def prevent_forking_outside_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prevent_forking_outside_group", value)

    @property
    @pulumi.getter(name="projectCreationLevel")
    def project_creation_level(self) -> Optional[pulumi.Input[str]]:
        """
        Determine if developers can create projects in the group. Valid values are: `noone`, `maintainer`, `developer`
        """
        return pulumi.get(self, "project_creation_level")

    @project_creation_level.setter
    def project_creation_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_creation_level", value)

    @property
    @pulumi.getter(name="pushRules")
    def push_rules(self) -> Optional[pulumi.Input['GroupPushRulesArgs']]:
        """
        Push rules for the group.
        """
        return pulumi.get(self, "push_rules")

    @push_rules.setter
    def push_rules(self, value: Optional[pulumi.Input['GroupPushRulesArgs']]):
        pulumi.set(self, "push_rules", value)

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow users to request member access.
        """
        return pulumi.get(self, "request_access_enabled")

    @request_access_enabled.setter
    def request_access_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_access_enabled", value)

    @property
    @pulumi.getter(name="requireTwoFactorAuthentication")
    def require_two_factor_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        Require all users in this group to setup Two-factor authentication.
        """
        return pulumi.get(self, "require_two_factor_authentication")

    @require_two_factor_authentication.setter
    def require_two_factor_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_two_factor_authentication", value)

    @property
    @pulumi.getter(name="shareWithGroupLock")
    def share_with_group_lock(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent sharing a project with another group within this group.
        """
        return pulumi.get(self, "share_with_group_lock")

    @share_with_group_lock.setter
    def share_with_group_lock(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "share_with_group_lock", value)

    @property
    @pulumi.getter(name="sharedRunnersMinutesLimit")
    def shared_runners_minutes_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Can be set by administrators only. Maximum number of monthly CI/CD minutes for this group. Can be nil (default; inherit system default), 0 (unlimited), or > 0.
        """
        return pulumi.get(self, "shared_runners_minutes_limit")

    @shared_runners_minutes_limit.setter
    def shared_runners_minutes_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shared_runners_minutes_limit", value)

    @property
    @pulumi.getter(name="sharedRunnersSetting")
    def shared_runners_setting(self) -> Optional[pulumi.Input[str]]:
        """
        Enable or disable shared runners for a group’s subgroups and projects. Valid values are: `enabled`, `disabled_and_overridable`, `disabled_and_unoverridable`, `disabled_with_override`.
        """
        return pulumi.get(self, "shared_runners_setting")

    @shared_runners_setting.setter
    def shared_runners_setting(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_runners_setting", value)

    @property
    @pulumi.getter(name="subgroupCreationLevel")
    def subgroup_creation_level(self) -> Optional[pulumi.Input[str]]:
        """
        Allowed to create subgroups. Valid values are: `owner`, `maintainer`.
        """
        return pulumi.get(self, "subgroup_creation_level")

    @subgroup_creation_level.setter
    def subgroup_creation_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subgroup_creation_level", value)

    @property
    @pulumi.getter(name="twoFactorGracePeriod")
    def two_factor_grace_period(self) -> Optional[pulumi.Input[int]]:
        """
        Defaults to 48. Time before Two-factor authentication is enforced (in hours).
        """
        return pulumi.get(self, "two_factor_grace_period")

    @two_factor_grace_period.setter
    def two_factor_grace_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "two_factor_grace_period", value)

    @property
    @pulumi.getter(name="visibilityLevel")
    def visibility_level(self) -> Optional[pulumi.Input[str]]:
        """
        The group's visibility. Can be `private`, `internal`, or `public`. Valid values are: `private`, `internal`, `public`.
        """
        return pulumi.get(self, "visibility_level")

    @visibility_level.setter
    def visibility_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "visibility_level", value)

    @property
    @pulumi.getter(name="wikiAccessLevel")
    def wiki_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        The group's wiki access level. Only available on Premium and Ultimate plans. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "wiki_access_level")

    @wiki_access_level.setter
    def wiki_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wiki_access_level", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 auto_devops_enabled: Optional[pulumi.Input[bool]] = None,
                 avatar: Optional[pulumi.Input[str]] = None,
                 avatar_hash: Optional[pulumi.Input[str]] = None,
                 avatar_url: Optional[pulumi.Input[str]] = None,
                 default_branch_protection: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 emails_disabled: Optional[pulumi.Input[bool]] = None,
                 extra_shared_runners_minutes_limit: Optional[pulumi.Input[int]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 full_path: Optional[pulumi.Input[str]] = None,
                 ip_restriction_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lfs_enabled: Optional[pulumi.Input[bool]] = None,
                 membership_lock: Optional[pulumi.Input[bool]] = None,
                 mentions_disabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 prevent_forking_outside_group: Optional[pulumi.Input[bool]] = None,
                 project_creation_level: Optional[pulumi.Input[str]] = None,
                 push_rules: Optional[pulumi.Input['GroupPushRulesArgs']] = None,
                 request_access_enabled: Optional[pulumi.Input[bool]] = None,
                 require_two_factor_authentication: Optional[pulumi.Input[bool]] = None,
                 runners_token: Optional[pulumi.Input[str]] = None,
                 share_with_group_lock: Optional[pulumi.Input[bool]] = None,
                 shared_runners_minutes_limit: Optional[pulumi.Input[int]] = None,
                 shared_runners_setting: Optional[pulumi.Input[str]] = None,
                 subgroup_creation_level: Optional[pulumi.Input[str]] = None,
                 two_factor_grace_period: Optional[pulumi.Input[int]] = None,
                 visibility_level: Optional[pulumi.Input[str]] = None,
                 web_url: Optional[pulumi.Input[str]] = None,
                 wiki_access_level: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[bool] auto_devops_enabled: Default to Auto DevOps pipeline for all projects within this group.
        :param pulumi.Input[str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[str] avatar_url: The URL of the avatar image.
        :param pulumi.Input[int] default_branch_protection: See https://docs.gitlab.com/ee/api/groups.html#options-for-default*branch*protection. Valid values are: `0`, `1`, `2`, `3`, `4`.
        :param pulumi.Input[str] description: The group's description.
        :param pulumi.Input[bool] emails_disabled: Disable email notifications.
        :param pulumi.Input[int] extra_shared_runners_minutes_limit: Can be set by administrators only. Additional CI/CD minutes for this group.
        :param pulumi.Input[str] full_name: The full name of the group.
        :param pulumi.Input[str] full_path: The full path of the group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_restriction_ranges: A list of IP addresses or subnet masks to restrict group access. Will be concatenated together into a comma separated string. Only allowed on top level groups.
        :param pulumi.Input[bool] lfs_enabled: Enable/disable Large File Storage (LFS) for the projects in this group.
        :param pulumi.Input[bool] membership_lock: Users cannot be added to projects in this group.
        :param pulumi.Input[bool] mentions_disabled: Disable the capability of a group from getting mentioned.
        :param pulumi.Input[str] name: The name of the group.
        :param pulumi.Input[int] parent_id: Id of the parent group (creates a nested group).
        :param pulumi.Input[str] path: The path of the group.
        :param pulumi.Input[bool] prevent_forking_outside_group: Defaults to false. When enabled, users can not fork projects from this group to external namespaces.
        :param pulumi.Input[str] project_creation_level: Determine if developers can create projects in the group. Valid values are: `noone`, `maintainer`, `developer`
        :param pulumi.Input['GroupPushRulesArgs'] push_rules: Push rules for the group.
        :param pulumi.Input[bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[bool] require_two_factor_authentication: Require all users in this group to setup Two-factor authentication.
        :param pulumi.Input[str] runners_token: The group level registration token to use during runner setup.
        :param pulumi.Input[bool] share_with_group_lock: Prevent sharing a project with another group within this group.
        :param pulumi.Input[int] shared_runners_minutes_limit: Can be set by administrators only. Maximum number of monthly CI/CD minutes for this group. Can be nil (default; inherit system default), 0 (unlimited), or > 0.
        :param pulumi.Input[str] shared_runners_setting: Enable or disable shared runners for a group’s subgroups and projects. Valid values are: `enabled`, `disabled_and_overridable`, `disabled_and_unoverridable`, `disabled_with_override`.
        :param pulumi.Input[str] subgroup_creation_level: Allowed to create subgroups. Valid values are: `owner`, `maintainer`.
        :param pulumi.Input[int] two_factor_grace_period: Defaults to 48. Time before Two-factor authentication is enforced (in hours).
        :param pulumi.Input[str] visibility_level: The group's visibility. Can be `private`, `internal`, or `public`. Valid values are: `private`, `internal`, `public`.
        :param pulumi.Input[str] web_url: Web URL of the group.
        :param pulumi.Input[str] wiki_access_level: The group's wiki access level. Only available on Premium and Ultimate plans. Valid values are `disabled`, `private`, `enabled`.
        """
        if auto_devops_enabled is not None:
            pulumi.set(__self__, "auto_devops_enabled", auto_devops_enabled)
        if avatar is not None:
            pulumi.set(__self__, "avatar", avatar)
        if avatar_hash is not None:
            pulumi.set(__self__, "avatar_hash", avatar_hash)
        if avatar_url is not None:
            pulumi.set(__self__, "avatar_url", avatar_url)
        if default_branch_protection is not None:
            pulumi.set(__self__, "default_branch_protection", default_branch_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if emails_disabled is not None:
            pulumi.set(__self__, "emails_disabled", emails_disabled)
        if extra_shared_runners_minutes_limit is not None:
            pulumi.set(__self__, "extra_shared_runners_minutes_limit", extra_shared_runners_minutes_limit)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if full_path is not None:
            pulumi.set(__self__, "full_path", full_path)
        if ip_restriction_ranges is not None:
            pulumi.set(__self__, "ip_restriction_ranges", ip_restriction_ranges)
        if lfs_enabled is not None:
            pulumi.set(__self__, "lfs_enabled", lfs_enabled)
        if membership_lock is not None:
            pulumi.set(__self__, "membership_lock", membership_lock)
        if mentions_disabled is not None:
            pulumi.set(__self__, "mentions_disabled", mentions_disabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if prevent_forking_outside_group is not None:
            pulumi.set(__self__, "prevent_forking_outside_group", prevent_forking_outside_group)
        if project_creation_level is not None:
            pulumi.set(__self__, "project_creation_level", project_creation_level)
        if push_rules is not None:
            pulumi.set(__self__, "push_rules", push_rules)
        if request_access_enabled is not None:
            pulumi.set(__self__, "request_access_enabled", request_access_enabled)
        if require_two_factor_authentication is not None:
            pulumi.set(__self__, "require_two_factor_authentication", require_two_factor_authentication)
        if runners_token is not None:
            pulumi.set(__self__, "runners_token", runners_token)
        if share_with_group_lock is not None:
            pulumi.set(__self__, "share_with_group_lock", share_with_group_lock)
        if shared_runners_minutes_limit is not None:
            pulumi.set(__self__, "shared_runners_minutes_limit", shared_runners_minutes_limit)
        if shared_runners_setting is not None:
            pulumi.set(__self__, "shared_runners_setting", shared_runners_setting)
        if subgroup_creation_level is not None:
            pulumi.set(__self__, "subgroup_creation_level", subgroup_creation_level)
        if two_factor_grace_period is not None:
            pulumi.set(__self__, "two_factor_grace_period", two_factor_grace_period)
        if visibility_level is not None:
            pulumi.set(__self__, "visibility_level", visibility_level)
        if web_url is not None:
            pulumi.set(__self__, "web_url", web_url)
        if wiki_access_level is not None:
            pulumi.set(__self__, "wiki_access_level", wiki_access_level)

    @property
    @pulumi.getter(name="autoDevopsEnabled")
    def auto_devops_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Default to Auto DevOps pipeline for all projects within this group.
        """
        return pulumi.get(self, "auto_devops_enabled")

    @auto_devops_enabled.setter
    def auto_devops_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_devops_enabled", value)

    @property
    @pulumi.getter
    def avatar(self) -> Optional[pulumi.Input[str]]:
        """
        A local path to the avatar image to upload. **Note**: not available for imported resources.
        """
        return pulumi.get(self, "avatar")

    @avatar.setter
    def avatar(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar", value)

    @property
    @pulumi.getter(name="avatarHash")
    def avatar_hash(self) -> Optional[pulumi.Input[str]]:
        """
        The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        """
        return pulumi.get(self, "avatar_hash")

    @avatar_hash.setter
    def avatar_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar_hash", value)

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the avatar image.
        """
        return pulumi.get(self, "avatar_url")

    @avatar_url.setter
    def avatar_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar_url", value)

    @property
    @pulumi.getter(name="defaultBranchProtection")
    def default_branch_protection(self) -> Optional[pulumi.Input[int]]:
        """
        See https://docs.gitlab.com/ee/api/groups.html#options-for-default*branch*protection. Valid values are: `0`, `1`, `2`, `3`, `4`.
        """
        return pulumi.get(self, "default_branch_protection")

    @default_branch_protection.setter
    def default_branch_protection(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_branch_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The group's description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailsDisabled")
    def emails_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable email notifications.
        """
        return pulumi.get(self, "emails_disabled")

    @emails_disabled.setter
    def emails_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "emails_disabled", value)

    @property
    @pulumi.getter(name="extraSharedRunnersMinutesLimit")
    def extra_shared_runners_minutes_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Can be set by administrators only. Additional CI/CD minutes for this group.
        """
        return pulumi.get(self, "extra_shared_runners_minutes_limit")

    @extra_shared_runners_minutes_limit.setter
    def extra_shared_runners_minutes_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "extra_shared_runners_minutes_limit", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the group.
        """
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> Optional[pulumi.Input[str]]:
        """
        The full path of the group.
        """
        return pulumi.get(self, "full_path")

    @full_path.setter
    def full_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_path", value)

    @property
    @pulumi.getter(name="ipRestrictionRanges")
    def ip_restriction_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IP addresses or subnet masks to restrict group access. Will be concatenated together into a comma separated string. Only allowed on top level groups.
        """
        return pulumi.get(self, "ip_restriction_ranges")

    @ip_restriction_ranges.setter
    def ip_restriction_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_restriction_ranges", value)

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/disable Large File Storage (LFS) for the projects in this group.
        """
        return pulumi.get(self, "lfs_enabled")

    @lfs_enabled.setter
    def lfs_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lfs_enabled", value)

    @property
    @pulumi.getter(name="membershipLock")
    def membership_lock(self) -> Optional[pulumi.Input[bool]]:
        """
        Users cannot be added to projects in this group.
        """
        return pulumi.get(self, "membership_lock")

    @membership_lock.setter
    def membership_lock(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "membership_lock", value)

    @property
    @pulumi.getter(name="mentionsDisabled")
    def mentions_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable the capability of a group from getting mentioned.
        """
        return pulumi.get(self, "mentions_disabled")

    @mentions_disabled.setter
    def mentions_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mentions_disabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[int]]:
        """
        Id of the parent group (creates a nested group).
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the group.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="preventForkingOutsideGroup")
    def prevent_forking_outside_group(self) -> Optional[pulumi.Input[bool]]:
        """
        Defaults to false. When enabled, users can not fork projects from this group to external namespaces.
        """
        return pulumi.get(self, "prevent_forking_outside_group")

    @prevent_forking_outside_group.setter
    def prevent_forking_outside_group(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "prevent_forking_outside_group", value)

    @property
    @pulumi.getter(name="projectCreationLevel")
    def project_creation_level(self) -> Optional[pulumi.Input[str]]:
        """
        Determine if developers can create projects in the group. Valid values are: `noone`, `maintainer`, `developer`
        """
        return pulumi.get(self, "project_creation_level")

    @project_creation_level.setter
    def project_creation_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_creation_level", value)

    @property
    @pulumi.getter(name="pushRules")
    def push_rules(self) -> Optional[pulumi.Input['GroupPushRulesArgs']]:
        """
        Push rules for the group.
        """
        return pulumi.get(self, "push_rules")

    @push_rules.setter
    def push_rules(self, value: Optional[pulumi.Input['GroupPushRulesArgs']]):
        pulumi.set(self, "push_rules", value)

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow users to request member access.
        """
        return pulumi.get(self, "request_access_enabled")

    @request_access_enabled.setter
    def request_access_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_access_enabled", value)

    @property
    @pulumi.getter(name="requireTwoFactorAuthentication")
    def require_two_factor_authentication(self) -> Optional[pulumi.Input[bool]]:
        """
        Require all users in this group to setup Two-factor authentication.
        """
        return pulumi.get(self, "require_two_factor_authentication")

    @require_two_factor_authentication.setter
    def require_two_factor_authentication(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_two_factor_authentication", value)

    @property
    @pulumi.getter(name="runnersToken")
    def runners_token(self) -> Optional[pulumi.Input[str]]:
        """
        The group level registration token to use during runner setup.
        """
        return pulumi.get(self, "runners_token")

    @runners_token.setter
    def runners_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runners_token", value)

    @property
    @pulumi.getter(name="shareWithGroupLock")
    def share_with_group_lock(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent sharing a project with another group within this group.
        """
        return pulumi.get(self, "share_with_group_lock")

    @share_with_group_lock.setter
    def share_with_group_lock(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "share_with_group_lock", value)

    @property
    @pulumi.getter(name="sharedRunnersMinutesLimit")
    def shared_runners_minutes_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Can be set by administrators only. Maximum number of monthly CI/CD minutes for this group. Can be nil (default; inherit system default), 0 (unlimited), or > 0.
        """
        return pulumi.get(self, "shared_runners_minutes_limit")

    @shared_runners_minutes_limit.setter
    def shared_runners_minutes_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shared_runners_minutes_limit", value)

    @property
    @pulumi.getter(name="sharedRunnersSetting")
    def shared_runners_setting(self) -> Optional[pulumi.Input[str]]:
        """
        Enable or disable shared runners for a group’s subgroups and projects. Valid values are: `enabled`, `disabled_and_overridable`, `disabled_and_unoverridable`, `disabled_with_override`.
        """
        return pulumi.get(self, "shared_runners_setting")

    @shared_runners_setting.setter
    def shared_runners_setting(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shared_runners_setting", value)

    @property
    @pulumi.getter(name="subgroupCreationLevel")
    def subgroup_creation_level(self) -> Optional[pulumi.Input[str]]:
        """
        Allowed to create subgroups. Valid values are: `owner`, `maintainer`.
        """
        return pulumi.get(self, "subgroup_creation_level")

    @subgroup_creation_level.setter
    def subgroup_creation_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subgroup_creation_level", value)

    @property
    @pulumi.getter(name="twoFactorGracePeriod")
    def two_factor_grace_period(self) -> Optional[pulumi.Input[int]]:
        """
        Defaults to 48. Time before Two-factor authentication is enforced (in hours).
        """
        return pulumi.get(self, "two_factor_grace_period")

    @two_factor_grace_period.setter
    def two_factor_grace_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "two_factor_grace_period", value)

    @property
    @pulumi.getter(name="visibilityLevel")
    def visibility_level(self) -> Optional[pulumi.Input[str]]:
        """
        The group's visibility. Can be `private`, `internal`, or `public`. Valid values are: `private`, `internal`, `public`.
        """
        return pulumi.get(self, "visibility_level")

    @visibility_level.setter
    def visibility_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "visibility_level", value)

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> Optional[pulumi.Input[str]]:
        """
        Web URL of the group.
        """
        return pulumi.get(self, "web_url")

    @web_url.setter
    def web_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_url", value)

    @property
    @pulumi.getter(name="wikiAccessLevel")
    def wiki_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        The group's wiki access level. Only available on Premium and Ultimate plans. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "wiki_access_level")

    @wiki_access_level.setter
    def wiki_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wiki_access_level", value)


class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_devops_enabled: Optional[pulumi.Input[bool]] = None,
                 avatar: Optional[pulumi.Input[str]] = None,
                 avatar_hash: Optional[pulumi.Input[str]] = None,
                 default_branch_protection: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 emails_disabled: Optional[pulumi.Input[bool]] = None,
                 extra_shared_runners_minutes_limit: Optional[pulumi.Input[int]] = None,
                 ip_restriction_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lfs_enabled: Optional[pulumi.Input[bool]] = None,
                 membership_lock: Optional[pulumi.Input[bool]] = None,
                 mentions_disabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 prevent_forking_outside_group: Optional[pulumi.Input[bool]] = None,
                 project_creation_level: Optional[pulumi.Input[str]] = None,
                 push_rules: Optional[pulumi.Input[pulumi.InputType['GroupPushRulesArgs']]] = None,
                 request_access_enabled: Optional[pulumi.Input[bool]] = None,
                 require_two_factor_authentication: Optional[pulumi.Input[bool]] = None,
                 share_with_group_lock: Optional[pulumi.Input[bool]] = None,
                 shared_runners_minutes_limit: Optional[pulumi.Input[int]] = None,
                 shared_runners_setting: Optional[pulumi.Input[str]] = None,
                 subgroup_creation_level: Optional[pulumi.Input[str]] = None,
                 two_factor_grace_period: Optional[pulumi.Input[int]] = None,
                 visibility_level: Optional[pulumi.Input[str]] = None,
                 wiki_access_level: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The `Group` resource allows to manage the lifecycle of a group.

        > On GitLab SaaS, you must use the GitLab UI to create groups without a parent group. You cannot use this provider nor the API to do this.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example_group = gitlab.Group("exampleGroup",
            path="example",
            description="An example group")
        # Create a project in the example group
        example_project = gitlab.Project("exampleProject",
            description="An example project",
            namespace_id=example_group.id)
        # Group with custom push rules
        example_two = gitlab.Group("example-two",
            path="example-two",
            description="An example group with push rules",
            push_rules=gitlab.GroupPushRulesArgs(
                author_email_regex="@example\\\\.com$",
                commit_committer_check=True,
                member_check=True,
                prevent_secrets=True,
            ))
        ```

        ## Import

        ```sh
         $ pulumi import gitlab:index/group:Group You can import a group state using `<resource> <id>`. The
        ```

         `id` can be whatever the [details of a group][details_of_a_group] api takes for its `:id` value, so for example

        ```sh
         $ pulumi import gitlab:index/group:Group example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_devops_enabled: Default to Auto DevOps pipeline for all projects within this group.
        :param pulumi.Input[str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[int] default_branch_protection: See https://docs.gitlab.com/ee/api/groups.html#options-for-default*branch*protection. Valid values are: `0`, `1`, `2`, `3`, `4`.
        :param pulumi.Input[str] description: The group's description.
        :param pulumi.Input[bool] emails_disabled: Disable email notifications.
        :param pulumi.Input[int] extra_shared_runners_minutes_limit: Can be set by administrators only. Additional CI/CD minutes for this group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_restriction_ranges: A list of IP addresses or subnet masks to restrict group access. Will be concatenated together into a comma separated string. Only allowed on top level groups.
        :param pulumi.Input[bool] lfs_enabled: Enable/disable Large File Storage (LFS) for the projects in this group.
        :param pulumi.Input[bool] membership_lock: Users cannot be added to projects in this group.
        :param pulumi.Input[bool] mentions_disabled: Disable the capability of a group from getting mentioned.
        :param pulumi.Input[str] name: The name of the group.
        :param pulumi.Input[int] parent_id: Id of the parent group (creates a nested group).
        :param pulumi.Input[str] path: The path of the group.
        :param pulumi.Input[bool] prevent_forking_outside_group: Defaults to false. When enabled, users can not fork projects from this group to external namespaces.
        :param pulumi.Input[str] project_creation_level: Determine if developers can create projects in the group. Valid values are: `noone`, `maintainer`, `developer`
        :param pulumi.Input[pulumi.InputType['GroupPushRulesArgs']] push_rules: Push rules for the group.
        :param pulumi.Input[bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[bool] require_two_factor_authentication: Require all users in this group to setup Two-factor authentication.
        :param pulumi.Input[bool] share_with_group_lock: Prevent sharing a project with another group within this group.
        :param pulumi.Input[int] shared_runners_minutes_limit: Can be set by administrators only. Maximum number of monthly CI/CD minutes for this group. Can be nil (default; inherit system default), 0 (unlimited), or > 0.
        :param pulumi.Input[str] shared_runners_setting: Enable or disable shared runners for a group’s subgroups and projects. Valid values are: `enabled`, `disabled_and_overridable`, `disabled_and_unoverridable`, `disabled_with_override`.
        :param pulumi.Input[str] subgroup_creation_level: Allowed to create subgroups. Valid values are: `owner`, `maintainer`.
        :param pulumi.Input[int] two_factor_grace_period: Defaults to 48. Time before Two-factor authentication is enforced (in hours).
        :param pulumi.Input[str] visibility_level: The group's visibility. Can be `private`, `internal`, or `public`. Valid values are: `private`, `internal`, `public`.
        :param pulumi.Input[str] wiki_access_level: The group's wiki access level. Only available on Premium and Ultimate plans. Valid values are `disabled`, `private`, `enabled`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `Group` resource allows to manage the lifecycle of a group.

        > On GitLab SaaS, you must use the GitLab UI to create groups without a parent group. You cannot use this provider nor the API to do this.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example_group = gitlab.Group("exampleGroup",
            path="example",
            description="An example group")
        # Create a project in the example group
        example_project = gitlab.Project("exampleProject",
            description="An example project",
            namespace_id=example_group.id)
        # Group with custom push rules
        example_two = gitlab.Group("example-two",
            path="example-two",
            description="An example group with push rules",
            push_rules=gitlab.GroupPushRulesArgs(
                author_email_regex="@example\\\\.com$",
                commit_committer_check=True,
                member_check=True,
                prevent_secrets=True,
            ))
        ```

        ## Import

        ```sh
         $ pulumi import gitlab:index/group:Group You can import a group state using `<resource> <id>`. The
        ```

         `id` can be whatever the [details of a group][details_of_a_group] api takes for its `:id` value, so for example

        ```sh
         $ pulumi import gitlab:index/group:Group example example
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_devops_enabled: Optional[pulumi.Input[bool]] = None,
                 avatar: Optional[pulumi.Input[str]] = None,
                 avatar_hash: Optional[pulumi.Input[str]] = None,
                 default_branch_protection: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 emails_disabled: Optional[pulumi.Input[bool]] = None,
                 extra_shared_runners_minutes_limit: Optional[pulumi.Input[int]] = None,
                 ip_restriction_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lfs_enabled: Optional[pulumi.Input[bool]] = None,
                 membership_lock: Optional[pulumi.Input[bool]] = None,
                 mentions_disabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[int]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 prevent_forking_outside_group: Optional[pulumi.Input[bool]] = None,
                 project_creation_level: Optional[pulumi.Input[str]] = None,
                 push_rules: Optional[pulumi.Input[pulumi.InputType['GroupPushRulesArgs']]] = None,
                 request_access_enabled: Optional[pulumi.Input[bool]] = None,
                 require_two_factor_authentication: Optional[pulumi.Input[bool]] = None,
                 share_with_group_lock: Optional[pulumi.Input[bool]] = None,
                 shared_runners_minutes_limit: Optional[pulumi.Input[int]] = None,
                 shared_runners_setting: Optional[pulumi.Input[str]] = None,
                 subgroup_creation_level: Optional[pulumi.Input[str]] = None,
                 two_factor_grace_period: Optional[pulumi.Input[int]] = None,
                 visibility_level: Optional[pulumi.Input[str]] = None,
                 wiki_access_level: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["auto_devops_enabled"] = auto_devops_enabled
            __props__.__dict__["avatar"] = avatar
            __props__.__dict__["avatar_hash"] = avatar_hash
            __props__.__dict__["default_branch_protection"] = default_branch_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["emails_disabled"] = emails_disabled
            __props__.__dict__["extra_shared_runners_minutes_limit"] = extra_shared_runners_minutes_limit
            __props__.__dict__["ip_restriction_ranges"] = ip_restriction_ranges
            __props__.__dict__["lfs_enabled"] = lfs_enabled
            __props__.__dict__["membership_lock"] = membership_lock
            __props__.__dict__["mentions_disabled"] = mentions_disabled
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_id"] = parent_id
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["prevent_forking_outside_group"] = prevent_forking_outside_group
            __props__.__dict__["project_creation_level"] = project_creation_level
            __props__.__dict__["push_rules"] = push_rules
            __props__.__dict__["request_access_enabled"] = request_access_enabled
            __props__.__dict__["require_two_factor_authentication"] = require_two_factor_authentication
            __props__.__dict__["share_with_group_lock"] = share_with_group_lock
            __props__.__dict__["shared_runners_minutes_limit"] = shared_runners_minutes_limit
            __props__.__dict__["shared_runners_setting"] = shared_runners_setting
            __props__.__dict__["subgroup_creation_level"] = subgroup_creation_level
            __props__.__dict__["two_factor_grace_period"] = two_factor_grace_period
            __props__.__dict__["visibility_level"] = visibility_level
            __props__.__dict__["wiki_access_level"] = wiki_access_level
            __props__.__dict__["avatar_url"] = None
            __props__.__dict__["full_name"] = None
            __props__.__dict__["full_path"] = None
            __props__.__dict__["runners_token"] = None
            __props__.__dict__["web_url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["runnersToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Group, __self__).__init__(
            'gitlab:index/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_devops_enabled: Optional[pulumi.Input[bool]] = None,
            avatar: Optional[pulumi.Input[str]] = None,
            avatar_hash: Optional[pulumi.Input[str]] = None,
            avatar_url: Optional[pulumi.Input[str]] = None,
            default_branch_protection: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            emails_disabled: Optional[pulumi.Input[bool]] = None,
            extra_shared_runners_minutes_limit: Optional[pulumi.Input[int]] = None,
            full_name: Optional[pulumi.Input[str]] = None,
            full_path: Optional[pulumi.Input[str]] = None,
            ip_restriction_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            lfs_enabled: Optional[pulumi.Input[bool]] = None,
            membership_lock: Optional[pulumi.Input[bool]] = None,
            mentions_disabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent_id: Optional[pulumi.Input[int]] = None,
            path: Optional[pulumi.Input[str]] = None,
            prevent_forking_outside_group: Optional[pulumi.Input[bool]] = None,
            project_creation_level: Optional[pulumi.Input[str]] = None,
            push_rules: Optional[pulumi.Input[pulumi.InputType['GroupPushRulesArgs']]] = None,
            request_access_enabled: Optional[pulumi.Input[bool]] = None,
            require_two_factor_authentication: Optional[pulumi.Input[bool]] = None,
            runners_token: Optional[pulumi.Input[str]] = None,
            share_with_group_lock: Optional[pulumi.Input[bool]] = None,
            shared_runners_minutes_limit: Optional[pulumi.Input[int]] = None,
            shared_runners_setting: Optional[pulumi.Input[str]] = None,
            subgroup_creation_level: Optional[pulumi.Input[str]] = None,
            two_factor_grace_period: Optional[pulumi.Input[int]] = None,
            visibility_level: Optional[pulumi.Input[str]] = None,
            web_url: Optional[pulumi.Input[str]] = None,
            wiki_access_level: Optional[pulumi.Input[str]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_devops_enabled: Default to Auto DevOps pipeline for all projects within this group.
        :param pulumi.Input[str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[str] avatar_url: The URL of the avatar image.
        :param pulumi.Input[int] default_branch_protection: See https://docs.gitlab.com/ee/api/groups.html#options-for-default*branch*protection. Valid values are: `0`, `1`, `2`, `3`, `4`.
        :param pulumi.Input[str] description: The group's description.
        :param pulumi.Input[bool] emails_disabled: Disable email notifications.
        :param pulumi.Input[int] extra_shared_runners_minutes_limit: Can be set by administrators only. Additional CI/CD minutes for this group.
        :param pulumi.Input[str] full_name: The full name of the group.
        :param pulumi.Input[str] full_path: The full path of the group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_restriction_ranges: A list of IP addresses or subnet masks to restrict group access. Will be concatenated together into a comma separated string. Only allowed on top level groups.
        :param pulumi.Input[bool] lfs_enabled: Enable/disable Large File Storage (LFS) for the projects in this group.
        :param pulumi.Input[bool] membership_lock: Users cannot be added to projects in this group.
        :param pulumi.Input[bool] mentions_disabled: Disable the capability of a group from getting mentioned.
        :param pulumi.Input[str] name: The name of the group.
        :param pulumi.Input[int] parent_id: Id of the parent group (creates a nested group).
        :param pulumi.Input[str] path: The path of the group.
        :param pulumi.Input[bool] prevent_forking_outside_group: Defaults to false. When enabled, users can not fork projects from this group to external namespaces.
        :param pulumi.Input[str] project_creation_level: Determine if developers can create projects in the group. Valid values are: `noone`, `maintainer`, `developer`
        :param pulumi.Input[pulumi.InputType['GroupPushRulesArgs']] push_rules: Push rules for the group.
        :param pulumi.Input[bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[bool] require_two_factor_authentication: Require all users in this group to setup Two-factor authentication.
        :param pulumi.Input[str] runners_token: The group level registration token to use during runner setup.
        :param pulumi.Input[bool] share_with_group_lock: Prevent sharing a project with another group within this group.
        :param pulumi.Input[int] shared_runners_minutes_limit: Can be set by administrators only. Maximum number of monthly CI/CD minutes for this group. Can be nil (default; inherit system default), 0 (unlimited), or > 0.
        :param pulumi.Input[str] shared_runners_setting: Enable or disable shared runners for a group’s subgroups and projects. Valid values are: `enabled`, `disabled_and_overridable`, `disabled_and_unoverridable`, `disabled_with_override`.
        :param pulumi.Input[str] subgroup_creation_level: Allowed to create subgroups. Valid values are: `owner`, `maintainer`.
        :param pulumi.Input[int] two_factor_grace_period: Defaults to 48. Time before Two-factor authentication is enforced (in hours).
        :param pulumi.Input[str] visibility_level: The group's visibility. Can be `private`, `internal`, or `public`. Valid values are: `private`, `internal`, `public`.
        :param pulumi.Input[str] web_url: Web URL of the group.
        :param pulumi.Input[str] wiki_access_level: The group's wiki access level. Only available on Premium and Ultimate plans. Valid values are `disabled`, `private`, `enabled`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["auto_devops_enabled"] = auto_devops_enabled
        __props__.__dict__["avatar"] = avatar
        __props__.__dict__["avatar_hash"] = avatar_hash
        __props__.__dict__["avatar_url"] = avatar_url
        __props__.__dict__["default_branch_protection"] = default_branch_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["emails_disabled"] = emails_disabled
        __props__.__dict__["extra_shared_runners_minutes_limit"] = extra_shared_runners_minutes_limit
        __props__.__dict__["full_name"] = full_name
        __props__.__dict__["full_path"] = full_path
        __props__.__dict__["ip_restriction_ranges"] = ip_restriction_ranges
        __props__.__dict__["lfs_enabled"] = lfs_enabled
        __props__.__dict__["membership_lock"] = membership_lock
        __props__.__dict__["mentions_disabled"] = mentions_disabled
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["path"] = path
        __props__.__dict__["prevent_forking_outside_group"] = prevent_forking_outside_group
        __props__.__dict__["project_creation_level"] = project_creation_level
        __props__.__dict__["push_rules"] = push_rules
        __props__.__dict__["request_access_enabled"] = request_access_enabled
        __props__.__dict__["require_two_factor_authentication"] = require_two_factor_authentication
        __props__.__dict__["runners_token"] = runners_token
        __props__.__dict__["share_with_group_lock"] = share_with_group_lock
        __props__.__dict__["shared_runners_minutes_limit"] = shared_runners_minutes_limit
        __props__.__dict__["shared_runners_setting"] = shared_runners_setting
        __props__.__dict__["subgroup_creation_level"] = subgroup_creation_level
        __props__.__dict__["two_factor_grace_period"] = two_factor_grace_period
        __props__.__dict__["visibility_level"] = visibility_level
        __props__.__dict__["web_url"] = web_url
        __props__.__dict__["wiki_access_level"] = wiki_access_level
        return Group(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoDevopsEnabled")
    def auto_devops_enabled(self) -> pulumi.Output[bool]:
        """
        Default to Auto DevOps pipeline for all projects within this group.
        """
        return pulumi.get(self, "auto_devops_enabled")

    @property
    @pulumi.getter
    def avatar(self) -> pulumi.Output[Optional[str]]:
        """
        A local path to the avatar image to upload. **Note**: not available for imported resources.
        """
        return pulumi.get(self, "avatar")

    @property
    @pulumi.getter(name="avatarHash")
    def avatar_hash(self) -> pulumi.Output[str]:
        """
        The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        """
        return pulumi.get(self, "avatar_hash")

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> pulumi.Output[str]:
        """
        The URL of the avatar image.
        """
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter(name="defaultBranchProtection")
    def default_branch_protection(self) -> pulumi.Output[int]:
        """
        See https://docs.gitlab.com/ee/api/groups.html#options-for-default*branch*protection. Valid values are: `0`, `1`, `2`, `3`, `4`.
        """
        return pulumi.get(self, "default_branch_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The group's description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailsDisabled")
    def emails_disabled(self) -> pulumi.Output[bool]:
        """
        Disable email notifications.
        """
        return pulumi.get(self, "emails_disabled")

    @property
    @pulumi.getter(name="extraSharedRunnersMinutesLimit")
    def extra_shared_runners_minutes_limit(self) -> pulumi.Output[int]:
        """
        Can be set by administrators only. Additional CI/CD minutes for this group.
        """
        return pulumi.get(self, "extra_shared_runners_minutes_limit")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> pulumi.Output[str]:
        """
        The full name of the group.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter(name="fullPath")
    def full_path(self) -> pulumi.Output[str]:
        """
        The full path of the group.
        """
        return pulumi.get(self, "full_path")

    @property
    @pulumi.getter(name="ipRestrictionRanges")
    def ip_restriction_ranges(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of IP addresses or subnet masks to restrict group access. Will be concatenated together into a comma separated string. Only allowed on top level groups.
        """
        return pulumi.get(self, "ip_restriction_ranges")

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> pulumi.Output[bool]:
        """
        Enable/disable Large File Storage (LFS) for the projects in this group.
        """
        return pulumi.get(self, "lfs_enabled")

    @property
    @pulumi.getter(name="membershipLock")
    def membership_lock(self) -> pulumi.Output[Optional[bool]]:
        """
        Users cannot be added to projects in this group.
        """
        return pulumi.get(self, "membership_lock")

    @property
    @pulumi.getter(name="mentionsDisabled")
    def mentions_disabled(self) -> pulumi.Output[bool]:
        """
        Disable the capability of a group from getting mentioned.
        """
        return pulumi.get(self, "mentions_disabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[int]:
        """
        Id of the parent group (creates a nested group).
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        The path of the group.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="preventForkingOutsideGroup")
    def prevent_forking_outside_group(self) -> pulumi.Output[bool]:
        """
        Defaults to false. When enabled, users can not fork projects from this group to external namespaces.
        """
        return pulumi.get(self, "prevent_forking_outside_group")

    @property
    @pulumi.getter(name="projectCreationLevel")
    def project_creation_level(self) -> pulumi.Output[str]:
        """
        Determine if developers can create projects in the group. Valid values are: `noone`, `maintainer`, `developer`
        """
        return pulumi.get(self, "project_creation_level")

    @property
    @pulumi.getter(name="pushRules")
    def push_rules(self) -> pulumi.Output['outputs.GroupPushRules']:
        """
        Push rules for the group.
        """
        return pulumi.get(self, "push_rules")

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> pulumi.Output[bool]:
        """
        Allow users to request member access.
        """
        return pulumi.get(self, "request_access_enabled")

    @property
    @pulumi.getter(name="requireTwoFactorAuthentication")
    def require_two_factor_authentication(self) -> pulumi.Output[bool]:
        """
        Require all users in this group to setup Two-factor authentication.
        """
        return pulumi.get(self, "require_two_factor_authentication")

    @property
    @pulumi.getter(name="runnersToken")
    def runners_token(self) -> pulumi.Output[str]:
        """
        The group level registration token to use during runner setup.
        """
        return pulumi.get(self, "runners_token")

    @property
    @pulumi.getter(name="shareWithGroupLock")
    def share_with_group_lock(self) -> pulumi.Output[bool]:
        """
        Prevent sharing a project with another group within this group.
        """
        return pulumi.get(self, "share_with_group_lock")

    @property
    @pulumi.getter(name="sharedRunnersMinutesLimit")
    def shared_runners_minutes_limit(self) -> pulumi.Output[int]:
        """
        Can be set by administrators only. Maximum number of monthly CI/CD minutes for this group. Can be nil (default; inherit system default), 0 (unlimited), or > 0.
        """
        return pulumi.get(self, "shared_runners_minutes_limit")

    @property
    @pulumi.getter(name="sharedRunnersSetting")
    def shared_runners_setting(self) -> pulumi.Output[str]:
        """
        Enable or disable shared runners for a group’s subgroups and projects. Valid values are: `enabled`, `disabled_and_overridable`, `disabled_and_unoverridable`, `disabled_with_override`.
        """
        return pulumi.get(self, "shared_runners_setting")

    @property
    @pulumi.getter(name="subgroupCreationLevel")
    def subgroup_creation_level(self) -> pulumi.Output[str]:
        """
        Allowed to create subgroups. Valid values are: `owner`, `maintainer`.
        """
        return pulumi.get(self, "subgroup_creation_level")

    @property
    @pulumi.getter(name="twoFactorGracePeriod")
    def two_factor_grace_period(self) -> pulumi.Output[int]:
        """
        Defaults to 48. Time before Two-factor authentication is enforced (in hours).
        """
        return pulumi.get(self, "two_factor_grace_period")

    @property
    @pulumi.getter(name="visibilityLevel")
    def visibility_level(self) -> pulumi.Output[str]:
        """
        The group's visibility. Can be `private`, `internal`, or `public`. Valid values are: `private`, `internal`, `public`.
        """
        return pulumi.get(self, "visibility_level")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> pulumi.Output[str]:
        """
        Web URL of the group.
        """
        return pulumi.get(self, "web_url")

    @property
    @pulumi.getter(name="wikiAccessLevel")
    def wiki_access_level(self) -> pulumi.Output[str]:
        """
        The group's wiki access level. Only available on Premium and Ultimate plans. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "wiki_access_level")

