# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 allow_merge_on_skipped_pipeline: Optional[pulumi.Input[bool]] = None,
                 analytics_access_level: Optional[pulumi.Input[str]] = None,
                 approvals_before_merge: Optional[pulumi.Input[int]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_cancel_pending_pipelines: Optional[pulumi.Input[str]] = None,
                 auto_devops_deploy_strategy: Optional[pulumi.Input[str]] = None,
                 auto_devops_enabled: Optional[pulumi.Input[bool]] = None,
                 autoclose_referenced_issues: Optional[pulumi.Input[bool]] = None,
                 avatar: Optional[pulumi.Input[str]] = None,
                 avatar_hash: Optional[pulumi.Input[str]] = None,
                 build_coverage_regex: Optional[pulumi.Input[str]] = None,
                 build_git_strategy: Optional[pulumi.Input[str]] = None,
                 build_timeout: Optional[pulumi.Input[int]] = None,
                 builds_access_level: Optional[pulumi.Input[str]] = None,
                 ci_config_path: Optional[pulumi.Input[str]] = None,
                 ci_default_git_depth: Optional[pulumi.Input[int]] = None,
                 ci_forward_deployment_enabled: Optional[pulumi.Input[bool]] = None,
                 ci_separated_caches: Optional[pulumi.Input[bool]] = None,
                 container_expiration_policy: Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']] = None,
                 container_registry_access_level: Optional[pulumi.Input[str]] = None,
                 container_registry_enabled: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 emails_disabled: Optional[pulumi.Input[bool]] = None,
                 environments_access_level: Optional[pulumi.Input[str]] = None,
                 external_authorization_classification_label: Optional[pulumi.Input[str]] = None,
                 feature_flags_access_level: Optional[pulumi.Input[str]] = None,
                 forked_from_project_id: Optional[pulumi.Input[int]] = None,
                 forking_access_level: Optional[pulumi.Input[str]] = None,
                 group_runners_enabled: Optional[pulumi.Input[bool]] = None,
                 group_with_project_templates_id: Optional[pulumi.Input[int]] = None,
                 import_url: Optional[pulumi.Input[str]] = None,
                 import_url_password: Optional[pulumi.Input[str]] = None,
                 import_url_username: Optional[pulumi.Input[str]] = None,
                 infrastructure_access_level: Optional[pulumi.Input[str]] = None,
                 initialize_with_readme: Optional[pulumi.Input[bool]] = None,
                 issues_access_level: Optional[pulumi.Input[str]] = None,
                 issues_enabled: Optional[pulumi.Input[bool]] = None,
                 issues_template: Optional[pulumi.Input[str]] = None,
                 keep_latest_artifact: Optional[pulumi.Input[bool]] = None,
                 lfs_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_commit_template: Optional[pulumi.Input[str]] = None,
                 merge_method: Optional[pulumi.Input[str]] = None,
                 merge_pipelines_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_requests_access_level: Optional[pulumi.Input[str]] = None,
                 merge_requests_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_requests_template: Optional[pulumi.Input[str]] = None,
                 merge_trains_enabled: Optional[pulumi.Input[bool]] = None,
                 mirror: Optional[pulumi.Input[bool]] = None,
                 mirror_overwrites_diverged_branches: Optional[pulumi.Input[bool]] = None,
                 mirror_trigger_builds: Optional[pulumi.Input[bool]] = None,
                 monitor_access_level: Optional[pulumi.Input[str]] = None,
                 mr_default_target_self: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[int]] = None,
                 only_allow_merge_if_all_discussions_are_resolved: Optional[pulumi.Input[bool]] = None,
                 only_allow_merge_if_pipeline_succeeds: Optional[pulumi.Input[bool]] = None,
                 only_mirror_protected_branches: Optional[pulumi.Input[bool]] = None,
                 packages_enabled: Optional[pulumi.Input[bool]] = None,
                 pages_access_level: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 pipelines_enabled: Optional[pulumi.Input[bool]] = None,
                 printing_merge_request_link_enabled: Optional[pulumi.Input[bool]] = None,
                 public_builds: Optional[pulumi.Input[bool]] = None,
                 public_jobs: Optional[pulumi.Input[bool]] = None,
                 push_rules: Optional[pulumi.Input['ProjectPushRulesArgs']] = None,
                 releases_access_level: Optional[pulumi.Input[str]] = None,
                 remove_source_branch_after_merge: Optional[pulumi.Input[bool]] = None,
                 repository_access_level: Optional[pulumi.Input[str]] = None,
                 repository_storage: Optional[pulumi.Input[str]] = None,
                 request_access_enabled: Optional[pulumi.Input[bool]] = None,
                 requirements_access_level: Optional[pulumi.Input[str]] = None,
                 resolve_outdated_diff_discussions: Optional[pulumi.Input[bool]] = None,
                 restrict_user_defined_variables: Optional[pulumi.Input[bool]] = None,
                 security_and_compliance_access_level: Optional[pulumi.Input[str]] = None,
                 shared_runners_enabled: Optional[pulumi.Input[bool]] = None,
                 skip_wait_for_default_branch_protection: Optional[pulumi.Input[bool]] = None,
                 snippets_access_level: Optional[pulumi.Input[str]] = None,
                 snippets_enabled: Optional[pulumi.Input[bool]] = None,
                 squash_commit_template: Optional[pulumi.Input[str]] = None,
                 squash_option: Optional[pulumi.Input[str]] = None,
                 suggestion_commit_message: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 template_project_id: Optional[pulumi.Input[int]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_custom_template: Optional[pulumi.Input[bool]] = None,
                 visibility_level: Optional[pulumi.Input[str]] = None,
                 wiki_access_level: Optional[pulumi.Input[str]] = None,
                 wiki_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[bool] allow_merge_on_skipped_pipeline: Set to true if you want to treat skipped pipelines as if they finished with success.
        :param pulumi.Input[str] analytics_access_level: Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[int] approvals_before_merge: Number of merge request approvals required for merging. Default is 0.
               This field **does not** work well in combination with the `ProjectApprovalRule` resource
               and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
               In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        :param pulumi.Input[bool] archive_on_destroy: Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        :param pulumi.Input[bool] archived: Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        :param pulumi.Input[str] auto_cancel_pending_pipelines: Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        :param pulumi.Input[str] auto_devops_deploy_strategy: Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        :param pulumi.Input[bool] auto_devops_enabled: Enable Auto DevOps for this project.
        :param pulumi.Input[bool] autoclose_referenced_issues: Set whether auto-closing referenced issues on default branch.
        :param pulumi.Input[str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[str] build_coverage_regex: Test coverage parsing for the project. This is deprecated feature in GitLab 15.0.
        :param pulumi.Input[str] build_git_strategy: The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        :param pulumi.Input[int] build_timeout: The maximum amount of time, in seconds, that a job can run.
        :param pulumi.Input[str] builds_access_level: Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] ci_config_path: Custom Path to CI config file.
        :param pulumi.Input[int] ci_default_git_depth: Default number of revisions for shallow cloning.
        :param pulumi.Input[bool] ci_forward_deployment_enabled: When a new deployment job starts, skip older deployment jobs that are still pending.
        :param pulumi.Input[bool] ci_separated_caches: Use separate caches for protected branches.
        :param pulumi.Input['ProjectContainerExpirationPolicyArgs'] container_expiration_policy: Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        :param pulumi.Input[str] container_registry_access_level: Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] container_registry_enabled: Enable container registry for the project.
        :param pulumi.Input[str] default_branch: The default branch for the project.
        :param pulumi.Input[str] description: A description of the project.
        :param pulumi.Input[bool] emails_disabled: Disable email notifications.
        :param pulumi.Input[str] environments_access_level: Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] external_authorization_classification_label: The classification label for the project.
        :param pulumi.Input[str] feature_flags_access_level: Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[int] forked_from_project_id: The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        :param pulumi.Input[str] forking_access_level: Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] group_runners_enabled: Enable group runners for this project.
        :param pulumi.Input[int] group_with_project_templates_id: For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        :param pulumi.Input[str] import_url: Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used
               together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import.
               Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the
               credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using
               `terraform import`. See the examples section for how to properly use it.
        :param pulumi.Input[str] import_url_password: The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
               to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
               use it.
        :param pulumi.Input[str] import_url_username: The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
               to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
               use it.
        :param pulumi.Input[str] infrastructure_access_level: Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] initialize_with_readme: Create main branch with first commit containing a README.md file.
        :param pulumi.Input[str] issues_access_level: Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] issues_enabled: Enable issue tracking for the project.
        :param pulumi.Input[str] issues_template: Sets the template for new issues in the project.
        :param pulumi.Input[bool] keep_latest_artifact: Disable or enable the ability to keep the latest artifact for this project.
        :param pulumi.Input[bool] lfs_enabled: Enable LFS for the project.
        :param pulumi.Input[str] merge_commit_template: Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
        :param pulumi.Input[str] merge_method: Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        :param pulumi.Input[bool] merge_pipelines_enabled: Enable or disable merge pipelines.
        :param pulumi.Input[str] merge_requests_access_level: Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] merge_requests_enabled: Enable merge requests for the project.
        :param pulumi.Input[str] merge_requests_template: Sets the template for new merge requests in the project.
        :param pulumi.Input[bool] merge_trains_enabled: Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        :param pulumi.Input[bool] mirror: Enable project pull mirror.
        :param pulumi.Input[bool] mirror_overwrites_diverged_branches: Enable overwrite diverged branches for a mirrored project.
        :param pulumi.Input[bool] mirror_trigger_builds: Enable trigger builds on pushes for a mirrored project.
        :param pulumi.Input[str] monitor_access_level: Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] mr_default_target_self: For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        :param pulumi.Input[str] name: The name of the project.
        :param pulumi.Input[int] namespace_id: The namespace (group or user) of the project. Defaults to your user.
        :param pulumi.Input[bool] only_allow_merge_if_all_discussions_are_resolved: Set to true if you want allow merges only if all discussions are resolved.
        :param pulumi.Input[bool] only_allow_merge_if_pipeline_succeeds: Set to true if you want allow merges only if a pipeline succeeds.
        :param pulumi.Input[bool] only_mirror_protected_branches: Enable only mirror protected branches for a mirrored project.
        :param pulumi.Input[bool] packages_enabled: Enable packages repository for the project.
        :param pulumi.Input[str] pages_access_level: Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        :param pulumi.Input[str] path: The path of the repository.
        :param pulumi.Input[bool] pipelines_enabled: Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        :param pulumi.Input[bool] printing_merge_request_link_enabled: Show link to create/view merge request when pushing from the command line
        :param pulumi.Input[bool] public_builds: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[bool] public_jobs: If true, jobs can be viewed by non-project members.
        :param pulumi.Input['ProjectPushRulesArgs'] push_rules: Push rules for the project.
        :param pulumi.Input[str] releases_access_level: Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] remove_source_branch_after_merge: Enable `Delete source branch` option by default for all new merge requests.
        :param pulumi.Input[str] repository_access_level: Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] repository_storage: Which storage shard the repository is on. (administrator only)
        :param pulumi.Input[bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[str] requirements_access_level: Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] resolve_outdated_diff_discussions: Automatically resolve merge request diffs discussions on lines changed with a push.
        :param pulumi.Input[bool] restrict_user_defined_variables: Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        :param pulumi.Input[str] security_and_compliance_access_level: Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] shared_runners_enabled: Enable shared runners for this project.
        :param pulumi.Input[bool] skip_wait_for_default_branch_protection: If `true`, the default behavior to wait for the default branch protection to be created is skipped.
               This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
               There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
               This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        :param pulumi.Input[str] snippets_access_level: Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] snippets_enabled: Enable snippets for the project.
        :param pulumi.Input[str] squash_commit_template: Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
        :param pulumi.Input[str] squash_option: Squash commits when merge request. Valid values are `never`, `always`, `default_on`, or `default_off`. The default value is `default_off`. [GitLab >= 14.1]
        :param pulumi.Input[str] suggestion_commit_message: The commit message used to apply merge request suggestions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        :param pulumi.Input[str] template_name: When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        :param pulumi.Input[int] template_project_id: When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: The list of topics for the project.
        :param pulumi.Input[bool] use_custom_template: Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
               	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting.html#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        :param pulumi.Input[str] visibility_level: Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        :param pulumi.Input[str] wiki_access_level: Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] wiki_enabled: Enable wiki for the project.
        """
        if allow_merge_on_skipped_pipeline is not None:
            pulumi.set(__self__, "allow_merge_on_skipped_pipeline", allow_merge_on_skipped_pipeline)
        if analytics_access_level is not None:
            pulumi.set(__self__, "analytics_access_level", analytics_access_level)
        if approvals_before_merge is not None:
            pulumi.set(__self__, "approvals_before_merge", approvals_before_merge)
        if archive_on_destroy is not None:
            pulumi.set(__self__, "archive_on_destroy", archive_on_destroy)
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if auto_cancel_pending_pipelines is not None:
            pulumi.set(__self__, "auto_cancel_pending_pipelines", auto_cancel_pending_pipelines)
        if auto_devops_deploy_strategy is not None:
            pulumi.set(__self__, "auto_devops_deploy_strategy", auto_devops_deploy_strategy)
        if auto_devops_enabled is not None:
            pulumi.set(__self__, "auto_devops_enabled", auto_devops_enabled)
        if autoclose_referenced_issues is not None:
            pulumi.set(__self__, "autoclose_referenced_issues", autoclose_referenced_issues)
        if avatar is not None:
            pulumi.set(__self__, "avatar", avatar)
        if avatar_hash is not None:
            pulumi.set(__self__, "avatar_hash", avatar_hash)
        if build_coverage_regex is not None:
            warnings.warn("""build_coverage_regex is removed in GitLab 15.0.""", DeprecationWarning)
            pulumi.log.warn("""build_coverage_regex is deprecated: build_coverage_regex is removed in GitLab 15.0.""")
        if build_coverage_regex is not None:
            pulumi.set(__self__, "build_coverage_regex", build_coverage_regex)
        if build_git_strategy is not None:
            pulumi.set(__self__, "build_git_strategy", build_git_strategy)
        if build_timeout is not None:
            pulumi.set(__self__, "build_timeout", build_timeout)
        if builds_access_level is not None:
            pulumi.set(__self__, "builds_access_level", builds_access_level)
        if ci_config_path is not None:
            pulumi.set(__self__, "ci_config_path", ci_config_path)
        if ci_default_git_depth is not None:
            pulumi.set(__self__, "ci_default_git_depth", ci_default_git_depth)
        if ci_forward_deployment_enabled is not None:
            pulumi.set(__self__, "ci_forward_deployment_enabled", ci_forward_deployment_enabled)
        if ci_separated_caches is not None:
            pulumi.set(__self__, "ci_separated_caches", ci_separated_caches)
        if container_expiration_policy is not None:
            pulumi.set(__self__, "container_expiration_policy", container_expiration_policy)
        if container_registry_access_level is not None:
            pulumi.set(__self__, "container_registry_access_level", container_registry_access_level)
        if container_registry_enabled is not None:
            warnings.warn("""Use `container_registry_access_level` instead.""", DeprecationWarning)
            pulumi.log.warn("""container_registry_enabled is deprecated: Use `container_registry_access_level` instead.""")
        if container_registry_enabled is not None:
            pulumi.set(__self__, "container_registry_enabled", container_registry_enabled)
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if emails_disabled is not None:
            pulumi.set(__self__, "emails_disabled", emails_disabled)
        if environments_access_level is not None:
            pulumi.set(__self__, "environments_access_level", environments_access_level)
        if external_authorization_classification_label is not None:
            pulumi.set(__self__, "external_authorization_classification_label", external_authorization_classification_label)
        if feature_flags_access_level is not None:
            pulumi.set(__self__, "feature_flags_access_level", feature_flags_access_level)
        if forked_from_project_id is not None:
            pulumi.set(__self__, "forked_from_project_id", forked_from_project_id)
        if forking_access_level is not None:
            pulumi.set(__self__, "forking_access_level", forking_access_level)
        if group_runners_enabled is not None:
            pulumi.set(__self__, "group_runners_enabled", group_runners_enabled)
        if group_with_project_templates_id is not None:
            pulumi.set(__self__, "group_with_project_templates_id", group_with_project_templates_id)
        if import_url is not None:
            pulumi.set(__self__, "import_url", import_url)
        if import_url_password is not None:
            pulumi.set(__self__, "import_url_password", import_url_password)
        if import_url_username is not None:
            pulumi.set(__self__, "import_url_username", import_url_username)
        if infrastructure_access_level is not None:
            pulumi.set(__self__, "infrastructure_access_level", infrastructure_access_level)
        if initialize_with_readme is not None:
            pulumi.set(__self__, "initialize_with_readme", initialize_with_readme)
        if issues_access_level is not None:
            pulumi.set(__self__, "issues_access_level", issues_access_level)
        if issues_enabled is not None:
            pulumi.set(__self__, "issues_enabled", issues_enabled)
        if issues_template is not None:
            pulumi.set(__self__, "issues_template", issues_template)
        if keep_latest_artifact is not None:
            pulumi.set(__self__, "keep_latest_artifact", keep_latest_artifact)
        if lfs_enabled is not None:
            pulumi.set(__self__, "lfs_enabled", lfs_enabled)
        if merge_commit_template is not None:
            pulumi.set(__self__, "merge_commit_template", merge_commit_template)
        if merge_method is not None:
            pulumi.set(__self__, "merge_method", merge_method)
        if merge_pipelines_enabled is not None:
            pulumi.set(__self__, "merge_pipelines_enabled", merge_pipelines_enabled)
        if merge_requests_access_level is not None:
            pulumi.set(__self__, "merge_requests_access_level", merge_requests_access_level)
        if merge_requests_enabled is not None:
            pulumi.set(__self__, "merge_requests_enabled", merge_requests_enabled)
        if merge_requests_template is not None:
            pulumi.set(__self__, "merge_requests_template", merge_requests_template)
        if merge_trains_enabled is not None:
            pulumi.set(__self__, "merge_trains_enabled", merge_trains_enabled)
        if mirror is not None:
            pulumi.set(__self__, "mirror", mirror)
        if mirror_overwrites_diverged_branches is not None:
            pulumi.set(__self__, "mirror_overwrites_diverged_branches", mirror_overwrites_diverged_branches)
        if mirror_trigger_builds is not None:
            pulumi.set(__self__, "mirror_trigger_builds", mirror_trigger_builds)
        if monitor_access_level is not None:
            pulumi.set(__self__, "monitor_access_level", monitor_access_level)
        if mr_default_target_self is not None:
            pulumi.set(__self__, "mr_default_target_self", mr_default_target_self)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if only_allow_merge_if_all_discussions_are_resolved is not None:
            pulumi.set(__self__, "only_allow_merge_if_all_discussions_are_resolved", only_allow_merge_if_all_discussions_are_resolved)
        if only_allow_merge_if_pipeline_succeeds is not None:
            pulumi.set(__self__, "only_allow_merge_if_pipeline_succeeds", only_allow_merge_if_pipeline_succeeds)
        if only_mirror_protected_branches is not None:
            pulumi.set(__self__, "only_mirror_protected_branches", only_mirror_protected_branches)
        if packages_enabled is not None:
            pulumi.set(__self__, "packages_enabled", packages_enabled)
        if pages_access_level is not None:
            pulumi.set(__self__, "pages_access_level", pages_access_level)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if pipelines_enabled is not None:
            warnings.warn("""Deprecated in favor of `builds_access_level`""", DeprecationWarning)
            pulumi.log.warn("""pipelines_enabled is deprecated: Deprecated in favor of `builds_access_level`""")
        if pipelines_enabled is not None:
            pulumi.set(__self__, "pipelines_enabled", pipelines_enabled)
        if printing_merge_request_link_enabled is not None:
            pulumi.set(__self__, "printing_merge_request_link_enabled", printing_merge_request_link_enabled)
        if public_builds is not None:
            warnings.warn("""The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""", DeprecationWarning)
            pulumi.log.warn("""public_builds is deprecated: The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""")
        if public_builds is not None:
            pulumi.set(__self__, "public_builds", public_builds)
        if public_jobs is not None:
            pulumi.set(__self__, "public_jobs", public_jobs)
        if push_rules is not None:
            pulumi.set(__self__, "push_rules", push_rules)
        if releases_access_level is not None:
            pulumi.set(__self__, "releases_access_level", releases_access_level)
        if remove_source_branch_after_merge is not None:
            pulumi.set(__self__, "remove_source_branch_after_merge", remove_source_branch_after_merge)
        if repository_access_level is not None:
            pulumi.set(__self__, "repository_access_level", repository_access_level)
        if repository_storage is not None:
            pulumi.set(__self__, "repository_storage", repository_storage)
        if request_access_enabled is not None:
            pulumi.set(__self__, "request_access_enabled", request_access_enabled)
        if requirements_access_level is not None:
            pulumi.set(__self__, "requirements_access_level", requirements_access_level)
        if resolve_outdated_diff_discussions is not None:
            pulumi.set(__self__, "resolve_outdated_diff_discussions", resolve_outdated_diff_discussions)
        if restrict_user_defined_variables is not None:
            pulumi.set(__self__, "restrict_user_defined_variables", restrict_user_defined_variables)
        if security_and_compliance_access_level is not None:
            pulumi.set(__self__, "security_and_compliance_access_level", security_and_compliance_access_level)
        if shared_runners_enabled is not None:
            pulumi.set(__self__, "shared_runners_enabled", shared_runners_enabled)
        if skip_wait_for_default_branch_protection is not None:
            pulumi.set(__self__, "skip_wait_for_default_branch_protection", skip_wait_for_default_branch_protection)
        if snippets_access_level is not None:
            pulumi.set(__self__, "snippets_access_level", snippets_access_level)
        if snippets_enabled is not None:
            pulumi.set(__self__, "snippets_enabled", snippets_enabled)
        if squash_commit_template is not None:
            pulumi.set(__self__, "squash_commit_template", squash_commit_template)
        if squash_option is not None:
            pulumi.set(__self__, "squash_option", squash_option)
        if suggestion_commit_message is not None:
            pulumi.set(__self__, "suggestion_commit_message", suggestion_commit_message)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if template_project_id is not None:
            pulumi.set(__self__, "template_project_id", template_project_id)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if use_custom_template is not None:
            pulumi.set(__self__, "use_custom_template", use_custom_template)
        if visibility_level is not None:
            pulumi.set(__self__, "visibility_level", visibility_level)
        if wiki_access_level is not None:
            pulumi.set(__self__, "wiki_access_level", wiki_access_level)
        if wiki_enabled is not None:
            pulumi.set(__self__, "wiki_enabled", wiki_enabled)

    @property
    @pulumi.getter(name="allowMergeOnSkippedPipeline")
    def allow_merge_on_skipped_pipeline(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if you want to treat skipped pipelines as if they finished with success.
        """
        return pulumi.get(self, "allow_merge_on_skipped_pipeline")

    @allow_merge_on_skipped_pipeline.setter
    def allow_merge_on_skipped_pipeline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_merge_on_skipped_pipeline", value)

    @property
    @pulumi.getter(name="analyticsAccessLevel")
    def analytics_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "analytics_access_level")

    @analytics_access_level.setter
    def analytics_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analytics_access_level", value)

    @property
    @pulumi.getter(name="approvalsBeforeMerge")
    def approvals_before_merge(self) -> Optional[pulumi.Input[int]]:
        """
        Number of merge request approvals required for merging. Default is 0.
        This field **does not** work well in combination with the `ProjectApprovalRule` resource
        and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
        In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        """
        return pulumi.get(self, "approvals_before_merge")

    @approvals_before_merge.setter
    def approvals_before_merge(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "approvals_before_merge", value)

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        """
        return pulumi.get(self, "archive_on_destroy")

    @archive_on_destroy.setter
    def archive_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archive_on_destroy", value)

    @property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        """
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archived", value)

    @property
    @pulumi.getter(name="autoCancelPendingPipelines")
    def auto_cancel_pending_pipelines(self) -> Optional[pulumi.Input[str]]:
        """
        Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        """
        return pulumi.get(self, "auto_cancel_pending_pipelines")

    @auto_cancel_pending_pipelines.setter
    def auto_cancel_pending_pipelines(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_cancel_pending_pipelines", value)

    @property
    @pulumi.getter(name="autoDevopsDeployStrategy")
    def auto_devops_deploy_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        """
        return pulumi.get(self, "auto_devops_deploy_strategy")

    @auto_devops_deploy_strategy.setter
    def auto_devops_deploy_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_devops_deploy_strategy", value)

    @property
    @pulumi.getter(name="autoDevopsEnabled")
    def auto_devops_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Auto DevOps for this project.
        """
        return pulumi.get(self, "auto_devops_enabled")

    @auto_devops_enabled.setter
    def auto_devops_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_devops_enabled", value)

    @property
    @pulumi.getter(name="autocloseReferencedIssues")
    def autoclose_referenced_issues(self) -> Optional[pulumi.Input[bool]]:
        """
        Set whether auto-closing referenced issues on default branch.
        """
        return pulumi.get(self, "autoclose_referenced_issues")

    @autoclose_referenced_issues.setter
    def autoclose_referenced_issues(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoclose_referenced_issues", value)

    @property
    @pulumi.getter
    def avatar(self) -> Optional[pulumi.Input[str]]:
        """
        A local path to the avatar image to upload. **Note**: not available for imported resources.
        """
        return pulumi.get(self, "avatar")

    @avatar.setter
    def avatar(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar", value)

    @property
    @pulumi.getter(name="avatarHash")
    def avatar_hash(self) -> Optional[pulumi.Input[str]]:
        """
        The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        """
        return pulumi.get(self, "avatar_hash")

    @avatar_hash.setter
    def avatar_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar_hash", value)

    @property
    @pulumi.getter(name="buildCoverageRegex")
    def build_coverage_regex(self) -> Optional[pulumi.Input[str]]:
        """
        Test coverage parsing for the project. This is deprecated feature in GitLab 15.0.
        """
        warnings.warn("""build_coverage_regex is removed in GitLab 15.0.""", DeprecationWarning)
        pulumi.log.warn("""build_coverage_regex is deprecated: build_coverage_regex is removed in GitLab 15.0.""")

        return pulumi.get(self, "build_coverage_regex")

    @build_coverage_regex.setter
    def build_coverage_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_coverage_regex", value)

    @property
    @pulumi.getter(name="buildGitStrategy")
    def build_git_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        """
        return pulumi.get(self, "build_git_strategy")

    @build_git_strategy.setter
    def build_git_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_git_strategy", value)

    @property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time, in seconds, that a job can run.
        """
        return pulumi.get(self, "build_timeout")

    @build_timeout.setter
    def build_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "build_timeout", value)

    @property
    @pulumi.getter(name="buildsAccessLevel")
    def builds_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "builds_access_level")

    @builds_access_level.setter
    def builds_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "builds_access_level", value)

    @property
    @pulumi.getter(name="ciConfigPath")
    def ci_config_path(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Path to CI config file.
        """
        return pulumi.get(self, "ci_config_path")

    @ci_config_path.setter
    def ci_config_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ci_config_path", value)

    @property
    @pulumi.getter(name="ciDefaultGitDepth")
    def ci_default_git_depth(self) -> Optional[pulumi.Input[int]]:
        """
        Default number of revisions for shallow cloning.
        """
        return pulumi.get(self, "ci_default_git_depth")

    @ci_default_git_depth.setter
    def ci_default_git_depth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ci_default_git_depth", value)

    @property
    @pulumi.getter(name="ciForwardDeploymentEnabled")
    def ci_forward_deployment_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When a new deployment job starts, skip older deployment jobs that are still pending.
        """
        return pulumi.get(self, "ci_forward_deployment_enabled")

    @ci_forward_deployment_enabled.setter
    def ci_forward_deployment_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ci_forward_deployment_enabled", value)

    @property
    @pulumi.getter(name="ciSeparatedCaches")
    def ci_separated_caches(self) -> Optional[pulumi.Input[bool]]:
        """
        Use separate caches for protected branches.
        """
        return pulumi.get(self, "ci_separated_caches")

    @ci_separated_caches.setter
    def ci_separated_caches(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ci_separated_caches", value)

    @property
    @pulumi.getter(name="containerExpirationPolicy")
    def container_expiration_policy(self) -> Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']]:
        """
        Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        """
        return pulumi.get(self, "container_expiration_policy")

    @container_expiration_policy.setter
    def container_expiration_policy(self, value: Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']]):
        pulumi.set(self, "container_expiration_policy", value)

    @property
    @pulumi.getter(name="containerRegistryAccessLevel")
    def container_registry_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "container_registry_access_level")

    @container_registry_access_level.setter
    def container_registry_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_registry_access_level", value)

    @property
    @pulumi.getter(name="containerRegistryEnabled")
    def container_registry_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable container registry for the project.
        """
        warnings.warn("""Use `container_registry_access_level` instead.""", DeprecationWarning)
        pulumi.log.warn("""container_registry_enabled is deprecated: Use `container_registry_access_level` instead.""")

        return pulumi.get(self, "container_registry_enabled")

    @container_registry_enabled.setter
    def container_registry_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "container_registry_enabled", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[str]]:
        """
        The default branch for the project.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailsDisabled")
    def emails_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable email notifications.
        """
        return pulumi.get(self, "emails_disabled")

    @emails_disabled.setter
    def emails_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "emails_disabled", value)

    @property
    @pulumi.getter(name="environmentsAccessLevel")
    def environments_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "environments_access_level")

    @environments_access_level.setter
    def environments_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environments_access_level", value)

    @property
    @pulumi.getter(name="externalAuthorizationClassificationLabel")
    def external_authorization_classification_label(self) -> Optional[pulumi.Input[str]]:
        """
        The classification label for the project.
        """
        return pulumi.get(self, "external_authorization_classification_label")

    @external_authorization_classification_label.setter
    def external_authorization_classification_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_authorization_classification_label", value)

    @property
    @pulumi.getter(name="featureFlagsAccessLevel")
    def feature_flags_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "feature_flags_access_level")

    @feature_flags_access_level.setter
    def feature_flags_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_flags_access_level", value)

    @property
    @pulumi.getter(name="forkedFromProjectId")
    def forked_from_project_id(self) -> Optional[pulumi.Input[int]]:
        """
        The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        """
        return pulumi.get(self, "forked_from_project_id")

    @forked_from_project_id.setter
    def forked_from_project_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "forked_from_project_id", value)

    @property
    @pulumi.getter(name="forkingAccessLevel")
    def forking_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "forking_access_level")

    @forking_access_level.setter
    def forking_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forking_access_level", value)

    @property
    @pulumi.getter(name="groupRunnersEnabled")
    def group_runners_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable group runners for this project.
        """
        return pulumi.get(self, "group_runners_enabled")

    @group_runners_enabled.setter
    def group_runners_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "group_runners_enabled", value)

    @property
    @pulumi.getter(name="groupWithProjectTemplatesId")
    def group_with_project_templates_id(self) -> Optional[pulumi.Input[int]]:
        """
        For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        """
        return pulumi.get(self, "group_with_project_templates_id")

    @group_with_project_templates_id.setter
    def group_with_project_templates_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_with_project_templates_id", value)

    @property
    @pulumi.getter(name="importUrl")
    def import_url(self) -> Optional[pulumi.Input[str]]:
        """
        Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used
        together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import.
        Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the
        credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using
        `terraform import`. See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url")

    @import_url.setter
    def import_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_url", value)

    @property
    @pulumi.getter(name="importUrlPassword")
    def import_url_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
        to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
        use it.
        """
        return pulumi.get(self, "import_url_password")

    @import_url_password.setter
    def import_url_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_url_password", value)

    @property
    @pulumi.getter(name="importUrlUsername")
    def import_url_username(self) -> Optional[pulumi.Input[str]]:
        """
        The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
        to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
        use it.
        """
        return pulumi.get(self, "import_url_username")

    @import_url_username.setter
    def import_url_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_url_username", value)

    @property
    @pulumi.getter(name="infrastructureAccessLevel")
    def infrastructure_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "infrastructure_access_level")

    @infrastructure_access_level.setter
    def infrastructure_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infrastructure_access_level", value)

    @property
    @pulumi.getter(name="initializeWithReadme")
    def initialize_with_readme(self) -> Optional[pulumi.Input[bool]]:
        """
        Create main branch with first commit containing a README.md file.
        """
        return pulumi.get(self, "initialize_with_readme")

    @initialize_with_readme.setter
    def initialize_with_readme(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "initialize_with_readme", value)

    @property
    @pulumi.getter(name="issuesAccessLevel")
    def issues_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "issues_access_level")

    @issues_access_level.setter
    def issues_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issues_access_level", value)

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable issue tracking for the project.
        """
        return pulumi.get(self, "issues_enabled")

    @issues_enabled.setter
    def issues_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "issues_enabled", value)

    @property
    @pulumi.getter(name="issuesTemplate")
    def issues_template(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the template for new issues in the project.
        """
        return pulumi.get(self, "issues_template")

    @issues_template.setter
    def issues_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issues_template", value)

    @property
    @pulumi.getter(name="keepLatestArtifact")
    def keep_latest_artifact(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable or enable the ability to keep the latest artifact for this project.
        """
        return pulumi.get(self, "keep_latest_artifact")

    @keep_latest_artifact.setter
    def keep_latest_artifact(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_latest_artifact", value)

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable LFS for the project.
        """
        return pulumi.get(self, "lfs_enabled")

    @lfs_enabled.setter
    def lfs_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lfs_enabled", value)

    @property
    @pulumi.getter(name="mergeCommitTemplate")
    def merge_commit_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
        """
        return pulumi.get(self, "merge_commit_template")

    @merge_commit_template.setter
    def merge_commit_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_commit_template", value)

    @property
    @pulumi.getter(name="mergeMethod")
    def merge_method(self) -> Optional[pulumi.Input[str]]:
        """
        Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        """
        return pulumi.get(self, "merge_method")

    @merge_method.setter
    def merge_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_method", value)

    @property
    @pulumi.getter(name="mergePipelinesEnabled")
    def merge_pipelines_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable merge pipelines.
        """
        return pulumi.get(self, "merge_pipelines_enabled")

    @merge_pipelines_enabled.setter
    def merge_pipelines_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_pipelines_enabled", value)

    @property
    @pulumi.getter(name="mergeRequestsAccessLevel")
    def merge_requests_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "merge_requests_access_level")

    @merge_requests_access_level.setter
    def merge_requests_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_requests_access_level", value)

    @property
    @pulumi.getter(name="mergeRequestsEnabled")
    def merge_requests_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable merge requests for the project.
        """
        return pulumi.get(self, "merge_requests_enabled")

    @merge_requests_enabled.setter
    def merge_requests_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_requests_enabled", value)

    @property
    @pulumi.getter(name="mergeRequestsTemplate")
    def merge_requests_template(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the template for new merge requests in the project.
        """
        return pulumi.get(self, "merge_requests_template")

    @merge_requests_template.setter
    def merge_requests_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_requests_template", value)

    @property
    @pulumi.getter(name="mergeTrainsEnabled")
    def merge_trains_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        """
        return pulumi.get(self, "merge_trains_enabled")

    @merge_trains_enabled.setter
    def merge_trains_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_trains_enabled", value)

    @property
    @pulumi.getter
    def mirror(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable project pull mirror.
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mirror", value)

    @property
    @pulumi.getter(name="mirrorOverwritesDivergedBranches")
    def mirror_overwrites_diverged_branches(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable overwrite diverged branches for a mirrored project.
        """
        return pulumi.get(self, "mirror_overwrites_diverged_branches")

    @mirror_overwrites_diverged_branches.setter
    def mirror_overwrites_diverged_branches(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mirror_overwrites_diverged_branches", value)

    @property
    @pulumi.getter(name="mirrorTriggerBuilds")
    def mirror_trigger_builds(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable trigger builds on pushes for a mirrored project.
        """
        return pulumi.get(self, "mirror_trigger_builds")

    @mirror_trigger_builds.setter
    def mirror_trigger_builds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mirror_trigger_builds", value)

    @property
    @pulumi.getter(name="monitorAccessLevel")
    def monitor_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "monitor_access_level")

    @monitor_access_level.setter
    def monitor_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor_access_level", value)

    @property
    @pulumi.getter(name="mrDefaultTargetSelf")
    def mr_default_target_self(self) -> Optional[pulumi.Input[bool]]:
        """
        For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        """
        return pulumi.get(self, "mr_default_target_self")

    @mr_default_target_self.setter
    def mr_default_target_self(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mr_default_target_self", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[int]]:
        """
        The namespace (group or user) of the project. Defaults to your user.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="onlyAllowMergeIfAllDiscussionsAreResolved")
    def only_allow_merge_if_all_discussions_are_resolved(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if you want allow merges only if all discussions are resolved.
        """
        return pulumi.get(self, "only_allow_merge_if_all_discussions_are_resolved")

    @only_allow_merge_if_all_discussions_are_resolved.setter
    def only_allow_merge_if_all_discussions_are_resolved(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "only_allow_merge_if_all_discussions_are_resolved", value)

    @property
    @pulumi.getter(name="onlyAllowMergeIfPipelineSucceeds")
    def only_allow_merge_if_pipeline_succeeds(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if you want allow merges only if a pipeline succeeds.
        """
        return pulumi.get(self, "only_allow_merge_if_pipeline_succeeds")

    @only_allow_merge_if_pipeline_succeeds.setter
    def only_allow_merge_if_pipeline_succeeds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "only_allow_merge_if_pipeline_succeeds", value)

    @property
    @pulumi.getter(name="onlyMirrorProtectedBranches")
    def only_mirror_protected_branches(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable only mirror protected branches for a mirrored project.
        """
        return pulumi.get(self, "only_mirror_protected_branches")

    @only_mirror_protected_branches.setter
    def only_mirror_protected_branches(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "only_mirror_protected_branches", value)

    @property
    @pulumi.getter(name="packagesEnabled")
    def packages_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable packages repository for the project.
        """
        return pulumi.get(self, "packages_enabled")

    @packages_enabled.setter
    def packages_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "packages_enabled", value)

    @property
    @pulumi.getter(name="pagesAccessLevel")
    def pages_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        """
        return pulumi.get(self, "pages_access_level")

    @pages_access_level.setter
    def pages_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pages_access_level", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the repository.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="pipelinesEnabled")
    def pipelines_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        """
        warnings.warn("""Deprecated in favor of `builds_access_level`""", DeprecationWarning)
        pulumi.log.warn("""pipelines_enabled is deprecated: Deprecated in favor of `builds_access_level`""")

        return pulumi.get(self, "pipelines_enabled")

    @pipelines_enabled.setter
    def pipelines_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pipelines_enabled", value)

    @property
    @pulumi.getter(name="printingMergeRequestLinkEnabled")
    def printing_merge_request_link_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Show link to create/view merge request when pushing from the command line
        """
        return pulumi.get(self, "printing_merge_request_link_enabled")

    @printing_merge_request_link_enabled.setter
    def printing_merge_request_link_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "printing_merge_request_link_enabled", value)

    @property
    @pulumi.getter(name="publicBuilds")
    def public_builds(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, jobs can be viewed by non-project members.
        """
        warnings.warn("""The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""", DeprecationWarning)
        pulumi.log.warn("""public_builds is deprecated: The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""")

        return pulumi.get(self, "public_builds")

    @public_builds.setter
    def public_builds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_builds", value)

    @property
    @pulumi.getter(name="publicJobs")
    def public_jobs(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, jobs can be viewed by non-project members.
        """
        return pulumi.get(self, "public_jobs")

    @public_jobs.setter
    def public_jobs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_jobs", value)

    @property
    @pulumi.getter(name="pushRules")
    def push_rules(self) -> Optional[pulumi.Input['ProjectPushRulesArgs']]:
        """
        Push rules for the project.
        """
        return pulumi.get(self, "push_rules")

    @push_rules.setter
    def push_rules(self, value: Optional[pulumi.Input['ProjectPushRulesArgs']]):
        pulumi.set(self, "push_rules", value)

    @property
    @pulumi.getter(name="releasesAccessLevel")
    def releases_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "releases_access_level")

    @releases_access_level.setter
    def releases_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "releases_access_level", value)

    @property
    @pulumi.getter(name="removeSourceBranchAfterMerge")
    def remove_source_branch_after_merge(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable `Delete source branch` option by default for all new merge requests.
        """
        return pulumi.get(self, "remove_source_branch_after_merge")

    @remove_source_branch_after_merge.setter
    def remove_source_branch_after_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_source_branch_after_merge", value)

    @property
    @pulumi.getter(name="repositoryAccessLevel")
    def repository_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "repository_access_level")

    @repository_access_level.setter
    def repository_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_access_level", value)

    @property
    @pulumi.getter(name="repositoryStorage")
    def repository_storage(self) -> Optional[pulumi.Input[str]]:
        """
        Which storage shard the repository is on. (administrator only)
        """
        return pulumi.get(self, "repository_storage")

    @repository_storage.setter
    def repository_storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_storage", value)

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow users to request member access.
        """
        return pulumi.get(self, "request_access_enabled")

    @request_access_enabled.setter
    def request_access_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_access_enabled", value)

    @property
    @pulumi.getter(name="requirementsAccessLevel")
    def requirements_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "requirements_access_level")

    @requirements_access_level.setter
    def requirements_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requirements_access_level", value)

    @property
    @pulumi.getter(name="resolveOutdatedDiffDiscussions")
    def resolve_outdated_diff_discussions(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically resolve merge request diffs discussions on lines changed with a push.
        """
        return pulumi.get(self, "resolve_outdated_diff_discussions")

    @resolve_outdated_diff_discussions.setter
    def resolve_outdated_diff_discussions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resolve_outdated_diff_discussions", value)

    @property
    @pulumi.getter(name="restrictUserDefinedVariables")
    def restrict_user_defined_variables(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        """
        return pulumi.get(self, "restrict_user_defined_variables")

    @restrict_user_defined_variables.setter
    def restrict_user_defined_variables(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restrict_user_defined_variables", value)

    @property
    @pulumi.getter(name="securityAndComplianceAccessLevel")
    def security_and_compliance_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "security_and_compliance_access_level")

    @security_and_compliance_access_level.setter
    def security_and_compliance_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_and_compliance_access_level", value)

    @property
    @pulumi.getter(name="sharedRunnersEnabled")
    def shared_runners_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable shared runners for this project.
        """
        return pulumi.get(self, "shared_runners_enabled")

    @shared_runners_enabled.setter
    def shared_runners_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shared_runners_enabled", value)

    @property
    @pulumi.getter(name="skipWaitForDefaultBranchProtection")
    def skip_wait_for_default_branch_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, the default behavior to wait for the default branch protection to be created is skipped.
        This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
        There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
        This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        """
        return pulumi.get(self, "skip_wait_for_default_branch_protection")

    @skip_wait_for_default_branch_protection.setter
    def skip_wait_for_default_branch_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_wait_for_default_branch_protection", value)

    @property
    @pulumi.getter(name="snippetsAccessLevel")
    def snippets_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "snippets_access_level")

    @snippets_access_level.setter
    def snippets_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snippets_access_level", value)

    @property
    @pulumi.getter(name="snippetsEnabled")
    def snippets_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable snippets for the project.
        """
        return pulumi.get(self, "snippets_enabled")

    @snippets_enabled.setter
    def snippets_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "snippets_enabled", value)

    @property
    @pulumi.getter(name="squashCommitTemplate")
    def squash_commit_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
        """
        return pulumi.get(self, "squash_commit_template")

    @squash_commit_template.setter
    def squash_commit_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_commit_template", value)

    @property
    @pulumi.getter(name="squashOption")
    def squash_option(self) -> Optional[pulumi.Input[str]]:
        """
        Squash commits when merge request. Valid values are `never`, `always`, `default_on`, or `default_off`. The default value is `default_off`. [GitLab >= 14.1]
        """
        return pulumi.get(self, "squash_option")

    @squash_option.setter
    def squash_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_option", value)

    @property
    @pulumi.getter(name="suggestionCommitMessage")
    def suggestion_commit_message(self) -> Optional[pulumi.Input[str]]:
        """
        The commit message used to apply merge request suggestions.
        """
        return pulumi.get(self, "suggestion_commit_message")

    @suggestion_commit_message.setter
    def suggestion_commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suggestion_commit_message", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[str]]:
        """
        When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter(name="templateProjectId")
    def template_project_id(self) -> Optional[pulumi.Input[int]]:
        """
        When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        """
        return pulumi.get(self, "template_project_id")

    @template_project_id.setter
    def template_project_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "template_project_id", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of topics for the project.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter(name="useCustomTemplate")
    def use_custom_template(self) -> Optional[pulumi.Input[bool]]:
        """
        Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
        	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting.html#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        """
        return pulumi.get(self, "use_custom_template")

    @use_custom_template.setter
    def use_custom_template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_custom_template", value)

    @property
    @pulumi.getter(name="visibilityLevel")
    def visibility_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        """
        return pulumi.get(self, "visibility_level")

    @visibility_level.setter
    def visibility_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "visibility_level", value)

    @property
    @pulumi.getter(name="wikiAccessLevel")
    def wiki_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "wiki_access_level")

    @wiki_access_level.setter
    def wiki_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wiki_access_level", value)

    @property
    @pulumi.getter(name="wikiEnabled")
    def wiki_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable wiki for the project.
        """
        return pulumi.get(self, "wiki_enabled")

    @wiki_enabled.setter
    def wiki_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wiki_enabled", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 allow_merge_on_skipped_pipeline: Optional[pulumi.Input[bool]] = None,
                 analytics_access_level: Optional[pulumi.Input[str]] = None,
                 approvals_before_merge: Optional[pulumi.Input[int]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_cancel_pending_pipelines: Optional[pulumi.Input[str]] = None,
                 auto_devops_deploy_strategy: Optional[pulumi.Input[str]] = None,
                 auto_devops_enabled: Optional[pulumi.Input[bool]] = None,
                 autoclose_referenced_issues: Optional[pulumi.Input[bool]] = None,
                 avatar: Optional[pulumi.Input[str]] = None,
                 avatar_hash: Optional[pulumi.Input[str]] = None,
                 avatar_url: Optional[pulumi.Input[str]] = None,
                 build_coverage_regex: Optional[pulumi.Input[str]] = None,
                 build_git_strategy: Optional[pulumi.Input[str]] = None,
                 build_timeout: Optional[pulumi.Input[int]] = None,
                 builds_access_level: Optional[pulumi.Input[str]] = None,
                 ci_config_path: Optional[pulumi.Input[str]] = None,
                 ci_default_git_depth: Optional[pulumi.Input[int]] = None,
                 ci_forward_deployment_enabled: Optional[pulumi.Input[bool]] = None,
                 ci_separated_caches: Optional[pulumi.Input[bool]] = None,
                 container_expiration_policy: Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']] = None,
                 container_registry_access_level: Optional[pulumi.Input[str]] = None,
                 container_registry_enabled: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 emails_disabled: Optional[pulumi.Input[bool]] = None,
                 empty_repo: Optional[pulumi.Input[bool]] = None,
                 environments_access_level: Optional[pulumi.Input[str]] = None,
                 external_authorization_classification_label: Optional[pulumi.Input[str]] = None,
                 feature_flags_access_level: Optional[pulumi.Input[str]] = None,
                 forked_from_project_id: Optional[pulumi.Input[int]] = None,
                 forking_access_level: Optional[pulumi.Input[str]] = None,
                 group_runners_enabled: Optional[pulumi.Input[bool]] = None,
                 group_with_project_templates_id: Optional[pulumi.Input[int]] = None,
                 http_url_to_repo: Optional[pulumi.Input[str]] = None,
                 import_url: Optional[pulumi.Input[str]] = None,
                 import_url_password: Optional[pulumi.Input[str]] = None,
                 import_url_username: Optional[pulumi.Input[str]] = None,
                 infrastructure_access_level: Optional[pulumi.Input[str]] = None,
                 initialize_with_readme: Optional[pulumi.Input[bool]] = None,
                 issues_access_level: Optional[pulumi.Input[str]] = None,
                 issues_enabled: Optional[pulumi.Input[bool]] = None,
                 issues_template: Optional[pulumi.Input[str]] = None,
                 keep_latest_artifact: Optional[pulumi.Input[bool]] = None,
                 lfs_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_commit_template: Optional[pulumi.Input[str]] = None,
                 merge_method: Optional[pulumi.Input[str]] = None,
                 merge_pipelines_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_requests_access_level: Optional[pulumi.Input[str]] = None,
                 merge_requests_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_requests_template: Optional[pulumi.Input[str]] = None,
                 merge_trains_enabled: Optional[pulumi.Input[bool]] = None,
                 mirror: Optional[pulumi.Input[bool]] = None,
                 mirror_overwrites_diverged_branches: Optional[pulumi.Input[bool]] = None,
                 mirror_trigger_builds: Optional[pulumi.Input[bool]] = None,
                 monitor_access_level: Optional[pulumi.Input[str]] = None,
                 mr_default_target_self: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[int]] = None,
                 only_allow_merge_if_all_discussions_are_resolved: Optional[pulumi.Input[bool]] = None,
                 only_allow_merge_if_pipeline_succeeds: Optional[pulumi.Input[bool]] = None,
                 only_mirror_protected_branches: Optional[pulumi.Input[bool]] = None,
                 packages_enabled: Optional[pulumi.Input[bool]] = None,
                 pages_access_level: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 path_with_namespace: Optional[pulumi.Input[str]] = None,
                 pipelines_enabled: Optional[pulumi.Input[bool]] = None,
                 printing_merge_request_link_enabled: Optional[pulumi.Input[bool]] = None,
                 public_builds: Optional[pulumi.Input[bool]] = None,
                 public_jobs: Optional[pulumi.Input[bool]] = None,
                 push_rules: Optional[pulumi.Input['ProjectPushRulesArgs']] = None,
                 releases_access_level: Optional[pulumi.Input[str]] = None,
                 remove_source_branch_after_merge: Optional[pulumi.Input[bool]] = None,
                 repository_access_level: Optional[pulumi.Input[str]] = None,
                 repository_storage: Optional[pulumi.Input[str]] = None,
                 request_access_enabled: Optional[pulumi.Input[bool]] = None,
                 requirements_access_level: Optional[pulumi.Input[str]] = None,
                 resolve_outdated_diff_discussions: Optional[pulumi.Input[bool]] = None,
                 restrict_user_defined_variables: Optional[pulumi.Input[bool]] = None,
                 runners_token: Optional[pulumi.Input[str]] = None,
                 security_and_compliance_access_level: Optional[pulumi.Input[str]] = None,
                 shared_runners_enabled: Optional[pulumi.Input[bool]] = None,
                 skip_wait_for_default_branch_protection: Optional[pulumi.Input[bool]] = None,
                 snippets_access_level: Optional[pulumi.Input[str]] = None,
                 snippets_enabled: Optional[pulumi.Input[bool]] = None,
                 squash_commit_template: Optional[pulumi.Input[str]] = None,
                 squash_option: Optional[pulumi.Input[str]] = None,
                 ssh_url_to_repo: Optional[pulumi.Input[str]] = None,
                 suggestion_commit_message: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 template_project_id: Optional[pulumi.Input[int]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_custom_template: Optional[pulumi.Input[bool]] = None,
                 visibility_level: Optional[pulumi.Input[str]] = None,
                 web_url: Optional[pulumi.Input[str]] = None,
                 wiki_access_level: Optional[pulumi.Input[str]] = None,
                 wiki_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[bool] allow_merge_on_skipped_pipeline: Set to true if you want to treat skipped pipelines as if they finished with success.
        :param pulumi.Input[str] analytics_access_level: Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[int] approvals_before_merge: Number of merge request approvals required for merging. Default is 0.
               This field **does not** work well in combination with the `ProjectApprovalRule` resource
               and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
               In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        :param pulumi.Input[bool] archive_on_destroy: Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        :param pulumi.Input[bool] archived: Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        :param pulumi.Input[str] auto_cancel_pending_pipelines: Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        :param pulumi.Input[str] auto_devops_deploy_strategy: Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        :param pulumi.Input[bool] auto_devops_enabled: Enable Auto DevOps for this project.
        :param pulumi.Input[bool] autoclose_referenced_issues: Set whether auto-closing referenced issues on default branch.
        :param pulumi.Input[str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[str] avatar_url: The URL of the avatar image.
        :param pulumi.Input[str] build_coverage_regex: Test coverage parsing for the project. This is deprecated feature in GitLab 15.0.
        :param pulumi.Input[str] build_git_strategy: The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        :param pulumi.Input[int] build_timeout: The maximum amount of time, in seconds, that a job can run.
        :param pulumi.Input[str] builds_access_level: Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] ci_config_path: Custom Path to CI config file.
        :param pulumi.Input[int] ci_default_git_depth: Default number of revisions for shallow cloning.
        :param pulumi.Input[bool] ci_forward_deployment_enabled: When a new deployment job starts, skip older deployment jobs that are still pending.
        :param pulumi.Input[bool] ci_separated_caches: Use separate caches for protected branches.
        :param pulumi.Input['ProjectContainerExpirationPolicyArgs'] container_expiration_policy: Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        :param pulumi.Input[str] container_registry_access_level: Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] container_registry_enabled: Enable container registry for the project.
        :param pulumi.Input[str] default_branch: The default branch for the project.
        :param pulumi.Input[str] description: A description of the project.
        :param pulumi.Input[bool] emails_disabled: Disable email notifications.
        :param pulumi.Input[bool] empty_repo: Whether the project is empty.
        :param pulumi.Input[str] environments_access_level: Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] external_authorization_classification_label: The classification label for the project.
        :param pulumi.Input[str] feature_flags_access_level: Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[int] forked_from_project_id: The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        :param pulumi.Input[str] forking_access_level: Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] group_runners_enabled: Enable group runners for this project.
        :param pulumi.Input[int] group_with_project_templates_id: For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        :param pulumi.Input[str] http_url_to_repo: URL that can be provided to `git clone` to clone the
        :param pulumi.Input[str] import_url: Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used
               together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import.
               Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the
               credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using
               `terraform import`. See the examples section for how to properly use it.
        :param pulumi.Input[str] import_url_password: The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
               to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
               use it.
        :param pulumi.Input[str] import_url_username: The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
               to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
               use it.
        :param pulumi.Input[str] infrastructure_access_level: Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] initialize_with_readme: Create main branch with first commit containing a README.md file.
        :param pulumi.Input[str] issues_access_level: Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] issues_enabled: Enable issue tracking for the project.
        :param pulumi.Input[str] issues_template: Sets the template for new issues in the project.
        :param pulumi.Input[bool] keep_latest_artifact: Disable or enable the ability to keep the latest artifact for this project.
        :param pulumi.Input[bool] lfs_enabled: Enable LFS for the project.
        :param pulumi.Input[str] merge_commit_template: Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
        :param pulumi.Input[str] merge_method: Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        :param pulumi.Input[bool] merge_pipelines_enabled: Enable or disable merge pipelines.
        :param pulumi.Input[str] merge_requests_access_level: Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] merge_requests_enabled: Enable merge requests for the project.
        :param pulumi.Input[str] merge_requests_template: Sets the template for new merge requests in the project.
        :param pulumi.Input[bool] merge_trains_enabled: Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        :param pulumi.Input[bool] mirror: Enable project pull mirror.
        :param pulumi.Input[bool] mirror_overwrites_diverged_branches: Enable overwrite diverged branches for a mirrored project.
        :param pulumi.Input[bool] mirror_trigger_builds: Enable trigger builds on pushes for a mirrored project.
        :param pulumi.Input[str] monitor_access_level: Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] mr_default_target_self: For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        :param pulumi.Input[str] name: The name of the project.
        :param pulumi.Input[int] namespace_id: The namespace (group or user) of the project. Defaults to your user.
        :param pulumi.Input[bool] only_allow_merge_if_all_discussions_are_resolved: Set to true if you want allow merges only if all discussions are resolved.
        :param pulumi.Input[bool] only_allow_merge_if_pipeline_succeeds: Set to true if you want allow merges only if a pipeline succeeds.
        :param pulumi.Input[bool] only_mirror_protected_branches: Enable only mirror protected branches for a mirrored project.
        :param pulumi.Input[bool] packages_enabled: Enable packages repository for the project.
        :param pulumi.Input[str] pages_access_level: Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        :param pulumi.Input[str] path: The path of the repository.
        :param pulumi.Input[str] path_with_namespace: The path of the repository with namespace.
        :param pulumi.Input[bool] pipelines_enabled: Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        :param pulumi.Input[bool] printing_merge_request_link_enabled: Show link to create/view merge request when pushing from the command line
        :param pulumi.Input[bool] public_builds: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[bool] public_jobs: If true, jobs can be viewed by non-project members.
        :param pulumi.Input['ProjectPushRulesArgs'] push_rules: Push rules for the project.
        :param pulumi.Input[str] releases_access_level: Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] remove_source_branch_after_merge: Enable `Delete source branch` option by default for all new merge requests.
        :param pulumi.Input[str] repository_access_level: Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] repository_storage: Which storage shard the repository is on. (administrator only)
        :param pulumi.Input[bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[str] requirements_access_level: Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] resolve_outdated_diff_discussions: Automatically resolve merge request diffs discussions on lines changed with a push.
        :param pulumi.Input[bool] restrict_user_defined_variables: Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        :param pulumi.Input[str] runners_token: Registration token to use during runner setup.
        :param pulumi.Input[str] security_and_compliance_access_level: Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] shared_runners_enabled: Enable shared runners for this project.
        :param pulumi.Input[bool] skip_wait_for_default_branch_protection: If `true`, the default behavior to wait for the default branch protection to be created is skipped.
               This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
               There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
               This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        :param pulumi.Input[str] snippets_access_level: Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] snippets_enabled: Enable snippets for the project.
        :param pulumi.Input[str] squash_commit_template: Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
        :param pulumi.Input[str] squash_option: Squash commits when merge request. Valid values are `never`, `always`, `default_on`, or `default_off`. The default value is `default_off`. [GitLab >= 14.1]
        :param pulumi.Input[str] ssh_url_to_repo: URL that can be provided to `git clone` to clone the
        :param pulumi.Input[str] suggestion_commit_message: The commit message used to apply merge request suggestions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        :param pulumi.Input[str] template_name: When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        :param pulumi.Input[int] template_project_id: When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: The list of topics for the project.
        :param pulumi.Input[bool] use_custom_template: Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
               	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting.html#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        :param pulumi.Input[str] visibility_level: Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        :param pulumi.Input[str] web_url: URL that can be used to find the project in a browser.
        :param pulumi.Input[str] wiki_access_level: Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] wiki_enabled: Enable wiki for the project.
        """
        if allow_merge_on_skipped_pipeline is not None:
            pulumi.set(__self__, "allow_merge_on_skipped_pipeline", allow_merge_on_skipped_pipeline)
        if analytics_access_level is not None:
            pulumi.set(__self__, "analytics_access_level", analytics_access_level)
        if approvals_before_merge is not None:
            pulumi.set(__self__, "approvals_before_merge", approvals_before_merge)
        if archive_on_destroy is not None:
            pulumi.set(__self__, "archive_on_destroy", archive_on_destroy)
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if auto_cancel_pending_pipelines is not None:
            pulumi.set(__self__, "auto_cancel_pending_pipelines", auto_cancel_pending_pipelines)
        if auto_devops_deploy_strategy is not None:
            pulumi.set(__self__, "auto_devops_deploy_strategy", auto_devops_deploy_strategy)
        if auto_devops_enabled is not None:
            pulumi.set(__self__, "auto_devops_enabled", auto_devops_enabled)
        if autoclose_referenced_issues is not None:
            pulumi.set(__self__, "autoclose_referenced_issues", autoclose_referenced_issues)
        if avatar is not None:
            pulumi.set(__self__, "avatar", avatar)
        if avatar_hash is not None:
            pulumi.set(__self__, "avatar_hash", avatar_hash)
        if avatar_url is not None:
            pulumi.set(__self__, "avatar_url", avatar_url)
        if build_coverage_regex is not None:
            warnings.warn("""build_coverage_regex is removed in GitLab 15.0.""", DeprecationWarning)
            pulumi.log.warn("""build_coverage_regex is deprecated: build_coverage_regex is removed in GitLab 15.0.""")
        if build_coverage_regex is not None:
            pulumi.set(__self__, "build_coverage_regex", build_coverage_regex)
        if build_git_strategy is not None:
            pulumi.set(__self__, "build_git_strategy", build_git_strategy)
        if build_timeout is not None:
            pulumi.set(__self__, "build_timeout", build_timeout)
        if builds_access_level is not None:
            pulumi.set(__self__, "builds_access_level", builds_access_level)
        if ci_config_path is not None:
            pulumi.set(__self__, "ci_config_path", ci_config_path)
        if ci_default_git_depth is not None:
            pulumi.set(__self__, "ci_default_git_depth", ci_default_git_depth)
        if ci_forward_deployment_enabled is not None:
            pulumi.set(__self__, "ci_forward_deployment_enabled", ci_forward_deployment_enabled)
        if ci_separated_caches is not None:
            pulumi.set(__self__, "ci_separated_caches", ci_separated_caches)
        if container_expiration_policy is not None:
            pulumi.set(__self__, "container_expiration_policy", container_expiration_policy)
        if container_registry_access_level is not None:
            pulumi.set(__self__, "container_registry_access_level", container_registry_access_level)
        if container_registry_enabled is not None:
            warnings.warn("""Use `container_registry_access_level` instead.""", DeprecationWarning)
            pulumi.log.warn("""container_registry_enabled is deprecated: Use `container_registry_access_level` instead.""")
        if container_registry_enabled is not None:
            pulumi.set(__self__, "container_registry_enabled", container_registry_enabled)
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if emails_disabled is not None:
            pulumi.set(__self__, "emails_disabled", emails_disabled)
        if empty_repo is not None:
            pulumi.set(__self__, "empty_repo", empty_repo)
        if environments_access_level is not None:
            pulumi.set(__self__, "environments_access_level", environments_access_level)
        if external_authorization_classification_label is not None:
            pulumi.set(__self__, "external_authorization_classification_label", external_authorization_classification_label)
        if feature_flags_access_level is not None:
            pulumi.set(__self__, "feature_flags_access_level", feature_flags_access_level)
        if forked_from_project_id is not None:
            pulumi.set(__self__, "forked_from_project_id", forked_from_project_id)
        if forking_access_level is not None:
            pulumi.set(__self__, "forking_access_level", forking_access_level)
        if group_runners_enabled is not None:
            pulumi.set(__self__, "group_runners_enabled", group_runners_enabled)
        if group_with_project_templates_id is not None:
            pulumi.set(__self__, "group_with_project_templates_id", group_with_project_templates_id)
        if http_url_to_repo is not None:
            pulumi.set(__self__, "http_url_to_repo", http_url_to_repo)
        if import_url is not None:
            pulumi.set(__self__, "import_url", import_url)
        if import_url_password is not None:
            pulumi.set(__self__, "import_url_password", import_url_password)
        if import_url_username is not None:
            pulumi.set(__self__, "import_url_username", import_url_username)
        if infrastructure_access_level is not None:
            pulumi.set(__self__, "infrastructure_access_level", infrastructure_access_level)
        if initialize_with_readme is not None:
            pulumi.set(__self__, "initialize_with_readme", initialize_with_readme)
        if issues_access_level is not None:
            pulumi.set(__self__, "issues_access_level", issues_access_level)
        if issues_enabled is not None:
            pulumi.set(__self__, "issues_enabled", issues_enabled)
        if issues_template is not None:
            pulumi.set(__self__, "issues_template", issues_template)
        if keep_latest_artifact is not None:
            pulumi.set(__self__, "keep_latest_artifact", keep_latest_artifact)
        if lfs_enabled is not None:
            pulumi.set(__self__, "lfs_enabled", lfs_enabled)
        if merge_commit_template is not None:
            pulumi.set(__self__, "merge_commit_template", merge_commit_template)
        if merge_method is not None:
            pulumi.set(__self__, "merge_method", merge_method)
        if merge_pipelines_enabled is not None:
            pulumi.set(__self__, "merge_pipelines_enabled", merge_pipelines_enabled)
        if merge_requests_access_level is not None:
            pulumi.set(__self__, "merge_requests_access_level", merge_requests_access_level)
        if merge_requests_enabled is not None:
            pulumi.set(__self__, "merge_requests_enabled", merge_requests_enabled)
        if merge_requests_template is not None:
            pulumi.set(__self__, "merge_requests_template", merge_requests_template)
        if merge_trains_enabled is not None:
            pulumi.set(__self__, "merge_trains_enabled", merge_trains_enabled)
        if mirror is not None:
            pulumi.set(__self__, "mirror", mirror)
        if mirror_overwrites_diverged_branches is not None:
            pulumi.set(__self__, "mirror_overwrites_diverged_branches", mirror_overwrites_diverged_branches)
        if mirror_trigger_builds is not None:
            pulumi.set(__self__, "mirror_trigger_builds", mirror_trigger_builds)
        if monitor_access_level is not None:
            pulumi.set(__self__, "monitor_access_level", monitor_access_level)
        if mr_default_target_self is not None:
            pulumi.set(__self__, "mr_default_target_self", mr_default_target_self)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if only_allow_merge_if_all_discussions_are_resolved is not None:
            pulumi.set(__self__, "only_allow_merge_if_all_discussions_are_resolved", only_allow_merge_if_all_discussions_are_resolved)
        if only_allow_merge_if_pipeline_succeeds is not None:
            pulumi.set(__self__, "only_allow_merge_if_pipeline_succeeds", only_allow_merge_if_pipeline_succeeds)
        if only_mirror_protected_branches is not None:
            pulumi.set(__self__, "only_mirror_protected_branches", only_mirror_protected_branches)
        if packages_enabled is not None:
            pulumi.set(__self__, "packages_enabled", packages_enabled)
        if pages_access_level is not None:
            pulumi.set(__self__, "pages_access_level", pages_access_level)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if path_with_namespace is not None:
            pulumi.set(__self__, "path_with_namespace", path_with_namespace)
        if pipelines_enabled is not None:
            warnings.warn("""Deprecated in favor of `builds_access_level`""", DeprecationWarning)
            pulumi.log.warn("""pipelines_enabled is deprecated: Deprecated in favor of `builds_access_level`""")
        if pipelines_enabled is not None:
            pulumi.set(__self__, "pipelines_enabled", pipelines_enabled)
        if printing_merge_request_link_enabled is not None:
            pulumi.set(__self__, "printing_merge_request_link_enabled", printing_merge_request_link_enabled)
        if public_builds is not None:
            warnings.warn("""The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""", DeprecationWarning)
            pulumi.log.warn("""public_builds is deprecated: The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""")
        if public_builds is not None:
            pulumi.set(__self__, "public_builds", public_builds)
        if public_jobs is not None:
            pulumi.set(__self__, "public_jobs", public_jobs)
        if push_rules is not None:
            pulumi.set(__self__, "push_rules", push_rules)
        if releases_access_level is not None:
            pulumi.set(__self__, "releases_access_level", releases_access_level)
        if remove_source_branch_after_merge is not None:
            pulumi.set(__self__, "remove_source_branch_after_merge", remove_source_branch_after_merge)
        if repository_access_level is not None:
            pulumi.set(__self__, "repository_access_level", repository_access_level)
        if repository_storage is not None:
            pulumi.set(__self__, "repository_storage", repository_storage)
        if request_access_enabled is not None:
            pulumi.set(__self__, "request_access_enabled", request_access_enabled)
        if requirements_access_level is not None:
            pulumi.set(__self__, "requirements_access_level", requirements_access_level)
        if resolve_outdated_diff_discussions is not None:
            pulumi.set(__self__, "resolve_outdated_diff_discussions", resolve_outdated_diff_discussions)
        if restrict_user_defined_variables is not None:
            pulumi.set(__self__, "restrict_user_defined_variables", restrict_user_defined_variables)
        if runners_token is not None:
            pulumi.set(__self__, "runners_token", runners_token)
        if security_and_compliance_access_level is not None:
            pulumi.set(__self__, "security_and_compliance_access_level", security_and_compliance_access_level)
        if shared_runners_enabled is not None:
            pulumi.set(__self__, "shared_runners_enabled", shared_runners_enabled)
        if skip_wait_for_default_branch_protection is not None:
            pulumi.set(__self__, "skip_wait_for_default_branch_protection", skip_wait_for_default_branch_protection)
        if snippets_access_level is not None:
            pulumi.set(__self__, "snippets_access_level", snippets_access_level)
        if snippets_enabled is not None:
            pulumi.set(__self__, "snippets_enabled", snippets_enabled)
        if squash_commit_template is not None:
            pulumi.set(__self__, "squash_commit_template", squash_commit_template)
        if squash_option is not None:
            pulumi.set(__self__, "squash_option", squash_option)
        if ssh_url_to_repo is not None:
            pulumi.set(__self__, "ssh_url_to_repo", ssh_url_to_repo)
        if suggestion_commit_message is not None:
            pulumi.set(__self__, "suggestion_commit_message", suggestion_commit_message)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if template_project_id is not None:
            pulumi.set(__self__, "template_project_id", template_project_id)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if use_custom_template is not None:
            pulumi.set(__self__, "use_custom_template", use_custom_template)
        if visibility_level is not None:
            pulumi.set(__self__, "visibility_level", visibility_level)
        if web_url is not None:
            pulumi.set(__self__, "web_url", web_url)
        if wiki_access_level is not None:
            pulumi.set(__self__, "wiki_access_level", wiki_access_level)
        if wiki_enabled is not None:
            pulumi.set(__self__, "wiki_enabled", wiki_enabled)

    @property
    @pulumi.getter(name="allowMergeOnSkippedPipeline")
    def allow_merge_on_skipped_pipeline(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if you want to treat skipped pipelines as if they finished with success.
        """
        return pulumi.get(self, "allow_merge_on_skipped_pipeline")

    @allow_merge_on_skipped_pipeline.setter
    def allow_merge_on_skipped_pipeline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_merge_on_skipped_pipeline", value)

    @property
    @pulumi.getter(name="analyticsAccessLevel")
    def analytics_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "analytics_access_level")

    @analytics_access_level.setter
    def analytics_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analytics_access_level", value)

    @property
    @pulumi.getter(name="approvalsBeforeMerge")
    def approvals_before_merge(self) -> Optional[pulumi.Input[int]]:
        """
        Number of merge request approvals required for merging. Default is 0.
        This field **does not** work well in combination with the `ProjectApprovalRule` resource
        and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
        In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        """
        return pulumi.get(self, "approvals_before_merge")

    @approvals_before_merge.setter
    def approvals_before_merge(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "approvals_before_merge", value)

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        """
        return pulumi.get(self, "archive_on_destroy")

    @archive_on_destroy.setter
    def archive_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archive_on_destroy", value)

    @property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        """
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "archived", value)

    @property
    @pulumi.getter(name="autoCancelPendingPipelines")
    def auto_cancel_pending_pipelines(self) -> Optional[pulumi.Input[str]]:
        """
        Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        """
        return pulumi.get(self, "auto_cancel_pending_pipelines")

    @auto_cancel_pending_pipelines.setter
    def auto_cancel_pending_pipelines(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_cancel_pending_pipelines", value)

    @property
    @pulumi.getter(name="autoDevopsDeployStrategy")
    def auto_devops_deploy_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        """
        return pulumi.get(self, "auto_devops_deploy_strategy")

    @auto_devops_deploy_strategy.setter
    def auto_devops_deploy_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_devops_deploy_strategy", value)

    @property
    @pulumi.getter(name="autoDevopsEnabled")
    def auto_devops_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Auto DevOps for this project.
        """
        return pulumi.get(self, "auto_devops_enabled")

    @auto_devops_enabled.setter
    def auto_devops_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_devops_enabled", value)

    @property
    @pulumi.getter(name="autocloseReferencedIssues")
    def autoclose_referenced_issues(self) -> Optional[pulumi.Input[bool]]:
        """
        Set whether auto-closing referenced issues on default branch.
        """
        return pulumi.get(self, "autoclose_referenced_issues")

    @autoclose_referenced_issues.setter
    def autoclose_referenced_issues(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoclose_referenced_issues", value)

    @property
    @pulumi.getter
    def avatar(self) -> Optional[pulumi.Input[str]]:
        """
        A local path to the avatar image to upload. **Note**: not available for imported resources.
        """
        return pulumi.get(self, "avatar")

    @avatar.setter
    def avatar(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar", value)

    @property
    @pulumi.getter(name="avatarHash")
    def avatar_hash(self) -> Optional[pulumi.Input[str]]:
        """
        The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        """
        return pulumi.get(self, "avatar_hash")

    @avatar_hash.setter
    def avatar_hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar_hash", value)

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the avatar image.
        """
        return pulumi.get(self, "avatar_url")

    @avatar_url.setter
    def avatar_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "avatar_url", value)

    @property
    @pulumi.getter(name="buildCoverageRegex")
    def build_coverage_regex(self) -> Optional[pulumi.Input[str]]:
        """
        Test coverage parsing for the project. This is deprecated feature in GitLab 15.0.
        """
        warnings.warn("""build_coverage_regex is removed in GitLab 15.0.""", DeprecationWarning)
        pulumi.log.warn("""build_coverage_regex is deprecated: build_coverage_regex is removed in GitLab 15.0.""")

        return pulumi.get(self, "build_coverage_regex")

    @build_coverage_regex.setter
    def build_coverage_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_coverage_regex", value)

    @property
    @pulumi.getter(name="buildGitStrategy")
    def build_git_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        """
        return pulumi.get(self, "build_git_strategy")

    @build_git_strategy.setter
    def build_git_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_git_strategy", value)

    @property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time, in seconds, that a job can run.
        """
        return pulumi.get(self, "build_timeout")

    @build_timeout.setter
    def build_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "build_timeout", value)

    @property
    @pulumi.getter(name="buildsAccessLevel")
    def builds_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "builds_access_level")

    @builds_access_level.setter
    def builds_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "builds_access_level", value)

    @property
    @pulumi.getter(name="ciConfigPath")
    def ci_config_path(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Path to CI config file.
        """
        return pulumi.get(self, "ci_config_path")

    @ci_config_path.setter
    def ci_config_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ci_config_path", value)

    @property
    @pulumi.getter(name="ciDefaultGitDepth")
    def ci_default_git_depth(self) -> Optional[pulumi.Input[int]]:
        """
        Default number of revisions for shallow cloning.
        """
        return pulumi.get(self, "ci_default_git_depth")

    @ci_default_git_depth.setter
    def ci_default_git_depth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ci_default_git_depth", value)

    @property
    @pulumi.getter(name="ciForwardDeploymentEnabled")
    def ci_forward_deployment_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        When a new deployment job starts, skip older deployment jobs that are still pending.
        """
        return pulumi.get(self, "ci_forward_deployment_enabled")

    @ci_forward_deployment_enabled.setter
    def ci_forward_deployment_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ci_forward_deployment_enabled", value)

    @property
    @pulumi.getter(name="ciSeparatedCaches")
    def ci_separated_caches(self) -> Optional[pulumi.Input[bool]]:
        """
        Use separate caches for protected branches.
        """
        return pulumi.get(self, "ci_separated_caches")

    @ci_separated_caches.setter
    def ci_separated_caches(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ci_separated_caches", value)

    @property
    @pulumi.getter(name="containerExpirationPolicy")
    def container_expiration_policy(self) -> Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']]:
        """
        Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        """
        return pulumi.get(self, "container_expiration_policy")

    @container_expiration_policy.setter
    def container_expiration_policy(self, value: Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']]):
        pulumi.set(self, "container_expiration_policy", value)

    @property
    @pulumi.getter(name="containerRegistryAccessLevel")
    def container_registry_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "container_registry_access_level")

    @container_registry_access_level.setter
    def container_registry_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_registry_access_level", value)

    @property
    @pulumi.getter(name="containerRegistryEnabled")
    def container_registry_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable container registry for the project.
        """
        warnings.warn("""Use `container_registry_access_level` instead.""", DeprecationWarning)
        pulumi.log.warn("""container_registry_enabled is deprecated: Use `container_registry_access_level` instead.""")

        return pulumi.get(self, "container_registry_enabled")

    @container_registry_enabled.setter
    def container_registry_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "container_registry_enabled", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[str]]:
        """
        The default branch for the project.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailsDisabled")
    def emails_disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable email notifications.
        """
        return pulumi.get(self, "emails_disabled")

    @emails_disabled.setter
    def emails_disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "emails_disabled", value)

    @property
    @pulumi.getter(name="emptyRepo")
    def empty_repo(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the project is empty.
        """
        return pulumi.get(self, "empty_repo")

    @empty_repo.setter
    def empty_repo(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "empty_repo", value)

    @property
    @pulumi.getter(name="environmentsAccessLevel")
    def environments_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "environments_access_level")

    @environments_access_level.setter
    def environments_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environments_access_level", value)

    @property
    @pulumi.getter(name="externalAuthorizationClassificationLabel")
    def external_authorization_classification_label(self) -> Optional[pulumi.Input[str]]:
        """
        The classification label for the project.
        """
        return pulumi.get(self, "external_authorization_classification_label")

    @external_authorization_classification_label.setter
    def external_authorization_classification_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_authorization_classification_label", value)

    @property
    @pulumi.getter(name="featureFlagsAccessLevel")
    def feature_flags_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "feature_flags_access_level")

    @feature_flags_access_level.setter
    def feature_flags_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_flags_access_level", value)

    @property
    @pulumi.getter(name="forkedFromProjectId")
    def forked_from_project_id(self) -> Optional[pulumi.Input[int]]:
        """
        The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        """
        return pulumi.get(self, "forked_from_project_id")

    @forked_from_project_id.setter
    def forked_from_project_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "forked_from_project_id", value)

    @property
    @pulumi.getter(name="forkingAccessLevel")
    def forking_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "forking_access_level")

    @forking_access_level.setter
    def forking_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "forking_access_level", value)

    @property
    @pulumi.getter(name="groupRunnersEnabled")
    def group_runners_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable group runners for this project.
        """
        return pulumi.get(self, "group_runners_enabled")

    @group_runners_enabled.setter
    def group_runners_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "group_runners_enabled", value)

    @property
    @pulumi.getter(name="groupWithProjectTemplatesId")
    def group_with_project_templates_id(self) -> Optional[pulumi.Input[int]]:
        """
        For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        """
        return pulumi.get(self, "group_with_project_templates_id")

    @group_with_project_templates_id.setter
    def group_with_project_templates_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_with_project_templates_id", value)

    @property
    @pulumi.getter(name="httpUrlToRepo")
    def http_url_to_repo(self) -> Optional[pulumi.Input[str]]:
        """
        URL that can be provided to `git clone` to clone the
        """
        return pulumi.get(self, "http_url_to_repo")

    @http_url_to_repo.setter
    def http_url_to_repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_url_to_repo", value)

    @property
    @pulumi.getter(name="importUrl")
    def import_url(self) -> Optional[pulumi.Input[str]]:
        """
        Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used
        together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import.
        Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the
        credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using
        `terraform import`. See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url")

    @import_url.setter
    def import_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_url", value)

    @property
    @pulumi.getter(name="importUrlPassword")
    def import_url_password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
        to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
        use it.
        """
        return pulumi.get(self, "import_url_password")

    @import_url_password.setter
    def import_url_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_url_password", value)

    @property
    @pulumi.getter(name="importUrlUsername")
    def import_url_username(self) -> Optional[pulumi.Input[str]]:
        """
        The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
        to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
        use it.
        """
        return pulumi.get(self, "import_url_username")

    @import_url_username.setter
    def import_url_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "import_url_username", value)

    @property
    @pulumi.getter(name="infrastructureAccessLevel")
    def infrastructure_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "infrastructure_access_level")

    @infrastructure_access_level.setter
    def infrastructure_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "infrastructure_access_level", value)

    @property
    @pulumi.getter(name="initializeWithReadme")
    def initialize_with_readme(self) -> Optional[pulumi.Input[bool]]:
        """
        Create main branch with first commit containing a README.md file.
        """
        return pulumi.get(self, "initialize_with_readme")

    @initialize_with_readme.setter
    def initialize_with_readme(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "initialize_with_readme", value)

    @property
    @pulumi.getter(name="issuesAccessLevel")
    def issues_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "issues_access_level")

    @issues_access_level.setter
    def issues_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issues_access_level", value)

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable issue tracking for the project.
        """
        return pulumi.get(self, "issues_enabled")

    @issues_enabled.setter
    def issues_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "issues_enabled", value)

    @property
    @pulumi.getter(name="issuesTemplate")
    def issues_template(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the template for new issues in the project.
        """
        return pulumi.get(self, "issues_template")

    @issues_template.setter
    def issues_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issues_template", value)

    @property
    @pulumi.getter(name="keepLatestArtifact")
    def keep_latest_artifact(self) -> Optional[pulumi.Input[bool]]:
        """
        Disable or enable the ability to keep the latest artifact for this project.
        """
        return pulumi.get(self, "keep_latest_artifact")

    @keep_latest_artifact.setter
    def keep_latest_artifact(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_latest_artifact", value)

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable LFS for the project.
        """
        return pulumi.get(self, "lfs_enabled")

    @lfs_enabled.setter
    def lfs_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "lfs_enabled", value)

    @property
    @pulumi.getter(name="mergeCommitTemplate")
    def merge_commit_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
        """
        return pulumi.get(self, "merge_commit_template")

    @merge_commit_template.setter
    def merge_commit_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_commit_template", value)

    @property
    @pulumi.getter(name="mergeMethod")
    def merge_method(self) -> Optional[pulumi.Input[str]]:
        """
        Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        """
        return pulumi.get(self, "merge_method")

    @merge_method.setter
    def merge_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_method", value)

    @property
    @pulumi.getter(name="mergePipelinesEnabled")
    def merge_pipelines_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable merge pipelines.
        """
        return pulumi.get(self, "merge_pipelines_enabled")

    @merge_pipelines_enabled.setter
    def merge_pipelines_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_pipelines_enabled", value)

    @property
    @pulumi.getter(name="mergeRequestsAccessLevel")
    def merge_requests_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "merge_requests_access_level")

    @merge_requests_access_level.setter
    def merge_requests_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_requests_access_level", value)

    @property
    @pulumi.getter(name="mergeRequestsEnabled")
    def merge_requests_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable merge requests for the project.
        """
        return pulumi.get(self, "merge_requests_enabled")

    @merge_requests_enabled.setter
    def merge_requests_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_requests_enabled", value)

    @property
    @pulumi.getter(name="mergeRequestsTemplate")
    def merge_requests_template(self) -> Optional[pulumi.Input[str]]:
        """
        Sets the template for new merge requests in the project.
        """
        return pulumi.get(self, "merge_requests_template")

    @merge_requests_template.setter
    def merge_requests_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "merge_requests_template", value)

    @property
    @pulumi.getter(name="mergeTrainsEnabled")
    def merge_trains_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        """
        return pulumi.get(self, "merge_trains_enabled")

    @merge_trains_enabled.setter
    def merge_trains_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "merge_trains_enabled", value)

    @property
    @pulumi.getter
    def mirror(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable project pull mirror.
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mirror", value)

    @property
    @pulumi.getter(name="mirrorOverwritesDivergedBranches")
    def mirror_overwrites_diverged_branches(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable overwrite diverged branches for a mirrored project.
        """
        return pulumi.get(self, "mirror_overwrites_diverged_branches")

    @mirror_overwrites_diverged_branches.setter
    def mirror_overwrites_diverged_branches(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mirror_overwrites_diverged_branches", value)

    @property
    @pulumi.getter(name="mirrorTriggerBuilds")
    def mirror_trigger_builds(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable trigger builds on pushes for a mirrored project.
        """
        return pulumi.get(self, "mirror_trigger_builds")

    @mirror_trigger_builds.setter
    def mirror_trigger_builds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mirror_trigger_builds", value)

    @property
    @pulumi.getter(name="monitorAccessLevel")
    def monitor_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "monitor_access_level")

    @monitor_access_level.setter
    def monitor_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor_access_level", value)

    @property
    @pulumi.getter(name="mrDefaultTargetSelf")
    def mr_default_target_self(self) -> Optional[pulumi.Input[bool]]:
        """
        For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        """
        return pulumi.get(self, "mr_default_target_self")

    @mr_default_target_self.setter
    def mr_default_target_self(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mr_default_target_self", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[int]]:
        """
        The namespace (group or user) of the project. Defaults to your user.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="onlyAllowMergeIfAllDiscussionsAreResolved")
    def only_allow_merge_if_all_discussions_are_resolved(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if you want allow merges only if all discussions are resolved.
        """
        return pulumi.get(self, "only_allow_merge_if_all_discussions_are_resolved")

    @only_allow_merge_if_all_discussions_are_resolved.setter
    def only_allow_merge_if_all_discussions_are_resolved(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "only_allow_merge_if_all_discussions_are_resolved", value)

    @property
    @pulumi.getter(name="onlyAllowMergeIfPipelineSucceeds")
    def only_allow_merge_if_pipeline_succeeds(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if you want allow merges only if a pipeline succeeds.
        """
        return pulumi.get(self, "only_allow_merge_if_pipeline_succeeds")

    @only_allow_merge_if_pipeline_succeeds.setter
    def only_allow_merge_if_pipeline_succeeds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "only_allow_merge_if_pipeline_succeeds", value)

    @property
    @pulumi.getter(name="onlyMirrorProtectedBranches")
    def only_mirror_protected_branches(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable only mirror protected branches for a mirrored project.
        """
        return pulumi.get(self, "only_mirror_protected_branches")

    @only_mirror_protected_branches.setter
    def only_mirror_protected_branches(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "only_mirror_protected_branches", value)

    @property
    @pulumi.getter(name="packagesEnabled")
    def packages_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable packages repository for the project.
        """
        return pulumi.get(self, "packages_enabled")

    @packages_enabled.setter
    def packages_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "packages_enabled", value)

    @property
    @pulumi.getter(name="pagesAccessLevel")
    def pages_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        """
        return pulumi.get(self, "pages_access_level")

    @pages_access_level.setter
    def pages_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pages_access_level", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the repository.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="pathWithNamespace")
    def path_with_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the repository with namespace.
        """
        return pulumi.get(self, "path_with_namespace")

    @path_with_namespace.setter
    def path_with_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_with_namespace", value)

    @property
    @pulumi.getter(name="pipelinesEnabled")
    def pipelines_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        """
        warnings.warn("""Deprecated in favor of `builds_access_level`""", DeprecationWarning)
        pulumi.log.warn("""pipelines_enabled is deprecated: Deprecated in favor of `builds_access_level`""")

        return pulumi.get(self, "pipelines_enabled")

    @pipelines_enabled.setter
    def pipelines_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pipelines_enabled", value)

    @property
    @pulumi.getter(name="printingMergeRequestLinkEnabled")
    def printing_merge_request_link_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Show link to create/view merge request when pushing from the command line
        """
        return pulumi.get(self, "printing_merge_request_link_enabled")

    @printing_merge_request_link_enabled.setter
    def printing_merge_request_link_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "printing_merge_request_link_enabled", value)

    @property
    @pulumi.getter(name="publicBuilds")
    def public_builds(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, jobs can be viewed by non-project members.
        """
        warnings.warn("""The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""", DeprecationWarning)
        pulumi.log.warn("""public_builds is deprecated: The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""")

        return pulumi.get(self, "public_builds")

    @public_builds.setter
    def public_builds(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_builds", value)

    @property
    @pulumi.getter(name="publicJobs")
    def public_jobs(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, jobs can be viewed by non-project members.
        """
        return pulumi.get(self, "public_jobs")

    @public_jobs.setter
    def public_jobs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_jobs", value)

    @property
    @pulumi.getter(name="pushRules")
    def push_rules(self) -> Optional[pulumi.Input['ProjectPushRulesArgs']]:
        """
        Push rules for the project.
        """
        return pulumi.get(self, "push_rules")

    @push_rules.setter
    def push_rules(self, value: Optional[pulumi.Input['ProjectPushRulesArgs']]):
        pulumi.set(self, "push_rules", value)

    @property
    @pulumi.getter(name="releasesAccessLevel")
    def releases_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "releases_access_level")

    @releases_access_level.setter
    def releases_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "releases_access_level", value)

    @property
    @pulumi.getter(name="removeSourceBranchAfterMerge")
    def remove_source_branch_after_merge(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable `Delete source branch` option by default for all new merge requests.
        """
        return pulumi.get(self, "remove_source_branch_after_merge")

    @remove_source_branch_after_merge.setter
    def remove_source_branch_after_merge(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remove_source_branch_after_merge", value)

    @property
    @pulumi.getter(name="repositoryAccessLevel")
    def repository_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "repository_access_level")

    @repository_access_level.setter
    def repository_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_access_level", value)

    @property
    @pulumi.getter(name="repositoryStorage")
    def repository_storage(self) -> Optional[pulumi.Input[str]]:
        """
        Which storage shard the repository is on. (administrator only)
        """
        return pulumi.get(self, "repository_storage")

    @repository_storage.setter
    def repository_storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repository_storage", value)

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow users to request member access.
        """
        return pulumi.get(self, "request_access_enabled")

    @request_access_enabled.setter
    def request_access_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_access_enabled", value)

    @property
    @pulumi.getter(name="requirementsAccessLevel")
    def requirements_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "requirements_access_level")

    @requirements_access_level.setter
    def requirements_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requirements_access_level", value)

    @property
    @pulumi.getter(name="resolveOutdatedDiffDiscussions")
    def resolve_outdated_diff_discussions(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically resolve merge request diffs discussions on lines changed with a push.
        """
        return pulumi.get(self, "resolve_outdated_diff_discussions")

    @resolve_outdated_diff_discussions.setter
    def resolve_outdated_diff_discussions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resolve_outdated_diff_discussions", value)

    @property
    @pulumi.getter(name="restrictUserDefinedVariables")
    def restrict_user_defined_variables(self) -> Optional[pulumi.Input[bool]]:
        """
        Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        """
        return pulumi.get(self, "restrict_user_defined_variables")

    @restrict_user_defined_variables.setter
    def restrict_user_defined_variables(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restrict_user_defined_variables", value)

    @property
    @pulumi.getter(name="runnersToken")
    def runners_token(self) -> Optional[pulumi.Input[str]]:
        """
        Registration token to use during runner setup.
        """
        return pulumi.get(self, "runners_token")

    @runners_token.setter
    def runners_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runners_token", value)

    @property
    @pulumi.getter(name="securityAndComplianceAccessLevel")
    def security_and_compliance_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "security_and_compliance_access_level")

    @security_and_compliance_access_level.setter
    def security_and_compliance_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_and_compliance_access_level", value)

    @property
    @pulumi.getter(name="sharedRunnersEnabled")
    def shared_runners_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable shared runners for this project.
        """
        return pulumi.get(self, "shared_runners_enabled")

    @shared_runners_enabled.setter
    def shared_runners_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shared_runners_enabled", value)

    @property
    @pulumi.getter(name="skipWaitForDefaultBranchProtection")
    def skip_wait_for_default_branch_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        If `true`, the default behavior to wait for the default branch protection to be created is skipped.
        This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
        There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
        This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        """
        return pulumi.get(self, "skip_wait_for_default_branch_protection")

    @skip_wait_for_default_branch_protection.setter
    def skip_wait_for_default_branch_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_wait_for_default_branch_protection", value)

    @property
    @pulumi.getter(name="snippetsAccessLevel")
    def snippets_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "snippets_access_level")

    @snippets_access_level.setter
    def snippets_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snippets_access_level", value)

    @property
    @pulumi.getter(name="snippetsEnabled")
    def snippets_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable snippets for the project.
        """
        return pulumi.get(self, "snippets_enabled")

    @snippets_enabled.setter
    def snippets_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "snippets_enabled", value)

    @property
    @pulumi.getter(name="squashCommitTemplate")
    def squash_commit_template(self) -> Optional[pulumi.Input[str]]:
        """
        Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
        """
        return pulumi.get(self, "squash_commit_template")

    @squash_commit_template.setter
    def squash_commit_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_commit_template", value)

    @property
    @pulumi.getter(name="squashOption")
    def squash_option(self) -> Optional[pulumi.Input[str]]:
        """
        Squash commits when merge request. Valid values are `never`, `always`, `default_on`, or `default_off`. The default value is `default_off`. [GitLab >= 14.1]
        """
        return pulumi.get(self, "squash_option")

    @squash_option.setter
    def squash_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "squash_option", value)

    @property
    @pulumi.getter(name="sshUrlToRepo")
    def ssh_url_to_repo(self) -> Optional[pulumi.Input[str]]:
        """
        URL that can be provided to `git clone` to clone the
        """
        return pulumi.get(self, "ssh_url_to_repo")

    @ssh_url_to_repo.setter
    def ssh_url_to_repo(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_url_to_repo", value)

    @property
    @pulumi.getter(name="suggestionCommitMessage")
    def suggestion_commit_message(self) -> Optional[pulumi.Input[str]]:
        """
        The commit message used to apply merge request suggestions.
        """
        return pulumi.get(self, "suggestion_commit_message")

    @suggestion_commit_message.setter
    def suggestion_commit_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "suggestion_commit_message", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[str]]:
        """
        When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter(name="templateProjectId")
    def template_project_id(self) -> Optional[pulumi.Input[int]]:
        """
        When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        """
        return pulumi.get(self, "template_project_id")

    @template_project_id.setter
    def template_project_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "template_project_id", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of topics for the project.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter(name="useCustomTemplate")
    def use_custom_template(self) -> Optional[pulumi.Input[bool]]:
        """
        Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
        	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting.html#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        """
        return pulumi.get(self, "use_custom_template")

    @use_custom_template.setter
    def use_custom_template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_custom_template", value)

    @property
    @pulumi.getter(name="visibilityLevel")
    def visibility_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        """
        return pulumi.get(self, "visibility_level")

    @visibility_level.setter
    def visibility_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "visibility_level", value)

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL that can be used to find the project in a browser.
        """
        return pulumi.get(self, "web_url")

    @web_url.setter
    def web_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_url", value)

    @property
    @pulumi.getter(name="wikiAccessLevel")
    def wiki_access_level(self) -> Optional[pulumi.Input[str]]:
        """
        Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "wiki_access_level")

    @wiki_access_level.setter
    def wiki_access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "wiki_access_level", value)

    @property
    @pulumi.getter(name="wikiEnabled")
    def wiki_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable wiki for the project.
        """
        return pulumi.get(self, "wiki_enabled")

    @wiki_enabled.setter
    def wiki_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wiki_enabled", value)


class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_merge_on_skipped_pipeline: Optional[pulumi.Input[bool]] = None,
                 analytics_access_level: Optional[pulumi.Input[str]] = None,
                 approvals_before_merge: Optional[pulumi.Input[int]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_cancel_pending_pipelines: Optional[pulumi.Input[str]] = None,
                 auto_devops_deploy_strategy: Optional[pulumi.Input[str]] = None,
                 auto_devops_enabled: Optional[pulumi.Input[bool]] = None,
                 autoclose_referenced_issues: Optional[pulumi.Input[bool]] = None,
                 avatar: Optional[pulumi.Input[str]] = None,
                 avatar_hash: Optional[pulumi.Input[str]] = None,
                 build_coverage_regex: Optional[pulumi.Input[str]] = None,
                 build_git_strategy: Optional[pulumi.Input[str]] = None,
                 build_timeout: Optional[pulumi.Input[int]] = None,
                 builds_access_level: Optional[pulumi.Input[str]] = None,
                 ci_config_path: Optional[pulumi.Input[str]] = None,
                 ci_default_git_depth: Optional[pulumi.Input[int]] = None,
                 ci_forward_deployment_enabled: Optional[pulumi.Input[bool]] = None,
                 ci_separated_caches: Optional[pulumi.Input[bool]] = None,
                 container_expiration_policy: Optional[pulumi.Input[pulumi.InputType['ProjectContainerExpirationPolicyArgs']]] = None,
                 container_registry_access_level: Optional[pulumi.Input[str]] = None,
                 container_registry_enabled: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 emails_disabled: Optional[pulumi.Input[bool]] = None,
                 environments_access_level: Optional[pulumi.Input[str]] = None,
                 external_authorization_classification_label: Optional[pulumi.Input[str]] = None,
                 feature_flags_access_level: Optional[pulumi.Input[str]] = None,
                 forked_from_project_id: Optional[pulumi.Input[int]] = None,
                 forking_access_level: Optional[pulumi.Input[str]] = None,
                 group_runners_enabled: Optional[pulumi.Input[bool]] = None,
                 group_with_project_templates_id: Optional[pulumi.Input[int]] = None,
                 import_url: Optional[pulumi.Input[str]] = None,
                 import_url_password: Optional[pulumi.Input[str]] = None,
                 import_url_username: Optional[pulumi.Input[str]] = None,
                 infrastructure_access_level: Optional[pulumi.Input[str]] = None,
                 initialize_with_readme: Optional[pulumi.Input[bool]] = None,
                 issues_access_level: Optional[pulumi.Input[str]] = None,
                 issues_enabled: Optional[pulumi.Input[bool]] = None,
                 issues_template: Optional[pulumi.Input[str]] = None,
                 keep_latest_artifact: Optional[pulumi.Input[bool]] = None,
                 lfs_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_commit_template: Optional[pulumi.Input[str]] = None,
                 merge_method: Optional[pulumi.Input[str]] = None,
                 merge_pipelines_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_requests_access_level: Optional[pulumi.Input[str]] = None,
                 merge_requests_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_requests_template: Optional[pulumi.Input[str]] = None,
                 merge_trains_enabled: Optional[pulumi.Input[bool]] = None,
                 mirror: Optional[pulumi.Input[bool]] = None,
                 mirror_overwrites_diverged_branches: Optional[pulumi.Input[bool]] = None,
                 mirror_trigger_builds: Optional[pulumi.Input[bool]] = None,
                 monitor_access_level: Optional[pulumi.Input[str]] = None,
                 mr_default_target_self: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[int]] = None,
                 only_allow_merge_if_all_discussions_are_resolved: Optional[pulumi.Input[bool]] = None,
                 only_allow_merge_if_pipeline_succeeds: Optional[pulumi.Input[bool]] = None,
                 only_mirror_protected_branches: Optional[pulumi.Input[bool]] = None,
                 packages_enabled: Optional[pulumi.Input[bool]] = None,
                 pages_access_level: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 pipelines_enabled: Optional[pulumi.Input[bool]] = None,
                 printing_merge_request_link_enabled: Optional[pulumi.Input[bool]] = None,
                 public_builds: Optional[pulumi.Input[bool]] = None,
                 public_jobs: Optional[pulumi.Input[bool]] = None,
                 push_rules: Optional[pulumi.Input[pulumi.InputType['ProjectPushRulesArgs']]] = None,
                 releases_access_level: Optional[pulumi.Input[str]] = None,
                 remove_source_branch_after_merge: Optional[pulumi.Input[bool]] = None,
                 repository_access_level: Optional[pulumi.Input[str]] = None,
                 repository_storage: Optional[pulumi.Input[str]] = None,
                 request_access_enabled: Optional[pulumi.Input[bool]] = None,
                 requirements_access_level: Optional[pulumi.Input[str]] = None,
                 resolve_outdated_diff_discussions: Optional[pulumi.Input[bool]] = None,
                 restrict_user_defined_variables: Optional[pulumi.Input[bool]] = None,
                 security_and_compliance_access_level: Optional[pulumi.Input[str]] = None,
                 shared_runners_enabled: Optional[pulumi.Input[bool]] = None,
                 skip_wait_for_default_branch_protection: Optional[pulumi.Input[bool]] = None,
                 snippets_access_level: Optional[pulumi.Input[str]] = None,
                 snippets_enabled: Optional[pulumi.Input[bool]] = None,
                 squash_commit_template: Optional[pulumi.Input[str]] = None,
                 squash_option: Optional[pulumi.Input[str]] = None,
                 suggestion_commit_message: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 template_project_id: Optional[pulumi.Input[int]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_custom_template: Optional[pulumi.Input[bool]] = None,
                 visibility_level: Optional[pulumi.Input[str]] = None,
                 wiki_access_level: Optional[pulumi.Input[str]] = None,
                 wiki_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.Project("example",
            description="My awesome codebase",
            visibility_level="public")
        # Project with custom push rules
        example_two = gitlab.Project("example-two", push_rules=gitlab.ProjectPushRulesArgs(
            author_email_regex="@example\\\\.com$",
            commit_committer_check=True,
            member_check=True,
            prevent_secrets=True,
        ))
        peter_parker = gitlab.get_user(username="peter_parker")
        peters_repo = gitlab.Project("petersRepo",
            description="This is a description",
            namespace_id=peter_parker.namespace_id)
        # Fork a project
        fork_project = gitlab.Project("forkProject",
            description="This is a fork",
            forked_from_project_id=example.id)
        # Fork a project and setup a pull mirror
        fork_index_project_project = gitlab.Project("forkIndex/projectProject",
            description="This is a fork",
            forked_from_project_id=example.id,
            import_url=example.http_url_to_repo,
            mirror=True)
        # Create a project by importing it from a public project
        import_public = gitlab.Project("importPublic", import_url="https://gitlab.example.com/repo.git")
        # Create a project by importing it from a public project and setup the pull mirror
        import_public_with_mirror = gitlab.Project("importPublicWithMirror",
            import_url="https://gitlab.example.com/repo.git",
            mirror=True)
        # Create a project by importing it from a private project
        import_private_project = gitlab.Project("importPrivateProject",
            import_url="https://gitlab.example.com/repo.git",
            import_url_username="user",
            import_url_password="pass")
        # Create a project by importing it from a private project and setup the pull mirror
        import_private_with_mirror = gitlab.Project("importPrivateWithMirror",
            import_url="https://gitlab.example.com/repo.git",
            import_url_username="user",
            import_url_password="pass",
            mirror=True)
        # Create a project by importing it from a private project and provide credentials in `import_url`
        # NOTE: only use this if you really must, use `import_url_username` and `import_url_password` whenever possible
        #       GitLab API will always return the `import_url` without credentials, therefore you must ignore the `import_url` for changes:
        import_private_index_project_project = gitlab.Project("importPrivateIndex/projectProject", import_url="https://user:pass@gitlab.example.com/repo.git")
        ```

        ## Import

        ```sh
         $ pulumi import gitlab:index/project:Project You can import a project state using `<resource> <id>`. The
        ```

         `id` can be whatever the [get single project api][get_single_project] takes for its `:id` value, so for example

        ```sh
         $ pulumi import gitlab:index/project:Project example richardc/example
        ```

         NOTEthe `import_url_username` and `import_url_password` cannot be imported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_merge_on_skipped_pipeline: Set to true if you want to treat skipped pipelines as if they finished with success.
        :param pulumi.Input[str] analytics_access_level: Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[int] approvals_before_merge: Number of merge request approvals required for merging. Default is 0.
               This field **does not** work well in combination with the `ProjectApprovalRule` resource
               and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
               In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        :param pulumi.Input[bool] archive_on_destroy: Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        :param pulumi.Input[bool] archived: Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        :param pulumi.Input[str] auto_cancel_pending_pipelines: Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        :param pulumi.Input[str] auto_devops_deploy_strategy: Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        :param pulumi.Input[bool] auto_devops_enabled: Enable Auto DevOps for this project.
        :param pulumi.Input[bool] autoclose_referenced_issues: Set whether auto-closing referenced issues on default branch.
        :param pulumi.Input[str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[str] build_coverage_regex: Test coverage parsing for the project. This is deprecated feature in GitLab 15.0.
        :param pulumi.Input[str] build_git_strategy: The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        :param pulumi.Input[int] build_timeout: The maximum amount of time, in seconds, that a job can run.
        :param pulumi.Input[str] builds_access_level: Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] ci_config_path: Custom Path to CI config file.
        :param pulumi.Input[int] ci_default_git_depth: Default number of revisions for shallow cloning.
        :param pulumi.Input[bool] ci_forward_deployment_enabled: When a new deployment job starts, skip older deployment jobs that are still pending.
        :param pulumi.Input[bool] ci_separated_caches: Use separate caches for protected branches.
        :param pulumi.Input[pulumi.InputType['ProjectContainerExpirationPolicyArgs']] container_expiration_policy: Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        :param pulumi.Input[str] container_registry_access_level: Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] container_registry_enabled: Enable container registry for the project.
        :param pulumi.Input[str] default_branch: The default branch for the project.
        :param pulumi.Input[str] description: A description of the project.
        :param pulumi.Input[bool] emails_disabled: Disable email notifications.
        :param pulumi.Input[str] environments_access_level: Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] external_authorization_classification_label: The classification label for the project.
        :param pulumi.Input[str] feature_flags_access_level: Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[int] forked_from_project_id: The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        :param pulumi.Input[str] forking_access_level: Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] group_runners_enabled: Enable group runners for this project.
        :param pulumi.Input[int] group_with_project_templates_id: For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        :param pulumi.Input[str] import_url: Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used
               together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import.
               Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the
               credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using
               `terraform import`. See the examples section for how to properly use it.
        :param pulumi.Input[str] import_url_password: The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
               to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
               use it.
        :param pulumi.Input[str] import_url_username: The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
               to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
               use it.
        :param pulumi.Input[str] infrastructure_access_level: Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] initialize_with_readme: Create main branch with first commit containing a README.md file.
        :param pulumi.Input[str] issues_access_level: Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] issues_enabled: Enable issue tracking for the project.
        :param pulumi.Input[str] issues_template: Sets the template for new issues in the project.
        :param pulumi.Input[bool] keep_latest_artifact: Disable or enable the ability to keep the latest artifact for this project.
        :param pulumi.Input[bool] lfs_enabled: Enable LFS for the project.
        :param pulumi.Input[str] merge_commit_template: Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
        :param pulumi.Input[str] merge_method: Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        :param pulumi.Input[bool] merge_pipelines_enabled: Enable or disable merge pipelines.
        :param pulumi.Input[str] merge_requests_access_level: Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] merge_requests_enabled: Enable merge requests for the project.
        :param pulumi.Input[str] merge_requests_template: Sets the template for new merge requests in the project.
        :param pulumi.Input[bool] merge_trains_enabled: Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        :param pulumi.Input[bool] mirror: Enable project pull mirror.
        :param pulumi.Input[bool] mirror_overwrites_diverged_branches: Enable overwrite diverged branches for a mirrored project.
        :param pulumi.Input[bool] mirror_trigger_builds: Enable trigger builds on pushes for a mirrored project.
        :param pulumi.Input[str] monitor_access_level: Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] mr_default_target_self: For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        :param pulumi.Input[str] name: The name of the project.
        :param pulumi.Input[int] namespace_id: The namespace (group or user) of the project. Defaults to your user.
        :param pulumi.Input[bool] only_allow_merge_if_all_discussions_are_resolved: Set to true if you want allow merges only if all discussions are resolved.
        :param pulumi.Input[bool] only_allow_merge_if_pipeline_succeeds: Set to true if you want allow merges only if a pipeline succeeds.
        :param pulumi.Input[bool] only_mirror_protected_branches: Enable only mirror protected branches for a mirrored project.
        :param pulumi.Input[bool] packages_enabled: Enable packages repository for the project.
        :param pulumi.Input[str] pages_access_level: Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        :param pulumi.Input[str] path: The path of the repository.
        :param pulumi.Input[bool] pipelines_enabled: Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        :param pulumi.Input[bool] printing_merge_request_link_enabled: Show link to create/view merge request when pushing from the command line
        :param pulumi.Input[bool] public_builds: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[bool] public_jobs: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[pulumi.InputType['ProjectPushRulesArgs']] push_rules: Push rules for the project.
        :param pulumi.Input[str] releases_access_level: Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] remove_source_branch_after_merge: Enable `Delete source branch` option by default for all new merge requests.
        :param pulumi.Input[str] repository_access_level: Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] repository_storage: Which storage shard the repository is on. (administrator only)
        :param pulumi.Input[bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[str] requirements_access_level: Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] resolve_outdated_diff_discussions: Automatically resolve merge request diffs discussions on lines changed with a push.
        :param pulumi.Input[bool] restrict_user_defined_variables: Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        :param pulumi.Input[str] security_and_compliance_access_level: Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] shared_runners_enabled: Enable shared runners for this project.
        :param pulumi.Input[bool] skip_wait_for_default_branch_protection: If `true`, the default behavior to wait for the default branch protection to be created is skipped.
               This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
               There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
               This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        :param pulumi.Input[str] snippets_access_level: Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] snippets_enabled: Enable snippets for the project.
        :param pulumi.Input[str] squash_commit_template: Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
        :param pulumi.Input[str] squash_option: Squash commits when merge request. Valid values are `never`, `always`, `default_on`, or `default_off`. The default value is `default_off`. [GitLab >= 14.1]
        :param pulumi.Input[str] suggestion_commit_message: The commit message used to apply merge request suggestions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        :param pulumi.Input[str] template_name: When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        :param pulumi.Input[int] template_project_id: When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: The list of topics for the project.
        :param pulumi.Input[bool] use_custom_template: Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
               	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting.html#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        :param pulumi.Input[str] visibility_level: Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        :param pulumi.Input[str] wiki_access_level: Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] wiki_enabled: Enable wiki for the project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        example = gitlab.Project("example",
            description="My awesome codebase",
            visibility_level="public")
        # Project with custom push rules
        example_two = gitlab.Project("example-two", push_rules=gitlab.ProjectPushRulesArgs(
            author_email_regex="@example\\\\.com$",
            commit_committer_check=True,
            member_check=True,
            prevent_secrets=True,
        ))
        peter_parker = gitlab.get_user(username="peter_parker")
        peters_repo = gitlab.Project("petersRepo",
            description="This is a description",
            namespace_id=peter_parker.namespace_id)
        # Fork a project
        fork_project = gitlab.Project("forkProject",
            description="This is a fork",
            forked_from_project_id=example.id)
        # Fork a project and setup a pull mirror
        fork_index_project_project = gitlab.Project("forkIndex/projectProject",
            description="This is a fork",
            forked_from_project_id=example.id,
            import_url=example.http_url_to_repo,
            mirror=True)
        # Create a project by importing it from a public project
        import_public = gitlab.Project("importPublic", import_url="https://gitlab.example.com/repo.git")
        # Create a project by importing it from a public project and setup the pull mirror
        import_public_with_mirror = gitlab.Project("importPublicWithMirror",
            import_url="https://gitlab.example.com/repo.git",
            mirror=True)
        # Create a project by importing it from a private project
        import_private_project = gitlab.Project("importPrivateProject",
            import_url="https://gitlab.example.com/repo.git",
            import_url_username="user",
            import_url_password="pass")
        # Create a project by importing it from a private project and setup the pull mirror
        import_private_with_mirror = gitlab.Project("importPrivateWithMirror",
            import_url="https://gitlab.example.com/repo.git",
            import_url_username="user",
            import_url_password="pass",
            mirror=True)
        # Create a project by importing it from a private project and provide credentials in `import_url`
        # NOTE: only use this if you really must, use `import_url_username` and `import_url_password` whenever possible
        #       GitLab API will always return the `import_url` without credentials, therefore you must ignore the `import_url` for changes:
        import_private_index_project_project = gitlab.Project("importPrivateIndex/projectProject", import_url="https://user:pass@gitlab.example.com/repo.git")
        ```

        ## Import

        ```sh
         $ pulumi import gitlab:index/project:Project You can import a project state using `<resource> <id>`. The
        ```

         `id` can be whatever the [get single project api][get_single_project] takes for its `:id` value, so for example

        ```sh
         $ pulumi import gitlab:index/project:Project example richardc/example
        ```

         NOTEthe `import_url_username` and `import_url_password` cannot be imported.

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_merge_on_skipped_pipeline: Optional[pulumi.Input[bool]] = None,
                 analytics_access_level: Optional[pulumi.Input[str]] = None,
                 approvals_before_merge: Optional[pulumi.Input[int]] = None,
                 archive_on_destroy: Optional[pulumi.Input[bool]] = None,
                 archived: Optional[pulumi.Input[bool]] = None,
                 auto_cancel_pending_pipelines: Optional[pulumi.Input[str]] = None,
                 auto_devops_deploy_strategy: Optional[pulumi.Input[str]] = None,
                 auto_devops_enabled: Optional[pulumi.Input[bool]] = None,
                 autoclose_referenced_issues: Optional[pulumi.Input[bool]] = None,
                 avatar: Optional[pulumi.Input[str]] = None,
                 avatar_hash: Optional[pulumi.Input[str]] = None,
                 build_coverage_regex: Optional[pulumi.Input[str]] = None,
                 build_git_strategy: Optional[pulumi.Input[str]] = None,
                 build_timeout: Optional[pulumi.Input[int]] = None,
                 builds_access_level: Optional[pulumi.Input[str]] = None,
                 ci_config_path: Optional[pulumi.Input[str]] = None,
                 ci_default_git_depth: Optional[pulumi.Input[int]] = None,
                 ci_forward_deployment_enabled: Optional[pulumi.Input[bool]] = None,
                 ci_separated_caches: Optional[pulumi.Input[bool]] = None,
                 container_expiration_policy: Optional[pulumi.Input[pulumi.InputType['ProjectContainerExpirationPolicyArgs']]] = None,
                 container_registry_access_level: Optional[pulumi.Input[str]] = None,
                 container_registry_enabled: Optional[pulumi.Input[bool]] = None,
                 default_branch: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 emails_disabled: Optional[pulumi.Input[bool]] = None,
                 environments_access_level: Optional[pulumi.Input[str]] = None,
                 external_authorization_classification_label: Optional[pulumi.Input[str]] = None,
                 feature_flags_access_level: Optional[pulumi.Input[str]] = None,
                 forked_from_project_id: Optional[pulumi.Input[int]] = None,
                 forking_access_level: Optional[pulumi.Input[str]] = None,
                 group_runners_enabled: Optional[pulumi.Input[bool]] = None,
                 group_with_project_templates_id: Optional[pulumi.Input[int]] = None,
                 import_url: Optional[pulumi.Input[str]] = None,
                 import_url_password: Optional[pulumi.Input[str]] = None,
                 import_url_username: Optional[pulumi.Input[str]] = None,
                 infrastructure_access_level: Optional[pulumi.Input[str]] = None,
                 initialize_with_readme: Optional[pulumi.Input[bool]] = None,
                 issues_access_level: Optional[pulumi.Input[str]] = None,
                 issues_enabled: Optional[pulumi.Input[bool]] = None,
                 issues_template: Optional[pulumi.Input[str]] = None,
                 keep_latest_artifact: Optional[pulumi.Input[bool]] = None,
                 lfs_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_commit_template: Optional[pulumi.Input[str]] = None,
                 merge_method: Optional[pulumi.Input[str]] = None,
                 merge_pipelines_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_requests_access_level: Optional[pulumi.Input[str]] = None,
                 merge_requests_enabled: Optional[pulumi.Input[bool]] = None,
                 merge_requests_template: Optional[pulumi.Input[str]] = None,
                 merge_trains_enabled: Optional[pulumi.Input[bool]] = None,
                 mirror: Optional[pulumi.Input[bool]] = None,
                 mirror_overwrites_diverged_branches: Optional[pulumi.Input[bool]] = None,
                 mirror_trigger_builds: Optional[pulumi.Input[bool]] = None,
                 monitor_access_level: Optional[pulumi.Input[str]] = None,
                 mr_default_target_self: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[int]] = None,
                 only_allow_merge_if_all_discussions_are_resolved: Optional[pulumi.Input[bool]] = None,
                 only_allow_merge_if_pipeline_succeeds: Optional[pulumi.Input[bool]] = None,
                 only_mirror_protected_branches: Optional[pulumi.Input[bool]] = None,
                 packages_enabled: Optional[pulumi.Input[bool]] = None,
                 pages_access_level: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 pipelines_enabled: Optional[pulumi.Input[bool]] = None,
                 printing_merge_request_link_enabled: Optional[pulumi.Input[bool]] = None,
                 public_builds: Optional[pulumi.Input[bool]] = None,
                 public_jobs: Optional[pulumi.Input[bool]] = None,
                 push_rules: Optional[pulumi.Input[pulumi.InputType['ProjectPushRulesArgs']]] = None,
                 releases_access_level: Optional[pulumi.Input[str]] = None,
                 remove_source_branch_after_merge: Optional[pulumi.Input[bool]] = None,
                 repository_access_level: Optional[pulumi.Input[str]] = None,
                 repository_storage: Optional[pulumi.Input[str]] = None,
                 request_access_enabled: Optional[pulumi.Input[bool]] = None,
                 requirements_access_level: Optional[pulumi.Input[str]] = None,
                 resolve_outdated_diff_discussions: Optional[pulumi.Input[bool]] = None,
                 restrict_user_defined_variables: Optional[pulumi.Input[bool]] = None,
                 security_and_compliance_access_level: Optional[pulumi.Input[str]] = None,
                 shared_runners_enabled: Optional[pulumi.Input[bool]] = None,
                 skip_wait_for_default_branch_protection: Optional[pulumi.Input[bool]] = None,
                 snippets_access_level: Optional[pulumi.Input[str]] = None,
                 snippets_enabled: Optional[pulumi.Input[bool]] = None,
                 squash_commit_template: Optional[pulumi.Input[str]] = None,
                 squash_option: Optional[pulumi.Input[str]] = None,
                 suggestion_commit_message: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 template_project_id: Optional[pulumi.Input[int]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 use_custom_template: Optional[pulumi.Input[bool]] = None,
                 visibility_level: Optional[pulumi.Input[str]] = None,
                 wiki_access_level: Optional[pulumi.Input[str]] = None,
                 wiki_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["allow_merge_on_skipped_pipeline"] = allow_merge_on_skipped_pipeline
            __props__.__dict__["analytics_access_level"] = analytics_access_level
            __props__.__dict__["approvals_before_merge"] = approvals_before_merge
            __props__.__dict__["archive_on_destroy"] = archive_on_destroy
            __props__.__dict__["archived"] = archived
            __props__.__dict__["auto_cancel_pending_pipelines"] = auto_cancel_pending_pipelines
            __props__.__dict__["auto_devops_deploy_strategy"] = auto_devops_deploy_strategy
            __props__.__dict__["auto_devops_enabled"] = auto_devops_enabled
            __props__.__dict__["autoclose_referenced_issues"] = autoclose_referenced_issues
            __props__.__dict__["avatar"] = avatar
            __props__.__dict__["avatar_hash"] = avatar_hash
            __props__.__dict__["build_coverage_regex"] = build_coverage_regex
            __props__.__dict__["build_git_strategy"] = build_git_strategy
            __props__.__dict__["build_timeout"] = build_timeout
            __props__.__dict__["builds_access_level"] = builds_access_level
            __props__.__dict__["ci_config_path"] = ci_config_path
            __props__.__dict__["ci_default_git_depth"] = ci_default_git_depth
            __props__.__dict__["ci_forward_deployment_enabled"] = ci_forward_deployment_enabled
            __props__.__dict__["ci_separated_caches"] = ci_separated_caches
            __props__.__dict__["container_expiration_policy"] = container_expiration_policy
            __props__.__dict__["container_registry_access_level"] = container_registry_access_level
            __props__.__dict__["container_registry_enabled"] = container_registry_enabled
            __props__.__dict__["default_branch"] = default_branch
            __props__.__dict__["description"] = description
            __props__.__dict__["emails_disabled"] = emails_disabled
            __props__.__dict__["environments_access_level"] = environments_access_level
            __props__.__dict__["external_authorization_classification_label"] = external_authorization_classification_label
            __props__.__dict__["feature_flags_access_level"] = feature_flags_access_level
            __props__.__dict__["forked_from_project_id"] = forked_from_project_id
            __props__.__dict__["forking_access_level"] = forking_access_level
            __props__.__dict__["group_runners_enabled"] = group_runners_enabled
            __props__.__dict__["group_with_project_templates_id"] = group_with_project_templates_id
            __props__.__dict__["import_url"] = import_url
            __props__.__dict__["import_url_password"] = None if import_url_password is None else pulumi.Output.secret(import_url_password)
            __props__.__dict__["import_url_username"] = import_url_username
            __props__.__dict__["infrastructure_access_level"] = infrastructure_access_level
            __props__.__dict__["initialize_with_readme"] = initialize_with_readme
            __props__.__dict__["issues_access_level"] = issues_access_level
            __props__.__dict__["issues_enabled"] = issues_enabled
            __props__.__dict__["issues_template"] = issues_template
            __props__.__dict__["keep_latest_artifact"] = keep_latest_artifact
            __props__.__dict__["lfs_enabled"] = lfs_enabled
            __props__.__dict__["merge_commit_template"] = merge_commit_template
            __props__.__dict__["merge_method"] = merge_method
            __props__.__dict__["merge_pipelines_enabled"] = merge_pipelines_enabled
            __props__.__dict__["merge_requests_access_level"] = merge_requests_access_level
            __props__.__dict__["merge_requests_enabled"] = merge_requests_enabled
            __props__.__dict__["merge_requests_template"] = merge_requests_template
            __props__.__dict__["merge_trains_enabled"] = merge_trains_enabled
            __props__.__dict__["mirror"] = mirror
            __props__.__dict__["mirror_overwrites_diverged_branches"] = mirror_overwrites_diverged_branches
            __props__.__dict__["mirror_trigger_builds"] = mirror_trigger_builds
            __props__.__dict__["monitor_access_level"] = monitor_access_level
            __props__.__dict__["mr_default_target_self"] = mr_default_target_self
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace_id"] = namespace_id
            __props__.__dict__["only_allow_merge_if_all_discussions_are_resolved"] = only_allow_merge_if_all_discussions_are_resolved
            __props__.__dict__["only_allow_merge_if_pipeline_succeeds"] = only_allow_merge_if_pipeline_succeeds
            __props__.__dict__["only_mirror_protected_branches"] = only_mirror_protected_branches
            __props__.__dict__["packages_enabled"] = packages_enabled
            __props__.__dict__["pages_access_level"] = pages_access_level
            __props__.__dict__["path"] = path
            __props__.__dict__["pipelines_enabled"] = pipelines_enabled
            __props__.__dict__["printing_merge_request_link_enabled"] = printing_merge_request_link_enabled
            __props__.__dict__["public_builds"] = public_builds
            __props__.__dict__["public_jobs"] = public_jobs
            __props__.__dict__["push_rules"] = push_rules
            __props__.__dict__["releases_access_level"] = releases_access_level
            __props__.__dict__["remove_source_branch_after_merge"] = remove_source_branch_after_merge
            __props__.__dict__["repository_access_level"] = repository_access_level
            __props__.__dict__["repository_storage"] = repository_storage
            __props__.__dict__["request_access_enabled"] = request_access_enabled
            __props__.__dict__["requirements_access_level"] = requirements_access_level
            __props__.__dict__["resolve_outdated_diff_discussions"] = resolve_outdated_diff_discussions
            __props__.__dict__["restrict_user_defined_variables"] = restrict_user_defined_variables
            __props__.__dict__["security_and_compliance_access_level"] = security_and_compliance_access_level
            __props__.__dict__["shared_runners_enabled"] = shared_runners_enabled
            __props__.__dict__["skip_wait_for_default_branch_protection"] = skip_wait_for_default_branch_protection
            __props__.__dict__["snippets_access_level"] = snippets_access_level
            __props__.__dict__["snippets_enabled"] = snippets_enabled
            __props__.__dict__["squash_commit_template"] = squash_commit_template
            __props__.__dict__["squash_option"] = squash_option
            __props__.__dict__["suggestion_commit_message"] = suggestion_commit_message
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_name"] = template_name
            __props__.__dict__["template_project_id"] = template_project_id
            __props__.__dict__["topics"] = topics
            __props__.__dict__["use_custom_template"] = use_custom_template
            __props__.__dict__["visibility_level"] = visibility_level
            __props__.__dict__["wiki_access_level"] = wiki_access_level
            __props__.__dict__["wiki_enabled"] = wiki_enabled
            __props__.__dict__["avatar_url"] = None
            __props__.__dict__["empty_repo"] = None
            __props__.__dict__["http_url_to_repo"] = None
            __props__.__dict__["path_with_namespace"] = None
            __props__.__dict__["runners_token"] = None
            __props__.__dict__["ssh_url_to_repo"] = None
            __props__.__dict__["web_url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["importUrlPassword", "runnersToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Project, __self__).__init__(
            'gitlab:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_merge_on_skipped_pipeline: Optional[pulumi.Input[bool]] = None,
            analytics_access_level: Optional[pulumi.Input[str]] = None,
            approvals_before_merge: Optional[pulumi.Input[int]] = None,
            archive_on_destroy: Optional[pulumi.Input[bool]] = None,
            archived: Optional[pulumi.Input[bool]] = None,
            auto_cancel_pending_pipelines: Optional[pulumi.Input[str]] = None,
            auto_devops_deploy_strategy: Optional[pulumi.Input[str]] = None,
            auto_devops_enabled: Optional[pulumi.Input[bool]] = None,
            autoclose_referenced_issues: Optional[pulumi.Input[bool]] = None,
            avatar: Optional[pulumi.Input[str]] = None,
            avatar_hash: Optional[pulumi.Input[str]] = None,
            avatar_url: Optional[pulumi.Input[str]] = None,
            build_coverage_regex: Optional[pulumi.Input[str]] = None,
            build_git_strategy: Optional[pulumi.Input[str]] = None,
            build_timeout: Optional[pulumi.Input[int]] = None,
            builds_access_level: Optional[pulumi.Input[str]] = None,
            ci_config_path: Optional[pulumi.Input[str]] = None,
            ci_default_git_depth: Optional[pulumi.Input[int]] = None,
            ci_forward_deployment_enabled: Optional[pulumi.Input[bool]] = None,
            ci_separated_caches: Optional[pulumi.Input[bool]] = None,
            container_expiration_policy: Optional[pulumi.Input[pulumi.InputType['ProjectContainerExpirationPolicyArgs']]] = None,
            container_registry_access_level: Optional[pulumi.Input[str]] = None,
            container_registry_enabled: Optional[pulumi.Input[bool]] = None,
            default_branch: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            emails_disabled: Optional[pulumi.Input[bool]] = None,
            empty_repo: Optional[pulumi.Input[bool]] = None,
            environments_access_level: Optional[pulumi.Input[str]] = None,
            external_authorization_classification_label: Optional[pulumi.Input[str]] = None,
            feature_flags_access_level: Optional[pulumi.Input[str]] = None,
            forked_from_project_id: Optional[pulumi.Input[int]] = None,
            forking_access_level: Optional[pulumi.Input[str]] = None,
            group_runners_enabled: Optional[pulumi.Input[bool]] = None,
            group_with_project_templates_id: Optional[pulumi.Input[int]] = None,
            http_url_to_repo: Optional[pulumi.Input[str]] = None,
            import_url: Optional[pulumi.Input[str]] = None,
            import_url_password: Optional[pulumi.Input[str]] = None,
            import_url_username: Optional[pulumi.Input[str]] = None,
            infrastructure_access_level: Optional[pulumi.Input[str]] = None,
            initialize_with_readme: Optional[pulumi.Input[bool]] = None,
            issues_access_level: Optional[pulumi.Input[str]] = None,
            issues_enabled: Optional[pulumi.Input[bool]] = None,
            issues_template: Optional[pulumi.Input[str]] = None,
            keep_latest_artifact: Optional[pulumi.Input[bool]] = None,
            lfs_enabled: Optional[pulumi.Input[bool]] = None,
            merge_commit_template: Optional[pulumi.Input[str]] = None,
            merge_method: Optional[pulumi.Input[str]] = None,
            merge_pipelines_enabled: Optional[pulumi.Input[bool]] = None,
            merge_requests_access_level: Optional[pulumi.Input[str]] = None,
            merge_requests_enabled: Optional[pulumi.Input[bool]] = None,
            merge_requests_template: Optional[pulumi.Input[str]] = None,
            merge_trains_enabled: Optional[pulumi.Input[bool]] = None,
            mirror: Optional[pulumi.Input[bool]] = None,
            mirror_overwrites_diverged_branches: Optional[pulumi.Input[bool]] = None,
            mirror_trigger_builds: Optional[pulumi.Input[bool]] = None,
            monitor_access_level: Optional[pulumi.Input[str]] = None,
            mr_default_target_self: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace_id: Optional[pulumi.Input[int]] = None,
            only_allow_merge_if_all_discussions_are_resolved: Optional[pulumi.Input[bool]] = None,
            only_allow_merge_if_pipeline_succeeds: Optional[pulumi.Input[bool]] = None,
            only_mirror_protected_branches: Optional[pulumi.Input[bool]] = None,
            packages_enabled: Optional[pulumi.Input[bool]] = None,
            pages_access_level: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            path_with_namespace: Optional[pulumi.Input[str]] = None,
            pipelines_enabled: Optional[pulumi.Input[bool]] = None,
            printing_merge_request_link_enabled: Optional[pulumi.Input[bool]] = None,
            public_builds: Optional[pulumi.Input[bool]] = None,
            public_jobs: Optional[pulumi.Input[bool]] = None,
            push_rules: Optional[pulumi.Input[pulumi.InputType['ProjectPushRulesArgs']]] = None,
            releases_access_level: Optional[pulumi.Input[str]] = None,
            remove_source_branch_after_merge: Optional[pulumi.Input[bool]] = None,
            repository_access_level: Optional[pulumi.Input[str]] = None,
            repository_storage: Optional[pulumi.Input[str]] = None,
            request_access_enabled: Optional[pulumi.Input[bool]] = None,
            requirements_access_level: Optional[pulumi.Input[str]] = None,
            resolve_outdated_diff_discussions: Optional[pulumi.Input[bool]] = None,
            restrict_user_defined_variables: Optional[pulumi.Input[bool]] = None,
            runners_token: Optional[pulumi.Input[str]] = None,
            security_and_compliance_access_level: Optional[pulumi.Input[str]] = None,
            shared_runners_enabled: Optional[pulumi.Input[bool]] = None,
            skip_wait_for_default_branch_protection: Optional[pulumi.Input[bool]] = None,
            snippets_access_level: Optional[pulumi.Input[str]] = None,
            snippets_enabled: Optional[pulumi.Input[bool]] = None,
            squash_commit_template: Optional[pulumi.Input[str]] = None,
            squash_option: Optional[pulumi.Input[str]] = None,
            ssh_url_to_repo: Optional[pulumi.Input[str]] = None,
            suggestion_commit_message: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            template_name: Optional[pulumi.Input[str]] = None,
            template_project_id: Optional[pulumi.Input[int]] = None,
            topics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            use_custom_template: Optional[pulumi.Input[bool]] = None,
            visibility_level: Optional[pulumi.Input[str]] = None,
            web_url: Optional[pulumi.Input[str]] = None,
            wiki_access_level: Optional[pulumi.Input[str]] = None,
            wiki_enabled: Optional[pulumi.Input[bool]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_merge_on_skipped_pipeline: Set to true if you want to treat skipped pipelines as if they finished with success.
        :param pulumi.Input[str] analytics_access_level: Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[int] approvals_before_merge: Number of merge request approvals required for merging. Default is 0.
               This field **does not** work well in combination with the `ProjectApprovalRule` resource
               and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
               In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        :param pulumi.Input[bool] archive_on_destroy: Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        :param pulumi.Input[bool] archived: Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        :param pulumi.Input[str] auto_cancel_pending_pipelines: Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        :param pulumi.Input[str] auto_devops_deploy_strategy: Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        :param pulumi.Input[bool] auto_devops_enabled: Enable Auto DevOps for this project.
        :param pulumi.Input[bool] autoclose_referenced_issues: Set whether auto-closing referenced issues on default branch.
        :param pulumi.Input[str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[str] avatar_url: The URL of the avatar image.
        :param pulumi.Input[str] build_coverage_regex: Test coverage parsing for the project. This is deprecated feature in GitLab 15.0.
        :param pulumi.Input[str] build_git_strategy: The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        :param pulumi.Input[int] build_timeout: The maximum amount of time, in seconds, that a job can run.
        :param pulumi.Input[str] builds_access_level: Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] ci_config_path: Custom Path to CI config file.
        :param pulumi.Input[int] ci_default_git_depth: Default number of revisions for shallow cloning.
        :param pulumi.Input[bool] ci_forward_deployment_enabled: When a new deployment job starts, skip older deployment jobs that are still pending.
        :param pulumi.Input[bool] ci_separated_caches: Use separate caches for protected branches.
        :param pulumi.Input[pulumi.InputType['ProjectContainerExpirationPolicyArgs']] container_expiration_policy: Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        :param pulumi.Input[str] container_registry_access_level: Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] container_registry_enabled: Enable container registry for the project.
        :param pulumi.Input[str] default_branch: The default branch for the project.
        :param pulumi.Input[str] description: A description of the project.
        :param pulumi.Input[bool] emails_disabled: Disable email notifications.
        :param pulumi.Input[bool] empty_repo: Whether the project is empty.
        :param pulumi.Input[str] environments_access_level: Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] external_authorization_classification_label: The classification label for the project.
        :param pulumi.Input[str] feature_flags_access_level: Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[int] forked_from_project_id: The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        :param pulumi.Input[str] forking_access_level: Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] group_runners_enabled: Enable group runners for this project.
        :param pulumi.Input[int] group_with_project_templates_id: For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        :param pulumi.Input[str] http_url_to_repo: URL that can be provided to `git clone` to clone the
        :param pulumi.Input[str] import_url: Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used
               together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import.
               Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the
               credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using
               `terraform import`. See the examples section for how to properly use it.
        :param pulumi.Input[str] import_url_password: The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
               to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
               use it.
        :param pulumi.Input[str] import_url_username: The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
               to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
               use it.
        :param pulumi.Input[str] infrastructure_access_level: Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] initialize_with_readme: Create main branch with first commit containing a README.md file.
        :param pulumi.Input[str] issues_access_level: Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] issues_enabled: Enable issue tracking for the project.
        :param pulumi.Input[str] issues_template: Sets the template for new issues in the project.
        :param pulumi.Input[bool] keep_latest_artifact: Disable or enable the ability to keep the latest artifact for this project.
        :param pulumi.Input[bool] lfs_enabled: Enable LFS for the project.
        :param pulumi.Input[str] merge_commit_template: Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
        :param pulumi.Input[str] merge_method: Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        :param pulumi.Input[bool] merge_pipelines_enabled: Enable or disable merge pipelines.
        :param pulumi.Input[str] merge_requests_access_level: Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] merge_requests_enabled: Enable merge requests for the project.
        :param pulumi.Input[str] merge_requests_template: Sets the template for new merge requests in the project.
        :param pulumi.Input[bool] merge_trains_enabled: Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        :param pulumi.Input[bool] mirror: Enable project pull mirror.
        :param pulumi.Input[bool] mirror_overwrites_diverged_branches: Enable overwrite diverged branches for a mirrored project.
        :param pulumi.Input[bool] mirror_trigger_builds: Enable trigger builds on pushes for a mirrored project.
        :param pulumi.Input[str] monitor_access_level: Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] mr_default_target_self: For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        :param pulumi.Input[str] name: The name of the project.
        :param pulumi.Input[int] namespace_id: The namespace (group or user) of the project. Defaults to your user.
        :param pulumi.Input[bool] only_allow_merge_if_all_discussions_are_resolved: Set to true if you want allow merges only if all discussions are resolved.
        :param pulumi.Input[bool] only_allow_merge_if_pipeline_succeeds: Set to true if you want allow merges only if a pipeline succeeds.
        :param pulumi.Input[bool] only_mirror_protected_branches: Enable only mirror protected branches for a mirrored project.
        :param pulumi.Input[bool] packages_enabled: Enable packages repository for the project.
        :param pulumi.Input[str] pages_access_level: Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        :param pulumi.Input[str] path: The path of the repository.
        :param pulumi.Input[str] path_with_namespace: The path of the repository with namespace.
        :param pulumi.Input[bool] pipelines_enabled: Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        :param pulumi.Input[bool] printing_merge_request_link_enabled: Show link to create/view merge request when pushing from the command line
        :param pulumi.Input[bool] public_builds: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[bool] public_jobs: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[pulumi.InputType['ProjectPushRulesArgs']] push_rules: Push rules for the project.
        :param pulumi.Input[str] releases_access_level: Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] remove_source_branch_after_merge: Enable `Delete source branch` option by default for all new merge requests.
        :param pulumi.Input[str] repository_access_level: Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[str] repository_storage: Which storage shard the repository is on. (administrator only)
        :param pulumi.Input[bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[str] requirements_access_level: Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] resolve_outdated_diff_discussions: Automatically resolve merge request diffs discussions on lines changed with a push.
        :param pulumi.Input[bool] restrict_user_defined_variables: Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        :param pulumi.Input[str] runners_token: Registration token to use during runner setup.
        :param pulumi.Input[str] security_and_compliance_access_level: Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] shared_runners_enabled: Enable shared runners for this project.
        :param pulumi.Input[bool] skip_wait_for_default_branch_protection: If `true`, the default behavior to wait for the default branch protection to be created is skipped.
               This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
               There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
               This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        :param pulumi.Input[str] snippets_access_level: Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] snippets_enabled: Enable snippets for the project.
        :param pulumi.Input[str] squash_commit_template: Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
        :param pulumi.Input[str] squash_option: Squash commits when merge request. Valid values are `never`, `always`, `default_on`, or `default_off`. The default value is `default_off`. [GitLab >= 14.1]
        :param pulumi.Input[str] ssh_url_to_repo: URL that can be provided to `git clone` to clone the
        :param pulumi.Input[str] suggestion_commit_message: The commit message used to apply merge request suggestions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        :param pulumi.Input[str] template_name: When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        :param pulumi.Input[int] template_project_id: When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] topics: The list of topics for the project.
        :param pulumi.Input[bool] use_custom_template: Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
               	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting.html#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        :param pulumi.Input[str] visibility_level: Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        :param pulumi.Input[str] web_url: URL that can be used to find the project in a browser.
        :param pulumi.Input[str] wiki_access_level: Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[bool] wiki_enabled: Enable wiki for the project.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["allow_merge_on_skipped_pipeline"] = allow_merge_on_skipped_pipeline
        __props__.__dict__["analytics_access_level"] = analytics_access_level
        __props__.__dict__["approvals_before_merge"] = approvals_before_merge
        __props__.__dict__["archive_on_destroy"] = archive_on_destroy
        __props__.__dict__["archived"] = archived
        __props__.__dict__["auto_cancel_pending_pipelines"] = auto_cancel_pending_pipelines
        __props__.__dict__["auto_devops_deploy_strategy"] = auto_devops_deploy_strategy
        __props__.__dict__["auto_devops_enabled"] = auto_devops_enabled
        __props__.__dict__["autoclose_referenced_issues"] = autoclose_referenced_issues
        __props__.__dict__["avatar"] = avatar
        __props__.__dict__["avatar_hash"] = avatar_hash
        __props__.__dict__["avatar_url"] = avatar_url
        __props__.__dict__["build_coverage_regex"] = build_coverage_regex
        __props__.__dict__["build_git_strategy"] = build_git_strategy
        __props__.__dict__["build_timeout"] = build_timeout
        __props__.__dict__["builds_access_level"] = builds_access_level
        __props__.__dict__["ci_config_path"] = ci_config_path
        __props__.__dict__["ci_default_git_depth"] = ci_default_git_depth
        __props__.__dict__["ci_forward_deployment_enabled"] = ci_forward_deployment_enabled
        __props__.__dict__["ci_separated_caches"] = ci_separated_caches
        __props__.__dict__["container_expiration_policy"] = container_expiration_policy
        __props__.__dict__["container_registry_access_level"] = container_registry_access_level
        __props__.__dict__["container_registry_enabled"] = container_registry_enabled
        __props__.__dict__["default_branch"] = default_branch
        __props__.__dict__["description"] = description
        __props__.__dict__["emails_disabled"] = emails_disabled
        __props__.__dict__["empty_repo"] = empty_repo
        __props__.__dict__["environments_access_level"] = environments_access_level
        __props__.__dict__["external_authorization_classification_label"] = external_authorization_classification_label
        __props__.__dict__["feature_flags_access_level"] = feature_flags_access_level
        __props__.__dict__["forked_from_project_id"] = forked_from_project_id
        __props__.__dict__["forking_access_level"] = forking_access_level
        __props__.__dict__["group_runners_enabled"] = group_runners_enabled
        __props__.__dict__["group_with_project_templates_id"] = group_with_project_templates_id
        __props__.__dict__["http_url_to_repo"] = http_url_to_repo
        __props__.__dict__["import_url"] = import_url
        __props__.__dict__["import_url_password"] = import_url_password
        __props__.__dict__["import_url_username"] = import_url_username
        __props__.__dict__["infrastructure_access_level"] = infrastructure_access_level
        __props__.__dict__["initialize_with_readme"] = initialize_with_readme
        __props__.__dict__["issues_access_level"] = issues_access_level
        __props__.__dict__["issues_enabled"] = issues_enabled
        __props__.__dict__["issues_template"] = issues_template
        __props__.__dict__["keep_latest_artifact"] = keep_latest_artifact
        __props__.__dict__["lfs_enabled"] = lfs_enabled
        __props__.__dict__["merge_commit_template"] = merge_commit_template
        __props__.__dict__["merge_method"] = merge_method
        __props__.__dict__["merge_pipelines_enabled"] = merge_pipelines_enabled
        __props__.__dict__["merge_requests_access_level"] = merge_requests_access_level
        __props__.__dict__["merge_requests_enabled"] = merge_requests_enabled
        __props__.__dict__["merge_requests_template"] = merge_requests_template
        __props__.__dict__["merge_trains_enabled"] = merge_trains_enabled
        __props__.__dict__["mirror"] = mirror
        __props__.__dict__["mirror_overwrites_diverged_branches"] = mirror_overwrites_diverged_branches
        __props__.__dict__["mirror_trigger_builds"] = mirror_trigger_builds
        __props__.__dict__["monitor_access_level"] = monitor_access_level
        __props__.__dict__["mr_default_target_self"] = mr_default_target_self
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["only_allow_merge_if_all_discussions_are_resolved"] = only_allow_merge_if_all_discussions_are_resolved
        __props__.__dict__["only_allow_merge_if_pipeline_succeeds"] = only_allow_merge_if_pipeline_succeeds
        __props__.__dict__["only_mirror_protected_branches"] = only_mirror_protected_branches
        __props__.__dict__["packages_enabled"] = packages_enabled
        __props__.__dict__["pages_access_level"] = pages_access_level
        __props__.__dict__["path"] = path
        __props__.__dict__["path_with_namespace"] = path_with_namespace
        __props__.__dict__["pipelines_enabled"] = pipelines_enabled
        __props__.__dict__["printing_merge_request_link_enabled"] = printing_merge_request_link_enabled
        __props__.__dict__["public_builds"] = public_builds
        __props__.__dict__["public_jobs"] = public_jobs
        __props__.__dict__["push_rules"] = push_rules
        __props__.__dict__["releases_access_level"] = releases_access_level
        __props__.__dict__["remove_source_branch_after_merge"] = remove_source_branch_after_merge
        __props__.__dict__["repository_access_level"] = repository_access_level
        __props__.__dict__["repository_storage"] = repository_storage
        __props__.__dict__["request_access_enabled"] = request_access_enabled
        __props__.__dict__["requirements_access_level"] = requirements_access_level
        __props__.__dict__["resolve_outdated_diff_discussions"] = resolve_outdated_diff_discussions
        __props__.__dict__["restrict_user_defined_variables"] = restrict_user_defined_variables
        __props__.__dict__["runners_token"] = runners_token
        __props__.__dict__["security_and_compliance_access_level"] = security_and_compliance_access_level
        __props__.__dict__["shared_runners_enabled"] = shared_runners_enabled
        __props__.__dict__["skip_wait_for_default_branch_protection"] = skip_wait_for_default_branch_protection
        __props__.__dict__["snippets_access_level"] = snippets_access_level
        __props__.__dict__["snippets_enabled"] = snippets_enabled
        __props__.__dict__["squash_commit_template"] = squash_commit_template
        __props__.__dict__["squash_option"] = squash_option
        __props__.__dict__["ssh_url_to_repo"] = ssh_url_to_repo
        __props__.__dict__["suggestion_commit_message"] = suggestion_commit_message
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_name"] = template_name
        __props__.__dict__["template_project_id"] = template_project_id
        __props__.__dict__["topics"] = topics
        __props__.__dict__["use_custom_template"] = use_custom_template
        __props__.__dict__["visibility_level"] = visibility_level
        __props__.__dict__["web_url"] = web_url
        __props__.__dict__["wiki_access_level"] = wiki_access_level
        __props__.__dict__["wiki_enabled"] = wiki_enabled
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowMergeOnSkippedPipeline")
    def allow_merge_on_skipped_pipeline(self) -> pulumi.Output[bool]:
        """
        Set to true if you want to treat skipped pipelines as if they finished with success.
        """
        return pulumi.get(self, "allow_merge_on_skipped_pipeline")

    @property
    @pulumi.getter(name="analyticsAccessLevel")
    def analytics_access_level(self) -> pulumi.Output[str]:
        """
        Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "analytics_access_level")

    @property
    @pulumi.getter(name="approvalsBeforeMerge")
    def approvals_before_merge(self) -> pulumi.Output[Optional[int]]:
        """
        Number of merge request approvals required for merging. Default is 0.
        This field **does not** work well in combination with the `ProjectApprovalRule` resource
        and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
        In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        """
        return pulumi.get(self, "approvals_before_merge")

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        """
        return pulumi.get(self, "archive_on_destroy")

    @property
    @pulumi.getter
    def archived(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        """
        return pulumi.get(self, "archived")

    @property
    @pulumi.getter(name="autoCancelPendingPipelines")
    def auto_cancel_pending_pipelines(self) -> pulumi.Output[str]:
        """
        Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        """
        return pulumi.get(self, "auto_cancel_pending_pipelines")

    @property
    @pulumi.getter(name="autoDevopsDeployStrategy")
    def auto_devops_deploy_strategy(self) -> pulumi.Output[str]:
        """
        Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        """
        return pulumi.get(self, "auto_devops_deploy_strategy")

    @property
    @pulumi.getter(name="autoDevopsEnabled")
    def auto_devops_enabled(self) -> pulumi.Output[bool]:
        """
        Enable Auto DevOps for this project.
        """
        return pulumi.get(self, "auto_devops_enabled")

    @property
    @pulumi.getter(name="autocloseReferencedIssues")
    def autoclose_referenced_issues(self) -> pulumi.Output[bool]:
        """
        Set whether auto-closing referenced issues on default branch.
        """
        return pulumi.get(self, "autoclose_referenced_issues")

    @property
    @pulumi.getter
    def avatar(self) -> pulumi.Output[Optional[str]]:
        """
        A local path to the avatar image to upload. **Note**: not available for imported resources.
        """
        return pulumi.get(self, "avatar")

    @property
    @pulumi.getter(name="avatarHash")
    def avatar_hash(self) -> pulumi.Output[str]:
        """
        The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        """
        return pulumi.get(self, "avatar_hash")

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> pulumi.Output[str]:
        """
        The URL of the avatar image.
        """
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter(name="buildCoverageRegex")
    def build_coverage_regex(self) -> pulumi.Output[Optional[str]]:
        """
        Test coverage parsing for the project. This is deprecated feature in GitLab 15.0.
        """
        warnings.warn("""build_coverage_regex is removed in GitLab 15.0.""", DeprecationWarning)
        pulumi.log.warn("""build_coverage_regex is deprecated: build_coverage_regex is removed in GitLab 15.0.""")

        return pulumi.get(self, "build_coverage_regex")

    @property
    @pulumi.getter(name="buildGitStrategy")
    def build_git_strategy(self) -> pulumi.Output[str]:
        """
        The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        """
        return pulumi.get(self, "build_git_strategy")

    @property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> pulumi.Output[int]:
        """
        The maximum amount of time, in seconds, that a job can run.
        """
        return pulumi.get(self, "build_timeout")

    @property
    @pulumi.getter(name="buildsAccessLevel")
    def builds_access_level(self) -> pulumi.Output[str]:
        """
        Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "builds_access_level")

    @property
    @pulumi.getter(name="ciConfigPath")
    def ci_config_path(self) -> pulumi.Output[Optional[str]]:
        """
        Custom Path to CI config file.
        """
        return pulumi.get(self, "ci_config_path")

    @property
    @pulumi.getter(name="ciDefaultGitDepth")
    def ci_default_git_depth(self) -> pulumi.Output[int]:
        """
        Default number of revisions for shallow cloning.
        """
        return pulumi.get(self, "ci_default_git_depth")

    @property
    @pulumi.getter(name="ciForwardDeploymentEnabled")
    def ci_forward_deployment_enabled(self) -> pulumi.Output[bool]:
        """
        When a new deployment job starts, skip older deployment jobs that are still pending.
        """
        return pulumi.get(self, "ci_forward_deployment_enabled")

    @property
    @pulumi.getter(name="ciSeparatedCaches")
    def ci_separated_caches(self) -> pulumi.Output[bool]:
        """
        Use separate caches for protected branches.
        """
        return pulumi.get(self, "ci_separated_caches")

    @property
    @pulumi.getter(name="containerExpirationPolicy")
    def container_expiration_policy(self) -> pulumi.Output['outputs.ProjectContainerExpirationPolicy']:
        """
        Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        """
        return pulumi.get(self, "container_expiration_policy")

    @property
    @pulumi.getter(name="containerRegistryAccessLevel")
    def container_registry_access_level(self) -> pulumi.Output[str]:
        """
        Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "container_registry_access_level")

    @property
    @pulumi.getter(name="containerRegistryEnabled")
    def container_registry_enabled(self) -> pulumi.Output[bool]:
        """
        Enable container registry for the project.
        """
        warnings.warn("""Use `container_registry_access_level` instead.""", DeprecationWarning)
        pulumi.log.warn("""container_registry_enabled is deprecated: Use `container_registry_access_level` instead.""")

        return pulumi.get(self, "container_registry_enabled")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> pulumi.Output[str]:
        """
        The default branch for the project.
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailsDisabled")
    def emails_disabled(self) -> pulumi.Output[bool]:
        """
        Disable email notifications.
        """
        return pulumi.get(self, "emails_disabled")

    @property
    @pulumi.getter(name="emptyRepo")
    def empty_repo(self) -> pulumi.Output[bool]:
        """
        Whether the project is empty.
        """
        return pulumi.get(self, "empty_repo")

    @property
    @pulumi.getter(name="environmentsAccessLevel")
    def environments_access_level(self) -> pulumi.Output[str]:
        """
        Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "environments_access_level")

    @property
    @pulumi.getter(name="externalAuthorizationClassificationLabel")
    def external_authorization_classification_label(self) -> pulumi.Output[Optional[str]]:
        """
        The classification label for the project.
        """
        return pulumi.get(self, "external_authorization_classification_label")

    @property
    @pulumi.getter(name="featureFlagsAccessLevel")
    def feature_flags_access_level(self) -> pulumi.Output[str]:
        """
        Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "feature_flags_access_level")

    @property
    @pulumi.getter(name="forkedFromProjectId")
    def forked_from_project_id(self) -> pulumi.Output[Optional[int]]:
        """
        The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        """
        return pulumi.get(self, "forked_from_project_id")

    @property
    @pulumi.getter(name="forkingAccessLevel")
    def forking_access_level(self) -> pulumi.Output[str]:
        """
        Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "forking_access_level")

    @property
    @pulumi.getter(name="groupRunnersEnabled")
    def group_runners_enabled(self) -> pulumi.Output[bool]:
        """
        Enable group runners for this project.
        """
        return pulumi.get(self, "group_runners_enabled")

    @property
    @pulumi.getter(name="groupWithProjectTemplatesId")
    def group_with_project_templates_id(self) -> pulumi.Output[Optional[int]]:
        """
        For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        """
        return pulumi.get(self, "group_with_project_templates_id")

    @property
    @pulumi.getter(name="httpUrlToRepo")
    def http_url_to_repo(self) -> pulumi.Output[str]:
        """
        URL that can be provided to `git clone` to clone the
        """
        return pulumi.get(self, "http_url_to_repo")

    @property
    @pulumi.getter(name="importUrl")
    def import_url(self) -> pulumi.Output[Optional[str]]:
        """
        Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used
        together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import.
        Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the
        credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using
        `terraform import`. See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url")

    @property
    @pulumi.getter(name="importUrlPassword")
    def import_url_password(self) -> pulumi.Output[Optional[str]]:
        """
        The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
        to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
        use it.
        """
        return pulumi.get(self, "import_url_password")

    @property
    @pulumi.getter(name="importUrlUsername")
    def import_url_username(self) -> pulumi.Output[Optional[str]]:
        """
        The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related
        to the provider. This field cannot be imported using `terraform import`. See the examples section for how to properly
        use it.
        """
        return pulumi.get(self, "import_url_username")

    @property
    @pulumi.getter(name="infrastructureAccessLevel")
    def infrastructure_access_level(self) -> pulumi.Output[str]:
        """
        Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "infrastructure_access_level")

    @property
    @pulumi.getter(name="initializeWithReadme")
    def initialize_with_readme(self) -> pulumi.Output[Optional[bool]]:
        """
        Create main branch with first commit containing a README.md file.
        """
        return pulumi.get(self, "initialize_with_readme")

    @property
    @pulumi.getter(name="issuesAccessLevel")
    def issues_access_level(self) -> pulumi.Output[str]:
        """
        Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "issues_access_level")

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> pulumi.Output[bool]:
        """
        Enable issue tracking for the project.
        """
        return pulumi.get(self, "issues_enabled")

    @property
    @pulumi.getter(name="issuesTemplate")
    def issues_template(self) -> pulumi.Output[Optional[str]]:
        """
        Sets the template for new issues in the project.
        """
        return pulumi.get(self, "issues_template")

    @property
    @pulumi.getter(name="keepLatestArtifact")
    def keep_latest_artifact(self) -> pulumi.Output[bool]:
        """
        Disable or enable the ability to keep the latest artifact for this project.
        """
        return pulumi.get(self, "keep_latest_artifact")

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> pulumi.Output[bool]:
        """
        Enable LFS for the project.
        """
        return pulumi.get(self, "lfs_enabled")

    @property
    @pulumi.getter(name="mergeCommitTemplate")
    def merge_commit_template(self) -> pulumi.Output[Optional[str]]:
        """
        Template used to create merge commit message in merge requests. (Introduced in GitLab 14.5.)
        """
        return pulumi.get(self, "merge_commit_template")

    @property
    @pulumi.getter(name="mergeMethod")
    def merge_method(self) -> pulumi.Output[str]:
        """
        Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        """
        return pulumi.get(self, "merge_method")

    @property
    @pulumi.getter(name="mergePipelinesEnabled")
    def merge_pipelines_enabled(self) -> pulumi.Output[bool]:
        """
        Enable or disable merge pipelines.
        """
        return pulumi.get(self, "merge_pipelines_enabled")

    @property
    @pulumi.getter(name="mergeRequestsAccessLevel")
    def merge_requests_access_level(self) -> pulumi.Output[str]:
        """
        Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "merge_requests_access_level")

    @property
    @pulumi.getter(name="mergeRequestsEnabled")
    def merge_requests_enabled(self) -> pulumi.Output[bool]:
        """
        Enable merge requests for the project.
        """
        return pulumi.get(self, "merge_requests_enabled")

    @property
    @pulumi.getter(name="mergeRequestsTemplate")
    def merge_requests_template(self) -> pulumi.Output[Optional[str]]:
        """
        Sets the template for new merge requests in the project.
        """
        return pulumi.get(self, "merge_requests_template")

    @property
    @pulumi.getter(name="mergeTrainsEnabled")
    def merge_trains_enabled(self) -> pulumi.Output[bool]:
        """
        Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        """
        return pulumi.get(self, "merge_trains_enabled")

    @property
    @pulumi.getter
    def mirror(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable project pull mirror.
        """
        return pulumi.get(self, "mirror")

    @property
    @pulumi.getter(name="mirrorOverwritesDivergedBranches")
    def mirror_overwrites_diverged_branches(self) -> pulumi.Output[bool]:
        """
        Enable overwrite diverged branches for a mirrored project.
        """
        return pulumi.get(self, "mirror_overwrites_diverged_branches")

    @property
    @pulumi.getter(name="mirrorTriggerBuilds")
    def mirror_trigger_builds(self) -> pulumi.Output[bool]:
        """
        Enable trigger builds on pushes for a mirrored project.
        """
        return pulumi.get(self, "mirror_trigger_builds")

    @property
    @pulumi.getter(name="monitorAccessLevel")
    def monitor_access_level(self) -> pulumi.Output[str]:
        """
        Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "monitor_access_level")

    @property
    @pulumi.getter(name="mrDefaultTargetSelf")
    def mr_default_target_self(self) -> pulumi.Output[Optional[bool]]:
        """
        For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        """
        return pulumi.get(self, "mr_default_target_self")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[int]:
        """
        The namespace (group or user) of the project. Defaults to your user.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="onlyAllowMergeIfAllDiscussionsAreResolved")
    def only_allow_merge_if_all_discussions_are_resolved(self) -> pulumi.Output[bool]:
        """
        Set to true if you want allow merges only if all discussions are resolved.
        """
        return pulumi.get(self, "only_allow_merge_if_all_discussions_are_resolved")

    @property
    @pulumi.getter(name="onlyAllowMergeIfPipelineSucceeds")
    def only_allow_merge_if_pipeline_succeeds(self) -> pulumi.Output[bool]:
        """
        Set to true if you want allow merges only if a pipeline succeeds.
        """
        return pulumi.get(self, "only_allow_merge_if_pipeline_succeeds")

    @property
    @pulumi.getter(name="onlyMirrorProtectedBranches")
    def only_mirror_protected_branches(self) -> pulumi.Output[bool]:
        """
        Enable only mirror protected branches for a mirrored project.
        """
        return pulumi.get(self, "only_mirror_protected_branches")

    @property
    @pulumi.getter(name="packagesEnabled")
    def packages_enabled(self) -> pulumi.Output[bool]:
        """
        Enable packages repository for the project.
        """
        return pulumi.get(self, "packages_enabled")

    @property
    @pulumi.getter(name="pagesAccessLevel")
    def pages_access_level(self) -> pulumi.Output[str]:
        """
        Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        """
        return pulumi.get(self, "pages_access_level")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[str]]:
        """
        The path of the repository.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathWithNamespace")
    def path_with_namespace(self) -> pulumi.Output[str]:
        """
        The path of the repository with namespace.
        """
        return pulumi.get(self, "path_with_namespace")

    @property
    @pulumi.getter(name="pipelinesEnabled")
    def pipelines_enabled(self) -> pulumi.Output[bool]:
        """
        Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        """
        warnings.warn("""Deprecated in favor of `builds_access_level`""", DeprecationWarning)
        pulumi.log.warn("""pipelines_enabled is deprecated: Deprecated in favor of `builds_access_level`""")

        return pulumi.get(self, "pipelines_enabled")

    @property
    @pulumi.getter(name="printingMergeRequestLinkEnabled")
    def printing_merge_request_link_enabled(self) -> pulumi.Output[bool]:
        """
        Show link to create/view merge request when pushing from the command line
        """
        return pulumi.get(self, "printing_merge_request_link_enabled")

    @property
    @pulumi.getter(name="publicBuilds")
    def public_builds(self) -> pulumi.Output[bool]:
        """
        If true, jobs can be viewed by non-project members.
        """
        warnings.warn("""The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""", DeprecationWarning)
        pulumi.log.warn("""public_builds is deprecated: The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""")

        return pulumi.get(self, "public_builds")

    @property
    @pulumi.getter(name="publicJobs")
    def public_jobs(self) -> pulumi.Output[bool]:
        """
        If true, jobs can be viewed by non-project members.
        """
        return pulumi.get(self, "public_jobs")

    @property
    @pulumi.getter(name="pushRules")
    def push_rules(self) -> pulumi.Output['outputs.ProjectPushRules']:
        """
        Push rules for the project.
        """
        return pulumi.get(self, "push_rules")

    @property
    @pulumi.getter(name="releasesAccessLevel")
    def releases_access_level(self) -> pulumi.Output[str]:
        """
        Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "releases_access_level")

    @property
    @pulumi.getter(name="removeSourceBranchAfterMerge")
    def remove_source_branch_after_merge(self) -> pulumi.Output[bool]:
        """
        Enable `Delete source branch` option by default for all new merge requests.
        """
        return pulumi.get(self, "remove_source_branch_after_merge")

    @property
    @pulumi.getter(name="repositoryAccessLevel")
    def repository_access_level(self) -> pulumi.Output[str]:
        """
        Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "repository_access_level")

    @property
    @pulumi.getter(name="repositoryStorage")
    def repository_storage(self) -> pulumi.Output[str]:
        """
        Which storage shard the repository is on. (administrator only)
        """
        return pulumi.get(self, "repository_storage")

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> pulumi.Output[bool]:
        """
        Allow users to request member access.
        """
        return pulumi.get(self, "request_access_enabled")

    @property
    @pulumi.getter(name="requirementsAccessLevel")
    def requirements_access_level(self) -> pulumi.Output[str]:
        """
        Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "requirements_access_level")

    @property
    @pulumi.getter(name="resolveOutdatedDiffDiscussions")
    def resolve_outdated_diff_discussions(self) -> pulumi.Output[Optional[bool]]:
        """
        Automatically resolve merge request diffs discussions on lines changed with a push.
        """
        return pulumi.get(self, "resolve_outdated_diff_discussions")

    @property
    @pulumi.getter(name="restrictUserDefinedVariables")
    def restrict_user_defined_variables(self) -> pulumi.Output[Optional[bool]]:
        """
        Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        """
        return pulumi.get(self, "restrict_user_defined_variables")

    @property
    @pulumi.getter(name="runnersToken")
    def runners_token(self) -> pulumi.Output[str]:
        """
        Registration token to use during runner setup.
        """
        return pulumi.get(self, "runners_token")

    @property
    @pulumi.getter(name="securityAndComplianceAccessLevel")
    def security_and_compliance_access_level(self) -> pulumi.Output[str]:
        """
        Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "security_and_compliance_access_level")

    @property
    @pulumi.getter(name="sharedRunnersEnabled")
    def shared_runners_enabled(self) -> pulumi.Output[bool]:
        """
        Enable shared runners for this project.
        """
        return pulumi.get(self, "shared_runners_enabled")

    @property
    @pulumi.getter(name="skipWaitForDefaultBranchProtection")
    def skip_wait_for_default_branch_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        If `true`, the default behavior to wait for the default branch protection to be created is skipped.
        This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
        There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
        This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        """
        return pulumi.get(self, "skip_wait_for_default_branch_protection")

    @property
    @pulumi.getter(name="snippetsAccessLevel")
    def snippets_access_level(self) -> pulumi.Output[str]:
        """
        Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "snippets_access_level")

    @property
    @pulumi.getter(name="snippetsEnabled")
    def snippets_enabled(self) -> pulumi.Output[bool]:
        """
        Enable snippets for the project.
        """
        return pulumi.get(self, "snippets_enabled")

    @property
    @pulumi.getter(name="squashCommitTemplate")
    def squash_commit_template(self) -> pulumi.Output[Optional[str]]:
        """
        Template used to create squash commit message in merge requests. (Introduced in GitLab 14.6.)
        """
        return pulumi.get(self, "squash_commit_template")

    @property
    @pulumi.getter(name="squashOption")
    def squash_option(self) -> pulumi.Output[str]:
        """
        Squash commits when merge request. Valid values are `never`, `always`, `default_on`, or `default_off`. The default value is `default_off`. [GitLab >= 14.1]
        """
        return pulumi.get(self, "squash_option")

    @property
    @pulumi.getter(name="sshUrlToRepo")
    def ssh_url_to_repo(self) -> pulumi.Output[str]:
        """
        URL that can be provided to `git clone` to clone the
        """
        return pulumi.get(self, "ssh_url_to_repo")

    @property
    @pulumi.getter(name="suggestionCommitMessage")
    def suggestion_commit_message(self) -> pulumi.Output[Optional[str]]:
        """
        The commit message used to apply merge request suggestions.
        """
        return pulumi.get(self, "suggestion_commit_message")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[Optional[str]]:
        """
        When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        """
        return pulumi.get(self, "template_name")

    @property
    @pulumi.getter(name="templateProjectId")
    def template_project_id(self) -> pulumi.Output[Optional[int]]:
        """
        When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        """
        return pulumi.get(self, "template_project_id")

    @property
    @pulumi.getter
    def topics(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of topics for the project.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter(name="useCustomTemplate")
    def use_custom_template(self) -> pulumi.Output[Optional[bool]]:
        """
        Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
        	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting.html#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        """
        return pulumi.get(self, "use_custom_template")

    @property
    @pulumi.getter(name="visibilityLevel")
    def visibility_level(self) -> pulumi.Output[str]:
        """
        Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        """
        return pulumi.get(self, "visibility_level")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> pulumi.Output[str]:
        """
        URL that can be used to find the project in a browser.
        """
        return pulumi.get(self, "web_url")

    @property
    @pulumi.getter(name="wikiAccessLevel")
    def wiki_access_level(self) -> pulumi.Output[str]:
        """
        Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "wiki_access_level")

    @property
    @pulumi.getter(name="wikiEnabled")
    def wiki_enabled(self) -> pulumi.Output[bool]:
        """
        Enable wiki for the project.
        """
        return pulumi.get(self, "wiki_enabled")

