# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProjectApprovalRuleArgs', 'ProjectApprovalRule']

@pulumi.input_type
class ProjectApprovalRuleArgs:
    def __init__(__self__, *,
                 approvals_required: pulumi.Input[int],
                 project: pulumi.Input[str],
                 applies_to_all_protected_branches: Optional[pulumi.Input[bool]] = None,
                 disable_importing_default_any_approver_rule_on_create: Optional[pulumi.Input[bool]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protected_branch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 rule_type: Optional[pulumi.Input[str]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        The set of arguments for constructing a ProjectApprovalRule resource.
        :param pulumi.Input[int] approvals_required: The number of approvals required for this rule.
        :param pulumi.Input[str] project: The name or id of the project to add the approval rules.
        :param pulumi.Input[bool] applies_to_all_protected_branches: Whether the rule is applied to all protected branches. If set to 'true', the value of `protected_branch_ids` is ignored. Default is 'false'.
        :param pulumi.Input[bool] disable_importing_default_any_approver_rule_on_create: When this flag is set, the default `any_approver` rule will not be imported if present.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] group_ids: A list of group IDs whose members can approve of the merge request.
        :param pulumi.Input[str] name: The name of the approval rule.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] protected_branch_ids: A list of protected branch IDs (not branch names) for which the rule applies.
        :param pulumi.Input[str] rule_type: String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] user_ids: A list of specific User IDs to add to the list of approvers.
        """
        pulumi.set(__self__, "approvals_required", approvals_required)
        pulumi.set(__self__, "project", project)
        if applies_to_all_protected_branches is not None:
            pulumi.set(__self__, "applies_to_all_protected_branches", applies_to_all_protected_branches)
        if disable_importing_default_any_approver_rule_on_create is not None:
            pulumi.set(__self__, "disable_importing_default_any_approver_rule_on_create", disable_importing_default_any_approver_rule_on_create)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protected_branch_ids is not None:
            pulumi.set(__self__, "protected_branch_ids", protected_branch_ids)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="approvalsRequired")
    def approvals_required(self) -> pulumi.Input[int]:
        """
        The number of approvals required for this rule.
        """
        return pulumi.get(self, "approvals_required")

    @approvals_required.setter
    def approvals_required(self, value: pulumi.Input[int]):
        pulumi.set(self, "approvals_required", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The name or id of the project to add the approval rules.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="appliesToAllProtectedBranches")
    def applies_to_all_protected_branches(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the rule is applied to all protected branches. If set to 'true', the value of `protected_branch_ids` is ignored. Default is 'false'.
        """
        return pulumi.get(self, "applies_to_all_protected_branches")

    @applies_to_all_protected_branches.setter
    def applies_to_all_protected_branches(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "applies_to_all_protected_branches", value)

    @property
    @pulumi.getter(name="disableImportingDefaultAnyApproverRuleOnCreate")
    def disable_importing_default_any_approver_rule_on_create(self) -> Optional[pulumi.Input[bool]]:
        """
        When this flag is set, the default `any_approver` rule will not be imported if present.
        """
        return pulumi.get(self, "disable_importing_default_any_approver_rule_on_create")

    @disable_importing_default_any_approver_rule_on_create.setter
    def disable_importing_default_any_approver_rule_on_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_importing_default_any_approver_rule_on_create", value)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A list of group IDs whose members can approve of the merge request.
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "group_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the approval rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="protectedBranchIds")
    def protected_branch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A list of protected branch IDs (not branch names) for which the rule applies.
        """
        return pulumi.get(self, "protected_branch_ids")

    @protected_branch_ids.setter
    def protected_branch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "protected_branch_ids", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[pulumi.Input[str]]:
        """
        String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A list of specific User IDs to add to the list of approvers.
        """
        return pulumi.get(self, "user_ids")

    @user_ids.setter
    def user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "user_ids", value)


@pulumi.input_type
class _ProjectApprovalRuleState:
    def __init__(__self__, *,
                 applies_to_all_protected_branches: Optional[pulumi.Input[bool]] = None,
                 approvals_required: Optional[pulumi.Input[int]] = None,
                 disable_importing_default_any_approver_rule_on_create: Optional[pulumi.Input[bool]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protected_branch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 rule_type: Optional[pulumi.Input[str]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Input properties used for looking up and filtering ProjectApprovalRule resources.
        :param pulumi.Input[bool] applies_to_all_protected_branches: Whether the rule is applied to all protected branches. If set to 'true', the value of `protected_branch_ids` is ignored. Default is 'false'.
        :param pulumi.Input[int] approvals_required: The number of approvals required for this rule.
        :param pulumi.Input[bool] disable_importing_default_any_approver_rule_on_create: When this flag is set, the default `any_approver` rule will not be imported if present.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] group_ids: A list of group IDs whose members can approve of the merge request.
        :param pulumi.Input[str] name: The name of the approval rule.
        :param pulumi.Input[str] project: The name or id of the project to add the approval rules.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] protected_branch_ids: A list of protected branch IDs (not branch names) for which the rule applies.
        :param pulumi.Input[str] rule_type: String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] user_ids: A list of specific User IDs to add to the list of approvers.
        """
        if applies_to_all_protected_branches is not None:
            pulumi.set(__self__, "applies_to_all_protected_branches", applies_to_all_protected_branches)
        if approvals_required is not None:
            pulumi.set(__self__, "approvals_required", approvals_required)
        if disable_importing_default_any_approver_rule_on_create is not None:
            pulumi.set(__self__, "disable_importing_default_any_approver_rule_on_create", disable_importing_default_any_approver_rule_on_create)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protected_branch_ids is not None:
            pulumi.set(__self__, "protected_branch_ids", protected_branch_ids)
        if rule_type is not None:
            pulumi.set(__self__, "rule_type", rule_type)
        if user_ids is not None:
            pulumi.set(__self__, "user_ids", user_ids)

    @property
    @pulumi.getter(name="appliesToAllProtectedBranches")
    def applies_to_all_protected_branches(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the rule is applied to all protected branches. If set to 'true', the value of `protected_branch_ids` is ignored. Default is 'false'.
        """
        return pulumi.get(self, "applies_to_all_protected_branches")

    @applies_to_all_protected_branches.setter
    def applies_to_all_protected_branches(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "applies_to_all_protected_branches", value)

    @property
    @pulumi.getter(name="approvalsRequired")
    def approvals_required(self) -> Optional[pulumi.Input[int]]:
        """
        The number of approvals required for this rule.
        """
        return pulumi.get(self, "approvals_required")

    @approvals_required.setter
    def approvals_required(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "approvals_required", value)

    @property
    @pulumi.getter(name="disableImportingDefaultAnyApproverRuleOnCreate")
    def disable_importing_default_any_approver_rule_on_create(self) -> Optional[pulumi.Input[bool]]:
        """
        When this flag is set, the default `any_approver` rule will not be imported if present.
        """
        return pulumi.get(self, "disable_importing_default_any_approver_rule_on_create")

    @disable_importing_default_any_approver_rule_on_create.setter
    def disable_importing_default_any_approver_rule_on_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_importing_default_any_approver_rule_on_create", value)

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A list of group IDs whose members can approve of the merge request.
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "group_ids", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the approval rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The name or id of the project to add the approval rules.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="protectedBranchIds")
    def protected_branch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A list of protected branch IDs (not branch names) for which the rule applies.
        """
        return pulumi.get(self, "protected_branch_ids")

    @protected_branch_ids.setter
    def protected_branch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "protected_branch_ids", value)

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> Optional[pulumi.Input[str]]:
        """
        String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`.
        """
        return pulumi.get(self, "rule_type")

    @rule_type.setter
    def rule_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_type", value)

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        A list of specific User IDs to add to the list of approvers.
        """
        return pulumi.get(self, "user_ids")

    @user_ids.setter
    def user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "user_ids", value)


class ProjectApprovalRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applies_to_all_protected_branches: Optional[pulumi.Input[bool]] = None,
                 approvals_required: Optional[pulumi.Input[int]] = None,
                 disable_importing_default_any_approver_rule_on_create: Optional[pulumi.Input[bool]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protected_branch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 rule_type: Optional[pulumi.Input[str]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        """
        ## Import

        GitLab project approval rules can be imported using a key composed of `<project-id>:<rule-id>`, e.g.

        ```sh
         $ pulumi import gitlab:index/projectApprovalRule:ProjectApprovalRule example "12345:6"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] applies_to_all_protected_branches: Whether the rule is applied to all protected branches. If set to 'true', the value of `protected_branch_ids` is ignored. Default is 'false'.
        :param pulumi.Input[int] approvals_required: The number of approvals required for this rule.
        :param pulumi.Input[bool] disable_importing_default_any_approver_rule_on_create: When this flag is set, the default `any_approver` rule will not be imported if present.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] group_ids: A list of group IDs whose members can approve of the merge request.
        :param pulumi.Input[str] name: The name of the approval rule.
        :param pulumi.Input[str] project: The name or id of the project to add the approval rules.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] protected_branch_ids: A list of protected branch IDs (not branch names) for which the rule applies.
        :param pulumi.Input[str] rule_type: String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] user_ids: A list of specific User IDs to add to the list of approvers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectApprovalRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        GitLab project approval rules can be imported using a key composed of `<project-id>:<rule-id>`, e.g.

        ```sh
         $ pulumi import gitlab:index/projectApprovalRule:ProjectApprovalRule example "12345:6"
        ```

        :param str resource_name: The name of the resource.
        :param ProjectApprovalRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectApprovalRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applies_to_all_protected_branches: Optional[pulumi.Input[bool]] = None,
                 approvals_required: Optional[pulumi.Input[int]] = None,
                 disable_importing_default_any_approver_rule_on_create: Optional[pulumi.Input[bool]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protected_branch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 rule_type: Optional[pulumi.Input[str]] = None,
                 user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectApprovalRuleArgs.__new__(ProjectApprovalRuleArgs)

            __props__.__dict__["applies_to_all_protected_branches"] = applies_to_all_protected_branches
            if approvals_required is None and not opts.urn:
                raise TypeError("Missing required property 'approvals_required'")
            __props__.__dict__["approvals_required"] = approvals_required
            __props__.__dict__["disable_importing_default_any_approver_rule_on_create"] = disable_importing_default_any_approver_rule_on_create
            __props__.__dict__["group_ids"] = group_ids
            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["protected_branch_ids"] = protected_branch_ids
            __props__.__dict__["rule_type"] = rule_type
            __props__.__dict__["user_ids"] = user_ids
        super(ProjectApprovalRule, __self__).__init__(
            'gitlab:index/projectApprovalRule:ProjectApprovalRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            applies_to_all_protected_branches: Optional[pulumi.Input[bool]] = None,
            approvals_required: Optional[pulumi.Input[int]] = None,
            disable_importing_default_any_approver_rule_on_create: Optional[pulumi.Input[bool]] = None,
            group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            protected_branch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            rule_type: Optional[pulumi.Input[str]] = None,
            user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None) -> 'ProjectApprovalRule':
        """
        Get an existing ProjectApprovalRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] applies_to_all_protected_branches: Whether the rule is applied to all protected branches. If set to 'true', the value of `protected_branch_ids` is ignored. Default is 'false'.
        :param pulumi.Input[int] approvals_required: The number of approvals required for this rule.
        :param pulumi.Input[bool] disable_importing_default_any_approver_rule_on_create: When this flag is set, the default `any_approver` rule will not be imported if present.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] group_ids: A list of group IDs whose members can approve of the merge request.
        :param pulumi.Input[str] name: The name of the approval rule.
        :param pulumi.Input[str] project: The name or id of the project to add the approval rules.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] protected_branch_ids: A list of protected branch IDs (not branch names) for which the rule applies.
        :param pulumi.Input[str] rule_type: String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] user_ids: A list of specific User IDs to add to the list of approvers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectApprovalRuleState.__new__(_ProjectApprovalRuleState)

        __props__.__dict__["applies_to_all_protected_branches"] = applies_to_all_protected_branches
        __props__.__dict__["approvals_required"] = approvals_required
        __props__.__dict__["disable_importing_default_any_approver_rule_on_create"] = disable_importing_default_any_approver_rule_on_create
        __props__.__dict__["group_ids"] = group_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["protected_branch_ids"] = protected_branch_ids
        __props__.__dict__["rule_type"] = rule_type
        __props__.__dict__["user_ids"] = user_ids
        return ProjectApprovalRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appliesToAllProtectedBranches")
    def applies_to_all_protected_branches(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the rule is applied to all protected branches. If set to 'true', the value of `protected_branch_ids` is ignored. Default is 'false'.
        """
        return pulumi.get(self, "applies_to_all_protected_branches")

    @property
    @pulumi.getter(name="approvalsRequired")
    def approvals_required(self) -> pulumi.Output[int]:
        """
        The number of approvals required for this rule.
        """
        return pulumi.get(self, "approvals_required")

    @property
    @pulumi.getter(name="disableImportingDefaultAnyApproverRuleOnCreate")
    def disable_importing_default_any_approver_rule_on_create(self) -> pulumi.Output[Optional[bool]]:
        """
        When this flag is set, the default `any_approver` rule will not be imported if present.
        """
        return pulumi.get(self, "disable_importing_default_any_approver_rule_on_create")

    @property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        A list of group IDs whose members can approve of the merge request.
        """
        return pulumi.get(self, "group_ids")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the approval rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The name or id of the project to add the approval rules.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="protectedBranchIds")
    def protected_branch_ids(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        A list of protected branch IDs (not branch names) for which the rule applies.
        """
        return pulumi.get(self, "protected_branch_ids")

    @property
    @pulumi.getter(name="ruleType")
    def rule_type(self) -> pulumi.Output[str]:
        """
        String, defaults to 'regular'. The type of rule. `any_approver` is a pre-configured default rule with `approvals_required` at `0`. Valid values are `regular`, `any_approver`.
        """
        return pulumi.get(self, "rule_type")

    @property
    @pulumi.getter(name="userIds")
    def user_ids(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        A list of specific User IDs to add to the list of approvers.
        """
        return pulumi.get(self, "user_ids")

