# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectIssueArgs', 'ProjectIssue']

@pulumi.input_type
class ProjectIssueArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 title: pulumi.Input[str],
                 assignee_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 confidential: Optional[pulumi.Input[bool]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 delete_on_destroy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 discussion_locked: Optional[pulumi.Input[bool]] = None,
                 discussion_to_resolve: Optional[pulumi.Input[str]] = None,
                 due_date: Optional[pulumi.Input[str]] = None,
                 epic_issue_id: Optional[pulumi.Input[int]] = None,
                 iid: Optional[pulumi.Input[int]] = None,
                 issue_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 merge_request_to_resolve_discussions_of: Optional[pulumi.Input[int]] = None,
                 milestone_id: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a ProjectIssue resource.
        :param pulumi.Input[str] project: The name or ID of the project.
        :param pulumi.Input[str] title: The title of the issue.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] assignee_ids: The IDs of the users to assign the issue to.
        :param pulumi.Input[bool] confidential: Set an issue to be confidential.
        :param pulumi.Input[str] created_at: When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
        :param pulumi.Input[bool] delete_on_destroy: Whether the issue is deleted instead of closed during destroy.
        :param pulumi.Input[str] description: The description of an issue. Limited to 1,048,576 characters.
        :param pulumi.Input[bool] discussion_locked: Whether the issue is locked for discussions or not.
        :param pulumi.Input[str] discussion_to_resolve: The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
        :param pulumi.Input[str] due_date: The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
        :param pulumi.Input[int] epic_issue_id: The ID of the epic issue.
        :param pulumi.Input[int] iid: The internal ID of the project's issue.
        :param pulumi.Input[str] issue_type: The type of issue. Valid values are: `issue`, `incident`, `test_case`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The labels of an issue.
        :param pulumi.Input[int] merge_request_to_resolve_discussions_of: The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
        :param pulumi.Input[int] milestone_id: The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
        :param pulumi.Input[str] state: The state of the issue. Valid values are: `opened`, `closed`.
        :param pulumi.Input[str] updated_at: When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
        :param pulumi.Input[int] weight: The weight of the issue. Valid values are greater than or equal to 0.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "title", title)
        if assignee_ids is not None:
            pulumi.set(__self__, "assignee_ids", assignee_ids)
        if confidential is not None:
            pulumi.set(__self__, "confidential", confidential)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if delete_on_destroy is not None:
            pulumi.set(__self__, "delete_on_destroy", delete_on_destroy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discussion_locked is not None:
            pulumi.set(__self__, "discussion_locked", discussion_locked)
        if discussion_to_resolve is not None:
            pulumi.set(__self__, "discussion_to_resolve", discussion_to_resolve)
        if due_date is not None:
            pulumi.set(__self__, "due_date", due_date)
        if epic_issue_id is not None:
            pulumi.set(__self__, "epic_issue_id", epic_issue_id)
        if iid is not None:
            pulumi.set(__self__, "iid", iid)
        if issue_type is not None:
            pulumi.set(__self__, "issue_type", issue_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if merge_request_to_resolve_discussions_of is not None:
            pulumi.set(__self__, "merge_request_to_resolve_discussions_of", merge_request_to_resolve_discussions_of)
        if milestone_id is not None:
            pulumi.set(__self__, "milestone_id", milestone_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The name or ID of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        The title of the issue.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="assigneeIds")
    def assignee_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The IDs of the users to assign the issue to.
        """
        return pulumi.get(self, "assignee_ids")

    @assignee_ids.setter
    def assignee_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "assignee_ids", value)

    @property
    @pulumi.getter
    def confidential(self) -> Optional[pulumi.Input[bool]]:
        """
        Set an issue to be confidential.
        """
        return pulumi.get(self, "confidential")

    @confidential.setter
    def confidential(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confidential", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deleteOnDestroy")
    def delete_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the issue is deleted instead of closed during destroy.
        """
        return pulumi.get(self, "delete_on_destroy")

    @delete_on_destroy.setter
    def delete_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_on_destroy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of an issue. Limited to 1,048,576 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="discussionLocked")
    def discussion_locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the issue is locked for discussions or not.
        """
        return pulumi.get(self, "discussion_locked")

    @discussion_locked.setter
    def discussion_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "discussion_locked", value)

    @property
    @pulumi.getter(name="discussionToResolve")
    def discussion_to_resolve(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
        """
        return pulumi.get(self, "discussion_to_resolve")

    @discussion_to_resolve.setter
    def discussion_to_resolve(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discussion_to_resolve", value)

    @property
    @pulumi.getter(name="dueDate")
    def due_date(self) -> Optional[pulumi.Input[str]]:
        """
        The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
        """
        return pulumi.get(self, "due_date")

    @due_date.setter
    def due_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "due_date", value)

    @property
    @pulumi.getter(name="epicIssueId")
    def epic_issue_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the epic issue.
        """
        return pulumi.get(self, "epic_issue_id")

    @epic_issue_id.setter
    def epic_issue_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "epic_issue_id", value)

    @property
    @pulumi.getter
    def iid(self) -> Optional[pulumi.Input[int]]:
        """
        The internal ID of the project's issue.
        """
        return pulumi.get(self, "iid")

    @iid.setter
    def iid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iid", value)

    @property
    @pulumi.getter(name="issueType")
    def issue_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of issue. Valid values are: `issue`, `incident`, `test_case`.
        """
        return pulumi.get(self, "issue_type")

    @issue_type.setter
    def issue_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issue_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The labels of an issue.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="mergeRequestToResolveDiscussionsOf")
    def merge_request_to_resolve_discussions_of(self) -> Optional[pulumi.Input[int]]:
        """
        The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
        """
        return pulumi.get(self, "merge_request_to_resolve_discussions_of")

    @merge_request_to_resolve_discussions_of.setter
    def merge_request_to_resolve_discussions_of(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "merge_request_to_resolve_discussions_of", value)

    @property
    @pulumi.getter(name="milestoneId")
    def milestone_id(self) -> Optional[pulumi.Input[int]]:
        """
        The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
        """
        return pulumi.get(self, "milestone_id")

    @milestone_id.setter
    def milestone_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "milestone_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the issue. Valid values are: `opened`, `closed`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The weight of the issue. Valid values are greater than or equal to 0.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class _ProjectIssueState:
    def __init__(__self__, *,
                 assignee_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 author_id: Optional[pulumi.Input[int]] = None,
                 closed_at: Optional[pulumi.Input[str]] = None,
                 closed_by_user_id: Optional[pulumi.Input[int]] = None,
                 confidential: Optional[pulumi.Input[bool]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 delete_on_destroy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 discussion_locked: Optional[pulumi.Input[bool]] = None,
                 discussion_to_resolve: Optional[pulumi.Input[str]] = None,
                 downvotes: Optional[pulumi.Input[int]] = None,
                 due_date: Optional[pulumi.Input[str]] = None,
                 epic_id: Optional[pulumi.Input[int]] = None,
                 epic_issue_id: Optional[pulumi.Input[int]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 human_time_estimate: Optional[pulumi.Input[str]] = None,
                 human_total_time_spent: Optional[pulumi.Input[str]] = None,
                 iid: Optional[pulumi.Input[int]] = None,
                 issue_id: Optional[pulumi.Input[int]] = None,
                 issue_link_id: Optional[pulumi.Input[int]] = None,
                 issue_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 links: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 merge_request_to_resolve_discussions_of: Optional[pulumi.Input[int]] = None,
                 merge_requests_count: Optional[pulumi.Input[int]] = None,
                 milestone_id: Optional[pulumi.Input[int]] = None,
                 moved_to_id: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 references: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subscribed: Optional[pulumi.Input[bool]] = None,
                 task_completion_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectIssueTaskCompletionStatusArgs']]]] = None,
                 time_estimate: Optional[pulumi.Input[int]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 total_time_spent: Optional[pulumi.Input[int]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 upvotes: Optional[pulumi.Input[int]] = None,
                 user_notes_count: Optional[pulumi.Input[int]] = None,
                 web_url: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ProjectIssue resources.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] assignee_ids: The IDs of the users to assign the issue to.
        :param pulumi.Input[int] author_id: The ID of the author of the issue. Use `User` data source to get more information about the user.
        :param pulumi.Input[str] closed_at: When the issue was closed. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
        :param pulumi.Input[int] closed_by_user_id: The ID of the user that closed the issue. Use `User` data source to get more information about the user.
        :param pulumi.Input[bool] confidential: Set an issue to be confidential.
        :param pulumi.Input[str] created_at: When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
        :param pulumi.Input[bool] delete_on_destroy: Whether the issue is deleted instead of closed during destroy.
        :param pulumi.Input[str] description: The description of an issue. Limited to 1,048,576 characters.
        :param pulumi.Input[bool] discussion_locked: Whether the issue is locked for discussions or not.
        :param pulumi.Input[str] discussion_to_resolve: The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
        :param pulumi.Input[int] downvotes: The number of downvotes the issue has received.
        :param pulumi.Input[str] due_date: The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
        :param pulumi.Input[int] epic_id: ID of the epic to add the issue to. Valid values are greater than or equal to 0.
        :param pulumi.Input[int] epic_issue_id: The ID of the epic issue.
        :param pulumi.Input[str] external_id: The external ID of the issue.
        :param pulumi.Input[str] human_time_estimate: The human-readable time estimate of the issue.
        :param pulumi.Input[str] human_total_time_spent: The human-readable total time spent of the issue.
        :param pulumi.Input[int] iid: The internal ID of the project's issue.
        :param pulumi.Input[int] issue_id: The instance-wide ID of the issue.
        :param pulumi.Input[int] issue_link_id: The ID of the issue link.
        :param pulumi.Input[str] issue_type: The type of issue. Valid values are: `issue`, `incident`, `test_case`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The labels of an issue.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] links: The links of the issue.
        :param pulumi.Input[int] merge_request_to_resolve_discussions_of: The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
        :param pulumi.Input[int] merge_requests_count: The number of merge requests associated with the issue.
        :param pulumi.Input[int] milestone_id: The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
        :param pulumi.Input[int] moved_to_id: The ID of the issue that was moved to.
        :param pulumi.Input[str] project: The name or ID of the project.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] references: The references of the issue.
        :param pulumi.Input[str] state: The state of the issue. Valid values are: `opened`, `closed`.
        :param pulumi.Input[bool] subscribed: Whether the authenticated user is subscribed to the issue or not.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectIssueTaskCompletionStatusArgs']]] task_completion_statuses: The task completion status. It's always a one element list.
        :param pulumi.Input[int] time_estimate: The time estimate of the issue.
        :param pulumi.Input[str] title: The title of the issue.
        :param pulumi.Input[int] total_time_spent: The total time spent of the issue.
        :param pulumi.Input[str] updated_at: When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
        :param pulumi.Input[int] upvotes: The number of upvotes the issue has received.
        :param pulumi.Input[int] user_notes_count: The number of user notes on the issue.
        :param pulumi.Input[str] web_url: The web URL of the issue.
        :param pulumi.Input[int] weight: The weight of the issue. Valid values are greater than or equal to 0.
        """
        if assignee_ids is not None:
            pulumi.set(__self__, "assignee_ids", assignee_ids)
        if author_id is not None:
            pulumi.set(__self__, "author_id", author_id)
        if closed_at is not None:
            pulumi.set(__self__, "closed_at", closed_at)
        if closed_by_user_id is not None:
            pulumi.set(__self__, "closed_by_user_id", closed_by_user_id)
        if confidential is not None:
            pulumi.set(__self__, "confidential", confidential)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if delete_on_destroy is not None:
            pulumi.set(__self__, "delete_on_destroy", delete_on_destroy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discussion_locked is not None:
            pulumi.set(__self__, "discussion_locked", discussion_locked)
        if discussion_to_resolve is not None:
            pulumi.set(__self__, "discussion_to_resolve", discussion_to_resolve)
        if downvotes is not None:
            pulumi.set(__self__, "downvotes", downvotes)
        if due_date is not None:
            pulumi.set(__self__, "due_date", due_date)
        if epic_id is not None:
            pulumi.set(__self__, "epic_id", epic_id)
        if epic_issue_id is not None:
            pulumi.set(__self__, "epic_issue_id", epic_issue_id)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if human_time_estimate is not None:
            pulumi.set(__self__, "human_time_estimate", human_time_estimate)
        if human_total_time_spent is not None:
            pulumi.set(__self__, "human_total_time_spent", human_total_time_spent)
        if iid is not None:
            pulumi.set(__self__, "iid", iid)
        if issue_id is not None:
            pulumi.set(__self__, "issue_id", issue_id)
        if issue_link_id is not None:
            pulumi.set(__self__, "issue_link_id", issue_link_id)
        if issue_type is not None:
            pulumi.set(__self__, "issue_type", issue_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if links is not None:
            pulumi.set(__self__, "links", links)
        if merge_request_to_resolve_discussions_of is not None:
            pulumi.set(__self__, "merge_request_to_resolve_discussions_of", merge_request_to_resolve_discussions_of)
        if merge_requests_count is not None:
            pulumi.set(__self__, "merge_requests_count", merge_requests_count)
        if milestone_id is not None:
            pulumi.set(__self__, "milestone_id", milestone_id)
        if moved_to_id is not None:
            pulumi.set(__self__, "moved_to_id", moved_to_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if references is not None:
            pulumi.set(__self__, "references", references)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscribed is not None:
            pulumi.set(__self__, "subscribed", subscribed)
        if task_completion_statuses is not None:
            pulumi.set(__self__, "task_completion_statuses", task_completion_statuses)
        if time_estimate is not None:
            pulumi.set(__self__, "time_estimate", time_estimate)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if total_time_spent is not None:
            pulumi.set(__self__, "total_time_spent", total_time_spent)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if upvotes is not None:
            pulumi.set(__self__, "upvotes", upvotes)
        if user_notes_count is not None:
            pulumi.set(__self__, "user_notes_count", user_notes_count)
        if web_url is not None:
            pulumi.set(__self__, "web_url", web_url)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="assigneeIds")
    def assignee_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The IDs of the users to assign the issue to.
        """
        return pulumi.get(self, "assignee_ids")

    @assignee_ids.setter
    def assignee_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "assignee_ids", value)

    @property
    @pulumi.getter(name="authorId")
    def author_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the author of the issue. Use `User` data source to get more information about the user.
        """
        return pulumi.get(self, "author_id")

    @author_id.setter
    def author_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "author_id", value)

    @property
    @pulumi.getter(name="closedAt")
    def closed_at(self) -> Optional[pulumi.Input[str]]:
        """
        When the issue was closed. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
        """
        return pulumi.get(self, "closed_at")

    @closed_at.setter
    def closed_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "closed_at", value)

    @property
    @pulumi.getter(name="closedByUserId")
    def closed_by_user_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the user that closed the issue. Use `User` data source to get more information about the user.
        """
        return pulumi.get(self, "closed_by_user_id")

    @closed_by_user_id.setter
    def closed_by_user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "closed_by_user_id", value)

    @property
    @pulumi.getter
    def confidential(self) -> Optional[pulumi.Input[bool]]:
        """
        Set an issue to be confidential.
        """
        return pulumi.get(self, "confidential")

    @confidential.setter
    def confidential(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confidential", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deleteOnDestroy")
    def delete_on_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the issue is deleted instead of closed during destroy.
        """
        return pulumi.get(self, "delete_on_destroy")

    @delete_on_destroy.setter
    def delete_on_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_on_destroy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of an issue. Limited to 1,048,576 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="discussionLocked")
    def discussion_locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the issue is locked for discussions or not.
        """
        return pulumi.get(self, "discussion_locked")

    @discussion_locked.setter
    def discussion_locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "discussion_locked", value)

    @property
    @pulumi.getter(name="discussionToResolve")
    def discussion_to_resolve(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
        """
        return pulumi.get(self, "discussion_to_resolve")

    @discussion_to_resolve.setter
    def discussion_to_resolve(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "discussion_to_resolve", value)

    @property
    @pulumi.getter
    def downvotes(self) -> Optional[pulumi.Input[int]]:
        """
        The number of downvotes the issue has received.
        """
        return pulumi.get(self, "downvotes")

    @downvotes.setter
    def downvotes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "downvotes", value)

    @property
    @pulumi.getter(name="dueDate")
    def due_date(self) -> Optional[pulumi.Input[str]]:
        """
        The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
        """
        return pulumi.get(self, "due_date")

    @due_date.setter
    def due_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "due_date", value)

    @property
    @pulumi.getter(name="epicId")
    def epic_id(self) -> Optional[pulumi.Input[int]]:
        """
        ID of the epic to add the issue to. Valid values are greater than or equal to 0.
        """
        return pulumi.get(self, "epic_id")

    @epic_id.setter
    def epic_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "epic_id", value)

    @property
    @pulumi.getter(name="epicIssueId")
    def epic_issue_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the epic issue.
        """
        return pulumi.get(self, "epic_issue_id")

    @epic_issue_id.setter
    def epic_issue_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "epic_issue_id", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        The external ID of the issue.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="humanTimeEstimate")
    def human_time_estimate(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable time estimate of the issue.
        """
        return pulumi.get(self, "human_time_estimate")

    @human_time_estimate.setter
    def human_time_estimate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "human_time_estimate", value)

    @property
    @pulumi.getter(name="humanTotalTimeSpent")
    def human_total_time_spent(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable total time spent of the issue.
        """
        return pulumi.get(self, "human_total_time_spent")

    @human_total_time_spent.setter
    def human_total_time_spent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "human_total_time_spent", value)

    @property
    @pulumi.getter
    def iid(self) -> Optional[pulumi.Input[int]]:
        """
        The internal ID of the project's issue.
        """
        return pulumi.get(self, "iid")

    @iid.setter
    def iid(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "iid", value)

    @property
    @pulumi.getter(name="issueId")
    def issue_id(self) -> Optional[pulumi.Input[int]]:
        """
        The instance-wide ID of the issue.
        """
        return pulumi.get(self, "issue_id")

    @issue_id.setter
    def issue_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "issue_id", value)

    @property
    @pulumi.getter(name="issueLinkId")
    def issue_link_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the issue link.
        """
        return pulumi.get(self, "issue_link_id")

    @issue_link_id.setter
    def issue_link_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "issue_link_id", value)

    @property
    @pulumi.getter(name="issueType")
    def issue_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of issue. Valid values are: `issue`, `incident`, `test_case`.
        """
        return pulumi.get(self, "issue_type")

    @issue_type.setter
    def issue_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issue_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The labels of an issue.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def links(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The links of the issue.
        """
        return pulumi.get(self, "links")

    @links.setter
    def links(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "links", value)

    @property
    @pulumi.getter(name="mergeRequestToResolveDiscussionsOf")
    def merge_request_to_resolve_discussions_of(self) -> Optional[pulumi.Input[int]]:
        """
        The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
        """
        return pulumi.get(self, "merge_request_to_resolve_discussions_of")

    @merge_request_to_resolve_discussions_of.setter
    def merge_request_to_resolve_discussions_of(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "merge_request_to_resolve_discussions_of", value)

    @property
    @pulumi.getter(name="mergeRequestsCount")
    def merge_requests_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of merge requests associated with the issue.
        """
        return pulumi.get(self, "merge_requests_count")

    @merge_requests_count.setter
    def merge_requests_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "merge_requests_count", value)

    @property
    @pulumi.getter(name="milestoneId")
    def milestone_id(self) -> Optional[pulumi.Input[int]]:
        """
        The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
        """
        return pulumi.get(self, "milestone_id")

    @milestone_id.setter
    def milestone_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "milestone_id", value)

    @property
    @pulumi.getter(name="movedToId")
    def moved_to_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the issue that was moved to.
        """
        return pulumi.get(self, "moved_to_id")

    @moved_to_id.setter
    def moved_to_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "moved_to_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The name or ID of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def references(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The references of the issue.
        """
        return pulumi.get(self, "references")

    @references.setter
    def references(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "references", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the issue. Valid values are: `opened`, `closed`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def subscribed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the authenticated user is subscribed to the issue or not.
        """
        return pulumi.get(self, "subscribed")

    @subscribed.setter
    def subscribed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "subscribed", value)

    @property
    @pulumi.getter(name="taskCompletionStatuses")
    def task_completion_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectIssueTaskCompletionStatusArgs']]]]:
        """
        The task completion status. It's always a one element list.
        """
        return pulumi.get(self, "task_completion_statuses")

    @task_completion_statuses.setter
    def task_completion_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectIssueTaskCompletionStatusArgs']]]]):
        pulumi.set(self, "task_completion_statuses", value)

    @property
    @pulumi.getter(name="timeEstimate")
    def time_estimate(self) -> Optional[pulumi.Input[int]]:
        """
        The time estimate of the issue.
        """
        return pulumi.get(self, "time_estimate")

    @time_estimate.setter
    def time_estimate(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_estimate", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The title of the issue.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="totalTimeSpent")
    def total_time_spent(self) -> Optional[pulumi.Input[int]]:
        """
        The total time spent of the issue.
        """
        return pulumi.get(self, "total_time_spent")

    @total_time_spent.setter
    def total_time_spent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_time_spent", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def upvotes(self) -> Optional[pulumi.Input[int]]:
        """
        The number of upvotes the issue has received.
        """
        return pulumi.get(self, "upvotes")

    @upvotes.setter
    def upvotes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "upvotes", value)

    @property
    @pulumi.getter(name="userNotesCount")
    def user_notes_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of user notes on the issue.
        """
        return pulumi.get(self, "user_notes_count")

    @user_notes_count.setter
    def user_notes_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_notes_count", value)

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> Optional[pulumi.Input[str]]:
        """
        The web URL of the issue.
        """
        return pulumi.get(self, "web_url")

    @web_url.setter
    def web_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_url", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The weight of the issue. Valid values are greater than or equal to 0.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


class ProjectIssue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignee_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 confidential: Optional[pulumi.Input[bool]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 delete_on_destroy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 discussion_locked: Optional[pulumi.Input[bool]] = None,
                 discussion_to_resolve: Optional[pulumi.Input[str]] = None,
                 due_date: Optional[pulumi.Input[str]] = None,
                 epic_issue_id: Optional[pulumi.Input[int]] = None,
                 iid: Optional[pulumi.Input[int]] = None,
                 issue_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 merge_request_to_resolve_discussions_of: Optional[pulumi.Input[int]] = None,
                 milestone_id: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        foo = gitlab.Project("foo",
            description="Lorem Ipsum",
            visibility_level="public")
        welcome_issue = gitlab.ProjectIssue("welcomeIssue",
            project=foo.id,
            title="Welcome!",
            description=foo.name.apply(lambda name: f\"\"\"  Welcome to the {name} project!

        \"\"\"),
            discussion_locked=True)
        pulumi.export("welcomeIssueWebUrl", data["gitlab_project_issue"]["web_url"])
        ```

        ## Import

        You can import this resource with an id made up of `{project-id}:{issue-id}`, e.g.

        ```sh
         $ pulumi import gitlab:index/projectIssue:ProjectIssue welcome_issue 42:1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] assignee_ids: The IDs of the users to assign the issue to.
        :param pulumi.Input[bool] confidential: Set an issue to be confidential.
        :param pulumi.Input[str] created_at: When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
        :param pulumi.Input[bool] delete_on_destroy: Whether the issue is deleted instead of closed during destroy.
        :param pulumi.Input[str] description: The description of an issue. Limited to 1,048,576 characters.
        :param pulumi.Input[bool] discussion_locked: Whether the issue is locked for discussions or not.
        :param pulumi.Input[str] discussion_to_resolve: The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
        :param pulumi.Input[str] due_date: The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
        :param pulumi.Input[int] epic_issue_id: The ID of the epic issue.
        :param pulumi.Input[int] iid: The internal ID of the project's issue.
        :param pulumi.Input[str] issue_type: The type of issue. Valid values are: `issue`, `incident`, `test_case`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The labels of an issue.
        :param pulumi.Input[int] merge_request_to_resolve_discussions_of: The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
        :param pulumi.Input[int] milestone_id: The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
        :param pulumi.Input[str] project: The name or ID of the project.
        :param pulumi.Input[str] state: The state of the issue. Valid values are: `opened`, `closed`.
        :param pulumi.Input[str] title: The title of the issue.
        :param pulumi.Input[str] updated_at: When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
        :param pulumi.Input[int] weight: The weight of the issue. Valid values are greater than or equal to 0.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectIssueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        foo = gitlab.Project("foo",
            description="Lorem Ipsum",
            visibility_level="public")
        welcome_issue = gitlab.ProjectIssue("welcomeIssue",
            project=foo.id,
            title="Welcome!",
            description=foo.name.apply(lambda name: f\"\"\"  Welcome to the {name} project!

        \"\"\"),
            discussion_locked=True)
        pulumi.export("welcomeIssueWebUrl", data["gitlab_project_issue"]["web_url"])
        ```

        ## Import

        You can import this resource with an id made up of `{project-id}:{issue-id}`, e.g.

        ```sh
         $ pulumi import gitlab:index/projectIssue:ProjectIssue welcome_issue 42:1
        ```

        :param str resource_name: The name of the resource.
        :param ProjectIssueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectIssueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assignee_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 confidential: Optional[pulumi.Input[bool]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 delete_on_destroy: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 discussion_locked: Optional[pulumi.Input[bool]] = None,
                 discussion_to_resolve: Optional[pulumi.Input[str]] = None,
                 due_date: Optional[pulumi.Input[str]] = None,
                 epic_issue_id: Optional[pulumi.Input[int]] = None,
                 iid: Optional[pulumi.Input[int]] = None,
                 issue_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 merge_request_to_resolve_discussions_of: Optional[pulumi.Input[int]] = None,
                 milestone_id: Optional[pulumi.Input[int]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectIssueArgs.__new__(ProjectIssueArgs)

            __props__.__dict__["assignee_ids"] = assignee_ids
            __props__.__dict__["confidential"] = confidential
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["delete_on_destroy"] = delete_on_destroy
            __props__.__dict__["description"] = description
            __props__.__dict__["discussion_locked"] = discussion_locked
            __props__.__dict__["discussion_to_resolve"] = discussion_to_resolve
            __props__.__dict__["due_date"] = due_date
            __props__.__dict__["epic_issue_id"] = epic_issue_id
            __props__.__dict__["iid"] = iid
            __props__.__dict__["issue_type"] = issue_type
            __props__.__dict__["labels"] = labels
            __props__.__dict__["merge_request_to_resolve_discussions_of"] = merge_request_to_resolve_discussions_of
            __props__.__dict__["milestone_id"] = milestone_id
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["state"] = state
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["updated_at"] = updated_at
            __props__.__dict__["weight"] = weight
            __props__.__dict__["author_id"] = None
            __props__.__dict__["closed_at"] = None
            __props__.__dict__["closed_by_user_id"] = None
            __props__.__dict__["downvotes"] = None
            __props__.__dict__["epic_id"] = None
            __props__.__dict__["external_id"] = None
            __props__.__dict__["human_time_estimate"] = None
            __props__.__dict__["human_total_time_spent"] = None
            __props__.__dict__["issue_id"] = None
            __props__.__dict__["issue_link_id"] = None
            __props__.__dict__["links"] = None
            __props__.__dict__["merge_requests_count"] = None
            __props__.__dict__["moved_to_id"] = None
            __props__.__dict__["references"] = None
            __props__.__dict__["subscribed"] = None
            __props__.__dict__["task_completion_statuses"] = None
            __props__.__dict__["time_estimate"] = None
            __props__.__dict__["total_time_spent"] = None
            __props__.__dict__["upvotes"] = None
            __props__.__dict__["user_notes_count"] = None
            __props__.__dict__["web_url"] = None
        super(ProjectIssue, __self__).__init__(
            'gitlab:index/projectIssue:ProjectIssue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assignee_ids: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            author_id: Optional[pulumi.Input[int]] = None,
            closed_at: Optional[pulumi.Input[str]] = None,
            closed_by_user_id: Optional[pulumi.Input[int]] = None,
            confidential: Optional[pulumi.Input[bool]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            delete_on_destroy: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            discussion_locked: Optional[pulumi.Input[bool]] = None,
            discussion_to_resolve: Optional[pulumi.Input[str]] = None,
            downvotes: Optional[pulumi.Input[int]] = None,
            due_date: Optional[pulumi.Input[str]] = None,
            epic_id: Optional[pulumi.Input[int]] = None,
            epic_issue_id: Optional[pulumi.Input[int]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            human_time_estimate: Optional[pulumi.Input[str]] = None,
            human_total_time_spent: Optional[pulumi.Input[str]] = None,
            iid: Optional[pulumi.Input[int]] = None,
            issue_id: Optional[pulumi.Input[int]] = None,
            issue_link_id: Optional[pulumi.Input[int]] = None,
            issue_type: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            links: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            merge_request_to_resolve_discussions_of: Optional[pulumi.Input[int]] = None,
            merge_requests_count: Optional[pulumi.Input[int]] = None,
            milestone_id: Optional[pulumi.Input[int]] = None,
            moved_to_id: Optional[pulumi.Input[int]] = None,
            project: Optional[pulumi.Input[str]] = None,
            references: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subscribed: Optional[pulumi.Input[bool]] = None,
            task_completion_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectIssueTaskCompletionStatusArgs']]]]] = None,
            time_estimate: Optional[pulumi.Input[int]] = None,
            title: Optional[pulumi.Input[str]] = None,
            total_time_spent: Optional[pulumi.Input[int]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            upvotes: Optional[pulumi.Input[int]] = None,
            user_notes_count: Optional[pulumi.Input[int]] = None,
            web_url: Optional[pulumi.Input[str]] = None,
            weight: Optional[pulumi.Input[int]] = None) -> 'ProjectIssue':
        """
        Get an existing ProjectIssue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] assignee_ids: The IDs of the users to assign the issue to.
        :param pulumi.Input[int] author_id: The ID of the author of the issue. Use `User` data source to get more information about the user.
        :param pulumi.Input[str] closed_at: When the issue was closed. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
        :param pulumi.Input[int] closed_by_user_id: The ID of the user that closed the issue. Use `User` data source to get more information about the user.
        :param pulumi.Input[bool] confidential: Set an issue to be confidential.
        :param pulumi.Input[str] created_at: When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
        :param pulumi.Input[bool] delete_on_destroy: Whether the issue is deleted instead of closed during destroy.
        :param pulumi.Input[str] description: The description of an issue. Limited to 1,048,576 characters.
        :param pulumi.Input[bool] discussion_locked: Whether the issue is locked for discussions or not.
        :param pulumi.Input[str] discussion_to_resolve: The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
        :param pulumi.Input[int] downvotes: The number of downvotes the issue has received.
        :param pulumi.Input[str] due_date: The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
        :param pulumi.Input[int] epic_id: ID of the epic to add the issue to. Valid values are greater than or equal to 0.
        :param pulumi.Input[int] epic_issue_id: The ID of the epic issue.
        :param pulumi.Input[str] external_id: The external ID of the issue.
        :param pulumi.Input[str] human_time_estimate: The human-readable time estimate of the issue.
        :param pulumi.Input[str] human_total_time_spent: The human-readable total time spent of the issue.
        :param pulumi.Input[int] iid: The internal ID of the project's issue.
        :param pulumi.Input[int] issue_id: The instance-wide ID of the issue.
        :param pulumi.Input[int] issue_link_id: The ID of the issue link.
        :param pulumi.Input[str] issue_type: The type of issue. Valid values are: `issue`, `incident`, `test_case`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The labels of an issue.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] links: The links of the issue.
        :param pulumi.Input[int] merge_request_to_resolve_discussions_of: The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
        :param pulumi.Input[int] merge_requests_count: The number of merge requests associated with the issue.
        :param pulumi.Input[int] milestone_id: The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
        :param pulumi.Input[int] moved_to_id: The ID of the issue that was moved to.
        :param pulumi.Input[str] project: The name or ID of the project.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] references: The references of the issue.
        :param pulumi.Input[str] state: The state of the issue. Valid values are: `opened`, `closed`.
        :param pulumi.Input[bool] subscribed: Whether the authenticated user is subscribed to the issue or not.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProjectIssueTaskCompletionStatusArgs']]]] task_completion_statuses: The task completion status. It's always a one element list.
        :param pulumi.Input[int] time_estimate: The time estimate of the issue.
        :param pulumi.Input[str] title: The title of the issue.
        :param pulumi.Input[int] total_time_spent: The total time spent of the issue.
        :param pulumi.Input[str] updated_at: When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
        :param pulumi.Input[int] upvotes: The number of upvotes the issue has received.
        :param pulumi.Input[int] user_notes_count: The number of user notes on the issue.
        :param pulumi.Input[str] web_url: The web URL of the issue.
        :param pulumi.Input[int] weight: The weight of the issue. Valid values are greater than or equal to 0.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectIssueState.__new__(_ProjectIssueState)

        __props__.__dict__["assignee_ids"] = assignee_ids
        __props__.__dict__["author_id"] = author_id
        __props__.__dict__["closed_at"] = closed_at
        __props__.__dict__["closed_by_user_id"] = closed_by_user_id
        __props__.__dict__["confidential"] = confidential
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["delete_on_destroy"] = delete_on_destroy
        __props__.__dict__["description"] = description
        __props__.__dict__["discussion_locked"] = discussion_locked
        __props__.__dict__["discussion_to_resolve"] = discussion_to_resolve
        __props__.__dict__["downvotes"] = downvotes
        __props__.__dict__["due_date"] = due_date
        __props__.__dict__["epic_id"] = epic_id
        __props__.__dict__["epic_issue_id"] = epic_issue_id
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["human_time_estimate"] = human_time_estimate
        __props__.__dict__["human_total_time_spent"] = human_total_time_spent
        __props__.__dict__["iid"] = iid
        __props__.__dict__["issue_id"] = issue_id
        __props__.__dict__["issue_link_id"] = issue_link_id
        __props__.__dict__["issue_type"] = issue_type
        __props__.__dict__["labels"] = labels
        __props__.__dict__["links"] = links
        __props__.__dict__["merge_request_to_resolve_discussions_of"] = merge_request_to_resolve_discussions_of
        __props__.__dict__["merge_requests_count"] = merge_requests_count
        __props__.__dict__["milestone_id"] = milestone_id
        __props__.__dict__["moved_to_id"] = moved_to_id
        __props__.__dict__["project"] = project
        __props__.__dict__["references"] = references
        __props__.__dict__["state"] = state
        __props__.__dict__["subscribed"] = subscribed
        __props__.__dict__["task_completion_statuses"] = task_completion_statuses
        __props__.__dict__["time_estimate"] = time_estimate
        __props__.__dict__["title"] = title
        __props__.__dict__["total_time_spent"] = total_time_spent
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["upvotes"] = upvotes
        __props__.__dict__["user_notes_count"] = user_notes_count
        __props__.__dict__["web_url"] = web_url
        __props__.__dict__["weight"] = weight
        return ProjectIssue(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assigneeIds")
    def assignee_ids(self) -> pulumi.Output[Optional[Sequence[int]]]:
        """
        The IDs of the users to assign the issue to.
        """
        return pulumi.get(self, "assignee_ids")

    @property
    @pulumi.getter(name="authorId")
    def author_id(self) -> pulumi.Output[int]:
        """
        The ID of the author of the issue. Use `User` data source to get more information about the user.
        """
        return pulumi.get(self, "author_id")

    @property
    @pulumi.getter(name="closedAt")
    def closed_at(self) -> pulumi.Output[str]:
        """
        When the issue was closed. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
        """
        return pulumi.get(self, "closed_at")

    @property
    @pulumi.getter(name="closedByUserId")
    def closed_by_user_id(self) -> pulumi.Output[int]:
        """
        The ID of the user that closed the issue. Use `User` data source to get more information about the user.
        """
        return pulumi.get(self, "closed_by_user_id")

    @property
    @pulumi.getter
    def confidential(self) -> pulumi.Output[Optional[bool]]:
        """
        Set an issue to be confidential.
        """
        return pulumi.get(self, "confidential")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        When the issue was created. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z. Requires administrator or project/group owner rights.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deleteOnDestroy")
    def delete_on_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the issue is deleted instead of closed during destroy.
        """
        return pulumi.get(self, "delete_on_destroy")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of an issue. Limited to 1,048,576 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="discussionLocked")
    def discussion_locked(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the issue is locked for discussions or not.
        """
        return pulumi.get(self, "discussion_locked")

    @property
    @pulumi.getter(name="discussionToResolve")
    def discussion_to_resolve(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of a discussion to resolve. This fills out the issue with a default description and mark the discussion as resolved. Use in combination with merge*request*to*resolve*discussions_of.
        """
        return pulumi.get(self, "discussion_to_resolve")

    @property
    @pulumi.getter
    def downvotes(self) -> pulumi.Output[int]:
        """
        The number of downvotes the issue has received.
        """
        return pulumi.get(self, "downvotes")

    @property
    @pulumi.getter(name="dueDate")
    def due_date(self) -> pulumi.Output[Optional[str]]:
        """
        The due date. Date time string in the format YYYY-MM-DD, for example 2016-03-11.
        """
        return pulumi.get(self, "due_date")

    @property
    @pulumi.getter(name="epicId")
    def epic_id(self) -> pulumi.Output[int]:
        """
        ID of the epic to add the issue to. Valid values are greater than or equal to 0.
        """
        return pulumi.get(self, "epic_id")

    @property
    @pulumi.getter(name="epicIssueId")
    def epic_issue_id(self) -> pulumi.Output[int]:
        """
        The ID of the epic issue.
        """
        return pulumi.get(self, "epic_issue_id")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        """
        The external ID of the issue.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="humanTimeEstimate")
    def human_time_estimate(self) -> pulumi.Output[str]:
        """
        The human-readable time estimate of the issue.
        """
        return pulumi.get(self, "human_time_estimate")

    @property
    @pulumi.getter(name="humanTotalTimeSpent")
    def human_total_time_spent(self) -> pulumi.Output[str]:
        """
        The human-readable total time spent of the issue.
        """
        return pulumi.get(self, "human_total_time_spent")

    @property
    @pulumi.getter
    def iid(self) -> pulumi.Output[int]:
        """
        The internal ID of the project's issue.
        """
        return pulumi.get(self, "iid")

    @property
    @pulumi.getter(name="issueId")
    def issue_id(self) -> pulumi.Output[int]:
        """
        The instance-wide ID of the issue.
        """
        return pulumi.get(self, "issue_id")

    @property
    @pulumi.getter(name="issueLinkId")
    def issue_link_id(self) -> pulumi.Output[int]:
        """
        The ID of the issue link.
        """
        return pulumi.get(self, "issue_link_id")

    @property
    @pulumi.getter(name="issueType")
    def issue_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of issue. Valid values are: `issue`, `incident`, `test_case`.
        """
        return pulumi.get(self, "issue_type")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The labels of an issue.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def links(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The links of the issue.
        """
        return pulumi.get(self, "links")

    @property
    @pulumi.getter(name="mergeRequestToResolveDiscussionsOf")
    def merge_request_to_resolve_discussions_of(self) -> pulumi.Output[Optional[int]]:
        """
        The IID of a merge request in which to resolve all issues. This fills out the issue with a default description and mark all discussions as resolved. When passing a description or title, these values take precedence over the default values.
        """
        return pulumi.get(self, "merge_request_to_resolve_discussions_of")

    @property
    @pulumi.getter(name="mergeRequestsCount")
    def merge_requests_count(self) -> pulumi.Output[int]:
        """
        The number of merge requests associated with the issue.
        """
        return pulumi.get(self, "merge_requests_count")

    @property
    @pulumi.getter(name="milestoneId")
    def milestone_id(self) -> pulumi.Output[Optional[int]]:
        """
        The global ID of a milestone to assign issue. To find the milestone_id associated with a milestone, view an issue with the milestone assigned and use the API to retrieve the issue's details.
        """
        return pulumi.get(self, "milestone_id")

    @property
    @pulumi.getter(name="movedToId")
    def moved_to_id(self) -> pulumi.Output[int]:
        """
        The ID of the issue that was moved to.
        """
        return pulumi.get(self, "moved_to_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The name or ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def references(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The references of the issue.
        """
        return pulumi.get(self, "references")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[str]]:
        """
        The state of the issue. Valid values are: `opened`, `closed`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def subscribed(self) -> pulumi.Output[bool]:
        """
        Whether the authenticated user is subscribed to the issue or not.
        """
        return pulumi.get(self, "subscribed")

    @property
    @pulumi.getter(name="taskCompletionStatuses")
    def task_completion_statuses(self) -> pulumi.Output[Sequence['outputs.ProjectIssueTaskCompletionStatus']]:
        """
        The task completion status. It's always a one element list.
        """
        return pulumi.get(self, "task_completion_statuses")

    @property
    @pulumi.getter(name="timeEstimate")
    def time_estimate(self) -> pulumi.Output[int]:
        """
        The time estimate of the issue.
        """
        return pulumi.get(self, "time_estimate")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        The title of the issue.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="totalTimeSpent")
    def total_time_spent(self) -> pulumi.Output[int]:
        """
        The total time spent of the issue.
        """
        return pulumi.get(self, "total_time_spent")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        When the issue was updated. Date time string, ISO 8601 formatted, for example 2016-03-11T03:45:40Z.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def upvotes(self) -> pulumi.Output[int]:
        """
        The number of upvotes the issue has received.
        """
        return pulumi.get(self, "upvotes")

    @property
    @pulumi.getter(name="userNotesCount")
    def user_notes_count(self) -> pulumi.Output[int]:
        """
        The number of user notes on the issue.
        """
        return pulumi.get(self, "user_notes_count")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> pulumi.Output[str]:
        """
        The web URL of the issue.
        """
        return pulumi.get(self, "web_url")

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Output[int]:
        """
        The weight of the issue. Valid values are greater than or equal to 0.
        """
        return pulumi.get(self, "weight")

