# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['UserRunnerArgs', 'UserRunner']

@pulumi.input_type
class UserRunnerArgs:
    def __init__(__self__, *,
                 runner_type: pulumi.Input[str],
                 access_level: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 maximum_timeout: Optional[pulumi.Input[int]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 project_id: Optional[pulumi.Input[int]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 untagged: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a UserRunner resource.
        :param pulumi.Input[str] runner_type: The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        :param pulumi.Input[str] access_level: The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        :param pulumi.Input[str] description: Description of the runner.
        :param pulumi.Input[int] group_id: The ID of the group that the runner is created in. Required if runner*type is group*type.
        :param pulumi.Input[bool] locked: Specifies if the runner should be locked for the current project.
        :param pulumi.Input[int] maximum_timeout: Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        :param pulumi.Input[bool] paused: Specifies if the runner should ignore new jobs.
        :param pulumi.Input[int] project_id: The ID of the project that the runner is created in. Required if runner*type is project*type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: A list of runner tags.
        :param pulumi.Input[bool] untagged: Specifies if the runner should handle untagged jobs.
        """
        pulumi.set(__self__, "runner_type", runner_type)
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if maximum_timeout is not None:
            pulumi.set(__self__, "maximum_timeout", maximum_timeout)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)
        if untagged is not None:
            pulumi.set(__self__, "untagged", untagged)

    @property
    @pulumi.getter(name="runnerType")
    def runner_type(self) -> pulumi.Input[str]:
        """
        The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        """
        return pulumi.get(self, "runner_type")

    @runner_type.setter
    def runner_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "runner_type", value)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the runner.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the group that the runner is created in. Required if runner*type is group*type.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the runner should be locked for the current project.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter(name="maximumTimeout")
    def maximum_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        """
        return pulumi.get(self, "maximum_timeout")

    @maximum_timeout.setter
    def maximum_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_timeout", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the runner should ignore new jobs.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the project that the runner is created in. Required if runner*type is project*type.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of runner tags.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_lists", value)

    @property
    @pulumi.getter
    def untagged(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the runner should handle untagged jobs.
        """
        return pulumi.get(self, "untagged")

    @untagged.setter
    def untagged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "untagged", value)


@pulumi.input_type
class _UserRunnerState:
    def __init__(__self__, *,
                 access_level: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 maximum_timeout: Optional[pulumi.Input[int]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 project_id: Optional[pulumi.Input[int]] = None,
                 runner_type: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 untagged: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering UserRunner resources.
        :param pulumi.Input[str] access_level: The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        :param pulumi.Input[str] description: Description of the runner.
        :param pulumi.Input[int] group_id: The ID of the group that the runner is created in. Required if runner*type is group*type.
        :param pulumi.Input[bool] locked: Specifies if the runner should be locked for the current project.
        :param pulumi.Input[int] maximum_timeout: Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        :param pulumi.Input[bool] paused: Specifies if the runner should ignore new jobs.
        :param pulumi.Input[int] project_id: The ID of the project that the runner is created in. Required if runner*type is project*type.
        :param pulumi.Input[str] runner_type: The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: A list of runner tags.
        :param pulumi.Input[str] token: The authentication token to use when setting up a new runner with this configuration. This value cannot be imported.
        :param pulumi.Input[bool] untagged: Specifies if the runner should handle untagged jobs.
        """
        if access_level is not None:
            pulumi.set(__self__, "access_level", access_level)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if maximum_timeout is not None:
            pulumi.set(__self__, "maximum_timeout", maximum_timeout)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if runner_type is not None:
            pulumi.set(__self__, "runner_type", runner_type)
        if tag_lists is not None:
            pulumi.set(__self__, "tag_lists", tag_lists)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if untagged is not None:
            pulumi.set(__self__, "untagged", untagged)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[pulumi.Input[str]]:
        """
        The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        """
        return pulumi.get(self, "access_level")

    @access_level.setter
    def access_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_level", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the runner.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the group that the runner is created in. Required if runner*type is group*type.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the runner should be locked for the current project.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter(name="maximumTimeout")
    def maximum_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        """
        return pulumi.get(self, "maximum_timeout")

    @maximum_timeout.setter
    def maximum_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_timeout", value)

    @property
    @pulumi.getter
    def paused(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the runner should ignore new jobs.
        """
        return pulumi.get(self, "paused")

    @paused.setter
    def paused(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "paused", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[int]]:
        """
        The ID of the project that the runner is created in. Required if runner*type is project*type.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="runnerType")
    def runner_type(self) -> Optional[pulumi.Input[str]]:
        """
        The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        """
        return pulumi.get(self, "runner_type")

    @runner_type.setter
    def runner_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runner_type", value)

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of runner tags.
        """
        return pulumi.get(self, "tag_lists")

    @tag_lists.setter
    def tag_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_lists", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The authentication token to use when setting up a new runner with this configuration. This value cannot be imported.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter
    def untagged(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the runner should handle untagged jobs.
        """
        return pulumi.get(self, "untagged")

    @untagged.setter
    def untagged(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "untagged", value)


class UserRunner(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 maximum_timeout: Optional[pulumi.Input[int]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 project_id: Optional[pulumi.Input[int]] = None,
                 runner_type: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 untagged: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The `UserRunner` resource allows creating a GitLab runner using the new [GitLab Runner Registration Flow](https://docs.gitlab.com/ee/ci/runners/new_creation_workflow.html).

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/users.html#create-a-runner)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_level: The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        :param pulumi.Input[str] description: Description of the runner.
        :param pulumi.Input[int] group_id: The ID of the group that the runner is created in. Required if runner*type is group*type.
        :param pulumi.Input[bool] locked: Specifies if the runner should be locked for the current project.
        :param pulumi.Input[int] maximum_timeout: Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        :param pulumi.Input[bool] paused: Specifies if the runner should ignore new jobs.
        :param pulumi.Input[int] project_id: The ID of the project that the runner is created in. Required if runner*type is project*type.
        :param pulumi.Input[str] runner_type: The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: A list of runner tags.
        :param pulumi.Input[bool] untagged: Specifies if the runner should handle untagged jobs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserRunnerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `UserRunner` resource allows creating a GitLab runner using the new [GitLab Runner Registration Flow](https://docs.gitlab.com/ee/ci/runners/new_creation_workflow.html).

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/users.html#create-a-runner)

        :param str resource_name: The name of the resource.
        :param UserRunnerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserRunnerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_level: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[int]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 maximum_timeout: Optional[pulumi.Input[int]] = None,
                 paused: Optional[pulumi.Input[bool]] = None,
                 project_id: Optional[pulumi.Input[int]] = None,
                 runner_type: Optional[pulumi.Input[str]] = None,
                 tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 untagged: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserRunnerArgs.__new__(UserRunnerArgs)

            __props__.__dict__["access_level"] = access_level
            __props__.__dict__["description"] = description
            __props__.__dict__["group_id"] = group_id
            __props__.__dict__["locked"] = locked
            __props__.__dict__["maximum_timeout"] = maximum_timeout
            __props__.__dict__["paused"] = paused
            __props__.__dict__["project_id"] = project_id
            if runner_type is None and not opts.urn:
                raise TypeError("Missing required property 'runner_type'")
            __props__.__dict__["runner_type"] = runner_type
            __props__.__dict__["tag_lists"] = tag_lists
            __props__.__dict__["untagged"] = untagged
            __props__.__dict__["token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(UserRunner, __self__).__init__(
            'gitlab:index/userRunner:UserRunner',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_level: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            group_id: Optional[pulumi.Input[int]] = None,
            locked: Optional[pulumi.Input[bool]] = None,
            maximum_timeout: Optional[pulumi.Input[int]] = None,
            paused: Optional[pulumi.Input[bool]] = None,
            project_id: Optional[pulumi.Input[int]] = None,
            runner_type: Optional[pulumi.Input[str]] = None,
            tag_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token: Optional[pulumi.Input[str]] = None,
            untagged: Optional[pulumi.Input[bool]] = None) -> 'UserRunner':
        """
        Get an existing UserRunner resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_level: The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        :param pulumi.Input[str] description: Description of the runner.
        :param pulumi.Input[int] group_id: The ID of the group that the runner is created in. Required if runner*type is group*type.
        :param pulumi.Input[bool] locked: Specifies if the runner should be locked for the current project.
        :param pulumi.Input[int] maximum_timeout: Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        :param pulumi.Input[bool] paused: Specifies if the runner should ignore new jobs.
        :param pulumi.Input[int] project_id: The ID of the project that the runner is created in. Required if runner*type is project*type.
        :param pulumi.Input[str] runner_type: The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_lists: A list of runner tags.
        :param pulumi.Input[str] token: The authentication token to use when setting up a new runner with this configuration. This value cannot be imported.
        :param pulumi.Input[bool] untagged: Specifies if the runner should handle untagged jobs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserRunnerState.__new__(_UserRunnerState)

        __props__.__dict__["access_level"] = access_level
        __props__.__dict__["description"] = description
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["locked"] = locked
        __props__.__dict__["maximum_timeout"] = maximum_timeout
        __props__.__dict__["paused"] = paused
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["runner_type"] = runner_type
        __props__.__dict__["tag_lists"] = tag_lists
        __props__.__dict__["token"] = token
        __props__.__dict__["untagged"] = untagged
        return UserRunner(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> pulumi.Output[str]:
        """
        The access level of the runner. Valid values are: `not_protected`, `ref_protected`.
        """
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the runner.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[Optional[int]]:
        """
        The ID of the group that the runner is created in. Required if runner*type is group*type.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def locked(self) -> pulumi.Output[bool]:
        """
        Specifies if the runner should be locked for the current project.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter(name="maximumTimeout")
    def maximum_timeout(self) -> pulumi.Output[int]:
        """
        Maximum timeout that limits the amount of time (in seconds) that runners can run jobs. Must be at least 600 (10 minutes).
        """
        return pulumi.get(self, "maximum_timeout")

    @property
    @pulumi.getter
    def paused(self) -> pulumi.Output[bool]:
        """
        Specifies if the runner should ignore new jobs.
        """
        return pulumi.get(self, "paused")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[Optional[int]]:
        """
        The ID of the project that the runner is created in. Required if runner*type is project*type.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="runnerType")
    def runner_type(self) -> pulumi.Output[str]:
        """
        The scope of the runner. Valid values are: `instance_type`, `group_type`, `project_type`.
        """
        return pulumi.get(self, "runner_type")

    @property
    @pulumi.getter(name="tagLists")
    def tag_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of runner tags.
        """
        return pulumi.get(self, "tag_lists")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[str]:
        """
        The authentication token to use when setting up a new runner with this configuration. This value cannot be imported.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def untagged(self) -> pulumi.Output[bool]:
        """
        Specifies if the runner should handle untagged jobs.
        """
        return pulumi.get(self, "untagged")

