# Using StorageOptions with fsspec-utils

This example demonstrates how to use different StorageOptions classes with fsspec-utils to configure various storage systems.

## Overview

The example shows:
1. Creating instances of different StorageOptions subclasses
2. Converting them to fsspec filesystems using to_filesystem()
3. Performing simple operations with each filesystem
4. Demonstrating configuration for different storage systems

## Prerequisites

- Python 3.8+
- fsspec-utils installed

## Running the Example

Run the example script:

```bash
python storage_options_example.py
```

Or run the Jupyter notebook:

```bash
jupyter notebook storage_options_example.ipynb
```

Or run the Marimo notebook:

```bash
marimo run storage_options_example_mamo.py
```

## Files in This Example

- `storage_options_example.py`: Python script demonstrating the functionality
- `storage_options_example.ipynb`: Jupyter notebook version of the example
- `storage_options_example_mamo.py`: Marimo notebook version of the example
- `README.md`: This file