SHA256_AUDIT_PATH = [
    b"1a208aeebcd1b39fe2de247ee8db9454e1e93a312d206b87f6ca9cc6ec6f1ddd",
    b"0a1b78b383f580856f433c01a5741e160d451c185910027f6cc9f828687a40c4",
    b"3d1745789bc63f2da15850de1c12a5bf46ed81e1cc90f086148b1662e79aab3d",
    b"9095b61e14d8990acf390905621e62b1714fb8e399fbb71de5510e0aef45affe",
    b"0a332b91b8fab564e6afd1dd452449e04619b18accc0ff9aa8393cd4928451f2",
    b"2336f0181d264aed6d8f3a6507ca14a8d3b3c3a23791ac263e845d208c1ee330",
    b"b4ce56e300590500360c146c6452edbede25d4ed83919278749ee5dbe178e048",
    b"933f6ddc848ea562e4f9c5cfb5f176941301dad0c6fdb9d1fbbe34fac1be6966",
    b"b95a6222958a86f74c030be27c44f57dbe313e5e7c7f4ffb98bcbd3a03bb52f2",
    b"daeeb3ce5923defd0faeb8e0c210b753b85b809445d7d3d3cd537a9aabaa9c45",
    b"7fadd0a13e9138a2aa6c3fdec4e2275af233b94812784f66bcca9aa8e989f2bc",
    b"1864e6ba3e32878610546539734fb5eeae2529991f130c575c73a7e25a2a7c56",
    b"12842d1202b1dc6828a17ab253c02e7ce9409b5192430feba44189f39cc02d66",
    b"29af64b16fa3053c13d02ac63aa75b23aa468506e44c3a2315edc85d2dc22b11",
    b"b527b99934a0bd9edd154e449b0502e2c499bba783f3bc3dfe23364b6b532009",
    b"4584db8ae8e351ace08e01f306378a92bfd43611714814f3d834a2842d69faa8",
    b"86a9a41573b0d6e4292f01e93243d6cc65b30f06606fc6fa57390e7e90ed580f",
    b"a88b98fbe84d4c6aae8db9d1605dfac059d9f03fe0fcb0d5dff1295dacba09e6",
    b"06326dc617a6d1f7021dc536026dbfd5fffc6f7c5531d48ef6ccd1ed1569f2a1",
    b"f41fe8fdc3a2e4e8345e30216e7ebecffee26ff266eeced208a6c2a3cf08f960",
    b"40cf5bde8abb76983f3e98ba97aa36240402975674e120f234b3448911090f8d",
    b"b3222dc8658538079883d980d7fdc2bef9285344ea34338968f736b04aeb387a",
]

RAW_HEX_LEAF = (
    b"00000000013de9d2b29b000000055b308205573082043fa00302010202072b777b56df"
    b"7bc5300d06092a864886f70d01010505003081ca310b30090603550406130255533110"
    b"300e060355040813074172697a6f6e61311330110603550407130a53636f7474736461"
    b"6c65311a3018060355040a1311476f44616464792e636f6d2c20496e632e3133303106"
    b"0355040b132a687474703a2f2f6365727469666963617465732e676f64616464792e63"
    b"6f6d2f7265706f7369746f72793130302e06035504031327476f204461646479205365"
    b"637572652043657274696669636174696f6e20417574686f726974793111300f060355"
    b"040513083037393639323837301e170d3133303131343038353035305a170d31353031"
    b"31343038353035305a305331163014060355040a130d7777772e69646e65742e6e6574"
    b"3121301f060355040b1318446f6d61696e20436f6e74726f6c2056616c696461746564"
    b"311630140603550403130d7777772e69646e65742e6e657430820122300d06092a8648"
    b"86f70d01010105000382010f003082010a0282010100d4e4a4b1bbc981c9b8166f0737"
    b"c113000aa5370b21ad86a831a379de929db258f056ba0681c50211552b249a02ec00c5"
    b"37e014805a5b5f4d09c84fdcdfc49310f4a9f9004245d119ce5461bc5c42fd99694b88"
    b"388e035e333ac77a24762d2a97ea15622459cc4adcd37474a11c7cff6239f810120f85"
    b"e014d2066a3592be604b310055e84a74c91c6f401cb7f78bdb45636fb0b1516b04c5ee"
    b"7b3fa1507865ff885d2ace21cbb28fdaa464efaa1d5faab1c65e4c46d2139175448f54"
    b"b5da5aea956719de836ac69cd3a74ca049557cee96f5e09e07ba7e7b4ebf9bf167f4c3"
    b"bf8039a4cab4bec068c899e997bca58672bd7686b5c85ea24841e48c46f76830390203"
    b"010001a38201b6308201b2300f0603551d130101ff04053003010100301d0603551d25"
    b"0416301406082b0601050507030106082b06010505070302300e0603551d0f0101ff04"
    b"04030205a030330603551d1f042c302a3028a026a0248622687474703a2f2f63726c2e"
    b"676f64616464792e636f6d2f676473312d38332e63726c30530603551d20044c304a30"
    b"48060b6086480186fd6d010717013039303706082b06010505070201162b687474703a"
    b"2f2f6365727469666963617465732e676f64616464792e636f6d2f7265706f7369746f"
    b"72792f30818006082b0601050507010104743072302406082b06010505073001861868"
    b"7474703a2f2f6f6373702e676f64616464792e636f6d2f304a06082b06010505073002"
    b"863e687474703a2f2f6365727469666963617465732e676f64616464792e636f6d2f72"
    b"65706f7369746f72792f67645f696e7465726d6564696174652e637274301f0603551d"
    b"23041830168014fdac6132936c45d6e2ee855f9abae7769968cce730230603551d1104"
    b"1c301a820d7777772e69646e65742e6e6574820969646e65742e6e6574301d0603551d"
    b"0e041604144d3ae8a87ddcf046764021b87e7d8d39ddd18ea0300d06092a864886f70d"
    b"01010505000382010100ad651b199f340f043732a71178c0af48e22877b9e5d99a70f5"
    b"d78537c31d6516e19669aa6bfdb8b2cc7a145ba7d77b35101f9519e03b58e692732314"
    b"1383c3ab45dc219bd5a584a2b6333b6e1bbef5f76e89b3c187ef1d3b853b4910e895a4"
    b"57dbe7627e759f56c8484c30b22a74fb00f7b1d7c41533a1fd176cd2a2b06076acd7ca"
    b"ddc6ca6d0c2a815f9eb3ef0d03d27e7eebd7824c78fdb51679c03278cfbb2d85ae65a4"
    b"7485cb733fc1c7407834f7471ababd68f140983817c6f388b2f2e2bfe9e26608f9924f"
    b"16473462d136427d1f2801e4b870b078c20ec4ba21e22ab32a00b76522d523825bcabb"
    b"8c7b6142d624be8d2af69ecc36fb5689572a0f59c00000"
)
GET_NYM_REPLY = {
    "op": "REPLY",
    "result": {
        "data": {
            "dest": "Av63wJYM7xYR4AiygYq4c3",
            "identifier": "V4SGRU86Z58d6TV7PBUe6f",
            "role": "101",
            "seqNo": 17794,
            "txnTime": 1632262244,
            "verkey": "6QSduYdf8Bi6t8PfNm5vNomGWDtXhmMmTRzaciudBXYJ",
        },
        "dest": "Av63wJYM7xYR4AiygYq4c3",
        "identifier": "LibindyDid111111111111",
        "reqId": 1632267113185021500,
        "seqNo": 17794,
        "state_proof": {
            "multi_signature": {
                "participants": ["Node2", "Node3", "Node1"],
                "signature": "Qye7WDGrhwEpr2MUmQ2hhm8yWAsUG6gKKf4TXxrw7BybGA96HWXLXhnV5gm5HBQCb4sDXiirTKuyWgMDyfDxKewya9mZhkGXf5WzaADFuaoJkTeSywqqmsrfpcHc2e49eEyncpCxFzhJn6sius4jLgJ7MAfSeVGwyydeR1YsJb3Nm5",
                "value": {
                    "ledger_id": 1,
                    "pool_state_root_hash": "7siDH8Qanh82UviK4zjBSfLXcoCvLaeGkrByi1ow9Tsm",
                    "state_root_hash": "GJq4XL4pJYnDGg3MJ64y3QnfuezxsuBEezk5GC5yaZPM",
                    "timestamp": 1632266842,
                    "txn_root_hash": "BTnnWQ7imcHSoMykHLeYZX5q8eGEHWdbUydQNA4RG8La",
                },
            },
            "proof_nodes": r"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",
            "root_hash": "GJq4XL4pJYnDGg3MJ64y3QnfuezxsuBEezk5GC5yaZPM",
        },
        "txnTime": 1632262244,
        "type": "105",
    },
}
GET_ATTRIB_REPLY = {
    "op": "REPLY",
    "result": {
        "data": "!@#$%^&*()",
        "dest": "Av63wJYM7xYR4AiygYq4c3",
        "enc": "!@#$%^&*()",
        "identifier": "Av63wJYM7xYR4AiygYq4c3",
        "reqId": 1632330118219577700,
        "seqNo": 17861,
        "state_proof": {
            "multi_signature": {
                "participants": ["Node2", "Node1", "Node3"],
                "signature": "RYJYMn96nrrDmNFjeeP7voVY4M7fCj4fHFb8uGiBsLJWd2fujVuoFdNbD7BnP9N5djkerANM2XGqUVAoQ5b9MQLF6NXpK9rQkoAfVCrz9NBJYsD8LW6sc4YN5gwqJgnQegsmHWSfYgyhWq9b27RB59yh6pNh1PQmxc6G2N9TC1vBqH",
                "value": {
                    "ledger_id": 1,
                    "pool_state_root_hash": "7siDH8Qanh82UviK4zjBSfLXcoCvLaeGkrByi1ow9Tsm",
                    "state_root_hash": "CdNjqYsC3wJ9ddBSGJpFDgbPUC3LMU5WpLMKfk7Nu8y9",
                    "timestamp": 1632330092,
                    "txn_root_hash": "CLP3Zj6SLd4HETezr7Me37ZCS3uRVqc1EMsj8HUvB3Yq",
                },
            },
            "proof_nodes": r"+QiL+QFxoCtXu0mw1ebGv2A1OlkjRukRnJs8oy7d8gNbrj6yQHcdoJZ0vJmO7PM69ytB3v6d5S4bjVzqCqVyBOGaQO94YeW4oEwDRy2u5bnRgo+C0Ei+5gM4c8Ix8Jlp1soSA77Wp+JeoAHtsE0/wuXFZIhuZAGwGjpkmE/dPrJJpMkF5o30osw5oCVIfS9J8fGGzco4zXyQosHepwSy9paGNk9FsV0VO1MnoCgsaLN77phwtLe44HNqB0cKpX6oZ9mYIMh4L2ftnzZboL95y56198Y4O52Nco9iUuTmLfzm6v9wmrL11n1s6CzkoDV/kCAK2ik/Mgln5rw4jk9rrloUTIn4q54xeJ/mQuoloMVbQ7SP66F5uWPXPGL6wB8Ql57X+jyxxdPdsMMw1YDToA1fbg6tMjTiFsdTCFwWazLdJTKrIfs8IuUeEedhPCJ6oB2FYyT/1bw24xogKSpO5Gv3l/bKLHObq2Wk/mqD41jQgICAgICA+Ma4VzYzd0pZTTd4WVI0QWl5Z1lxNGMzOjE6OTVjZTc4OWM1YzlkMTg0OTA5NzI3MDk4MzhjYTNhOTcxOTA5NGJjYTNhYzE2MzMyY2ZlYzA2NTJiMDIzNjE0Mbhr+Gm4Z3sibHNuIjoxNzg2MSwibHV0IjoxNjMyMzI5NzkxLCJ2YWwiOiI5NWNlNzg5YzVjOWQxODQ5MDk3MjcwOTgzOGNhM2E5NzE5MDk0YmNhM2FjMTYzMzJjZmVjMDY1MmIwMjM2MTQxIn35AhGgxhCAyLVujfeK3JsRsgKfOt9Bb3ska1oiAVYag9PVuOegeRV6fPSTJt/1kb7zbzRTbp04FMXI5bh+zDAIId/BwVygIzsQpf1vDPjjejQjs/CdoQGbkZuKHmZr271Ig0AN5u+grLAIkAqdmj74uhpGiWZowzq865dSdqYgbZnMqgaToTWgNIUFaaiUJZtBWots40Rq0hHrdlBq8JkMe+nj0Lgp+fmgIpG3OWbOVvJGty97UXLi+dWrRFXPaz8NO3sxoB4mSzqgMS1eS5NVzVbpzgbPapd1YpyBVOh9Go/9i7AfaKYD5cOgat2YQEMPq60wdEGqtriJhUCjw2OLL0vhL0TNi2ND26mgkNokyer/73cwd4PnSKPcYPkZ4agoHLVvlW18WnixN0ygeL+k83IfgIXPu6BMB9+cqF7bWG/YK6oJiVf1ZuJUa9SgmHQxRfRmB/RwL0KjDbJ3qJlFoQRAz1wtxvXyNi+cByagEWsn+ywZ9ZQuKDcyn9IuehCRtTqJQsN7LBtBx/R+bJ6glo2X0D1eYSlFN7b/0LIUKclTBHj5bdgy4OTXWlj2LpOgkEjZ+8tcM+RSpKuci1FhEBDDhuoVqVgecYXXUZNrakGgL6k6RJRCh72J0PO6Q3vITduaS082vQCrgEFc/He5BqCgnVULBCn2xpLt+ZIhdZ5Iy0QplY92A6NCLXhdeiLq43OA+FGAgICg9EAG0bMCoDsOIAeeVsSUfuaWGFTwGpqY6yLabYx94ViAgKCy5sizDOkq2rkIiK7FvGI8JevCCGnuhRW9HVyKsf5N4oCAgICAgICAgID5AdGgqg1jHpCwamQoUZu/uQ18daiTDZtRr/YwOCaPtRRId1+gVI/Q8qJrilettFsXNlqrsnmaM9EOCCrCvgAYDDSdf/yAoFVcY1y8UEHaBzUobZrCK8c8kRngMZd80j7ywiP8kDpsoNDNNzg2WFFXlgBjIZveTP5YZREwyedRVXBg2wjTZAM7oIv/uPTYAlOiikIRdX81jnwSjYB5e1KUFaWv5blHaAaboCW43JdUGkAT9z3i0S4ltG3/8ZJzLsPJIAUIGgdyAhS/oJbB1VqfeADhIlt23LemzWTRbwgf9hAt6sPE2cqXUomuoCJlCjTV9hRqjUz6gOqV79a5SLWCoW4iesO349lU1o+goNlT/odRQuiWFG9k1jp65+v3p8/e+jL/19DW8Ls6TJMFoNOrRuQOnS8I1LxMJVDa6Wh7sZSb3frT5OFfvfut2UiGoM15BNI74tpvLtRxIdVRdgD0osxm6p/ZK4gIwkvFBOH2oA2qxnGbloUxmnmrFGtlFISU5DJJ05hk4taXuucoE6NZgKBuiyA7ZAD2PrOQ7Uf4k4SqZ79ocrVC/3Ig7c9KrJxBEqDlt+9qAhnCxmLm6Jemh+BEujLz6/+iYHwQdfXYJlSVXoD5AhGgjYADdAGfaHwD1ZjrFjXc6lovqisiVgLPJrq8ls0GQ3SgSjtvwpwCcfvFe9YXTDbJCg2gvqTtyo4Jlf73ZOwORnyg8ykP9RcmUJ1UBZSBwsW4qJfNOBOXR3cBVAqueQFR4GOgqzkXDPKLhggk8a3PzVdn0xrGfprjAEwGBooqB4TRcx6gVlXAnuovfI4+jt6Ajha7UTFpA374qZxNpD7PGMCYtc+gf1baoHr1sLUHBa1QivjMij1HZtvjB53M8TkTV0GqefqgM/DWNl1Q9gWZyYyazVjgCV+ONrnwhtjDHnBfH9UPDOegAEgbMzojKeMXZ4m0Sxi4CNXOyrGNPTDeHeCtr0y6uPmgN2bNLvID/ysP5NP8UrTBj9GwD64zP1xntYY4TCVrQB2gPYXHiVzJi9KBr9l3jFd5Fk3etzB2YOqTC7I+VgzzoBegOmyvt8INrm6Cto8WRCTeelO71DJHNozSFVOWKVipTMugHXniwGJA5KmvQMvz/Z3RNn8FSCQtbRXGNqCGi2thnOWgIPh3Eh/l+j+Zriqj8SsqFhF/V2aLdAWhls4dqrTqMPKgaUrJkpqBbQKRZU/8zCZLDCAqRDJfwt4M45i5t+cjFWWg9mlc9jKf1g0HFoLU457KUeafP10Tr3dUxfQ/UPT6ypigG+w51LbnJJOg7T7fWKLUfFjcfNmsDT1oJbrFKkQm1iaA",
            "root_hash": "CdNjqYsC3wJ9ddBSGJpFDgbPUC3LMU5WpLMKfk7Nu8y9",
        },
        "txnTime": 1632329791,
        "type": "104",
    },
}
GET_CLAIM_DEF_REPLY_INVALID = {
    "op": "REPLY",
    "result": {
        "type": "108",
        "identifier": "L5AD5g65TDQr1PPHHRoiGf",
        "reqId": 1514308188474704,
        "seqNo": 10,
        "txnTime": 1514214795,
        "state_proof": {
            "root_hash": "81bGgr7FDSsf4ymdqaWzfnN86TETmkUKH4dj4AqnokrH",
            "proof_nodes": r"+QHl+FGAgICg0he/hjc9t/tPFzmCrb2T+nHnN0cRwqPKqZEc3pw2iCaAoAsA80p3oFwfl4dDaKkNI8z8weRsSaS9Y8n3HoardRzxgICAgICAgICAgID4naAgwxDOAEoIq+wUHr5h9jjSAIPDjS7SEG1NvWJbToxVQbh6+Hi4dnsiaWRlbnRpZmllciI6Ikw1QUQ1ZzY1VERRcjFQUEhIUm9pR2YiLCJyb2xlIjpudWxsLCJzZXFObyI6MTAsInR4blRpbWUiOjE1MTQyMTQ3OTUsInZlcmtleSI6In42dWV3Um03MmRXN1pUWFdObUFkUjFtIn348YCAgKDKj6ZIi+Ob9HXBy/CULIerYmmnnK2A6hN1u4ofU2eihKBna5MOCHiaObMfghjsZ8KBSbC6EpTFruD02fuGKlF1q4CAgICgBk8Cpc14mIr78WguSeT7+/rLT8qykKxzI4IO5ZMQwSmAoLsEwI+BkQFBiPsN8F610IjAg3+MVMbBjzugJKDo4NhYoFJ0ln1wq3FTWO0iw1zoUcO3FPjSh5ytvf1jvSxxcmJxoF0Hy14HfsVll8qa9aQ8T740lPFLR431oSefGorqgM5ioK1TJOr6JuvtBNByVMRv+rjhklCp6nkleiyLIq8vZYRcgIA=",
            "multi_signature": {
                "value": {
                    "timestamp": 1514308168,
                    "ledger_id": 1,
                    "txn_root_hash": "4Y2DpBPSsgwd5CVE8Z2zZZKS4M6n9AbisT3jYvCYyC2y",
                    "pool_state_root_hash": "9fzzkqU25JbgxycNYwUqKmM3LT8KsvUFkSSowD4pHpoK",
                    "state_root_hash": "81bGgr7FDSsf4ymdqaWzfnN86TETmkUKH4dj4AqnokrH",
                },
                "signature": "REbtR8NvQy3dDRZLoTtzjHNx9ar65ttzk4jMqikwQiL1sPcHK4JAqrqVmhRLtw6Ed3iKuP4v8tgjA2BEvoyLTX6vB6vN4CqtFLqJaPJqMNZvr9tA5Lm6ZHBeEsH1QQLBYnWSAtXt658PotLUEp38sNxRh21t1zavbYcyV8AmxuVTg3",
                "participants": ["Delta", "Gamma", "Alpha"],
            },
        },
        "data": {
            "primary": {
                "n": "99189903989663138528233707329605798928847401116390236896063089765075372754629124936444122843118055706252253099463393473802518363989430955476296412713569660919619346846287050031967219079283379371982179475331351180676850316480923612843063670221492520841649469839691711425409965721272803880205396716527258248613465269182675039055965728267714834218146604131070697050035414285666112493815538051150077642431887363704371988066099418960634098618638462715333172965774724821969116693268040267277814162178224754076427686143924953663821419082938398179004138428079999099795086963773235443135512644254456755455484183769568248126517",
                "r": {
                    "codigo": "77817306548649534964657604646528331475274954783537816321078654710433118782259165423707503504749761340340683516491478085067491481212351726168032288636412669012430462439715498773706352645189398384169438794551946449612310560107003342591907228223912795152388336064119335728480656473934502582043358475971816917205870755637508198751179472187927719874981872028671079011576534531499918130408338567566829925647438062516632369126112933518179590448203159587338345116555203325745240711205260653560198723237613260080096617921311750049773564348145887149507995200290642658140014127849403602234119374930582030243016220836988785748210",
                    "first_user_approval_did": "384901452384513081023453460679014535564385391647798526437625701270162051331706043117594824177342667741056529936232353830727447163172559133459335920295636853313371417661137116545007085547366678995840721301359884373742490543707510495480790286114302712462455589494291174548398600636747006947872365673176941628656054411947918922418869423914814997795002269883418897691993622163781887636679688285100098762090036009143337590370690393872610987382838641041957318532497439209204958966457484919235443545472237330446545746252024812060581212126262338426171637686716995589583620088274775670178908018079422522219635588234611784509",
                    "master_secret": "81068502063840180320741074287906342543066681492620931450052491621732172194335348147008386419344368715569934655546242506895767888038584542979256597551262789656277827574295200747121137618608474555341285956626018554958296531200733383691408878725586893553643865674542888944749888613820957252358913841108334724015407887220439435243473820099357742585381819060146664353782556070228374281217851773218373481446849227404348736589966775390145852652183646921017461814146947628161797432921543759003294668132044659050119305185855913513921197232121257678830761378709935258794232279170242473754467191437715593342674001392685033193794",
                    "nombre": "56564082360321401174322417318224565332137922170165451581597752645392521885870184917204920004118802994562843023560417187680525409882456236587673934846877768777199500103855762167848063320030625777430614007189667776149877989836641529396943443514272872564555015923301040044658163395537423931233642434950634299962603449098098818126403527867428584248119402622538104047631507595457098143469160334326123436992275174769315471259117233927959876492402389453565288307019478442635743703896480580402861092754498280875793229979329341447657771507422025327622092055197419860974454523205910355593867584986246363260282531337281676793491",
                    "organization_did": "74899935378718944225677848839884335012111378948985015496762544471888033974270547589113991633535973126327329814277788790948434314438231641471331884661213528602615811557141738364853570574223344350088619877830486416101458230567718116114215656684394440136049648931170659984460754247230461493096378581471192072170388858573417277123886312354262483127937403754694858588460383672140110402187709391829034522049039006592593736054436190154967830450996645446351632748263577745729816194354763565454686659832819328289881169088902243386915920828612763749218569228108689615286684563087321268625375752451676754219994921630526320203476",
                    "second_user_approval_did": "89119359902571208030477407091536952123967779930589362112667306028903075751373766454398071862082997438772474017794013371240677512679500869341895799567663068078521267419965895858373953860879647715955445898200932327173266279475993955169239937764491733655589713972003156629820768853933396265084804500417473440680977037907787836687381227950999759863611023819934983323762751137271632765089287524211847780886994147394428053839235628668993765050763392704234752115503722513934641902436865635425231562129248342900089210925398432689711852670912182650883673124222838105654417490386113188985500801951496785800582743829588068907047",
                },
                "rctxt": "55547577127438452265999702988403173852746410863821639817686336079827589263493913120270701258855524914528308109700621574592392602314295356183113041445284938138034569935576573259819114834782964857977382395287420488028136585682257950683908415155172282405919061674426279404033026475575266286298592744120897737265495085570022313613602512862724115564775639676766370968468135181898956237168424857364482828066846065626379464086895703289263133463139052074535468896626368295979227303228929533876243931297370520779853391301535635730515106839625918686618833229258361549523072827169051454870773288344997544238354671312123446595072",
                "s": "76390640419992943357387572917900898435678229255627168485796009046041444552924973855414926188853070419104084147556871783111646804667947793179269848356207708256916960811483515023101091196431618938254921768709340219038096287590606545670154994184316979207153302903153178050396002360076849204120423298892878360003672100994708647647917295298682518440979873684387308281835117444201027818850637617521716647611865785494687167981676381951451652957380673960004108264169883362799934962785023366929163087551374986121037560891329467151316116696669178867317314984235577675774978649604926672390555790902478998274813041084228870108873",
                "z": "61045765676410000482097344755537720120654736675041635423599566923209517703349841897383346627436576448338376802479852357173131386445010272306227443795009060661051658092981601448476716067337100738642200234810775085678513549725669008108236620735588819625211643346883386904560923354128473293459231989623557344378160673531493684921954207398963165225114647217866746760601743246098299506327232318935202330671228079044639582315169397789100837576948787308107676091229832990695040809784770294223134972610136425448955990141256448736380191702953097163518870012238820870246537689784095307756867782192952273049396153702731638708090",
            },
            "revocation": {
                "g": "1 033139FA1575A54B8439D4BA2703F035336D28037612E50EF050647A574DA757 1 17E1CB296818C6215C4A99257AE52BA5465F62997701C9DBB8AA9C069AF7F9B0 2 095E45DDF417D05FB10933FFC63D474548B7FFFF7888802F07FFFFFF7D07A8A8",
                "g_dash": "1 1EE383F16B2F27DD44CFEADEE7FAB0CD50EFD2A194E9B116B0D89ED6ACD9E342 1 19DFF4801228D80AC56B5EB6172B96AAC3B0C470C98991E81841E0D49A21CC38 1 051CEDF98F814E8213FE85F9FA28BAC1826DE1F32DD9A031FDFECE286B624E64 1 06550C3D4EF014887D36D203B99AB7CD558630DA94687F007C092438E8991398 2 095E45DDF417D05FB10933FFC63D474548B7FFFF7888802F07FFFFFF7D07A8A8 1 0000000000000000000000000000000000000000000000000000000000000000",
                "h": "1 1C7B7FA206065061BDEA6B421D575985801C432BE94885958AF9E3E4C8388819 1 03A5D07D9E32DB3CCAA55FDF36C2525684ABE4F0EFFC6C4FA1DF1246B716748A 2 095E45DDF417D05FB10933FFC63D474548B7FFFF7888802F07FFFFFF7D07A8A8",
                "h0": "1 0058F2F874D7B5CBE24C8CE56471346B1900B2DCABA0AD58FC976E725A8B6310 1 0E5576E1F0B1D2B1AE5057BD30F0F47AB2FFC6A89DD7EA407C6069AC8100651C 2 095E45DDF417D05FB10933FFC63D474548B7FFFF7888802F07FFFFFF7D07A8A8",
                "h1": "1 21C75A1436336A5DD2870614F9EA1516686BDEEC105EDC1EDF7666AD34FE6E6B 1 19B2C0A16F9CC44AD050844400ABB8BFCEE49F2DDF4E05E58323767D6E096EC7 2 095E45DDF417D05FB10933FFC63D474548B7FFFF7888802F07FFFFFF7D07A8A8",
                "h2": "1 2309419416526C6255383D3C9FFB7C37D35975F15F5AD6304310BB8BE65C1A61 1 0D287AA25D7A118E7D9991F8022945B43AACC2F1CEB47A8CB338B31E44D1CA35 2 095E45DDF417D05FB10933FFC63D474548B7FFFF7888802F07FFFFFF7D07A8A8",
                "h_cap": "1 183DD9C36D3F66ECFA6EF7E3CF4331FF1EC80BE8EAEFB45F38E77E1E4DC873C5 1 1CFFF20D54ED8E75279D5498638B197CF12E90ED1B0CB81AC631CF68399FF20C 1 2349DFB2FC8743C36CF8609D960FE092E1F8D2D502808F1FD8B7F108ECAD598A 1 0F988ECDA1A09A1B36F711D6132A749D1BFAAEDFAC161E9C088822DB89C6185E 2 095E45DDF417D05FB10933FFC63D474548B7FFFF7888802F07FFFFFF7D07A8A8 1 0000000000000000000000000000000000000000000000000000000000000000",
                "htilde": "1 1B2D30224CA334957A61805D1826C185AB3120F4CD05162EF6EDC3D507BFF332 1 24CD57DFD210EF8EC056864C4970A0D980B29E7235692B80200B0C425FA6260C 2 095E45DDF417D05FB10933FFC63D474548B7FFFF7888802F07FFFFFF7D07A8A8",
                "pk": "1 14B3128654FA6FA490C8E07D7189AF655DB903C356C81271CE0FE2CA1D6434DF 1 212D406D3CCE907AB00EEA9F192431564604CFD13EE9DC597ACA45353616F545 2 095E45DDF417D05FB10933FFC63D474548B7FFFF7888802F07FFFFFF7D07A8A8",
                "u": "1 1397CFD01CBADE79023FD996C3C253E65D6FF70B8746D3BDFF712C69AA7A5A52 1 111BC0EF91F9BB4B8ACE2562B87A02F31F031C1A115B6E14AEE11FDB65DF1628 1 02F32E65B7F0BD4B532D203DA415B34BF2E38358F2665D27F01A61899AA887AD 1 218A71DD9CB509655AE744D159570E7371C6B28F103F3BCE1FC5B74B14BED098 2 095E45DDF417D05FB10933FFC63D474548B7FFFF7888802F07FFFFFF7D07A8A8 1 0000000000000000000000000000000000000000000000000000000000000000",
                "y": "1 00BF5D14ED0BEC12C8D0F95B8DB1DE5B22BA995C8823F10A59B957E2B03250EA 1 007FDEB4F6BF33271BDDD19ACA54EAC0C8F7FAD9E45CF29FB695530F26178665 1 2231CB929DDE775B5CA2001E5A7D9F75EB07968A5FC2796A02FE1946397D1F74 1 1840253E7AD8098184E480DBA2BF179BE2EDF8F1D94E13069D833607CD7F739F 2 095E45DDF417D05FB10933FFC63D474548B7FFFF7888802F07FFFFFF7D07A8A8 1 0000000000000000000000000000000000000000000000000000000000000000",
            },
        },
        "signature_type": "CL",
        "origin": "2VkbBskPNNyWrLrZq7DBhk",
        "ref": 10,
        "tag": "some_tag",
    },
}
GET_REVOC_REG_DEF_REPLY_A = {
    "op": "REPLY",
    "result": {
        "type": "115",
        "reqId": 1632558557551332200,
        "state_proof": {
            "proof_nodes": r"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",
            "root_hash": "GxYME9tsA7DJmG6gxFQnZEbYJPJHMGPxkyC3WgLjenhr",
            "multi_signature": {
                "value": {
                    "txn_root_hash": "AEDjpftVLdQ52ndRNgTdi58WWY8qyRgJEbYKYFPoGvFX",
                    "timestamp": 1632558557,
                    "ledger_id": 1,
                    "pool_state_root_hash": "NCGqbfRWDWtLB2bDuL6TC5BhrRdQMc5MyKdXQqXii44",
                    "state_root_hash": "GxYME9tsA7DJmG6gxFQnZEbYJPJHMGPxkyC3WgLjenhr",
                },
                "participants": ["Node2", "Node4", "Node1"],
                "signature": "Qw9q7HGDwmDck9MhFvja62PsyZ6pyxifr4EL4P2fKPo232EGwT7xQ9dFaHf5eBxZ2mfshUFJT1HQwAaG3Ne41shxiUxp35uLqrMhpWcSpj1G8yDwqk3RA5u8TuwqEyjHqeonEKbWeGuc9E6cAsUuVPghssoUkVUjiVBSG6Kfpdozas",
            },
        },
        "txnTime": 1632558551,
        "identifier": "GjZWsBLgZCR18aL468JAT7w9CZRiBnpxUPPgyQxh4voa",
        "seqNo": 370,
        "data": {
            "credDefId": "BbJuU6tHXex38bxRhELMpZ:3:CL:368:tag1",
            "revocDefType": "CL_ACCUM",
            "value": {
                "publicKeys": {
                    "accumKey": {
                        "z": "1 19D4909A597523ECC28DA2535C4CED69853EA7C1E8483FABC5CA57234FB51E50 1 1A58E6DFD101593948B03D189E08C73F89D4B6FE65B923C803CA1DDAF096D520 1 0377CF7C3897CD438CE001F4616FFE509A9A858171B8CA9A246B4322BFF3D9CA 1 1DF56890540BBFF09AA5533F6422EE9D3BC56DF1C9667ADF83FBF4E45B0DDF42 1 03105813667B3EDC4FA8368701E8DA309F8673B399772B6889A5CE1F15E7DC7F 1 219CADBD62B6C4AE3C68AC3CC32B694B628C22EF8D1510152E13E65D0BFE53DA 1 0015CA9A6EBF05D4B869B2670D50D61E2B8E153ECBB08CAA80696B30D7B00508 1 1CAA9EB636CB022D63218A9126B40E54C08509A22CA9361554EF625838B184A0 1 0315415749915804B98FB88E17FE7E09B89CB0D4AF92005F2B2964BEFDC6BB0B 1 1A2A1540DD1BB9DD1017D3485BD5EAFF8EC7C6730CB908BA6DC430C13178738C 1 14A5039C3F462AAD8C43C77C02798A4717C2E24173A857C50FBEB993E2EB4EF8 1 10FA884F5FA72E1671892E3F5C96250C6AEDFAAFBCF8106EC0F3A295A4E72296"
                    }
                },
                "maxCredNum": 16,
                "tailsLocation": "/home/shaan/.indy_client/tails/FTGNPmvebq4Kegk5uunDKZSoiohKZCpFqNDgosZ6iC5Z",
                "issuanceType": "ISSUANCE_ON_DEMAND",
                "tailsHash": "FTGNPmvebq4Kegk5uunDKZSoiohKZCpFqNDgosZ6iC5Z",
            },
            "tag": "tag1",
            "id": "BbJuU6tHXex38bxRhELMpZ:4:BbJuU6tHXex38bxRhELMpZ:3:CL:368:tag1:CL_ACCUM:tag1",
        },
        "id": "BbJuU6tHXex38bxRhELMpZ:4:BbJuU6tHXex38bxRhELMpZ:3:CL:368:tag1:CL_ACCUM:tag1",
    },
}
GET_REVOC_REG_DEF_REPLY_B = {
    "op": "REPLY",
    "result": {
        "type": "115",
        "reqId": 1632558692947869200,
        "state_proof": {
            "proof_nodes": r"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",
            "root_hash": "D6bik2u1PqTXfinfCDRtBesQufxTkDhcgHv6YkHwhKqV",
            "multi_signature": {
                "value": {
                    "txn_root_hash": "4nAzsTEHFLY37MhkroxNrQtqp3keu2xctYSsF3LW1oLq",
                    "timestamp": 1632558690,
                    "ledger_id": 1,
                    "pool_state_root_hash": "NCGqbfRWDWtLB2bDuL6TC5BhrRdQMc5MyKdXQqXii44",
                    "state_root_hash": "D6bik2u1PqTXfinfCDRtBesQufxTkDhcgHv6YkHwhKqV",
                },
                "participants": ["Node3", "Node2", "Node4"],
                "signature": "RNDa6r8TJrNkrfuSsj4DhXFscRTvV5JVZ5LtLCKKuJ2rgGQMS68HB15zCn6bscFdTMkskwd1Fu172oa8ub6dc5xGKr5s2mMDFkGHL3WiML4oeUvMn8eZ4Fz99SXySK8g8DbX7SrVRbnJyBuiLbSXY1rwtGH9XvRKfAVNbbqpV3vG6T",
            },
        },
        "txnTime": 1632558675,
        "identifier": "2PRyVHmkXQnQzJQKxHxnXC",
        "seqNo": 383,
        "data": {
            "credDefId": "UZxtsd7WJ33bSVDkncPhbg:3:CL:381:tag1",
            "revocDefType": "CL_ACCUM",
            "value": {
                "publicKeys": {
                    "accumKey": {
                        "z": "1 170BFB9EBADDA2CDB851BB30BE728FB7ADF7E3CD5B2F99AB2F9335A853D6328E 1 1447A7743E683AF7BD74984F23BC4A05DFCAE20322AFAE3179B004E715CEBAD0 1 1EC80064039BAC87EF9ED8BEA39D10ABCBA5CEFE5B06C530F0F0B80E53DBFAA4 1 0027C5DCCD96E3AD427D6F7A5E016D1947BAC13A887FFD4E779E9999BAACA710 1 04E0A478CC77F0CD31871E26AD3A71B41925D72578DF21A8DBAA80CA6D4ACBA0 1 0573FEA96B162577E82B15B4736F8BD3EA559714E271B2FC102BC45D03E80E53 1 1A2F0FD7E97CE7E31154993777FFD6BF5349BD871AD57713DFDFDF153F31D076 1 1371E752004B3AAACCFB77F10D7EF2E1D4184784947C52F014C7718C88F3B2BA 1 0385FBDD842EFE7AE551843E62FB26AF40973DAE333735501E8201DBF7D52ED6 1 1FDAF29E63E26B21AE55A79EC696A2D3D64F3883C7514B78BA5D7EDF5868D652 1 097F9EA0F0070AE36228E94106F9F99B9A26C077EEEA49E0761F450861F09D78 1 1747E08E1CEBC6A835A18FED5F0DA02D6C3102A4A855954C01C0863DD3B588BD"
                    }
                },
                "maxCredNum": 16,
                "tailsLocation": "/home/shaan/.indy_client/tails/DrdrRqtLXeGM3qBqPYL8Xnutsz7VfTZAbAsqD8r16zAa",
                "issuanceType": "ISSUANCE_ON_DEMAND",
                "tailsHash": "DrdrRqtLXeGM3qBqPYL8Xnutsz7VfTZAbAsqD8r16zAa",
            },
            "tag": "tag1",
            "id": "UZxtsd7WJ33bSVDkncPhbg:4:UZxtsd7WJ33bSVDkncPhbg:3:CL:381:tag1:CL_ACCUM:tag1",
        },
        "id": "UZxtsd7WJ33bSVDkncPhbg:4:UZxtsd7WJ33bSVDkncPhbg:3:CL:381:tag1:CL_ACCUM:tag1",
    },
}
GET_REVOC_REG_REPLY_A = {
    "result": {
        "identifier": "2PRyVHmkXQnQzJQKxHxnXC",
        "reqId": 1632557041908469400,
        "data": {
            "seqNo": 256,
            "value": {
                "accum": "21 125798F3C7741D1000FC7C73E77590E07CD7506620B1C809A3AEEA3BFD53E617B 21 13B3555A2847CEBC534A318292717B438D6220910E92E83C99CE57FEDBECDB832 6 5A69F6ACBB535F55F36B45C965BE9901042521BB2362AB87365B1FCB5B4D234C 4 34399006361DD42863054774B9E3947D86D9DD42A1323D92501C80D0BD9F84F0 6 595D71802C6CD0069C354B7CEF18CC53DC1D14096B0C386AAC5DFDD146A72D5A 4 03FD00736B09E9DB8E0061E6185830C09881AA69A4F4026AC82A059A27FFF99B"
            },
            "revocDefType": "CL_ACCUM",
            "revocRegDefId": "GUTK6XARozQCWxqzPSUr4g:4:GUTK6XARozQCWxqzPSUr4g:3:CL:249:tag1:CL_ACCUM:tag1",
            "txnTime": 1632557039,
        },
        "seqNo": 256,
        "revocRegDefId": "GUTK6XARozQCWxqzPSUr4g:4:GUTK6XARozQCWxqzPSUr4g:3:CL:249:tag1:CL_ACCUM:tag1",
        "type": "116",
        "timestamp": 1632557039,
        "state_proof": {
            "root_hash": "A5FT4MFfTxxoUsbgGDKLpYCd9CNhFb6iBuP2QCCtxosv",
            "proof_nodes": r"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",
            "multi_signature": {
                "value": {
                    "txn_root_hash": "4NVqX2SZkr3iRbvV4147gWbd7KWTXW7cuDF1Cf5KRft6",
                    "state_root_hash": "A5FT4MFfTxxoUsbgGDKLpYCd9CNhFb6iBuP2QCCtxosv",
                    "timestamp": 1632557039,
                    "pool_state_root_hash": "NCGqbfRWDWtLB2bDuL6TC5BhrRdQMc5MyKdXQqXii44",
                    "ledger_id": 1,
                },
                "participants": ["Node1", "Node4", "Node2"],
                "signature": "Rb1J2dbyCbUNKTwXqMGriPQNjsCXnZ389MhUFjxpaXkWETFViYip5hcsmaqf1nBwynNrwscgrnqrvLdUuSkSFTh1T44XKWEbxRuNkqEfrwzHN8gJRfgC76ZJ6LauouFxupfTKDVAQmp5VFNhheLWMcb3kYDsradM53JFTLEpSQiy7D",
            },
        },
        "txnTime": 1632557039,
    },
    "op": "REPLY",
}
GET_REVOC_REG_REPLY_B = {
    "op": "REPLY",
    "result": {
        "revocRegDefId": "72u1sXrVKn1tfa4kYr7sTV:4:72u1sXrVKn1tfa4kYr7sTV:3:CL:265:tag1:CL_ACCUM:tag1",
        "reqId": 1632557306220425900,
        "state_proof": {
            "proof_nodes": r"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",
            "root_hash": "BVYp58aLvRurnM8DSScnRpiKvX27RKSFqRFpYZpn3KiQ",
            "multi_signature": {
                "value": {
                    "ledger_id": 1,
                    "state_root_hash": "BVYp58aLvRurnM8DSScnRpiKvX27RKSFqRFpYZpn3KiQ",
                    "txn_root_hash": "Bxz5VGY3eipuFtNUhf6bY8kbwbxVUXDDqQBtqT15xTwM",
                    "timestamp": 1632557304,
                    "pool_state_root_hash": "NCGqbfRWDWtLB2bDuL6TC5BhrRdQMc5MyKdXQqXii44",
                },
                "participants": ["Node2", "Node1", "Node3"],
                "signature": "QuJsPA4W2E7yxX3mPPFTFG1nAGUn6daEbFiQy3q9rnCCn1foSCWTUp6RJiL3BCrp1EP1STdoXtsp7hySj6M3EA9SpJsCFDVyr5o7dzeumfP2zLseiaH5vK6c8pDnnvCbdEqvC3jiNKQ9rnaY3fUfRPcjha3MExsXLRRv5iWUron1vw",
            },
        },
        "txnTime": 1632557304,
        "timestamp": 1632557304,
        "seqNo": 273,
        "type": "116",
        "identifier": "2PRyVHmkXQnQzJQKxHxnXC",
        "data": {
            "revocRegDefId": "72u1sXrVKn1tfa4kYr7sTV:4:72u1sXrVKn1tfa4kYr7sTV:3:CL:265:tag1:CL_ACCUM:tag1",
            "value": {
                "accum": "21 13382ADAAE15B1F914D3B6B64295644521F907311790B0DF203C1BFC504F1C2EF 21 12BB5577087D3DC762228291D3F4BED0B7AE4C9BB481F253D27A30E3991509AE8 6 710C29F477F751B6E303BDF2E3A9DF07536A276F6F90A9E5CE14D39399CD1DB9 4 07928F4F6FEA02EC889B9C3152CEDC83C246C6A2FAAF7DF366D154B5CA544A93 6 71A3639FF85431716F5B6DED6E63560CD52150567C7F7F8B4D164373877B940E 4 1B911F7D7BDBB636A6B4140D6E304E7C8DCFED3466F1E36B4B04DD53105CF887"
            },
            "txnTime": 1632557304,
            "revocDefType": "CL_ACCUM",
            "seqNo": 273,
        },
    },
}
GET_REVOC_REG_DELTA_REPLY_A = {
    "result": {
        "to": 1632557591,
        "revocRegDefId": "KkA2eXVuUnbrcAYLXgQBhj:4:KkA2eXVuUnbrcAYLXgQBhj:3:CL:282:tag1:CL_ACCUM:tag1",
        "identifier": "GjZWsBLgZCR18aL468JAT7w9CZRiBnpxUPPgyQxh4voa",
        "seqNo": 289,
        "data": {
            "revocRegDefId": "KkA2eXVuUnbrcAYLXgQBhj:4:KkA2eXVuUnbrcAYLXgQBhj:3:CL:282:tag1:CL_ACCUM:tag1",
            "value": {
                "accum_to": {
                    "value": {
                        "revoked": [],
                        "prevAccum": "21 132752A4834056B17A4C9CF7EDE475E35E6CC4805A4DE635821933A9EFFD2800B 21 142DE001C8FB399E5F1A161D394BDCB515C4AA05057E674B5261938F7D8A58F86 6 62802355EA27DA8444332B041BF03994AD3320AC7A11CD7C0F7EF64767A43D64 4 0DEB2EB3075B3657A43857E53E01BF996D032292A9D3AD5343E7C277559B6740 6 5EB11809A3586A7A4AB93E5A67FF1145972F28F2FF1CB4777A49B7AB7C525CD8 4 1EB6F3CAB8D3BA3390F9130534CF97F2345AF330FA770B82A09C2C827E48E8A6",
                        "accum": "21 1354C75FB770C1F6952B08F3F6EAC48E9A456D65D1F6E4DE34EEF0EDF359CCB58 21 127CC02A5BD0936DACDE07F63875350C9A6707708253C0BC047A6D105F0900C26 6 88F617D8F807EAFE94C03506FDA3D0AA4D07B7E5297E057C32A350DDEC38C23D 4 313C36AE4190E23ECA3533BAFBE71411612CF17FE0F821512E70B8D2CDD4ED90 6 90830FCE44C7945DC2ECCE1098701917DD177E574158759277560DD6BB7A7FD1 4 1B699F8633EC6EA2DB4822A18937C6902CF8906D17B3B033E270062DD8300000",
                        "issued": [1, 2, 3, 4],
                    },
                    "revocRegDefId": "KkA2eXVuUnbrcAYLXgQBhj:4:KkA2eXVuUnbrcAYLXgQBhj:3:CL:282:tag1:CL_ACCUM:tag1",
                    "txnTime": 1632557589,
                    "seqNo": 289,
                    "revocDefType": "CL_ACCUM",
                },
                "revoked": [],
                "issued": [1, 2, 3, 4],
            },
            "revocDefType": "CL_ACCUM",
        },
        "type": "117",
        "txnTime": 1632557589,
        "state_proof": {
            "multi_signature": {
                "signature": "RMjCa7rQZGZ6ocaEYBGoT4k8W8mzVemxhtuLgeEm83UxhGExgEc4GF1zXG2mLnVDVLiCutRLEXNQ7b7szmhd4FWHK5MRXAgFoCCKgbsk6p7sqeW2bsPmXtVASyksgq3vVMh8jBuCN5g5ryL2vKExaYsrfFujhf3xZL7w4juYzAo9k3",
                "value": {
                    "timestamp": 1632557589,
                    "ledger_id": 1,
                    "txn_root_hash": "F5yJ6fRmeDxcvZvT9EGjhHu2LjjFTuiPgta7uSWEm4Qi",
                    "pool_state_root_hash": "NCGqbfRWDWtLB2bDuL6TC5BhrRdQMc5MyKdXQqXii44",
                    "state_root_hash": "DRyobLjvctGyUX39Y7ZYJiyfdk6NAALpCfRWQ7eUoVTg",
                },
                "participants": ["Node1", "Node3", "Node2"],
            },
            "root_hash": "DRyobLjvctGyUX39Y7ZYJiyfdk6NAALpCfRWQ7eUoVTg",
            "proof_nodes": r"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",
        },
        "reqId": 1632557591169735900,
    },
    "op": "REPLY",
}
GET_REVOC_REG_DELTA_REPLY_B = {
    "op": "REPLY",
    "result": {
        "revocRegDefId": "EKimXGooGt9o5GrPxeWqqD:4:EKimXGooGt9o5GrPxeWqqD:3:CL:298:tag1:CL_ACCUM:tag1",
        "from": 1632557772,
        "reqId": 1632557777495066800,
        "state_proof": {
            "proof_nodes": r"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",
            "root_hash": "Hc1ASwAU28iKXoTwgPLySzZsxcrB6RXm8b6km7LsMab",
            "multi_signature": {
                "value": {
                    "ledger_id": 1,
                    "state_root_hash": "Hc1ASwAU28iKXoTwgPLySzZsxcrB6RXm8b6km7LsMab",
                    "txn_root_hash": "HcKCAfN7ZmhoXgJwDokJcKTNtriQybUCuvr4u9TeBdhL",
                    "timestamp": 1632557775,
                    "pool_state_root_hash": "NCGqbfRWDWtLB2bDuL6TC5BhrRdQMc5MyKdXQqXii44",
                },
                "participants": ["Node4", "Node2", "Node3"],
                "signature": "R1ftxrdsmR5ZkuT9p3v44HMt7ET2SzkuxwY632EU3B9CEUKdamKkCuyFqbNF99s9Cit6x5TVufHnNPHiVXJD3YShBaFTrECpmXZjBkc2aEEPNZiBk1SSMnFJuWPmsL3hZy8EMVxGbBkyFyjFR3hhg8QbPfsTGKt7YiWf51WTdjvnw9",
            },
        },
        "txnTime": 1632557775,
        "to": 1632557777,
        "seqNo": 306,
        "type": "117",
        "identifier": "GjZWsBLgZCR18aL468JAT7w9CZRiBnpxUPPgyQxh4voa",
        "data": {
            "revocRegDefId": "EKimXGooGt9o5GrPxeWqqD:4:EKimXGooGt9o5GrPxeWqqD:3:CL:298:tag1:CL_ACCUM:tag1",
            "stateProofFrom": {
                "proof_nodes": r"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",
                "root_hash": "Di5KHhwYEvJPysprH4RkyaHFBvfkSuFTd5fQBGrvcKfE",
                "multi_signature": {
                    "value": {
                        "ledger_id": 1,
                        "state_root_hash": "Di5KHhwYEvJPysprH4RkyaHFBvfkSuFTd5fQBGrvcKfE",
                        "txn_root_hash": "CPsx5Mv6DG7Keg7AjTzf5GNvWhMHgm1V1PY1ATMft6Hj",
                        "timestamp": 1632557772,
                        "pool_state_root_hash": "NCGqbfRWDWtLB2bDuL6TC5BhrRdQMc5MyKdXQqXii44",
                    },
                    "participants": ["Node1", "Node4", "Node2"],
                    "signature": "QpgqdTZ7zLRxaZfBsb4j3hGgtSYUyuTP8cknmcjRKSbWaqzohRCsDoHggLmvJ1XBv3aetqt8koJAFw4zeVnVyEKn8qY1FWjJSmqMkUEwT93UXxY3HFNRZzimKTJ9jXW7dkNNuodcrNgJV7aL4GmSHuhvu2Qeujp8GKybpEdr9dugNb",
                },
            },
            "value": {
                "revoked": [1],
                "issued": [],
                "accum_to": {
                    "revocRegDefId": "EKimXGooGt9o5GrPxeWqqD:4:EKimXGooGt9o5GrPxeWqqD:3:CL:298:tag1:CL_ACCUM:tag1",
                    "value": {
                        "accum": "21 138ADC9FC017D4F9F8DA39848519A9D448763870F8AE1677FD51A216312F984C6 21 131E29F8529649AFB4B71384B7F00E77E0495CAA1A0DA2BD9F2ECDB1FDE71DB53 6 82BB005163E67191ADECF36FF0E4B7DBA1A271FFA01EE0CE7C1EA1A22A1DB84A 4 073A1509E93BB4643107EEFEAEABC88E5C5F1B35D1E39D9F31FCDA661CCFAF7C 6 8123FD46B42A8E949D5D74883D32417322728E3A61C961D7301AD2D29910073D 4 37DE07A51B426F4655ACB7B916580749909A7F9D65761146C68ED2DB5D296977"
                    },
                    "txnTime": 1632557775,
                    "revocDefType": "CL_ACCUM",
                    "seqNo": 306,
                },
                "accum_from": {
                    "revocRegDefId": "EKimXGooGt9o5GrPxeWqqD:4:EKimXGooGt9o5GrPxeWqqD:3:CL:298:tag1:CL_ACCUM:tag1",
                    "value": {
                        "accum": "21 12C0DF33880530F3C62977639E6CEB014A0329B3644AA0108A88BDDD9DAF20CFF 21 12626BC396342AD135E5C9650D2A7A43A9BDF28430DB1189156DA90A4C6C037DB 6 596AB3130CFB484CE1D0C93668833F79D610AFBC2F2A63C16FFDF4B04D7CC11C 4 09F9AA0039312B9193DFB5AEAF07F8D9FAA75E25CB5C2D4725E863F7BE4D79E4 6 7B30FFAC4B1FB82CC9C49226AF9C00320109146185A8EF68D695FA3AC105F172 4 330FB4CB1686319018D4F003C1B32967E553021B56AEADE0A75850E1964A7CA3"
                    },
                    "txnTime": 1632557772,
                    "revocDefType": "CL_ACCUM",
                    "seqNo": 305,
                },
            },
            "revocDefType": "CL_ACCUM",
        },
    },
}
GET_REVOC_REG_DELTA_REPLY_C = {
    "op": "REPLY",
    "result": {
        "revocRegDefId": "EBibQo1zAo6mt6rPEtuoSR:4:EBibQo1zAo6mt6rPEtuoSR:3:CL:315:tag1:CL_ACCUM:tag1",
        "reqId": 1632557963805207500,
        "state_proof": {
            "proof_nodes": r"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",
            "root_hash": "7PLYsQCFkkNaeP8ybJvxaVArt1ygXMVMfeVGqqNJFF91",
            "multi_signature": {
                "value": {
                    "ledger_id": 1,
                    "state_root_hash": "7PLYsQCFkkNaeP8ybJvxaVArt1ygXMVMfeVGqqNJFF91",
                    "txn_root_hash": "GXGyAdyC5BBxQSjFZa5QJtyJD4N2b6FaQHX5xGgntYyg",
                    "timestamp": 1632557961,
                    "pool_state_root_hash": "NCGqbfRWDWtLB2bDuL6TC5BhrRdQMc5MyKdXQqXii44",
                },
                "participants": ["Node4", "Node1", "Node3"],
                "signature": "R5pstaiNyfkERd92bmSEBqFc17pK1NNhQDt43HSnEW8vwijqFuQEKHQEYy6ktoPJfyisKMtgMoeX1GhpfGM55zt9S8wPLvvHhmhorerJpDffStMSg2UjkJZymADtgqVWP1SkAdUkwKfAMv8EarKztTvQc31qQqX2tc5LqvephJs6d5",
            },
        },
        "txnTime": 1632557961,
        "to": 1632557963,
        "seqNo": 323,
        "type": "117",
        "identifier": "GjZWsBLgZCR18aL468JAT7w9CZRiBnpxUPPgyQxh4voa",
        "data": {
            "revocRegDefId": "EBibQo1zAo6mt6rPEtuoSR:4:EBibQo1zAo6mt6rPEtuoSR:3:CL:315:tag1:CL_ACCUM:tag1",
            "value": {
                "revoked": [],
                "issued": [2, 3, 4],
                "accum_to": {
                    "revocRegDefId": "EBibQo1zAo6mt6rPEtuoSR:4:EBibQo1zAo6mt6rPEtuoSR:3:CL:315:tag1:CL_ACCUM:tag1",
                    "value": {
                        "revoked": [],
                        "prevAccum": "21 134F30F8EFB0EC9B6EFB6C34C7120513EB607CF70ED6AAECF39A45E387C77F4EF 21 11C7569BE54188752DA7B91EC2D6212BB4F354EB9EE3EC0D4093366B97DAF43E4 6 6B62F3232E73F90673B3BD4E14B5CC3AFD1F2F4BF2B700248671CAE62AEB0CDD 4 2C693E7376B584BFBC62BAAA58F7F00A037534479C4B19CB1ED3074C5993E7FB 6 851C540F2A4903A1642BD8FF37BF74CCA1BF5E2B5DA33C1AF2642FE53DD03E93 4 3495FD2E8E8F00B7B31AD71184D704339DEFC9ACABA9CF01E6DFE654EA270727",
                        "issued": [2, 3, 4],
                        "accum": "21 13806E104594D5EB31B53D37C5377A4ABAC0ED96EBD3B357B3DA0255A38654194 21 1179C83DD04FAED03B6E0EB0B897D9D764F7E9845780E6D41AAFF94E21BFAEEE4 6 6BD9507820E05B50AD9209844C3510D78B5C5DF7339B59A53FC1ACEA27EA0158 4 10324B3AF1819BDAF4E1C8556F0FFEBE86C3938D92A363210C27C8C8637A3A85 6 754293158879697A1C38BB43511165665F4144B529C4732196A366291DB54C51 4 352170479C0C261763B209BE2CBF14F9D9778AADB1E5BBCCA3FA3A54196FD118",
                    },
                    "txnTime": 1632557961,
                    "revocDefType": "CL_ACCUM",
                    "seqNo": 323,
                },
            },
            "revocDefType": "CL_ACCUM",
        },
    },
}
GET_SCHEMA_REPLY_A = {
    "result": {
        "data": {
            "attr_names": ["sex", "height", "name", "age"],
            "name": "test",
            "version": "1.0",
        },
        "dest": "Av63wJYM7xYR4AiygYq4c3",
        "identifier": "LibindyDid111111111111",
        "reqId": 1632343306375185900,
        "seqNo": 17983,
        "state_proof": {
            "multi_signature": {
                "participants": ["Node1", "Node3", "Node2"],
                "signature": "RBpjv3DjHyvvuAWH6CbQQcvEXPHrMZiDn4vmuT2h6q7bdL8o6wjgfBzwtkkoNHkcYfU9TWios8SinviphEvJXFhZvXjiNNP9eqmPxqJ8wc7pyCmd4GdPreA5DHbAiG56v4MDA2bQcsQhqiWZsjHQ1qFUbXkQpJevgTgg49efwaEhGb",
                "value": {
                    "ledger_id": 1,
                    "pool_state_root_hash": "7siDH8Qanh82UviK4zjBSfLXcoCvLaeGkrByi1ow9Tsm",
                    "state_root_hash": "7ASP7xJ2AqZJRGWKNAE8NtD5tspEYV91AokHujMpBsX1",
                    "timestamp": 1632343306,
                    "txn_root_hash": "9Ff1EwxJiU9ssJZ1QoPwdJxKhNREcKjRjyvA4jCp9gPg",
                },
            },
            "proof_nodes": r"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",
            "root_hash": "7ASP7xJ2AqZJRGWKNAE8NtD5tspEYV91AokHujMpBsX1",
        },
        "txnTime": 1632341500,
        "type": "107",
    },
    "op": "REPLY",
}
GET_SCHEMA_REPLY_B = {
    "result": {
        "state_proof": {
            "multi_signature": {
                "value": {
                    "state_root_hash": "81s3UgVN47doEdWzg897EssC5aCMZ5g2bHAFHXgJyUGe",
                    "pool_state_root_hash": "DuhjUiR6QDsT4X3KFTGHgPnaCCTTVMhmmA8uRwkkhDwA",
                    "txn_root_hash": "49dVmci81excka4Ff17uUPY6NyK5Fkyb7mxKQxHXGUXT",
                    "timestamp": 1526055830,
                    "ledger_id": 1,
                },
                "signature": "R5DPg3mctNrPwbzb7qCbo5LkTC2nnLj1jvuRSZDypD4FdFoH5eHp3v5vYvQaLkGfPnG9bmPwXgdhwrybsrTm9RvXj15MYxcfnBDACCjFCeAxjEKaWU6ebyJKi8UsGPiQzJVgVNaD6yvLNtvwzn6r9UhZ3wFVjWRu3M9sBfLZPCTE1m",
                "participants": ["Node1", "Node4", "Node3"],
            },
            "root_hash": "81s3UgVN47doEdWzg897EssC5aCMZ5g2bHAFHXgJyUGe",
            "proof_nodes": r"+QiL+FyFIC40LjS4VPhSuFB7ImxzbiI6MjQ3MSwibHV0IjoxNTI2MDU1ODMwLCJ2YWwiOnsiYXR0cl9uYW1lcyI6WyJhZ2UiLCJoZWlnaHQiLCJuYW1lIiwic2V4Il19feIWoKS+yLqQrrlh0AHdXeEgErYxfmhpVzaJ+U4XV9IhNgFz+DmXAIb3F2Y3d1cFJUVU5rWG42QXJZenM6Cg0ey22y1Sw5R0Wr517KDVTtxr1h+dgvtZsXyDnQ5IEjL5AbGgT71lC6jsMTHl3Pa1Rj1nmP8643p6YpwARnmr8pcYPVSg0mYAZNq3qZ1kBfzZ4IkJ9JPoSY9sNt5pSiPy1Sesoy6giTaZI9nDaWnk1Z5+KCJl+Go7TXmmgTHqURkcvCaGJvmAoNyumIZbkdqKaRnLJHMvQHk66iXOKc0eO9fAg0S6IweyoKOlTCQeHHpiiRIqOWf+ZiyoE1RzGLYwYv\/ZT92bj5TUoDYsQFMS2a6ItdDw7pD7FMbhAFy50WgvpLtc5N3kUoPnoEFpsFh4\/nnPQ9a7uJuO1aOF\/0eLZZPbk61GqZrhuH1goPfPWQgWLjM3nhcoyL5\/2KsHiwGTaXLKfB7UvL5Yk3u9oAoTTzqKqJFLJXTlBzO3RoFrsMHHRV7XiX\/ZNGqkeZLdoP2ODKKueuDUgH+081Su3N5ByHvgMGaU9dg+JxJCH351oL8QgC6a78sPnRhjdbUStwqlPP4TOGrPyYC4FAYtN\/A9gKBH\/5JTxilhi+ZrkUrfkkO2KYas7GIQW+HUecA6Ng0sH4Cggh7qzc1C\/0n1Os53lZb9INU33xFXaUSGn9E8NKkFUoyA+FGAgKA8XWevrjMeCJVdfpqrFMz3kn4gCHY9zstqAaYG7QRex6Cug+aEkajVK5kcv41wZi\/8t5dMKsZLmiDeQEkYUiForYCAgICAgICAgICAgID5AXGgdHHcBnO5LERbEZl44uTuxdCRy3YCHcyvM\/iroJzNdACgz7b3Y6RqprH64dbOJiWxR13LjcOakD6+ZdicWWEXM8yg\/6deXgumdcqhse0H2bS5U411JnaRZBYIEMPp1xkFGtKgaNnmuK+WwSL9pcmIZFJI5osNECREaxf7K1eOEXc0RqKgTnhZ9UgjsuSSGru0N3GIAy8BMivi0gX\/AWH8qQDpstCgbNiTG4lUqf96EyWojSovUtrz+XUpH+8N2+QFCrKpIOygv2R1F2JXyEqh2AXalY2VldRciIPsr7EWFAabOG4RKzugyDzJ72wkDeDMP19UfN\/lfpDFo9XnSIV4iHHjgz3QU4igGQ0k1eP\/uLZvThw6V0SemmquhaNp77pRQoQwMEtkdVqgqy7KI1QOQoBZgJjBqJ\/i56QfzUF1gKUu6voQvyQf3fegLUg5S0QHBY4ldJxdLdWpVfksMNnDVoeIOk4YaoY9TsiAgICAgIDkggA6oEwv9bhu5R8nrnUt4Yx3+oB0SXXXuZBO3b28qAICCOSd7owXN0LWxpY2VuY2U6OgOFNinrJ5T+l1MMwSVWJf5WOoYjFNf\/XZ3zVKmxgUnHP4sYCAgKC0dldFCLyH+sCHRrFr5phR9NjdPw6AKv0zlZKTn3x2OaDTgNSzkxwEcmAnqqgFicXYnk+U1UR9Zr5GW\/kNcr\/QpaBSnbcCh57QsvePUsmWURFq3G2WYfLinvZvbN7djK1eJaAZ1CRb5ndo+3SSaqOyg0hBd1UVFWwvDv9WxWwXaoEz4qBt6QgRVzUf5A9QoRzs\/BqQN3HRYS9mbvGzr8i8gQBsvoCAgICAgICAgPhRgICAgICAoMmjsuJicY9FzZqlzDRPdp3\/d6e2ete+uTUuGlLZrfEkgICAgICAgKA+q5fnel\/\/ZFjKfWOn3PScO8k6Qdki79w+y2ZACYUTZoCA+FGAgICAgKC4hIGO4DPcaKYmRpzNYUAXu57xExF9yyxyGD03dg3nCoCAgKBrY\/1SacMf6LNQ\/VBpr9p\/hAkk1AY6XrpoAxZW4aaOrYCAgICAgID4kYCgj6RlWm2C5oUBN0vbyaI+Hxh7AzbmI1SYINZ8bGj7FHygSwYrTkPDB\/SU3Yi8+UJW60leF09Xf4NDHIxnkH+XR8egHPodFdkcnKxOiLXtlpOuzM\/THPYfTQ9xWanloSw8uU6g1iRB91Rq8zT7dTIl1FIPXg0ovtW\/gktKvMVp\/XNxoOOAgICAgICAgICAgID5AhGgZBqeju\/DK9w6gsSRyeuChMfPiz3O5CJOt05Cwx6+Zq6g\/qAj00WnUVvBv214PQY\/n6Hz3ge+kdXc7bRq2zC31cCgK9Hxi\/K6rqzGHb2hV1UhJwZV9RZh9kW\/ROGpoNzP26qgWiSIFqr4VJmXkDDFgkHrnTBOnefFNXuDTl9ug1V3K86gsnM3Tnk5\/vzBW5+41I7cwvW1\/77F2bdmGlnc0xmx4TegMZvW8Kl\/KJS0Z3NItqp8zhKrxs+VwSHasFQG6ySr\/ROgPZToxrJxpSH9egAT4t\/cIXgXmeM9Lgqnk7ZWXWPcbN+g0kXS+Xw39zJ5DUOqKiMIKl3hcaVTIgnAEmke90PmIo+gMKg2q8Gla7GKLXYh5ZBAvGaZM0zm8zZEsu1WRLYePSSgqvwhtqLvuNKkBdPMSDAO28IarXiYXDhae80T+EiDK32gmO6lIx+XA5ydY7qyl\/c41qlWvyLmJIyhd71wOGS2xhmgwDrBtPzkPBdieH2gS50vDXWH7zUgksxbCX4lBbnlJV6gS9n9ZPT3Q7ICigKtf7\/6y383dDp\/junzRl9OfxsgYEKgtc5LYJgXPhA6bX7ma\/iOGn3C6DOpahza9mEQxCb5APCgUKah9cJa5x9dtgVS6rymjOoNTbrSuw+AxvrqhZgYgI6gE+UVSRl8WVc4BZyM+zE9W5OEO58lpO97\/pTn2PDkiB+A",
        },
        "type": "107",
        "reqId": 1526055830436897605,
        "seqNo": 2471,
        "data": {
            "version": "4.4.4",
            "attr_names": ["age", "height", "name", "sex"],
            "name": "test-licence",
        },
        "txnTime": 1526055830,
        "dest": "2hoqvcwupRTUNkXn6ArYzs",
        "identifier": "2hoqvcwupRTUNkXn6ArYzs",
    },
    "op": "REPLY",
}
GET_CLAIM_DEF_REPLY_A = {
    "result": {
        "origin": "2hoqvcwupRTUNkXn6ArYzs",
        "ref": 2471,
        "txnTime": 1526055837,
        "seqNo": 2472,
        "state_proof": {
            "proof_nodes": r"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",
            "multi_signature": {
                "value": {
                    "ledger_id": 1,
                    "pool_state_root_hash": "DuhjUiR6QDsT4X3KFTGHgPnaCCTTVMhmmA8uRwkkhDwA",
                    "txn_root_hash": "6jDkor7uh7kBVsmZesTXzD8T2nZf3t3PyaZkhHbhLLzj",
                    "state_root_hash": "CDTFffp31pxPUyxotNeT2JxQ4j8K9r2HYMTzmNrrZ5TL",
                    "timestamp": 1526055837,
                },
                "participants": ["Node3", "Node2", "Node4"],
                "signature": "R3Loufnbanmb8n8ARzQFzJHERbfi8qTxVH9G4MFGnro67CH6PQyNpgSaoqufhviCB3t6ixzFsnkWtRsUzThWxXAaz3Y5YhgB3nvvdF9NPDJjMxGWG2e4VbqmGnH1kTuZbqqUgBnHkQcxhU1DwzBtwdtYCoVgKCYmAYLxrhHt8yb8qu",
            },
            "root_hash": "CDTFffp31pxPUyxotNeT2JxQ4j8K9r2HYMTzmNrrZ5TL",
        },
        "data": {
            "primary": {
                "r": {
                    "age": "68324431017386373141723313379588123114122172733785498028129098771912332870161622586830226725832682089282797682478996628527458521203981066532148542867910727876973540501604298386964941331385945509447921573334640257131480681017298967411615851997278468982114318053852745062107685596645860574744820479443008568550713733647938784629517351521220040117482812057845591724691129906359015250113706837112935971415735663780322204054449465947028328022534972551186400163012220719718039176357586730457386744557089473465341563472760872536594611618365110919837962302554808225102415883187587908311141004150113254350300861684974387245524",
                    "height": "13939356647759609174485719802501773567276049548245424935504126500265586608662951980260718040791134755864486701853050225651855956737901595730976263505088594378380074293405559194748221759603581890598079117782820527925868489919600695104312261805970657325246956081208878862007439057712465023318674543859367201399080194572966833003881512520725074633033420930095211305635173717467241968613481516063152487980820555533755239133651769565133420156114776578165410212221881994925880629770028898705859268663836663647027677768478228049082189465977511902707373041793879289766830466362779198318255196657839703097701957436211432866940",
                    "sex": "20022101741446570264557630399489699993011383357495333780962515915463701761385865327966524872646907887816919241795166812245521381526599594939708271733894974601885444697364264320467230587792262093722414489552649750887746173699408773581709694927717324336563255309885303903452791340447296644230298702852495919610048570998314143211678209843631329899528727189541506380135323384697685129288034139901316951883056009308816474794904871533784876333707034390658024899757223718233822416033410932755695918855013227912649125625613708302826940395050959425506559689930729589702715565613350872257404294852981485742693414175561560376878",
                    "name": "21470694100729869744261292006763813345150044183446029540177870124524039106316094174460389232832571532284810170007293388299473733141322565289343893281311432223107289867486737597507381929324412597111791890822982978607377646493268665410154158352332552430455410676424655538131806962743837140975034501945349610114128040516920426419752180449876110429631390074018339624366625706057577988994157784979295579958266166722663022918076663412107247120922543421973109778231583641494528977463571610522286622037737315024310026589510134042108138559662654575330826743445692198806461970153226357910705261181205457260549327597981951573985",
                },
                "z": "86577229265747009560052615679615895419349481058284021085673929260636969170535560390660022683481326803220581815884464749038506104457182906050929596940529151731519096012460995580213574923115394453664191902057791953043346629148369777542113599040511920597866451649154423915282977750060280596799442262757753909295114858121438822608110664099684925371671089644086196379734044256966499814680946051154187391597679900273906654730748525684870945928000260002993274218927561839707361816863918092159839143300439497578075981381842189307826991559468115699410540879665465127893208243916471732332308562108973634353200261591256745812234",
                "n": "86724287350477751206656570979032966703329505889109970100672593600212159710122524558840987784946586074662132488236400738181991816412026591140984921370179767079606062874849350699068544007953394425621170412614434471437870413981961728213356970896311390324401528063993712079175929421151002066958792621968526123052543362726709351064982035483300909753311188927834431210143615918489181734829742678671085195486779344279087570275333764801067819032638761795735427697089756560490683732524286268242592541483561421003008848905312960263229239327096444856373881655366169784000740449827583427336247268796008957239930929940106124383441",
                "s": "68565823032708474306514409710254746185097024905866456492400609548513882080060651547254886717209317635536647955345162687060898443709138147278667084384903589486496041039093776147061990629509796556903457618318946948477020316739616698285098064517065210309432231348425794038491136239768243653004282415622183771020331818660661942833453261537705421796886050819425946416534064887172474631878946648680969678450250632713392749852095439858412085632624401434183699289763190966729771549896627986528002008455144081216013915376906960616224100785288425229004552127157820129850247623860663716001315305824246521524314406787572201936159",
                "rms": "57279696110727020230628302576589700618183762363882960191767791103858409422237116150822746386702678537060617035162158771261021205326414811089995155468452732347369957531042614743687780641303019056601049908281597307105484509385119697735678823173668624081938728770800068935332426199032434097694521029943581293515608277055518864299564909952705207331157426572681898162714820056622424494845195263946986591012537422825086117775467510208980394650070899723933489945234503492645580931663241570210025903493959090620866405770418934478358877241756698114261254562875594267266148011094739462828069179559394070466727563845901362557339",
                "rctxt": "28968968789316921956195020159043701485128084666788319688919703768305257857030853826651494435280634703130965749799263847281089261890586404514554128897545567559411392274924672850695923428556666839524191639557540925894441247523915911594915810062115573022491175505153277512476305377826383134343681670368530974886362266706187655064207938621808588725531887931062314044094064943783008218642721898688548716600959291789899808528982572786472183338043212505885146997913313141282478028502666021364027851488363355869491118603841447843857893374823843951923935275949332495109370644946403701670919133621008245580388712016814216268114",
            }
        },
        "reqId": 1526056339560518351,
        "type": "108",
        "signature_type": "CL",
        "identifier": "2hoqvcwupRTUNkXn6ArYzs",
    },
    "op": "REPLY",
}
GET_CLAIM_DEF_REPLY_B = {
    "result": {
        "data": {
            "primary": {
                "n": "114746515059260256085234678788587166148355243180280315102090645942751161606786511238733348638566416417303497105088451106899855630983593307364239632151590963537585250064542598188468391931410646982219473876772131150980262917568589457733589819957223264524201617141236009287666907817621809981593970342911797033651200317354944243448934984118385522763230083200500151663687733598612590779617976091488475790945488832306909284594586246370188320528257434368782767295927647652836090950436948787834961967536745377246052043584698163549299065527670856685769132775303570669824694852645445261928275720246006236672142506689977275868361",
                "r": {
                    "address1": "99691666140371070101358855135773568925647233196811391526286824382905688163990792578749168604103123248884382828153399602940509345627800317904075610052247641753179080938711038002760487730651355496233514312301108772924047804779106854832742682362631853415382718650290457593916293375742714388123906183692192298839372942898471052447331045137271144004625111415456710024852530838725807061493074186193830563122576703301370004391867534587752756127556778961151976176561132968144358067501677783620960920599769114567213278491640769805211738029349174624671317568270236523750186824708848670440189718797166160769005983338957645374651",
                    "address2": "50694627350272135995850227472773682653526785886273680025707432662274319132892635359629398510776487145897598764958307032635008747216007028774721753289104990954080718757271373082072271206903673750118720632612520934845984571658325100469119390059220958605738125231926799396876392119909204431936776959112879901832499818726172148126455962771797164231412142732169157096077449075112596659842193123517211788791802444854497416778006528187110765212794812816350644158221720598510512869974792744115485570047548700807040200469385145744569019135119452695958980311814554081191423436762488471083593240293107044795731173106225269075879",
                    "city": "102559182306527236449083287004741425738959787531929072403797989548015397214062434117297561478541945525533027326788960769556765871071638166299517271476445491827022651938273628586072010918899170935494269888904933582635309954710186662573013491930971322773769929465525735190214323632698521462642758610601865824221106289034715039425726673460562081648867092963498261193872377056119189184137195233286115023395930817931291731614731826876607790483194892570452915675015342381665340157231556766697416007335116526753816159747328974818962282332973001195014744573290346271712396063166983772336582770882568845075757379081928828333484",
                    "state": "15713842569245737467211725139597063575206193864299839064963322883000040008821879926466964994443780733540685507582503521942067619465901516066678686301847079899815506652234811980107432963385421543779350493494079718474286652279834034399265138653939510696807388435204386612790208603957327635965005102296774157640016748464771397682922017927919437902023107754480395084067810355347611382320882015302277874585199781243184210455762324907919521828011758577554657145366604111620312856210314976491491503679972802443973537563280871769127378645286351511023979727441703919415153280572332149194429598144248477123785366270918320355405",
                    "zip": "82439749096689797099365560351239753105378075571995009495583420256509858774982681509800195848127624487713779483877286273210752251434593846321791407852670597416682439130048751917529301094961639109787459476514215677667528190858195940523300129805780128872794677939891404232119474525809874425239287980834285388300426560924836810318681834730312715238871863866236582938180704668392242864562995155085487776333282873729950673055006682711045087024364613715008969916100231057009286368917288450047513042924053264179070247044364634863653978644955951623206916995954379611610172587909771777058114259553518287236931107941424476615146",
                },
                "rctxt": "12882106218364489852198756063472503925546736423511030980775724102309731782619944795270841688773712762811510510057735673384647149369683830553010311398919415875035419497039071344961855906260704429386009769391235310734274528765933895442598586760877605228504009278242556373802663874078663963134235128930919205138500224113611155809593610721019344088231155625768052107598044580568892989818589777033707706414333277298933289666110152325572085417003440591173816185535447148436461626970208749404809055575072540846992803414294365454191025320389124986744387913853078792368035519762273705341214769545763267017647118784802102609501",
                "rms": "106028334352956120254190539677164874113260919335177645538985439215552009817414268001747934794792622586283368183992307658729682605636119929047669814138904443196076047435578798659633647074839223564300440710991823806423760442858751109813721943066300113338814805016319371724589997933204691059213904593223879782913786796897287377655313546120850344752880386937803109231596086401736775016957962252911603462988048614441232196851204796503935873881697942972984657550803208348039692816399383898170960697113742325598099504349794803545598259703412134354513305415733108643762987048364882676189469605110499746876278508590562888471309",
                "s": "15678755827306057743760600028386502810123351546016461235476681362228825598831102199528795536128972467030169856793286910636446189899528748221680209430012552769741678665585748260276066556135386421782992251507127914167374251212176339062137692918334797451372750158620810700982064996262697961072684582507781695193053082112842190405411069106829867359524406960151388270743010774947305777397414657077050738998972524245537892741523091928637751005795657714227975900027201931853690576205714337633635803339006630861198097918548079506836227430559089772233951013727478631851053766855771442468532212938213839384294416442896733429506",
                "z": "107844580696935267224685953710248721588061270382223646096349113942754030931632137466395766282891847634657182239048215576555350103258761763383903208677615631334632643004349863812873041076611716205401052812505603586763826866994143145234436298946833325296153637822126459684843587236075925037465050361093439139718472639710725193340606561954142895780104125189011472434268099373557377935176988976044145686558487862982478674750049266524295725097728797460210399377848983033250414174145298927648861452166644982315308937830863192556869355971023436985865987383144838977793063894497859875560718743368644008878035558886398529867651",
            }
        },
        "identifier": "GGBDg1j8bsKmr4h5T9XqYf",
        "origin": "2hoqvcwupRTUNkXn6ArYzs",
        "ref": 1487,
        "reqId": 1522866729726860308,
        "seqNo": 1488,
        "signature_type": "CL",
        "state_proof": {
            "multi_signature": {
                "participants": ["Node4", "Node3", "Node1"],
                "signature": "R5cNGakn84PoGo4p9U6Y8CyYKGbRUE5mM78yA88KkvSDvWqN8jptp2hSTdzLgYgfWibbFcEv3iAxWH3LGxk9okwr38K6RR35ZbAttQHCafmWGwiUAMoKHoFrH8nMLWzb7A9ZXhb7uUYrSXp3zgZb2xFX83Q8kjmFTkvqcvZVy9uMt3",
                "value": {
                    "ledger_id": 1,
                    "pool_state_root_hash": "DuhjUiR6QDsT4X3KFTGHgPnaCCTTVMhmmA8uRwkkhDwA",
                    "state_root_hash": "3tses33E3t9z7W2gvHk8LizYcjWLTvGZwGZd3Q46SUUm",
                    "timestamp": 1522824724,
                    "txn_root_hash": "F3iggcw2svzk5uSynSAUQcsE6mKXBWRz5bXJoNvvBaRe",
                },
            },
            "proof_nodes": r"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",
            "root_hash": "3tses33E3t9z7W2gvHk8LizYcjWLTvGZwGZd3Q46SUUm",
        },
        "txnTime": 1522769812,
        "type": "108",
    }
}
