# Generated by Django 5.2.6 on 2025-09-18 06:17

import django.core.serializers.json
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='VersionControl',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField(help_text='Object ID of the application', null=True)),
                ('version', models.PositiveIntegerField(help_text='Version number of the snapshot')),
                ('data', models.JSONField(encoder=django.core.serializers.json.DjangoJSONEncoder, help_text='Full snapshot of the record')),
                ('data_hash', models.CharField(db_index=True, help_text='SHA-256 hash of the snapshot', max_length=64)),
                ('action', models.CharField(help_text='Action performed: create, update, delete, restore, rollback', max_length=20)),
                ('diff', models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, help_text='Precomputed human-readable diff', null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True, help_text='Timestamp when the version was created')),
                ('content_type', models.ForeignKey(help_text='Content type of the application', null=True, on_delete=django.db.models.deletion.SET_NULL, to='contenttypes.contenttype')),
                ('user', models.ForeignKey(blank=True, help_text='User who updated the version', null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('content_type', 'object_id', 'version')},
            },
        ),
    ]
