# coding: utf-8

"""
    Smooch

    The Smooch API is a unified interface for powering messaging in your customer experiences across every channel. Our API speeds access to new markets, reduces time to ship, eliminates complexity, and helps you build the best experiences for your customers. For more information, visit our [official documentation](https://docs.smooch.io).

    OpenAPI spec version: 5.27
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class MessageResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, message=None, extra_messages=None, conversation=None):
        """
        MessageResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'message': 'Message',
            'extra_messages': 'list[Message]',
            'conversation': 'Conversation'
        }

        self.attribute_map = {
            'message': 'message',
            'extra_messages': 'extraMessages',
            'conversation': 'conversation'
        }

        self._message = None
        self._extra_messages = None
        self._conversation = None

        # TODO: let required properties as mandatory parameter in the constructor.
        #       - to check if required property is not None (e.g. by calling setter)
        #       - ApiClient.__deserialize_model has to be adapted as well
        if message is not None:
          self.message = message
        if extra_messages is not None:
          self.extra_messages = extra_messages
        if conversation is not None:
          self.conversation = conversation

    @property
    def message(self):
        """
        Gets the message of this MessageResponse.
        The message.

        :return: The message of this MessageResponse.
        :rtype: Message
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this MessageResponse.
        The message.

        :param message: The message of this MessageResponse.
        :type: Message
        """
        if message is None:
            raise ValueError("Invalid value for `message`, must not be `None`")

        self._message = message

    @property
    def extra_messages(self):
        """
        Gets the extra_messages of this MessageResponse.
        List of extra messages created.

        :return: The extra_messages of this MessageResponse.
        :rtype: list[Message]
        """
        return self._extra_messages

    @extra_messages.setter
    def extra_messages(self, extra_messages):
        """
        Sets the extra_messages of this MessageResponse.
        List of extra messages created.

        :param extra_messages: The extra_messages of this MessageResponse.
        :type: list[Message]
        """

        self._extra_messages = extra_messages

    @property
    def conversation(self):
        """
        Gets the conversation of this MessageResponse.
        The conversation.

        :return: The conversation of this MessageResponse.
        :rtype: Conversation
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation):
        """
        Sets the conversation of this MessageResponse.
        The conversation.

        :param conversation: The conversation of this MessageResponse.
        :type: Conversation
        """
        if conversation is None:
            raise ValueError("Invalid value for `conversation`, must not be `None`")

        self._conversation = conversation

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, MessageResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
