from setuptools import setup, find_packages

setup(
    name="tomo-detect",
    version="0.1.4",
    packages=find_packages(),
    install_requires=open('requirements.txt').read().splitlines(),
    entry_points={
        'console_scripts': [
            'tomo-detect=tomo_detect.cli:main',
        ],
    },
    author="Rajath Kumar",
    author_email="rajathkumar120@gmail.com",
    description="A CLI tool for detecting motor coordinates in tomography data",
    long_description=open('README.md').read(),
    long_description_content_type="text/markdown",
    keywords="tomography, motor detection, deep learning",
    url="https://github.com/brendanartley/BYU-competition",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Science/Research",
        "Topic :: Scientific/Engineering :: Image Recognition",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
    ],
    python_requires=">=3.8",
    include_package_data=False,
)


