"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Host = exports.HostProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const bastionhost_generated_1 = require("./bastionhost.generated");
Object.defineProperty(exports, "HostProperty", { enumerable: true, get: function () { return bastionhost_generated_1.RosHost; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::BastionHost::Host`, which is used to create a host for O&M in a bastion host.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosHost`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-bastionhost-host
 */
class Host extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosHost = new bastionhost_generated_1.RosHost(this, id, {
            comment: props.comment,
            activeAddressType: props.activeAddressType,
            hostPrivateAddress: props.hostPrivateAddress,
            instanceRegionId: props.instanceRegionId,
            hostPublicAddress: props.hostPublicAddress,
            instanceId: props.instanceId,
            osType: props.osType,
            sourceInstanceId: props.sourceInstanceId,
            hostName: props.hostName,
            source: props.source,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosHost;
        this.attrHostId = rosHost.attrHostId;
    }
}
exports.Host = Host;
//# sourceMappingURL=data:application/json;base64,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