# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppSignonPolicyRuleArgs', 'AppSignonPolicyRule']

@pulumi.input_type
class AppSignonPolicyRuleArgs:
    def __init__(__self__, *,
                 policy_id: pulumi.Input[_builtins.str],
                 access: Optional[pulumi.Input[_builtins.str]] = None,
                 chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 device_assurances_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device_is_managed: Optional[pulumi.Input[_builtins.bool]] = None,
                 device_is_registered: Optional[pulumi.Input[_builtins.bool]] = None,
                 factor_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inactivity_period: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connection: Optional[pulumi.Input[_builtins.str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 re_authentication_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 risk_score: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_types_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_types_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AppSignonPolicyRule resource.
        :param pulumi.Input[_builtins.str] policy_id: ID of the policy
        :param pulumi.Input[_builtins.str] access: Allow or deny access based on the rule conditions: ALLOW or DENY
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] chains: Authentication method chains. Only supports 5 items in the array. Each chain can support maximum 3 steps. To be used only with verification method type `AUTH_METHOD_CHAIN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] constraints: An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class
        :param pulumi.Input[_builtins.str] custom_expression: This is an optional advanced setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_assurances_includeds: List of device assurance IDs to include
        :param pulumi.Input[_builtins.bool] device_is_managed: If the device is managed. A device is managed if it's managed by a device management system. When managed is passed, registered must also be included and must be set to true.
        :param pulumi.Input[_builtins.bool] device_is_registered: If the device is registered. A device is registered if the User enrolls with Okta Verify that is installed on the device.
        :param pulumi.Input[_builtins.str] factor_mode: The number of factors required to satisfy this assurance level
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_excludeds: List of group IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of group IDs to include
        :param pulumi.Input[_builtins.str] inactivity_period: The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals.
        :param pulumi.Input[_builtins.str] name: Policy Rule Name
        :param pulumi.Input[_builtins.str] network_connection: Network selection mode: ANYWHERE, ZONE, ON*NETWORK, or OFF*NETWORK.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_excludes: The zones to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_includes: The zones to include
        :param pulumi.Input[_builtins.int] priority: Priority of the rule.
        :param pulumi.Input[_builtins.str] re_authentication_frequency: The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. PT0S - Every sign-in attempt, PT43800H - Once per session
        :param pulumi.Input[_builtins.str] risk_score: The risk score specifies a particular level of risk to match on: ANY, LOW, MEDIUM, HIGH
        :param pulumi.Input[_builtins.str] status: Status of the rule
        :param pulumi.Input[_builtins.str] type: The Verification Method type
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_types_excludeds: Set of User Type IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_types_includeds: Set of User Type IDs to include
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users_excludeds: Set of User IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users_includeds: Set of User IDs to include
        """
        pulumi.set(__self__, "policy_id", policy_id)
        if access is not None:
            pulumi.set(__self__, "access", access)
        if chains is not None:
            pulumi.set(__self__, "chains", chains)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if custom_expression is not None:
            pulumi.set(__self__, "custom_expression", custom_expression)
        if device_assurances_includeds is not None:
            pulumi.set(__self__, "device_assurances_includeds", device_assurances_includeds)
        if device_is_managed is not None:
            pulumi.set(__self__, "device_is_managed", device_is_managed)
        if device_is_registered is not None:
            pulumi.set(__self__, "device_is_registered", device_is_registered)
        if factor_mode is not None:
            pulumi.set(__self__, "factor_mode", factor_mode)
        if groups_excludeds is not None:
            pulumi.set(__self__, "groups_excludeds", groups_excludeds)
        if groups_includeds is not None:
            pulumi.set(__self__, "groups_includeds", groups_includeds)
        if inactivity_period is not None:
            pulumi.set(__self__, "inactivity_period", inactivity_period)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connection is not None:
            pulumi.set(__self__, "network_connection", network_connection)
        if network_excludes is not None:
            pulumi.set(__self__, "network_excludes", network_excludes)
        if network_includes is not None:
            pulumi.set(__self__, "network_includes", network_includes)
        if platform_includes is not None:
            pulumi.set(__self__, "platform_includes", platform_includes)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if re_authentication_frequency is not None:
            pulumi.set(__self__, "re_authentication_frequency", re_authentication_frequency)
        if risk_score is not None:
            pulumi.set(__self__, "risk_score", risk_score)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_types_excludeds is not None:
            pulumi.set(__self__, "user_types_excludeds", user_types_excludeds)
        if user_types_includeds is not None:
            pulumi.set(__self__, "user_types_includeds", user_types_includeds)
        if users_excludeds is not None:
            pulumi.set(__self__, "users_excludeds", users_excludeds)
        if users_includeds is not None:
            pulumi.set(__self__, "users_includeds", users_includeds)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the policy
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allow or deny access based on the rule conditions: ALLOW or DENY
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter
    def chains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Authentication method chains. Only supports 5 items in the array. Each chain can support maximum 3 steps. To be used only with verification method type `AUTH_METHOD_CHAIN`.
        """
        return pulumi.get(self, "chains")

    @chains.setter
    def chains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "chains", value)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "constraints", value)

    @_builtins.property
    @pulumi.getter(name="customExpression")
    def custom_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is an optional advanced setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        """
        return pulumi.get(self, "custom_expression")

    @custom_expression.setter
    def custom_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_expression", value)

    @_builtins.property
    @pulumi.getter(name="deviceAssurancesIncludeds")
    def device_assurances_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of device assurance IDs to include
        """
        return pulumi.get(self, "device_assurances_includeds")

    @device_assurances_includeds.setter
    def device_assurances_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "device_assurances_includeds", value)

    @_builtins.property
    @pulumi.getter(name="deviceIsManaged")
    def device_is_managed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the device is managed. A device is managed if it's managed by a device management system. When managed is passed, registered must also be included and must be set to true.
        """
        return pulumi.get(self, "device_is_managed")

    @device_is_managed.setter
    def device_is_managed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "device_is_managed", value)

    @_builtins.property
    @pulumi.getter(name="deviceIsRegistered")
    def device_is_registered(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the device is registered. A device is registered if the User enrolls with Okta Verify that is installed on the device.
        """
        return pulumi.get(self, "device_is_registered")

    @device_is_registered.setter
    def device_is_registered(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "device_is_registered", value)

    @_builtins.property
    @pulumi.getter(name="factorMode")
    def factor_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of factors required to satisfy this assurance level
        """
        return pulumi.get(self, "factor_mode")

    @factor_mode.setter
    def factor_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "factor_mode", value)

    @_builtins.property
    @pulumi.getter(name="groupsExcludeds")
    def groups_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of group IDs to exclude
        """
        return pulumi.get(self, "groups_excludeds")

    @groups_excludeds.setter
    def groups_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_excludeds", value)

    @_builtins.property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of group IDs to include
        """
        return pulumi.get(self, "groups_includeds")

    @groups_includeds.setter
    def groups_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_includeds", value)

    @_builtins.property
    @pulumi.getter(name="inactivityPeriod")
    def inactivity_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals.
        """
        return pulumi.get(self, "inactivity_period")

    @inactivity_period.setter
    def inactivity_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inactivity_period", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Rule Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network selection mode: ANYWHERE, ZONE, ON*NETWORK, or OFF*NETWORK.
        """
        return pulumi.get(self, "network_connection")

    @network_connection.setter
    def network_connection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_connection", value)

    @_builtins.property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The zones to exclude
        """
        return pulumi.get(self, "network_excludes")

    @network_excludes.setter
    def network_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_excludes", value)

    @_builtins.property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The zones to include
        """
        return pulumi.get(self, "network_includes")

    @network_includes.setter
    def network_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_includes", value)

    @_builtins.property
    @pulumi.getter(name="platformIncludes")
    def platform_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]]:
        return pulumi.get(self, "platform_includes")

    @platform_includes.setter
    def platform_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]]):
        pulumi.set(self, "platform_includes", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="reAuthenticationFrequency")
    def re_authentication_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. PT0S - Every sign-in attempt, PT43800H - Once per session
        """
        return pulumi.get(self, "re_authentication_frequency")

    @re_authentication_frequency.setter
    def re_authentication_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "re_authentication_frequency", value)

    @_builtins.property
    @pulumi.getter(name="riskScore")
    def risk_score(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The risk score specifies a particular level of risk to match on: ANY, LOW, MEDIUM, HIGH
        """
        return pulumi.get(self, "risk_score")

    @risk_score.setter
    def risk_score(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "risk_score", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the rule
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Verification Method type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userTypesExcludeds")
    def user_types_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of User Type IDs to exclude
        """
        return pulumi.get(self, "user_types_excludeds")

    @user_types_excludeds.setter
    def user_types_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_types_excludeds", value)

    @_builtins.property
    @pulumi.getter(name="userTypesIncludeds")
    def user_types_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of User Type IDs to include
        """
        return pulumi.get(self, "user_types_includeds")

    @user_types_includeds.setter
    def user_types_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_types_includeds", value)

    @_builtins.property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of User IDs to exclude
        """
        return pulumi.get(self, "users_excludeds")

    @users_excludeds.setter
    def users_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "users_excludeds", value)

    @_builtins.property
    @pulumi.getter(name="usersIncludeds")
    def users_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of User IDs to include
        """
        return pulumi.get(self, "users_includeds")

    @users_includeds.setter
    def users_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "users_includeds", value)


@pulumi.input_type
class _AppSignonPolicyRuleState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input[_builtins.str]] = None,
                 chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 device_assurances_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device_is_managed: Optional[pulumi.Input[_builtins.bool]] = None,
                 device_is_registered: Optional[pulumi.Input[_builtins.bool]] = None,
                 factor_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inactivity_period: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connection: Optional[pulumi.Input[_builtins.str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 re_authentication_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 risk_score: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 system: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_types_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_types_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AppSignonPolicyRule resources.
        :param pulumi.Input[_builtins.str] access: Allow or deny access based on the rule conditions: ALLOW or DENY
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] chains: Authentication method chains. Only supports 5 items in the array. Each chain can support maximum 3 steps. To be used only with verification method type `AUTH_METHOD_CHAIN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] constraints: An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class
        :param pulumi.Input[_builtins.str] custom_expression: This is an optional advanced setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_assurances_includeds: List of device assurance IDs to include
        :param pulumi.Input[_builtins.bool] device_is_managed: If the device is managed. A device is managed if it's managed by a device management system. When managed is passed, registered must also be included and must be set to true.
        :param pulumi.Input[_builtins.bool] device_is_registered: If the device is registered. A device is registered if the User enrolls with Okta Verify that is installed on the device.
        :param pulumi.Input[_builtins.str] factor_mode: The number of factors required to satisfy this assurance level
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_excludeds: List of group IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of group IDs to include
        :param pulumi.Input[_builtins.str] inactivity_period: The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals.
        :param pulumi.Input[_builtins.str] name: Policy Rule Name
        :param pulumi.Input[_builtins.str] network_connection: Network selection mode: ANYWHERE, ZONE, ON*NETWORK, or OFF*NETWORK.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_excludes: The zones to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_includes: The zones to include
        :param pulumi.Input[_builtins.str] policy_id: ID of the policy
        :param pulumi.Input[_builtins.int] priority: Priority of the rule.
        :param pulumi.Input[_builtins.str] re_authentication_frequency: The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. PT0S - Every sign-in attempt, PT43800H - Once per session
        :param pulumi.Input[_builtins.str] risk_score: The risk score specifies a particular level of risk to match on: ANY, LOW, MEDIUM, HIGH
        :param pulumi.Input[_builtins.str] status: Status of the rule
        :param pulumi.Input[_builtins.bool] system: Often the `Catch-all Rule` this rule is the system (default) rule for its associated policy
        :param pulumi.Input[_builtins.str] type: The Verification Method type
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_types_excludeds: Set of User Type IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_types_includeds: Set of User Type IDs to include
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users_excludeds: Set of User IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users_includeds: Set of User IDs to include
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if chains is not None:
            pulumi.set(__self__, "chains", chains)
        if constraints is not None:
            pulumi.set(__self__, "constraints", constraints)
        if custom_expression is not None:
            pulumi.set(__self__, "custom_expression", custom_expression)
        if device_assurances_includeds is not None:
            pulumi.set(__self__, "device_assurances_includeds", device_assurances_includeds)
        if device_is_managed is not None:
            pulumi.set(__self__, "device_is_managed", device_is_managed)
        if device_is_registered is not None:
            pulumi.set(__self__, "device_is_registered", device_is_registered)
        if factor_mode is not None:
            pulumi.set(__self__, "factor_mode", factor_mode)
        if groups_excludeds is not None:
            pulumi.set(__self__, "groups_excludeds", groups_excludeds)
        if groups_includeds is not None:
            pulumi.set(__self__, "groups_includeds", groups_includeds)
        if inactivity_period is not None:
            pulumi.set(__self__, "inactivity_period", inactivity_period)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_connection is not None:
            pulumi.set(__self__, "network_connection", network_connection)
        if network_excludes is not None:
            pulumi.set(__self__, "network_excludes", network_excludes)
        if network_includes is not None:
            pulumi.set(__self__, "network_includes", network_includes)
        if platform_includes is not None:
            pulumi.set(__self__, "platform_includes", platform_includes)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if re_authentication_frequency is not None:
            pulumi.set(__self__, "re_authentication_frequency", re_authentication_frequency)
        if risk_score is not None:
            pulumi.set(__self__, "risk_score", risk_score)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system is not None:
            pulumi.set(__self__, "system", system)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_types_excludeds is not None:
            pulumi.set(__self__, "user_types_excludeds", user_types_excludeds)
        if user_types_includeds is not None:
            pulumi.set(__self__, "user_types_includeds", user_types_includeds)
        if users_excludeds is not None:
            pulumi.set(__self__, "users_excludeds", users_excludeds)
        if users_includeds is not None:
            pulumi.set(__self__, "users_includeds", users_includeds)

    @_builtins.property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Allow or deny access based on the rule conditions: ALLOW or DENY
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access", value)

    @_builtins.property
    @pulumi.getter
    def chains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Authentication method chains. Only supports 5 items in the array. Each chain can support maximum 3 steps. To be used only with verification method type `AUTH_METHOD_CHAIN`.
        """
        return pulumi.get(self, "chains")

    @chains.setter
    def chains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "chains", value)

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class
        """
        return pulumi.get(self, "constraints")

    @constraints.setter
    def constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "constraints", value)

    @_builtins.property
    @pulumi.getter(name="customExpression")
    def custom_expression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is an optional advanced setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        """
        return pulumi.get(self, "custom_expression")

    @custom_expression.setter
    def custom_expression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_expression", value)

    @_builtins.property
    @pulumi.getter(name="deviceAssurancesIncludeds")
    def device_assurances_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of device assurance IDs to include
        """
        return pulumi.get(self, "device_assurances_includeds")

    @device_assurances_includeds.setter
    def device_assurances_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "device_assurances_includeds", value)

    @_builtins.property
    @pulumi.getter(name="deviceIsManaged")
    def device_is_managed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the device is managed. A device is managed if it's managed by a device management system. When managed is passed, registered must also be included and must be set to true.
        """
        return pulumi.get(self, "device_is_managed")

    @device_is_managed.setter
    def device_is_managed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "device_is_managed", value)

    @_builtins.property
    @pulumi.getter(name="deviceIsRegistered")
    def device_is_registered(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If the device is registered. A device is registered if the User enrolls with Okta Verify that is installed on the device.
        """
        return pulumi.get(self, "device_is_registered")

    @device_is_registered.setter
    def device_is_registered(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "device_is_registered", value)

    @_builtins.property
    @pulumi.getter(name="factorMode")
    def factor_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The number of factors required to satisfy this assurance level
        """
        return pulumi.get(self, "factor_mode")

    @factor_mode.setter
    def factor_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "factor_mode", value)

    @_builtins.property
    @pulumi.getter(name="groupsExcludeds")
    def groups_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of group IDs to exclude
        """
        return pulumi.get(self, "groups_excludeds")

    @groups_excludeds.setter
    def groups_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_excludeds", value)

    @_builtins.property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of group IDs to include
        """
        return pulumi.get(self, "groups_includeds")

    @groups_includeds.setter
    def groups_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_includeds", value)

    @_builtins.property
    @pulumi.getter(name="inactivityPeriod")
    def inactivity_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals.
        """
        return pulumi.get(self, "inactivity_period")

    @inactivity_period.setter
    def inactivity_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "inactivity_period", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Rule Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network selection mode: ANYWHERE, ZONE, ON*NETWORK, or OFF*NETWORK.
        """
        return pulumi.get(self, "network_connection")

    @network_connection.setter
    def network_connection(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_connection", value)

    @_builtins.property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The zones to exclude
        """
        return pulumi.get(self, "network_excludes")

    @network_excludes.setter
    def network_excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_excludes", value)

    @_builtins.property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The zones to include
        """
        return pulumi.get(self, "network_includes")

    @network_includes.setter
    def network_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_includes", value)

    @_builtins.property
    @pulumi.getter(name="platformIncludes")
    def platform_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]]:
        return pulumi.get(self, "platform_includes")

    @platform_includes.setter
    def platform_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppSignonPolicyRulePlatformIncludeArgs']]]]):
        pulumi.set(self, "platform_includes", value)

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the policy
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Priority of the rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="reAuthenticationFrequency")
    def re_authentication_frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. PT0S - Every sign-in attempt, PT43800H - Once per session
        """
        return pulumi.get(self, "re_authentication_frequency")

    @re_authentication_frequency.setter
    def re_authentication_frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "re_authentication_frequency", value)

    @_builtins.property
    @pulumi.getter(name="riskScore")
    def risk_score(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The risk score specifies a particular level of risk to match on: ANY, LOW, MEDIUM, HIGH
        """
        return pulumi.get(self, "risk_score")

    @risk_score.setter
    def risk_score(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "risk_score", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the rule
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def system(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Often the `Catch-all Rule` this rule is the system (default) rule for its associated policy
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "system", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Verification Method type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userTypesExcludeds")
    def user_types_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of User Type IDs to exclude
        """
        return pulumi.get(self, "user_types_excludeds")

    @user_types_excludeds.setter
    def user_types_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_types_excludeds", value)

    @_builtins.property
    @pulumi.getter(name="userTypesIncludeds")
    def user_types_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of User Type IDs to include
        """
        return pulumi.get(self, "user_types_includeds")

    @user_types_includeds.setter
    def user_types_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "user_types_includeds", value)

    @_builtins.property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of User IDs to exclude
        """
        return pulumi.get(self, "users_excludeds")

    @users_excludeds.setter
    def users_excludeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "users_excludeds", value)

    @_builtins.property
    @pulumi.getter(name="usersIncludeds")
    def users_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of User IDs to include
        """
        return pulumi.get(self, "users_includeds")

    @users_includeds.setter
    def users_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "users_includeds", value)


@pulumi.type_token("okta:index/appSignonPolicyRule:AppSignonPolicyRule")
class AppSignonPolicyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[_builtins.str]] = None,
                 chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 device_assurances_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device_is_managed: Optional[pulumi.Input[_builtins.bool]] = None,
                 device_is_registered: Optional[pulumi.Input[_builtins.bool]] = None,
                 factor_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inactivity_period: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connection: Optional[pulumi.Input[_builtins.str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppSignonPolicyRulePlatformIncludeArgs', 'AppSignonPolicyRulePlatformIncludeArgsDict']]]]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 re_authentication_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 risk_score: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_types_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_types_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a sign-on policy rules for the application.
        > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.
        This resource allows you to create and configure a sign-on policy rule for the application.
        A default or 'Catch-all Rule' sign-on policy rule can be imported and managed as a custom rule.
        The only difference is that these fields are immutable and can not be managed: 'network_connection', 'network_excludes',
        'network_includes', 'platform_include', 'custom_expression', 'device_is_registered', 'device_is_managed', 'users_excluded',
        'users_included', 'groups_excluded', 'groups_included', 'user_types_excluded' and 'user_types_included'.

        ## Import

        ```sh
        $ pulumi import okta:index/appSignonPolicyRule:AppSignonPolicyRule example <policy_id>/<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access: Allow or deny access based on the rule conditions: ALLOW or DENY
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] chains: Authentication method chains. Only supports 5 items in the array. Each chain can support maximum 3 steps. To be used only with verification method type `AUTH_METHOD_CHAIN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] constraints: An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class
        :param pulumi.Input[_builtins.str] custom_expression: This is an optional advanced setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_assurances_includeds: List of device assurance IDs to include
        :param pulumi.Input[_builtins.bool] device_is_managed: If the device is managed. A device is managed if it's managed by a device management system. When managed is passed, registered must also be included and must be set to true.
        :param pulumi.Input[_builtins.bool] device_is_registered: If the device is registered. A device is registered if the User enrolls with Okta Verify that is installed on the device.
        :param pulumi.Input[_builtins.str] factor_mode: The number of factors required to satisfy this assurance level
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_excludeds: List of group IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of group IDs to include
        :param pulumi.Input[_builtins.str] inactivity_period: The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals.
        :param pulumi.Input[_builtins.str] name: Policy Rule Name
        :param pulumi.Input[_builtins.str] network_connection: Network selection mode: ANYWHERE, ZONE, ON*NETWORK, or OFF*NETWORK.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_excludes: The zones to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_includes: The zones to include
        :param pulumi.Input[_builtins.str] policy_id: ID of the policy
        :param pulumi.Input[_builtins.int] priority: Priority of the rule.
        :param pulumi.Input[_builtins.str] re_authentication_frequency: The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. PT0S - Every sign-in attempt, PT43800H - Once per session
        :param pulumi.Input[_builtins.str] risk_score: The risk score specifies a particular level of risk to match on: ANY, LOW, MEDIUM, HIGH
        :param pulumi.Input[_builtins.str] status: Status of the rule
        :param pulumi.Input[_builtins.str] type: The Verification Method type
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_types_excludeds: Set of User Type IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_types_includeds: Set of User Type IDs to include
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users_excludeds: Set of User IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users_includeds: Set of User IDs to include
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppSignonPolicyRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a sign-on policy rules for the application.
        > **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.
        This resource allows you to create and configure a sign-on policy rule for the application.
        A default or 'Catch-all Rule' sign-on policy rule can be imported and managed as a custom rule.
        The only difference is that these fields are immutable and can not be managed: 'network_connection', 'network_excludes',
        'network_includes', 'platform_include', 'custom_expression', 'device_is_registered', 'device_is_managed', 'users_excluded',
        'users_included', 'groups_excluded', 'groups_included', 'user_types_excluded' and 'user_types_included'.

        ## Import

        ```sh
        $ pulumi import okta:index/appSignonPolicyRule:AppSignonPolicyRule example <policy_id>/<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param AppSignonPolicyRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppSignonPolicyRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[_builtins.str]] = None,
                 chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 constraints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 custom_expression: Optional[pulumi.Input[_builtins.str]] = None,
                 device_assurances_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 device_is_managed: Optional[pulumi.Input[_builtins.bool]] = None,
                 device_is_registered: Optional[pulumi.Input[_builtins.bool]] = None,
                 factor_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 inactivity_period: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_connection: Optional[pulumi.Input[_builtins.str]] = None,
                 network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppSignonPolicyRulePlatformIncludeArgs', 'AppSignonPolicyRulePlatformIncludeArgsDict']]]]] = None,
                 policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 re_authentication_frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 risk_score: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_types_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_types_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 users_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppSignonPolicyRuleArgs.__new__(AppSignonPolicyRuleArgs)

            __props__.__dict__["access"] = access
            __props__.__dict__["chains"] = chains
            __props__.__dict__["constraints"] = constraints
            __props__.__dict__["custom_expression"] = custom_expression
            __props__.__dict__["device_assurances_includeds"] = device_assurances_includeds
            __props__.__dict__["device_is_managed"] = device_is_managed
            __props__.__dict__["device_is_registered"] = device_is_registered
            __props__.__dict__["factor_mode"] = factor_mode
            __props__.__dict__["groups_excludeds"] = groups_excludeds
            __props__.__dict__["groups_includeds"] = groups_includeds
            __props__.__dict__["inactivity_period"] = inactivity_period
            __props__.__dict__["name"] = name
            __props__.__dict__["network_connection"] = network_connection
            __props__.__dict__["network_excludes"] = network_excludes
            __props__.__dict__["network_includes"] = network_includes
            __props__.__dict__["platform_includes"] = platform_includes
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["priority"] = priority
            __props__.__dict__["re_authentication_frequency"] = re_authentication_frequency
            __props__.__dict__["risk_score"] = risk_score
            __props__.__dict__["status"] = status
            __props__.__dict__["type"] = type
            __props__.__dict__["user_types_excludeds"] = user_types_excludeds
            __props__.__dict__["user_types_includeds"] = user_types_includeds
            __props__.__dict__["users_excludeds"] = users_excludeds
            __props__.__dict__["users_includeds"] = users_includeds
            __props__.__dict__["system"] = None
        super(AppSignonPolicyRule, __self__).__init__(
            'okta:index/appSignonPolicyRule:AppSignonPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[_builtins.str]] = None,
            chains: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            constraints: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            custom_expression: Optional[pulumi.Input[_builtins.str]] = None,
            device_assurances_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            device_is_managed: Optional[pulumi.Input[_builtins.bool]] = None,
            device_is_registered: Optional[pulumi.Input[_builtins.bool]] = None,
            factor_mode: Optional[pulumi.Input[_builtins.str]] = None,
            groups_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            inactivity_period: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_connection: Optional[pulumi.Input[_builtins.str]] = None,
            network_excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            network_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            platform_includes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppSignonPolicyRulePlatformIncludeArgs', 'AppSignonPolicyRulePlatformIncludeArgsDict']]]]] = None,
            policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            re_authentication_frequency: Optional[pulumi.Input[_builtins.str]] = None,
            risk_score: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            system: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_types_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            user_types_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            users_excludeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            users_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'AppSignonPolicyRule':
        """
        Get an existing AppSignonPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access: Allow or deny access based on the rule conditions: ALLOW or DENY
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] chains: Authentication method chains. Only supports 5 items in the array. Each chain can support maximum 3 steps. To be used only with verification method type `AUTH_METHOD_CHAIN`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] constraints: An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class
        :param pulumi.Input[_builtins.str] custom_expression: This is an optional advanced setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_assurances_includeds: List of device assurance IDs to include
        :param pulumi.Input[_builtins.bool] device_is_managed: If the device is managed. A device is managed if it's managed by a device management system. When managed is passed, registered must also be included and must be set to true.
        :param pulumi.Input[_builtins.bool] device_is_registered: If the device is registered. A device is registered if the User enrolls with Okta Verify that is installed on the device.
        :param pulumi.Input[_builtins.str] factor_mode: The number of factors required to satisfy this assurance level
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_excludeds: List of group IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of group IDs to include
        :param pulumi.Input[_builtins.str] inactivity_period: The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals.
        :param pulumi.Input[_builtins.str] name: Policy Rule Name
        :param pulumi.Input[_builtins.str] network_connection: Network selection mode: ANYWHERE, ZONE, ON*NETWORK, or OFF*NETWORK.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_excludes: The zones to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_includes: The zones to include
        :param pulumi.Input[_builtins.str] policy_id: ID of the policy
        :param pulumi.Input[_builtins.int] priority: Priority of the rule.
        :param pulumi.Input[_builtins.str] re_authentication_frequency: The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. PT0S - Every sign-in attempt, PT43800H - Once per session
        :param pulumi.Input[_builtins.str] risk_score: The risk score specifies a particular level of risk to match on: ANY, LOW, MEDIUM, HIGH
        :param pulumi.Input[_builtins.str] status: Status of the rule
        :param pulumi.Input[_builtins.bool] system: Often the `Catch-all Rule` this rule is the system (default) rule for its associated policy
        :param pulumi.Input[_builtins.str] type: The Verification Method type
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_types_excludeds: Set of User Type IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] user_types_includeds: Set of User Type IDs to include
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users_excludeds: Set of User IDs to exclude
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users_includeds: Set of User IDs to include
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppSignonPolicyRuleState.__new__(_AppSignonPolicyRuleState)

        __props__.__dict__["access"] = access
        __props__.__dict__["chains"] = chains
        __props__.__dict__["constraints"] = constraints
        __props__.__dict__["custom_expression"] = custom_expression
        __props__.__dict__["device_assurances_includeds"] = device_assurances_includeds
        __props__.__dict__["device_is_managed"] = device_is_managed
        __props__.__dict__["device_is_registered"] = device_is_registered
        __props__.__dict__["factor_mode"] = factor_mode
        __props__.__dict__["groups_excludeds"] = groups_excludeds
        __props__.__dict__["groups_includeds"] = groups_includeds
        __props__.__dict__["inactivity_period"] = inactivity_period
        __props__.__dict__["name"] = name
        __props__.__dict__["network_connection"] = network_connection
        __props__.__dict__["network_excludes"] = network_excludes
        __props__.__dict__["network_includes"] = network_includes
        __props__.__dict__["platform_includes"] = platform_includes
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["priority"] = priority
        __props__.__dict__["re_authentication_frequency"] = re_authentication_frequency
        __props__.__dict__["risk_score"] = risk_score
        __props__.__dict__["status"] = status
        __props__.__dict__["system"] = system
        __props__.__dict__["type"] = type
        __props__.__dict__["user_types_excludeds"] = user_types_excludeds
        __props__.__dict__["user_types_includeds"] = user_types_includeds
        __props__.__dict__["users_excludeds"] = users_excludeds
        __props__.__dict__["users_includeds"] = users_includeds
        return AppSignonPolicyRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Allow or deny access based on the rule conditions: ALLOW or DENY
        """
        return pulumi.get(self, "access")

    @_builtins.property
    @pulumi.getter
    def chains(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Authentication method chains. Only supports 5 items in the array. Each chain can support maximum 3 steps. To be used only with verification method type `AUTH_METHOD_CHAIN`.
        """
        return pulumi.get(self, "chains")

    @_builtins.property
    @pulumi.getter
    def constraints(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class
        """
        return pulumi.get(self, "constraints")

    @_builtins.property
    @pulumi.getter(name="customExpression")
    def custom_expression(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This is an optional advanced setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
        """
        return pulumi.get(self, "custom_expression")

    @_builtins.property
    @pulumi.getter(name="deviceAssurancesIncludeds")
    def device_assurances_includeds(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of device assurance IDs to include
        """
        return pulumi.get(self, "device_assurances_includeds")

    @_builtins.property
    @pulumi.getter(name="deviceIsManaged")
    def device_is_managed(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If the device is managed. A device is managed if it's managed by a device management system. When managed is passed, registered must also be included and must be set to true.
        """
        return pulumi.get(self, "device_is_managed")

    @_builtins.property
    @pulumi.getter(name="deviceIsRegistered")
    def device_is_registered(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If the device is registered. A device is registered if the User enrolls with Okta Verify that is installed on the device.
        """
        return pulumi.get(self, "device_is_registered")

    @_builtins.property
    @pulumi.getter(name="factorMode")
    def factor_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The number of factors required to satisfy this assurance level
        """
        return pulumi.get(self, "factor_mode")

    @_builtins.property
    @pulumi.getter(name="groupsExcludeds")
    def groups_excludeds(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of group IDs to exclude
        """
        return pulumi.get(self, "groups_excludeds")

    @_builtins.property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of group IDs to include
        """
        return pulumi.get(self, "groups_includeds")

    @_builtins.property
    @pulumi.getter(name="inactivityPeriod")
    def inactivity_period(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals.
        """
        return pulumi.get(self, "inactivity_period")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Policy Rule Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkConnection")
    def network_connection(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Network selection mode: ANYWHERE, ZONE, ON*NETWORK, or OFF*NETWORK.
        """
        return pulumi.get(self, "network_connection")

    @_builtins.property
    @pulumi.getter(name="networkExcludes")
    def network_excludes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The zones to exclude
        """
        return pulumi.get(self, "network_excludes")

    @_builtins.property
    @pulumi.getter(name="networkIncludes")
    def network_includes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The zones to include
        """
        return pulumi.get(self, "network_includes")

    @_builtins.property
    @pulumi.getter(name="platformIncludes")
    def platform_includes(self) -> pulumi.Output[Optional[Sequence['outputs.AppSignonPolicyRulePlatformInclude']]]:
        return pulumi.get(self, "platform_includes")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the policy
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Priority of the rule.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="reAuthenticationFrequency")
    def re_authentication_frequency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. PT0S - Every sign-in attempt, PT43800H - Once per session
        """
        return pulumi.get(self, "re_authentication_frequency")

    @_builtins.property
    @pulumi.getter(name="riskScore")
    def risk_score(self) -> pulumi.Output[_builtins.str]:
        """
        The risk score specifies a particular level of risk to match on: ANY, LOW, MEDIUM, HIGH
        """
        return pulumi.get(self, "risk_score")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Status of the rule
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def system(self) -> pulumi.Output[_builtins.bool]:
        """
        Often the `Catch-all Rule` this rule is the system (default) rule for its associated policy
        """
        return pulumi.get(self, "system")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Verification Method type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userTypesExcludeds")
    def user_types_excludeds(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of User Type IDs to exclude
        """
        return pulumi.get(self, "user_types_excludeds")

    @_builtins.property
    @pulumi.getter(name="userTypesIncludeds")
    def user_types_includeds(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of User Type IDs to include
        """
        return pulumi.get(self, "user_types_includeds")

    @_builtins.property
    @pulumi.getter(name="usersExcludeds")
    def users_excludeds(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of User IDs to exclude
        """
        return pulumi.get(self, "users_excludeds")

    @_builtins.property
    @pulumi.getter(name="usersIncludeds")
    def users_includeds(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of User IDs to include
        """
        return pulumi.get(self, "users_includeds")

