# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CaptchaArgs', 'Captcha']

@pulumi.input_type
class CaptchaArgs:
    def __init__(__self__, *,
                 secret_key: pulumi.Input[_builtins.str],
                 site_key: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Captcha resource.
        :param pulumi.Input[_builtins.str] secret_key: Secret key issued from the CAPTCHA vendor to perform server-side validation for a CAPTCHA token
        :param pulumi.Input[_builtins.str] site_key: Site key issued from the CAPTCHA vendor to render a CAPTCHA on a page
        :param pulumi.Input[_builtins.str] type: Type of the captcha. Valid values: `HCAPTCHA`, `RECAPTCHA_V2`
        :param pulumi.Input[_builtins.str] name: Name of the CAPTCHA
        """
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "site_key", site_key)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[_builtins.str]:
        """
        Secret key issued from the CAPTCHA vendor to perform server-side validation for a CAPTCHA token
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="siteKey")
    def site_key(self) -> pulumi.Input[_builtins.str]:
        """
        Site key issued from the CAPTCHA vendor to render a CAPTCHA on a page
        """
        return pulumi.get(self, "site_key")

    @site_key.setter
    def site_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "site_key", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the captcha. Valid values: `HCAPTCHA`, `RECAPTCHA_V2`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the CAPTCHA
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CaptchaState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 site_key: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Captcha resources.
        :param pulumi.Input[_builtins.str] name: Name of the CAPTCHA
        :param pulumi.Input[_builtins.str] secret_key: Secret key issued from the CAPTCHA vendor to perform server-side validation for a CAPTCHA token
        :param pulumi.Input[_builtins.str] site_key: Site key issued from the CAPTCHA vendor to render a CAPTCHA on a page
        :param pulumi.Input[_builtins.str] type: Type of the captcha. Valid values: `HCAPTCHA`, `RECAPTCHA_V2`
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if site_key is not None:
            pulumi.set(__self__, "site_key", site_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the CAPTCHA
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Secret key issued from the CAPTCHA vendor to perform server-side validation for a CAPTCHA token
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="siteKey")
    def site_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Site key issued from the CAPTCHA vendor to render a CAPTCHA on a page
        """
        return pulumi.get(self, "site_key")

    @site_key.setter
    def site_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "site_key", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the captcha. Valid values: `HCAPTCHA`, `RECAPTCHA_V2`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("okta:index/captcha:Captcha")
class Captcha(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 site_key: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates different types of captcha.
        		> **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.
        		This resource allows you to create and configure a CAPTCHA.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.Captcha("example",
            name="My CAPTCHA",
            type="HCAPTCHA",
            site_key="some_key",
            secret_key="some_secret_key")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/captcha:Captcha example <captcha_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the CAPTCHA
        :param pulumi.Input[_builtins.str] secret_key: Secret key issued from the CAPTCHA vendor to perform server-side validation for a CAPTCHA token
        :param pulumi.Input[_builtins.str] site_key: Site key issued from the CAPTCHA vendor to render a CAPTCHA on a page
        :param pulumi.Input[_builtins.str] type: Type of the captcha. Valid values: `HCAPTCHA`, `RECAPTCHA_V2`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CaptchaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates different types of captcha.
        		> **WARNING:** This feature is only available as a part of the Identity Engine. Contact support for further information.
        		This resource allows you to create and configure a CAPTCHA.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.Captcha("example",
            name="My CAPTCHA",
            type="HCAPTCHA",
            site_key="some_key",
            secret_key="some_secret_key")
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/captcha:Captcha example <captcha_id>
        ```

        :param str resource_name: The name of the resource.
        :param CaptchaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CaptchaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 site_key: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CaptchaArgs.__new__(CaptchaArgs)

            __props__.__dict__["name"] = name
            if secret_key is None and not opts.urn:
                raise TypeError("Missing required property 'secret_key'")
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            if site_key is None and not opts.urn:
                raise TypeError("Missing required property 'site_key'")
            __props__.__dict__["site_key"] = site_key
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Captcha, __self__).__init__(
            'okta:index/captcha:Captcha',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            site_key: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Captcha':
        """
        Get an existing Captcha resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the CAPTCHA
        :param pulumi.Input[_builtins.str] secret_key: Secret key issued from the CAPTCHA vendor to perform server-side validation for a CAPTCHA token
        :param pulumi.Input[_builtins.str] site_key: Site key issued from the CAPTCHA vendor to render a CAPTCHA on a page
        :param pulumi.Input[_builtins.str] type: Type of the captcha. Valid values: `HCAPTCHA`, `RECAPTCHA_V2`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CaptchaState.__new__(_CaptchaState)

        __props__.__dict__["name"] = name
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["site_key"] = site_key
        __props__.__dict__["type"] = type
        return Captcha(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the CAPTCHA
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[_builtins.str]:
        """
        Secret key issued from the CAPTCHA vendor to perform server-side validation for a CAPTCHA token
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="siteKey")
    def site_key(self) -> pulumi.Output[_builtins.str]:
        """
        Site key issued from the CAPTCHA vendor to render a CAPTCHA on a page
        """
        return pulumi.get(self, "site_key")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the captcha. Valid values: `HCAPTCHA`, `RECAPTCHA_V2`
        """
        return pulumi.get(self, "type")

