# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDeviceAssurancePolicyResult',
    'AwaitableGetDeviceAssurancePolicyResult',
    'get_device_assurance_policy',
    'get_device_assurance_policy_output',
]

@pulumi.output_type
class GetDeviceAssurancePolicyResult:
    """
    A collection of values returned by getDeviceAssurancePolicy.
    """
    def __init__(__self__, disk_encryption_type=None, id=None, jailbreak=None, name=None, os_version=None, os_version_constraints=None, platform=None, screenlock_type=None, secure_hardware_present=None, third_party_signal_provider=None):
        if disk_encryption_type and not isinstance(disk_encryption_type, dict):
            raise TypeError("Expected argument 'disk_encryption_type' to be a dict")
        pulumi.set(__self__, "disk_encryption_type", disk_encryption_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if jailbreak and not isinstance(jailbreak, bool):
            raise TypeError("Expected argument 'jailbreak' to be a bool")
        pulumi.set(__self__, "jailbreak", jailbreak)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_version and not isinstance(os_version, dict):
            raise TypeError("Expected argument 'os_version' to be a dict")
        pulumi.set(__self__, "os_version", os_version)
        if os_version_constraints and not isinstance(os_version_constraints, list):
            raise TypeError("Expected argument 'os_version_constraints' to be a list")
        pulumi.set(__self__, "os_version_constraints", os_version_constraints)
        if platform and not isinstance(platform, str):
            raise TypeError("Expected argument 'platform' to be a str")
        pulumi.set(__self__, "platform", platform)
        if screenlock_type and not isinstance(screenlock_type, dict):
            raise TypeError("Expected argument 'screenlock_type' to be a dict")
        pulumi.set(__self__, "screenlock_type", screenlock_type)
        if secure_hardware_present and not isinstance(secure_hardware_present, bool):
            raise TypeError("Expected argument 'secure_hardware_present' to be a bool")
        pulumi.set(__self__, "secure_hardware_present", secure_hardware_present)
        if third_party_signal_provider and not isinstance(third_party_signal_provider, dict):
            raise TypeError("Expected argument 'third_party_signal_provider' to be a dict")
        pulumi.set(__self__, "third_party_signal_provider", third_party_signal_provider)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionType")
    def disk_encryption_type(self) -> 'outputs.GetDeviceAssurancePolicyDiskEncryptionTypeResult':
        """
        List of disk encryption type, can be `FULL`, `USER`
        """
        return pulumi.get(self, "disk_encryption_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        ID of the user type to retrieve, conflicts with `name`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def jailbreak(self) -> _builtins.bool:
        """
        Is the device jailbroken in the device assurance policy.
        """
        return pulumi.get(self, "jailbreak")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of user type to retrieve, conflicts with `id`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> 'outputs.GetDeviceAssurancePolicyOsVersionResult':
        """
        Minimum os version of the device in the device assurance policy.
        """
        return pulumi.get(self, "os_version")

    @_builtins.property
    @pulumi.getter(name="osVersionConstraints")
    def os_version_constraints(self) -> Sequence['outputs.GetDeviceAssurancePolicyOsVersionConstraintResult']:
        """
        The list of os version constraints.
        """
        return pulumi.get(self, "os_version_constraints")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> _builtins.str:
        """
        Policy device assurance platform
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="screenlockType")
    def screenlock_type(self) -> 'outputs.GetDeviceAssurancePolicyScreenlockTypeResult':
        """
        List of screenlock type, can be `BIOMETRIC` or `BIOMETRIC, PASSCODE`
        """
        return pulumi.get(self, "screenlock_type")

    @_builtins.property
    @pulumi.getter(name="secureHardwarePresent")
    def secure_hardware_present(self) -> Optional[_builtins.bool]:
        """
        Indicates if the device contains a secure hardware functionality
        """
        return pulumi.get(self, "secure_hardware_present")

    @_builtins.property
    @pulumi.getter(name="thirdPartySignalProvider")
    def third_party_signal_provider(self) -> Optional['outputs.GetDeviceAssurancePolicyThirdPartySignalProviderResult']:
        """
        Indicates if the device contains a secure hardware functionality
        """
        return pulumi.get(self, "third_party_signal_provider")


class AwaitableGetDeviceAssurancePolicyResult(GetDeviceAssurancePolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeviceAssurancePolicyResult(
            disk_encryption_type=self.disk_encryption_type,
            id=self.id,
            jailbreak=self.jailbreak,
            name=self.name,
            os_version=self.os_version,
            os_version_constraints=self.os_version_constraints,
            platform=self.platform,
            screenlock_type=self.screenlock_type,
            secure_hardware_present=self.secure_hardware_present,
            third_party_signal_provider=self.third_party_signal_provider)


def get_device_assurance_policy(id: Optional[_builtins.str] = None,
                                name: Optional[_builtins.str] = None,
                                secure_hardware_present: Optional[_builtins.bool] = None,
                                third_party_signal_provider: Optional[Union['GetDeviceAssurancePolicyThirdPartySignalProviderArgs', 'GetDeviceAssurancePolicyThirdPartySignalProviderArgsDict']] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeviceAssurancePolicyResult:
    """
    Get a policy assurance from Okta.


    :param _builtins.str id: ID of the user type to retrieve, conflicts with `name`.
    :param _builtins.str name: Name of user type to retrieve, conflicts with `id`.
    :param _builtins.bool secure_hardware_present: Indicates if the device contains a secure hardware functionality
    :param Union['GetDeviceAssurancePolicyThirdPartySignalProviderArgs', 'GetDeviceAssurancePolicyThirdPartySignalProviderArgsDict'] third_party_signal_provider: Indicates if the device contains a secure hardware functionality
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['secureHardwarePresent'] = secure_hardware_present
    __args__['thirdPartySignalProvider'] = third_party_signal_provider
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getDeviceAssurancePolicy:getDeviceAssurancePolicy', __args__, opts=opts, typ=GetDeviceAssurancePolicyResult).value

    return AwaitableGetDeviceAssurancePolicyResult(
        disk_encryption_type=pulumi.get(__ret__, 'disk_encryption_type'),
        id=pulumi.get(__ret__, 'id'),
        jailbreak=pulumi.get(__ret__, 'jailbreak'),
        name=pulumi.get(__ret__, 'name'),
        os_version=pulumi.get(__ret__, 'os_version'),
        os_version_constraints=pulumi.get(__ret__, 'os_version_constraints'),
        platform=pulumi.get(__ret__, 'platform'),
        screenlock_type=pulumi.get(__ret__, 'screenlock_type'),
        secure_hardware_present=pulumi.get(__ret__, 'secure_hardware_present'),
        third_party_signal_provider=pulumi.get(__ret__, 'third_party_signal_provider'))
def get_device_assurance_policy_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       secure_hardware_present: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                       third_party_signal_provider: Optional[pulumi.Input[Optional[Union['GetDeviceAssurancePolicyThirdPartySignalProviderArgs', 'GetDeviceAssurancePolicyThirdPartySignalProviderArgsDict']]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDeviceAssurancePolicyResult]:
    """
    Get a policy assurance from Okta.


    :param _builtins.str id: ID of the user type to retrieve, conflicts with `name`.
    :param _builtins.str name: Name of user type to retrieve, conflicts with `id`.
    :param _builtins.bool secure_hardware_present: Indicates if the device contains a secure hardware functionality
    :param Union['GetDeviceAssurancePolicyThirdPartySignalProviderArgs', 'GetDeviceAssurancePolicyThirdPartySignalProviderArgsDict'] third_party_signal_provider: Indicates if the device contains a secure hardware functionality
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['secureHardwarePresent'] = secure_hardware_present
    __args__['thirdPartySignalProvider'] = third_party_signal_provider
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getDeviceAssurancePolicy:getDeviceAssurancePolicy', __args__, opts=opts, typ=GetDeviceAssurancePolicyResult)
    return __ret__.apply(lambda __response__: GetDeviceAssurancePolicyResult(
        disk_encryption_type=pulumi.get(__response__, 'disk_encryption_type'),
        id=pulumi.get(__response__, 'id'),
        jailbreak=pulumi.get(__response__, 'jailbreak'),
        name=pulumi.get(__response__, 'name'),
        os_version=pulumi.get(__response__, 'os_version'),
        os_version_constraints=pulumi.get(__response__, 'os_version_constraints'),
        platform=pulumi.get(__response__, 'platform'),
        screenlock_type=pulumi.get(__response__, 'screenlock_type'),
        secure_hardware_present=pulumi.get(__response__, 'secure_hardware_present'),
        third_party_signal_provider=pulumi.get(__response__, 'third_party_signal_provider')))
