# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetFeaturesResult',
    'AwaitableGetFeaturesResult',
    'get_features',
    'get_features_output',
]

@pulumi.output_type
class GetFeaturesResult:
    """
    A collection of values returned by getFeatures.
    """
    def __init__(__self__, features=None, id=None, label=None, substring=None):
        if features and not isinstance(features, list):
            raise TypeError("Expected argument 'features' to be a list")
        pulumi.set(__self__, "features", features)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if substring and not isinstance(substring, str):
            raise TypeError("Expected argument 'substring' to be a str")
        pulumi.set(__self__, "substring", substring)

    @_builtins.property
    @pulumi.getter
    def features(self) -> Sequence['outputs.GetFeaturesFeatureResult']:
        """
        List of `Feature` belonging to the organization
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Generated ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        Searches for features whose label or name property matches this value exactly. Case sensitive
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def substring(self) -> Optional[_builtins.str]:
        """
        Searches for features whose label or name property substring match this value. Case sensitive
        """
        return pulumi.get(self, "substring")


class AwaitableGetFeaturesResult(GetFeaturesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFeaturesResult(
            features=self.features,
            id=self.id,
            label=self.label,
            substring=self.substring)


def get_features(label: Optional[_builtins.str] = None,
                 substring: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFeaturesResult:
    """
    Get a list of features from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_features(label="Android Device Trust")
    ```


    :param _builtins.str label: Searches for features whose label or name property matches this value exactly. Case sensitive
    :param _builtins.str substring: Searches for features whose label or name property substring match this value. Case sensitive
    """
    __args__ = dict()
    __args__['label'] = label
    __args__['substring'] = substring
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:index/getFeatures:getFeatures', __args__, opts=opts, typ=GetFeaturesResult).value

    return AwaitableGetFeaturesResult(
        features=pulumi.get(__ret__, 'features'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        substring=pulumi.get(__ret__, 'substring'))
def get_features_output(label: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        substring: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFeaturesResult]:
    """
    Get a list of features from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.get_features(label="Android Device Trust")
    ```


    :param _builtins.str label: Searches for features whose label or name property matches this value exactly. Case sensitive
    :param _builtins.str substring: Searches for features whose label or name property substring match this value. Case sensitive
    """
    __args__ = dict()
    __args__['label'] = label
    __args__['substring'] = substring
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:index/getFeatures:getFeatures', __args__, opts=opts, typ=GetFeaturesResult)
    return __ret__.apply(lambda __response__: GetFeaturesResult(
        features=pulumi.get(__response__, 'features'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        substring=pulumi.get(__response__, 'substring')))
