# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OwnerArgs', 'Owner']

@pulumi.input_type
class OwnerArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.str],
                 id_of_group_owner: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a Owner resource.
        :param pulumi.Input[_builtins.str] group_id: The id of the group
        :param pulumi.Input[_builtins.str] id_of_group_owner: The user id of the group owner
        :param pulumi.Input[_builtins.str] type: The entity type of the owner. Enum: "GROUP" "USER"
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "id_of_group_owner", id_of_group_owner)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the group
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="idOfGroupOwner")
    def id_of_group_owner(self) -> pulumi.Input[_builtins.str]:
        """
        The user id of the group owner
        """
        return pulumi.get(self, "id_of_group_owner")

    @id_of_group_owner.setter
    def id_of_group_owner(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id_of_group_owner", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The entity type of the owner. Enum: "GROUP" "USER"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _OwnerState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 id_of_group_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_id: Optional[pulumi.Input[_builtins.str]] = None,
                 origin_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resolved: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Owner resources.
        :param pulumi.Input[_builtins.str] display_name: The display name of the group owner
        :param pulumi.Input[_builtins.str] group_id: The id of the group
        :param pulumi.Input[_builtins.str] id_of_group_owner: The user id of the group owner
        :param pulumi.Input[_builtins.str] origin_id: The ID of the app instance if the originType is APPLICATION. This value is NULL if originType is OKTA_DIRECTORY.
        :param pulumi.Input[_builtins.str] origin_type: The source where group ownership is managed. Enum: "APPLICATION" "OKTA_DIRECTORY"
        :param pulumi.Input[_builtins.bool] resolved: If originType is APPLICATION, this parameter is set to FALSE until the owner's originId is reconciled with an associated Okta ID.
        :param pulumi.Input[_builtins.str] type: The entity type of the owner. Enum: "GROUP" "USER"
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if id_of_group_owner is not None:
            pulumi.set(__self__, "id_of_group_owner", id_of_group_owner)
        if origin_id is not None:
            pulumi.set(__self__, "origin_id", origin_id)
        if origin_type is not None:
            pulumi.set(__self__, "origin_type", origin_type)
        if resolved is not None:
            pulumi.set(__self__, "resolved", resolved)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the group owner
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the group
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="idOfGroupOwner")
    def id_of_group_owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user id of the group owner
        """
        return pulumi.get(self, "id_of_group_owner")

    @id_of_group_owner.setter
    def id_of_group_owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id_of_group_owner", value)

    @_builtins.property
    @pulumi.getter(name="originId")
    def origin_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the app instance if the originType is APPLICATION. This value is NULL if originType is OKTA_DIRECTORY.
        """
        return pulumi.get(self, "origin_id")

    @origin_id.setter
    def origin_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_id", value)

    @_builtins.property
    @pulumi.getter(name="originType")
    def origin_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source where group ownership is managed. Enum: "APPLICATION" "OKTA_DIRECTORY"
        """
        return pulumi.get(self, "origin_type")

    @origin_type.setter
    def origin_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin_type", value)

    @_builtins.property
    @pulumi.getter
    def resolved(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If originType is APPLICATION, this parameter is set to FALSE until the owner's originId is reconciled with an associated Okta ID.
        """
        return pulumi.get(self, "resolved")

    @resolved.setter
    def resolved(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "resolved", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The entity type of the owner. Enum: "GROUP" "USER"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("okta:group/owner:Owner")
class Owner(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 id_of_group_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages group owner resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.user.User("test",
            first_name="TestAcc",
            last_name="Smith",
            login="testAcc-replace_with_uuid@example.com",
            email="testAcc-replace_with_uuid@example.com")
        test_group = okta.group.Group("test", name="testAcc_replace_with_uuid")
        test_owner = okta.group.Owner("test",
            group_id=test_group.id,
            id_of_group_owner=test.id,
            type="USER")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_id: The id of the group
        :param pulumi.Input[_builtins.str] id_of_group_owner: The user id of the group owner
        :param pulumi.Input[_builtins.str] type: The entity type of the owner. Enum: "GROUP" "USER"
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OwnerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages group owner resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        test = okta.user.User("test",
            first_name="TestAcc",
            last_name="Smith",
            login="testAcc-replace_with_uuid@example.com",
            email="testAcc-replace_with_uuid@example.com")
        test_group = okta.group.Group("test", name="testAcc_replace_with_uuid")
        test_owner = okta.group.Owner("test",
            group_id=test_group.id,
            id_of_group_owner=test.id,
            type="USER")
        ```

        :param str resource_name: The name of the resource.
        :param OwnerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OwnerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 id_of_group_owner: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OwnerArgs.__new__(OwnerArgs)

            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if id_of_group_owner is None and not opts.urn:
                raise TypeError("Missing required property 'id_of_group_owner'")
            __props__.__dict__["id_of_group_owner"] = id_of_group_owner
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["display_name"] = None
            __props__.__dict__["origin_id"] = None
            __props__.__dict__["origin_type"] = None
            __props__.__dict__["resolved"] = None
        super(Owner, __self__).__init__(
            'okta:group/owner:Owner',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            id_of_group_owner: Optional[pulumi.Input[_builtins.str]] = None,
            origin_id: Optional[pulumi.Input[_builtins.str]] = None,
            origin_type: Optional[pulumi.Input[_builtins.str]] = None,
            resolved: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Owner':
        """
        Get an existing Owner resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: The display name of the group owner
        :param pulumi.Input[_builtins.str] group_id: The id of the group
        :param pulumi.Input[_builtins.str] id_of_group_owner: The user id of the group owner
        :param pulumi.Input[_builtins.str] origin_id: The ID of the app instance if the originType is APPLICATION. This value is NULL if originType is OKTA_DIRECTORY.
        :param pulumi.Input[_builtins.str] origin_type: The source where group ownership is managed. Enum: "APPLICATION" "OKTA_DIRECTORY"
        :param pulumi.Input[_builtins.bool] resolved: If originType is APPLICATION, this parameter is set to FALSE until the owner's originId is reconciled with an associated Okta ID.
        :param pulumi.Input[_builtins.str] type: The entity type of the owner. Enum: "GROUP" "USER"
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OwnerState.__new__(_OwnerState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["id_of_group_owner"] = id_of_group_owner
        __props__.__dict__["origin_id"] = origin_id
        __props__.__dict__["origin_type"] = origin_type
        __props__.__dict__["resolved"] = resolved
        __props__.__dict__["type"] = type
        return Owner(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the group owner
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the group
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="idOfGroupOwner")
    def id_of_group_owner(self) -> pulumi.Output[_builtins.str]:
        """
        The user id of the group owner
        """
        return pulumi.get(self, "id_of_group_owner")

    @_builtins.property
    @pulumi.getter(name="originId")
    def origin_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the app instance if the originType is APPLICATION. This value is NULL if originType is OKTA_DIRECTORY.
        """
        return pulumi.get(self, "origin_id")

    @_builtins.property
    @pulumi.getter(name="originType")
    def origin_type(self) -> pulumi.Output[_builtins.str]:
        """
        The source where group ownership is managed. Enum: "APPLICATION" "OKTA_DIRECTORY"
        """
        return pulumi.get(self, "origin_type")

    @_builtins.property
    @pulumi.getter
    def resolved(self) -> pulumi.Output[_builtins.bool]:
        """
        If originType is APPLICATION, this parameter is set to FALSE until the owner's originId is reconciled with an associated Okta ID.
        """
        return pulumi.get(self, "resolved")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The entity type of the owner. Enum: "GROUP" "USER"
        """
        return pulumi.get(self, "type")

