# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSamlResult',
    'AwaitableGetSamlResult',
    'get_saml',
    'get_saml_output',
]

@pulumi.output_type
class GetSamlResult:
    """
    A collection of values returned by getSaml.
    """
    def __init__(__self__, acs_binding=None, acs_type=None, audience=None, id=None, issuer=None, issuer_mode=None, kid=None, name=None, sso_binding=None, sso_destination=None, sso_url=None, subject_filter=None, subject_formats=None, type=None):
        if acs_binding and not isinstance(acs_binding, str):
            raise TypeError("Expected argument 'acs_binding' to be a str")
        pulumi.set(__self__, "acs_binding", acs_binding)
        if acs_type and not isinstance(acs_type, str):
            raise TypeError("Expected argument 'acs_type' to be a str")
        pulumi.set(__self__, "acs_type", acs_type)
        if audience and not isinstance(audience, str):
            raise TypeError("Expected argument 'audience' to be a str")
        pulumi.set(__self__, "audience", audience)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if issuer_mode and not isinstance(issuer_mode, str):
            raise TypeError("Expected argument 'issuer_mode' to be a str")
        pulumi.set(__self__, "issuer_mode", issuer_mode)
        if kid and not isinstance(kid, str):
            raise TypeError("Expected argument 'kid' to be a str")
        pulumi.set(__self__, "kid", kid)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sso_binding and not isinstance(sso_binding, str):
            raise TypeError("Expected argument 'sso_binding' to be a str")
        pulumi.set(__self__, "sso_binding", sso_binding)
        if sso_destination and not isinstance(sso_destination, str):
            raise TypeError("Expected argument 'sso_destination' to be a str")
        pulumi.set(__self__, "sso_destination", sso_destination)
        if sso_url and not isinstance(sso_url, str):
            raise TypeError("Expected argument 'sso_url' to be a str")
        pulumi.set(__self__, "sso_url", sso_url)
        if subject_filter and not isinstance(subject_filter, str):
            raise TypeError("Expected argument 'subject_filter' to be a str")
        pulumi.set(__self__, "subject_filter", subject_filter)
        if subject_formats and not isinstance(subject_formats, list):
            raise TypeError("Expected argument 'subject_formats' to be a list")
        pulumi.set(__self__, "subject_formats", subject_formats)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="acsBinding")
    def acs_binding(self) -> _builtins.str:
        """
        ACS binding
        """
        return pulumi.get(self, "acs_binding")

    @_builtins.property
    @pulumi.getter(name="acsType")
    def acs_type(self) -> _builtins.str:
        """
        Determines whether to publish an instance-specific (trust) or organization (shared) ACS endpoint in the SAML metadata.
        """
        return pulumi.get(self, "acs_type")

    @_builtins.property
    @pulumi.getter
    def audience(self) -> _builtins.str:
        """
        URI that identifies the target Okta IdP instance (SP)
        """
        return pulumi.get(self, "audience")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Id of idp.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> _builtins.str:
        """
        URI that identifies the issuer (IdP).
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> _builtins.str:
        """
        Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL in the request to the IdP.
        """
        return pulumi.get(self, "issuer_mode")

    @_builtins.property
    @pulumi.getter
    def kid(self) -> _builtins.str:
        """
        Key ID reference to the IdP's X.509 signature certificate.
        """
        return pulumi.get(self, "kid")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the idp.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ssoBinding")
    def sso_binding(self) -> _builtins.str:
        """
        Single sign-on binding.
        """
        return pulumi.get(self, "sso_binding")

    @_builtins.property
    @pulumi.getter(name="ssoDestination")
    def sso_destination(self) -> _builtins.str:
        """
        SSO request binding, HTTP-POST or HTTP-REDIRECT.
        """
        return pulumi.get(self, "sso_destination")

    @_builtins.property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> _builtins.str:
        """
        Single sign-on url.
        """
        return pulumi.get(self, "sso_url")

    @_builtins.property
    @pulumi.getter(name="subjectFilter")
    def subject_filter(self) -> _builtins.str:
        """
        Regular expression pattern used to filter untrusted IdP usernames.
        """
        return pulumi.get(self, "subject_filter")

    @_builtins.property
    @pulumi.getter(name="subjectFormats")
    def subject_formats(self) -> Sequence[_builtins.str]:
        """
        Expression to generate or transform a unique username for the IdP user.
        """
        return pulumi.get(self, "subject_formats")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of idp.
        """
        return pulumi.get(self, "type")


class AwaitableGetSamlResult(GetSamlResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSamlResult(
            acs_binding=self.acs_binding,
            acs_type=self.acs_type,
            audience=self.audience,
            id=self.id,
            issuer=self.issuer,
            issuer_mode=self.issuer_mode,
            kid=self.kid,
            name=self.name,
            sso_binding=self.sso_binding,
            sso_destination=self.sso_destination,
            sso_url=self.sso_url,
            subject_filter=self.subject_filter,
            subject_formats=self.subject_formats,
            type=self.type)


def get_saml(id: Optional[_builtins.str] = None,
             name: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSamlResult:
    """
    Get a SAML IdP from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.idp.get_saml(name="Example App")
    ```


    :param _builtins.str id: Id of idp.
    :param _builtins.str name: Name of the idp.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('okta:idp/getSaml:getSaml', __args__, opts=opts, typ=GetSamlResult).value

    return AwaitableGetSamlResult(
        acs_binding=pulumi.get(__ret__, 'acs_binding'),
        acs_type=pulumi.get(__ret__, 'acs_type'),
        audience=pulumi.get(__ret__, 'audience'),
        id=pulumi.get(__ret__, 'id'),
        issuer=pulumi.get(__ret__, 'issuer'),
        issuer_mode=pulumi.get(__ret__, 'issuer_mode'),
        kid=pulumi.get(__ret__, 'kid'),
        name=pulumi.get(__ret__, 'name'),
        sso_binding=pulumi.get(__ret__, 'sso_binding'),
        sso_destination=pulumi.get(__ret__, 'sso_destination'),
        sso_url=pulumi.get(__ret__, 'sso_url'),
        subject_filter=pulumi.get(__ret__, 'subject_filter'),
        subject_formats=pulumi.get(__ret__, 'subject_formats'),
        type=pulumi.get(__ret__, 'type'))
def get_saml_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSamlResult]:
    """
    Get a SAML IdP from Okta.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_okta as okta

    example = okta.idp.get_saml(name="Example App")
    ```


    :param _builtins.str id: Id of idp.
    :param _builtins.str name: Name of the idp.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('okta:idp/getSaml:getSaml', __args__, opts=opts, typ=GetSamlResult)
    return __ret__.apply(lambda __response__: GetSamlResult(
        acs_binding=pulumi.get(__response__, 'acs_binding'),
        acs_type=pulumi.get(__response__, 'acs_type'),
        audience=pulumi.get(__response__, 'audience'),
        id=pulumi.get(__response__, 'id'),
        issuer=pulumi.get(__response__, 'issuer'),
        issuer_mode=pulumi.get(__response__, 'issuer_mode'),
        kid=pulumi.get(__response__, 'kid'),
        name=pulumi.get(__response__, 'name'),
        sso_binding=pulumi.get(__response__, 'sso_binding'),
        sso_destination=pulumi.get(__response__, 'sso_destination'),
        sso_url=pulumi.get(__response__, 'sso_url'),
        subject_filter=pulumi.get(__response__, 'subject_filter'),
        subject_formats=pulumi.get(__response__, 'subject_formats'),
        type=pulumi.get(__response__, 'type')))
