# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SamlArgs', 'Saml']

@pulumi.input_type
class SamlArgs:
    def __init__(__self__, *,
                 issuer: pulumi.Input[_builtins.str],
                 kid: pulumi.Input[_builtins.str],
                 sso_url: pulumi.Input[_builtins.str],
                 account_link_action: Optional[pulumi.Input[_builtins.str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 acs_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 honor_persistent_name_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 max_clock_skew: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_format: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_master: Optional[pulumi.Input[_builtins.bool]] = None,
                 provisioning_action: Optional[pulumi.Input[_builtins.str]] = None,
                 request_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 request_signature_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 response_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 response_signature_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_destination: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_formats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subject_match_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_type: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended_action: Optional[pulumi.Input[_builtins.str]] = None,
                 username_template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Saml resource.
        :param pulumi.Input[_builtins.str] issuer: URI that identifies the issuer.
        :param pulumi.Input[_builtins.str] kid: The ID of the signing key.
        :param pulumi.Input[_builtins.str] sso_url: URL of binding-specific endpoint to send an AuthnRequest message to IdP.
        :param pulumi.Input[_builtins.str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[_builtins.str] acs_type: The type of ACS. It can be `INSTANCE` or `ORG`. Default: `INSTANCE`
        :param pulumi.Input[_builtins.str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[_builtins.str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[_builtins.bool] honor_persistent_name_id: Determines if the IdP should persist account linking when the incoming assertion NameID format is
               urn:oasis:names:tc:SAML:2.0:nameid-format:persistent
        :param pulumi.Input[_builtins.str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        :param pulumi.Input[_builtins.int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[_builtins.str] name: Name of the IdP
        :param pulumi.Input[_builtins.str] name_format: The name identifier format to use. By default `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified`.
        :param pulumi.Input[_builtins.bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[_builtins.str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[_builtins.str] request_signature_algorithm: The XML digital Signature Algorithm used when signing an `AuthnRequest` message. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        :param pulumi.Input[_builtins.str] request_signature_scope: Specifies whether to digitally sign an AuthnRequest messages to the IdP. It can be `REQUEST` or `NONE`. Default: `REQUEST`
        :param pulumi.Input[_builtins.str] response_signature_algorithm: The minimum XML digital signature algorithm allowed when verifying a `SAMLResponse` message or Assertion element. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        :param pulumi.Input[_builtins.str] response_signature_scope: Specifies whether to verify a `SAMLResponse` message or Assertion element XML digital signature. It can be `RESPONSE`, `ASSERTION`, or `ANY`. Default: `ANY`
        :param pulumi.Input[_builtins.str] sso_binding: The method of making an SSO request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`. Default: `HTTP-POST`
        :param pulumi.Input[_builtins.str] sso_destination: URI reference indicating the address to which the AuthnRequest message is sent.
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] subject_filter: Optional regular expression pattern used to filter untrusted IdP usernames.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subject_formats: The name format.
        :param pulumi.Input[_builtins.str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "kid", kid)
        pulumi.set(__self__, "sso_url", sso_url)
        if account_link_action is not None:
            pulumi.set(__self__, "account_link_action", account_link_action)
        if account_link_group_includes is not None:
            pulumi.set(__self__, "account_link_group_includes", account_link_group_includes)
        if acs_type is not None:
            pulumi.set(__self__, "acs_type", acs_type)
        if deprovisioned_action is not None:
            pulumi.set(__self__, "deprovisioned_action", deprovisioned_action)
        if groups_action is not None:
            pulumi.set(__self__, "groups_action", groups_action)
        if groups_assignments is not None:
            pulumi.set(__self__, "groups_assignments", groups_assignments)
        if groups_attribute is not None:
            pulumi.set(__self__, "groups_attribute", groups_attribute)
        if groups_filters is not None:
            pulumi.set(__self__, "groups_filters", groups_filters)
        if honor_persistent_name_id is not None:
            pulumi.set(__self__, "honor_persistent_name_id", honor_persistent_name_id)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)
        if max_clock_skew is not None:
            pulumi.set(__self__, "max_clock_skew", max_clock_skew)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_format is not None:
            pulumi.set(__self__, "name_format", name_format)
        if profile_master is not None:
            pulumi.set(__self__, "profile_master", profile_master)
        if provisioning_action is not None:
            pulumi.set(__self__, "provisioning_action", provisioning_action)
        if request_signature_algorithm is not None:
            pulumi.set(__self__, "request_signature_algorithm", request_signature_algorithm)
        if request_signature_scope is not None:
            pulumi.set(__self__, "request_signature_scope", request_signature_scope)
        if response_signature_algorithm is not None:
            pulumi.set(__self__, "response_signature_algorithm", response_signature_algorithm)
        if response_signature_scope is not None:
            pulumi.set(__self__, "response_signature_scope", response_signature_scope)
        if sso_binding is not None:
            pulumi.set(__self__, "sso_binding", sso_binding)
        if sso_destination is not None:
            pulumi.set(__self__, "sso_destination", sso_destination)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subject_filter is not None:
            pulumi.set(__self__, "subject_filter", subject_filter)
        if subject_formats is not None:
            pulumi.set(__self__, "subject_formats", subject_formats)
        if subject_match_attribute is not None:
            pulumi.set(__self__, "subject_match_attribute", subject_match_attribute)
        if subject_match_type is not None:
            pulumi.set(__self__, "subject_match_type", subject_match_type)
        if suspended_action is not None:
            pulumi.set(__self__, "suspended_action", suspended_action)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Input[_builtins.str]:
        """
        URI that identifies the issuer.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter
    def kid(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the signing key.
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kid", value)

    @_builtins.property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> pulumi.Input[_builtins.str]:
        """
        URL of binding-specific endpoint to send an AuthnRequest message to IdP.
        """
        return pulumi.get(self, "sso_url")

    @sso_url.setter
    def sso_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sso_url", value)

    @_builtins.property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the account linking action for an IdP user. Default: `AUTO`
        """
        return pulumi.get(self, "account_link_action")

    @account_link_action.setter
    def account_link_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_link_action", value)

    @_builtins.property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Group memberships to determine link candidates.
        """
        return pulumi.get(self, "account_link_group_includes")

    @account_link_group_includes.setter
    def account_link_group_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "account_link_group_includes", value)

    @_builtins.property
    @pulumi.getter(name="acsType")
    def acs_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of ACS. It can be `INSTANCE` or `ORG`. Default: `INSTANCE`
        """
        return pulumi.get(self, "acs_type")

    @acs_type.setter
    def acs_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acs_type", value)

    @_builtins.property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "deprovisioned_action")

    @deprovisioned_action.setter
    def deprovisioned_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deprovisioned_action", value)

    @_builtins.property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        """
        return pulumi.get(self, "groups_action")

    @groups_action.setter
    def groups_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_action", value)

    @_builtins.property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        """
        return pulumi.get(self, "groups_assignments")

    @groups_assignments.setter
    def groups_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_assignments", value)

    @_builtins.property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        """
        return pulumi.get(self, "groups_attribute")

    @groups_attribute.setter
    def groups_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        """
        return pulumi.get(self, "groups_filters")

    @groups_filters.setter
    def groups_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_filters", value)

    @_builtins.property
    @pulumi.getter(name="honorPersistentNameId")
    def honor_persistent_name_id(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if the IdP should persist account linking when the incoming assertion NameID format is
        urn:oasis:names:tc:SAML:2.0:nameid-format:persistent
        """
        return pulumi.get(self, "honor_persistent_name_id")

    @honor_persistent_name_id.setter
    def honor_persistent_name_id(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "honor_persistent_name_id", value)

    @_builtins.property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        """
        return pulumi.get(self, "issuer_mode")

    @issuer_mode.setter
    def issuer_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_mode", value)

    @_builtins.property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum allowable clock-skew when processing messages from the IdP.
        """
        return pulumi.get(self, "max_clock_skew")

    @max_clock_skew.setter
    def max_clock_skew(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_clock_skew", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nameFormat")
    def name_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name identifier format to use. By default `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified`.
        """
        return pulumi.get(self, "name_format")

    @name_format.setter
    def name_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_format", value)

    @_builtins.property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if the IdP should act as a source of truth for user profile attributes.
        """
        return pulumi.get(self, "profile_master")

    @profile_master.setter
    def profile_master(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "profile_master", value)

    @_builtins.property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning action for an IdP user during authentication. Default: `AUTO`
        """
        return pulumi.get(self, "provisioning_action")

    @provisioning_action.setter
    def provisioning_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioning_action", value)

    @_builtins.property
    @pulumi.getter(name="requestSignatureAlgorithm")
    def request_signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The XML digital Signature Algorithm used when signing an `AuthnRequest` message. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        """
        return pulumi.get(self, "request_signature_algorithm")

    @request_signature_algorithm.setter
    def request_signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_signature_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="requestSignatureScope")
    def request_signature_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to digitally sign an AuthnRequest messages to the IdP. It can be `REQUEST` or `NONE`. Default: `REQUEST`
        """
        return pulumi.get(self, "request_signature_scope")

    @request_signature_scope.setter
    def request_signature_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_signature_scope", value)

    @_builtins.property
    @pulumi.getter(name="responseSignatureAlgorithm")
    def response_signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum XML digital signature algorithm allowed when verifying a `SAMLResponse` message or Assertion element. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        """
        return pulumi.get(self, "response_signature_algorithm")

    @response_signature_algorithm.setter
    def response_signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_signature_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="responseSignatureScope")
    def response_signature_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to verify a `SAMLResponse` message or Assertion element XML digital signature. It can be `RESPONSE`, `ASSERTION`, or `ANY`. Default: `ANY`
        """
        return pulumi.get(self, "response_signature_scope")

    @response_signature_scope.setter
    def response_signature_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_signature_scope", value)

    @_builtins.property
    @pulumi.getter(name="ssoBinding")
    def sso_binding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method of making an SSO request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`. Default: `HTTP-POST`
        """
        return pulumi.get(self, "sso_binding")

    @sso_binding.setter
    def sso_binding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sso_binding", value)

    @_builtins.property
    @pulumi.getter(name="ssoDestination")
    def sso_destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI reference indicating the address to which the AuthnRequest message is sent.
        """
        return pulumi.get(self, "sso_destination")

    @sso_destination.setter
    def sso_destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sso_destination", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subjectFilter")
    def subject_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional regular expression pattern used to filter untrusted IdP usernames.
        """
        return pulumi.get(self, "subject_filter")

    @subject_filter.setter
    def subject_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_filter", value)

    @_builtins.property
    @pulumi.getter(name="subjectFormats")
    def subject_formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The name format.
        """
        return pulumi.get(self, "subject_formats")

    @subject_formats.setter
    def subject_formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subject_formats", value)

    @_builtins.property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_attribute")

    @subject_match_attribute.setter
    def subject_match_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_match_attribute", value)

    @_builtins.property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_type")

    @subject_match_type.setter
    def subject_match_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_match_type", value)

    @_builtins.property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "suspended_action")

    @suspended_action.setter
    def suspended_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "suspended_action", value)

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        return pulumi.get(self, "username_template")

    @username_template.setter
    def username_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username_template", value)


@pulumi.input_type
class _SamlState:
    def __init__(__self__, *,
                 account_link_action: Optional[pulumi.Input[_builtins.str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 acs_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 acs_type: Optional[pulumi.Input[_builtins.str]] = None,
                 audience: Optional[pulumi.Input[_builtins.str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 honor_persistent_name_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 kid: Optional[pulumi.Input[_builtins.str]] = None,
                 max_clock_skew: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_format: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_master: Optional[pulumi.Input[_builtins.bool]] = None,
                 provisioning_action: Optional[pulumi.Input[_builtins.str]] = None,
                 request_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 request_signature_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 response_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 response_signature_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_destination: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_url: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_formats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subject_match_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_type: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended_action: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type_id: Optional[pulumi.Input[_builtins.str]] = None,
                 username_template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Saml resources.
        :param pulumi.Input[_builtins.str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[_builtins.str] acs_type: The type of ACS. It can be `INSTANCE` or `ORG`. Default: `INSTANCE`
        :param pulumi.Input[_builtins.str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[_builtins.str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[_builtins.bool] honor_persistent_name_id: Determines if the IdP should persist account linking when the incoming assertion NameID format is
               urn:oasis:names:tc:SAML:2.0:nameid-format:persistent
        :param pulumi.Input[_builtins.str] issuer: URI that identifies the issuer.
        :param pulumi.Input[_builtins.str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        :param pulumi.Input[_builtins.str] kid: The ID of the signing key.
        :param pulumi.Input[_builtins.int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[_builtins.str] name: Name of the IdP
        :param pulumi.Input[_builtins.str] name_format: The name identifier format to use. By default `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified`.
        :param pulumi.Input[_builtins.bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[_builtins.str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[_builtins.str] request_signature_algorithm: The XML digital Signature Algorithm used when signing an `AuthnRequest` message. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        :param pulumi.Input[_builtins.str] request_signature_scope: Specifies whether to digitally sign an AuthnRequest messages to the IdP. It can be `REQUEST` or `NONE`. Default: `REQUEST`
        :param pulumi.Input[_builtins.str] response_signature_algorithm: The minimum XML digital signature algorithm allowed when verifying a `SAMLResponse` message or Assertion element. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        :param pulumi.Input[_builtins.str] response_signature_scope: Specifies whether to verify a `SAMLResponse` message or Assertion element XML digital signature. It can be `RESPONSE`, `ASSERTION`, or `ANY`. Default: `ANY`
        :param pulumi.Input[_builtins.str] sso_binding: The method of making an SSO request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`. Default: `HTTP-POST`
        :param pulumi.Input[_builtins.str] sso_destination: URI reference indicating the address to which the AuthnRequest message is sent.
        :param pulumi.Input[_builtins.str] sso_url: URL of binding-specific endpoint to send an AuthnRequest message to IdP.
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] subject_filter: Optional regular expression pattern used to filter untrusted IdP usernames.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subject_formats: The name format.
        :param pulumi.Input[_builtins.str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        if account_link_action is not None:
            pulumi.set(__self__, "account_link_action", account_link_action)
        if account_link_group_includes is not None:
            pulumi.set(__self__, "account_link_group_includes", account_link_group_includes)
        if acs_binding is not None:
            pulumi.set(__self__, "acs_binding", acs_binding)
        if acs_type is not None:
            pulumi.set(__self__, "acs_type", acs_type)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if deprovisioned_action is not None:
            pulumi.set(__self__, "deprovisioned_action", deprovisioned_action)
        if groups_action is not None:
            pulumi.set(__self__, "groups_action", groups_action)
        if groups_assignments is not None:
            pulumi.set(__self__, "groups_assignments", groups_assignments)
        if groups_attribute is not None:
            pulumi.set(__self__, "groups_attribute", groups_attribute)
        if groups_filters is not None:
            pulumi.set(__self__, "groups_filters", groups_filters)
        if honor_persistent_name_id is not None:
            pulumi.set(__self__, "honor_persistent_name_id", honor_persistent_name_id)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if issuer_mode is not None:
            pulumi.set(__self__, "issuer_mode", issuer_mode)
        if kid is not None:
            pulumi.set(__self__, "kid", kid)
        if max_clock_skew is not None:
            pulumi.set(__self__, "max_clock_skew", max_clock_skew)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_format is not None:
            pulumi.set(__self__, "name_format", name_format)
        if profile_master is not None:
            pulumi.set(__self__, "profile_master", profile_master)
        if provisioning_action is not None:
            pulumi.set(__self__, "provisioning_action", provisioning_action)
        if request_signature_algorithm is not None:
            pulumi.set(__self__, "request_signature_algorithm", request_signature_algorithm)
        if request_signature_scope is not None:
            pulumi.set(__self__, "request_signature_scope", request_signature_scope)
        if response_signature_algorithm is not None:
            pulumi.set(__self__, "response_signature_algorithm", response_signature_algorithm)
        if response_signature_scope is not None:
            pulumi.set(__self__, "response_signature_scope", response_signature_scope)
        if sso_binding is not None:
            pulumi.set(__self__, "sso_binding", sso_binding)
        if sso_destination is not None:
            pulumi.set(__self__, "sso_destination", sso_destination)
        if sso_url is not None:
            pulumi.set(__self__, "sso_url", sso_url)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subject_filter is not None:
            pulumi.set(__self__, "subject_filter", subject_filter)
        if subject_formats is not None:
            pulumi.set(__self__, "subject_formats", subject_formats)
        if subject_match_attribute is not None:
            pulumi.set(__self__, "subject_match_attribute", subject_match_attribute)
        if subject_match_type is not None:
            pulumi.set(__self__, "subject_match_type", subject_match_type)
        if suspended_action is not None:
            pulumi.set(__self__, "suspended_action", suspended_action)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_type_id is not None:
            pulumi.set(__self__, "user_type_id", user_type_id)
        if username_template is not None:
            pulumi.set(__self__, "username_template", username_template)

    @_builtins.property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the account linking action for an IdP user. Default: `AUTO`
        """
        return pulumi.get(self, "account_link_action")

    @account_link_action.setter
    def account_link_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_link_action", value)

    @_builtins.property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Group memberships to determine link candidates.
        """
        return pulumi.get(self, "account_link_group_includes")

    @account_link_group_includes.setter
    def account_link_group_includes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "account_link_group_includes", value)

    @_builtins.property
    @pulumi.getter(name="acsBinding")
    def acs_binding(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "acs_binding")

    @acs_binding.setter
    def acs_binding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acs_binding", value)

    @_builtins.property
    @pulumi.getter(name="acsType")
    def acs_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of ACS. It can be `INSTANCE` or `ORG`. Default: `INSTANCE`
        """
        return pulumi.get(self, "acs_type")

    @acs_type.setter
    def acs_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "acs_type", value)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audience", value)

    @_builtins.property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "deprovisioned_action")

    @deprovisioned_action.setter
    def deprovisioned_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deprovisioned_action", value)

    @_builtins.property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        """
        return pulumi.get(self, "groups_action")

    @groups_action.setter
    def groups_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_action", value)

    @_builtins.property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        """
        return pulumi.get(self, "groups_assignments")

    @groups_assignments.setter
    def groups_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_assignments", value)

    @_builtins.property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        """
        return pulumi.get(self, "groups_attribute")

    @groups_attribute.setter
    def groups_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "groups_attribute", value)

    @_builtins.property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        """
        return pulumi.get(self, "groups_filters")

    @groups_filters.setter
    def groups_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_filters", value)

    @_builtins.property
    @pulumi.getter(name="honorPersistentNameId")
    def honor_persistent_name_id(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if the IdP should persist account linking when the incoming assertion NameID format is
        urn:oasis:names:tc:SAML:2.0:nameid-format:persistent
        """
        return pulumi.get(self, "honor_persistent_name_id")

    @honor_persistent_name_id.setter
    def honor_persistent_name_id(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "honor_persistent_name_id", value)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI that identifies the issuer.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer", value)

    @_builtins.property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        """
        return pulumi.get(self, "issuer_mode")

    @issuer_mode.setter
    def issuer_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issuer_mode", value)

    @_builtins.property
    @pulumi.getter
    def kid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the signing key.
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kid", value)

    @_builtins.property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum allowable clock-skew when processing messages from the IdP.
        """
        return pulumi.get(self, "max_clock_skew")

    @max_clock_skew.setter
    def max_clock_skew(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_clock_skew", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nameFormat")
    def name_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name identifier format to use. By default `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified`.
        """
        return pulumi.get(self, "name_format")

    @name_format.setter
    def name_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_format", value)

    @_builtins.property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if the IdP should act as a source of truth for user profile attributes.
        """
        return pulumi.get(self, "profile_master")

    @profile_master.setter
    def profile_master(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "profile_master", value)

    @_builtins.property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioning action for an IdP user during authentication. Default: `AUTO`
        """
        return pulumi.get(self, "provisioning_action")

    @provisioning_action.setter
    def provisioning_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioning_action", value)

    @_builtins.property
    @pulumi.getter(name="requestSignatureAlgorithm")
    def request_signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The XML digital Signature Algorithm used when signing an `AuthnRequest` message. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        """
        return pulumi.get(self, "request_signature_algorithm")

    @request_signature_algorithm.setter
    def request_signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_signature_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="requestSignatureScope")
    def request_signature_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to digitally sign an AuthnRequest messages to the IdP. It can be `REQUEST` or `NONE`. Default: `REQUEST`
        """
        return pulumi.get(self, "request_signature_scope")

    @request_signature_scope.setter
    def request_signature_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_signature_scope", value)

    @_builtins.property
    @pulumi.getter(name="responseSignatureAlgorithm")
    def response_signature_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum XML digital signature algorithm allowed when verifying a `SAMLResponse` message or Assertion element. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        """
        return pulumi.get(self, "response_signature_algorithm")

    @response_signature_algorithm.setter
    def response_signature_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_signature_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="responseSignatureScope")
    def response_signature_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to verify a `SAMLResponse` message or Assertion element XML digital signature. It can be `RESPONSE`, `ASSERTION`, or `ANY`. Default: `ANY`
        """
        return pulumi.get(self, "response_signature_scope")

    @response_signature_scope.setter
    def response_signature_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_signature_scope", value)

    @_builtins.property
    @pulumi.getter(name="ssoBinding")
    def sso_binding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method of making an SSO request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`. Default: `HTTP-POST`
        """
        return pulumi.get(self, "sso_binding")

    @sso_binding.setter
    def sso_binding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sso_binding", value)

    @_builtins.property
    @pulumi.getter(name="ssoDestination")
    def sso_destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI reference indicating the address to which the AuthnRequest message is sent.
        """
        return pulumi.get(self, "sso_destination")

    @sso_destination.setter
    def sso_destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sso_destination", value)

    @_builtins.property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of binding-specific endpoint to send an AuthnRequest message to IdP.
        """
        return pulumi.get(self, "sso_url")

    @sso_url.setter
    def sso_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sso_url", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subjectFilter")
    def subject_filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional regular expression pattern used to filter untrusted IdP usernames.
        """
        return pulumi.get(self, "subject_filter")

    @subject_filter.setter
    def subject_filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_filter", value)

    @_builtins.property
    @pulumi.getter(name="subjectFormats")
    def subject_formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The name format.
        """
        return pulumi.get(self, "subject_formats")

    @subject_formats.setter
    def subject_formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subject_formats", value)

    @_builtins.property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_attribute")

    @subject_match_attribute.setter
    def subject_match_attribute(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_match_attribute", value)

    @_builtins.property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_type")

    @subject_match_type.setter
    def subject_match_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subject_match_type", value)

    @_builtins.property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "suspended_action")

    @suspended_action.setter
    def suspended_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "suspended_action", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userTypeId")
    def user_type_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "user_type_id")

    @user_type_id.setter
    def user_type_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type_id", value)

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        return pulumi.get(self, "username_template")

    @username_template.setter
    def username_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username_template", value)


@pulumi.type_token("okta:idp/saml:Saml")
class Saml(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_link_action: Optional[pulumi.Input[_builtins.str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 acs_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 honor_persistent_name_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 kid: Optional[pulumi.Input[_builtins.str]] = None,
                 max_clock_skew: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_format: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_master: Optional[pulumi.Input[_builtins.bool]] = None,
                 provisioning_action: Optional[pulumi.Input[_builtins.str]] = None,
                 request_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 request_signature_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 response_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 response_signature_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_destination: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_url: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_formats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subject_match_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_type: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended_action: Optional[pulumi.Input[_builtins.str]] = None,
                 username_template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a SAML Identity Provider. This resource allows you to create and configure a SAML Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.idp.Saml("example",
            name="testAcc_replace_with_uuid",
            acs_type="INSTANCE",
            sso_url="https://idp.example.com",
            sso_destination="https://idp.example.com",
            sso_binding="HTTP-POST",
            username_template="idpuser.email",
            kid=test["id"],
            issuer="https://idp.example.com",
            request_signature_scope="REQUEST",
            response_signature_scope="ANY")
        ```

        ## Import

        ```sh
        $ pulumi import okta:idp/saml:Saml example <idp_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[_builtins.str] acs_type: The type of ACS. It can be `INSTANCE` or `ORG`. Default: `INSTANCE`
        :param pulumi.Input[_builtins.str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[_builtins.str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[_builtins.bool] honor_persistent_name_id: Determines if the IdP should persist account linking when the incoming assertion NameID format is
               urn:oasis:names:tc:SAML:2.0:nameid-format:persistent
        :param pulumi.Input[_builtins.str] issuer: URI that identifies the issuer.
        :param pulumi.Input[_builtins.str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        :param pulumi.Input[_builtins.str] kid: The ID of the signing key.
        :param pulumi.Input[_builtins.int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[_builtins.str] name: Name of the IdP
        :param pulumi.Input[_builtins.str] name_format: The name identifier format to use. By default `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified`.
        :param pulumi.Input[_builtins.bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[_builtins.str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[_builtins.str] request_signature_algorithm: The XML digital Signature Algorithm used when signing an `AuthnRequest` message. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        :param pulumi.Input[_builtins.str] request_signature_scope: Specifies whether to digitally sign an AuthnRequest messages to the IdP. It can be `REQUEST` or `NONE`. Default: `REQUEST`
        :param pulumi.Input[_builtins.str] response_signature_algorithm: The minimum XML digital signature algorithm allowed when verifying a `SAMLResponse` message or Assertion element. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        :param pulumi.Input[_builtins.str] response_signature_scope: Specifies whether to verify a `SAMLResponse` message or Assertion element XML digital signature. It can be `RESPONSE`, `ASSERTION`, or `ANY`. Default: `ANY`
        :param pulumi.Input[_builtins.str] sso_binding: The method of making an SSO request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`. Default: `HTTP-POST`
        :param pulumi.Input[_builtins.str] sso_destination: URI reference indicating the address to which the AuthnRequest message is sent.
        :param pulumi.Input[_builtins.str] sso_url: URL of binding-specific endpoint to send an AuthnRequest message to IdP.
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] subject_filter: Optional regular expression pattern used to filter untrusted IdP usernames.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subject_formats: The name format.
        :param pulumi.Input[_builtins.str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SamlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a SAML Identity Provider. This resource allows you to create and configure a SAML Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.idp.Saml("example",
            name="testAcc_replace_with_uuid",
            acs_type="INSTANCE",
            sso_url="https://idp.example.com",
            sso_destination="https://idp.example.com",
            sso_binding="HTTP-POST",
            username_template="idpuser.email",
            kid=test["id"],
            issuer="https://idp.example.com",
            request_signature_scope="REQUEST",
            response_signature_scope="ANY")
        ```

        ## Import

        ```sh
        $ pulumi import okta:idp/saml:Saml example <idp_id>
        ```

        :param str resource_name: The name of the resource.
        :param SamlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SamlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_link_action: Optional[pulumi.Input[_builtins.str]] = None,
                 account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 acs_type: Optional[pulumi.Input[_builtins.str]] = None,
                 deprovisioned_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_action: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 groups_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 honor_persistent_name_id: Optional[pulumi.Input[_builtins.bool]] = None,
                 issuer: Optional[pulumi.Input[_builtins.str]] = None,
                 issuer_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 kid: Optional[pulumi.Input[_builtins.str]] = None,
                 max_clock_skew: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_format: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_master: Optional[pulumi.Input[_builtins.bool]] = None,
                 provisioning_action: Optional[pulumi.Input[_builtins.str]] = None,
                 request_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 request_signature_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 response_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 response_signature_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_binding: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_destination: Optional[pulumi.Input[_builtins.str]] = None,
                 sso_url: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_filter: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_formats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 subject_match_attribute: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_match_type: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended_action: Optional[pulumi.Input[_builtins.str]] = None,
                 username_template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SamlArgs.__new__(SamlArgs)

            __props__.__dict__["account_link_action"] = account_link_action
            __props__.__dict__["account_link_group_includes"] = account_link_group_includes
            __props__.__dict__["acs_type"] = acs_type
            __props__.__dict__["deprovisioned_action"] = deprovisioned_action
            __props__.__dict__["groups_action"] = groups_action
            __props__.__dict__["groups_assignments"] = groups_assignments
            __props__.__dict__["groups_attribute"] = groups_attribute
            __props__.__dict__["groups_filters"] = groups_filters
            __props__.__dict__["honor_persistent_name_id"] = honor_persistent_name_id
            if issuer is None and not opts.urn:
                raise TypeError("Missing required property 'issuer'")
            __props__.__dict__["issuer"] = issuer
            __props__.__dict__["issuer_mode"] = issuer_mode
            if kid is None and not opts.urn:
                raise TypeError("Missing required property 'kid'")
            __props__.__dict__["kid"] = kid
            __props__.__dict__["max_clock_skew"] = max_clock_skew
            __props__.__dict__["name"] = name
            __props__.__dict__["name_format"] = name_format
            __props__.__dict__["profile_master"] = profile_master
            __props__.__dict__["provisioning_action"] = provisioning_action
            __props__.__dict__["request_signature_algorithm"] = request_signature_algorithm
            __props__.__dict__["request_signature_scope"] = request_signature_scope
            __props__.__dict__["response_signature_algorithm"] = response_signature_algorithm
            __props__.__dict__["response_signature_scope"] = response_signature_scope
            __props__.__dict__["sso_binding"] = sso_binding
            __props__.__dict__["sso_destination"] = sso_destination
            if sso_url is None and not opts.urn:
                raise TypeError("Missing required property 'sso_url'")
            __props__.__dict__["sso_url"] = sso_url
            __props__.__dict__["status"] = status
            __props__.__dict__["subject_filter"] = subject_filter
            __props__.__dict__["subject_formats"] = subject_formats
            __props__.__dict__["subject_match_attribute"] = subject_match_attribute
            __props__.__dict__["subject_match_type"] = subject_match_type
            __props__.__dict__["suspended_action"] = suspended_action
            __props__.__dict__["username_template"] = username_template
            __props__.__dict__["acs_binding"] = None
            __props__.__dict__["audience"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["user_type_id"] = None
        super(Saml, __self__).__init__(
            'okta:idp/saml:Saml',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_link_action: Optional[pulumi.Input[_builtins.str]] = None,
            account_link_group_includes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            acs_binding: Optional[pulumi.Input[_builtins.str]] = None,
            acs_type: Optional[pulumi.Input[_builtins.str]] = None,
            audience: Optional[pulumi.Input[_builtins.str]] = None,
            deprovisioned_action: Optional[pulumi.Input[_builtins.str]] = None,
            groups_action: Optional[pulumi.Input[_builtins.str]] = None,
            groups_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            groups_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            groups_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            honor_persistent_name_id: Optional[pulumi.Input[_builtins.bool]] = None,
            issuer: Optional[pulumi.Input[_builtins.str]] = None,
            issuer_mode: Optional[pulumi.Input[_builtins.str]] = None,
            kid: Optional[pulumi.Input[_builtins.str]] = None,
            max_clock_skew: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_format: Optional[pulumi.Input[_builtins.str]] = None,
            profile_master: Optional[pulumi.Input[_builtins.bool]] = None,
            provisioning_action: Optional[pulumi.Input[_builtins.str]] = None,
            request_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            request_signature_scope: Optional[pulumi.Input[_builtins.str]] = None,
            response_signature_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            response_signature_scope: Optional[pulumi.Input[_builtins.str]] = None,
            sso_binding: Optional[pulumi.Input[_builtins.str]] = None,
            sso_destination: Optional[pulumi.Input[_builtins.str]] = None,
            sso_url: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subject_filter: Optional[pulumi.Input[_builtins.str]] = None,
            subject_formats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            subject_match_attribute: Optional[pulumi.Input[_builtins.str]] = None,
            subject_match_type: Optional[pulumi.Input[_builtins.str]] = None,
            suspended_action: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_type_id: Optional[pulumi.Input[_builtins.str]] = None,
            username_template: Optional[pulumi.Input[_builtins.str]] = None) -> 'Saml':
        """
        Get an existing Saml resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_link_action: Specifies the account linking action for an IdP user. Default: `AUTO`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[_builtins.str] acs_type: The type of ACS. It can be `INSTANCE` or `ORG`. Default: `INSTANCE`
        :param pulumi.Input[_builtins.str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] groups_action: Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        :param pulumi.Input[_builtins.str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        :param pulumi.Input[_builtins.bool] honor_persistent_name_id: Determines if the IdP should persist account linking when the incoming assertion NameID format is
               urn:oasis:names:tc:SAML:2.0:nameid-format:persistent
        :param pulumi.Input[_builtins.str] issuer: URI that identifies the issuer.
        :param pulumi.Input[_builtins.str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        :param pulumi.Input[_builtins.str] kid: The ID of the signing key.
        :param pulumi.Input[_builtins.int] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[_builtins.str] name: Name of the IdP
        :param pulumi.Input[_builtins.str] name_format: The name identifier format to use. By default `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified`.
        :param pulumi.Input[_builtins.bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[_builtins.str] provisioning_action: Provisioning action for an IdP user during authentication. Default: `AUTO`
        :param pulumi.Input[_builtins.str] request_signature_algorithm: The XML digital Signature Algorithm used when signing an `AuthnRequest` message. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        :param pulumi.Input[_builtins.str] request_signature_scope: Specifies whether to digitally sign an AuthnRequest messages to the IdP. It can be `REQUEST` or `NONE`. Default: `REQUEST`
        :param pulumi.Input[_builtins.str] response_signature_algorithm: The minimum XML digital signature algorithm allowed when verifying a `SAMLResponse` message or Assertion element. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        :param pulumi.Input[_builtins.str] response_signature_scope: Specifies whether to verify a `SAMLResponse` message or Assertion element XML digital signature. It can be `RESPONSE`, `ASSERTION`, or `ANY`. Default: `ANY`
        :param pulumi.Input[_builtins.str] sso_binding: The method of making an SSO request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`. Default: `HTTP-POST`
        :param pulumi.Input[_builtins.str] sso_destination: URI reference indicating the address to which the AuthnRequest message is sent.
        :param pulumi.Input[_builtins.str] sso_url: URL of binding-specific endpoint to send an AuthnRequest message to IdP.
        :param pulumi.Input[_builtins.str] status: Default to `ACTIVE`
        :param pulumi.Input[_builtins.str] subject_filter: Optional regular expression pattern used to filter untrusted IdP usernames.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subject_formats: The name format.
        :param pulumi.Input[_builtins.str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        :param pulumi.Input[_builtins.str] suspended_action: Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        :param pulumi.Input[_builtins.str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SamlState.__new__(_SamlState)

        __props__.__dict__["account_link_action"] = account_link_action
        __props__.__dict__["account_link_group_includes"] = account_link_group_includes
        __props__.__dict__["acs_binding"] = acs_binding
        __props__.__dict__["acs_type"] = acs_type
        __props__.__dict__["audience"] = audience
        __props__.__dict__["deprovisioned_action"] = deprovisioned_action
        __props__.__dict__["groups_action"] = groups_action
        __props__.__dict__["groups_assignments"] = groups_assignments
        __props__.__dict__["groups_attribute"] = groups_attribute
        __props__.__dict__["groups_filters"] = groups_filters
        __props__.__dict__["honor_persistent_name_id"] = honor_persistent_name_id
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["issuer_mode"] = issuer_mode
        __props__.__dict__["kid"] = kid
        __props__.__dict__["max_clock_skew"] = max_clock_skew
        __props__.__dict__["name"] = name
        __props__.__dict__["name_format"] = name_format
        __props__.__dict__["profile_master"] = profile_master
        __props__.__dict__["provisioning_action"] = provisioning_action
        __props__.__dict__["request_signature_algorithm"] = request_signature_algorithm
        __props__.__dict__["request_signature_scope"] = request_signature_scope
        __props__.__dict__["response_signature_algorithm"] = response_signature_algorithm
        __props__.__dict__["response_signature_scope"] = response_signature_scope
        __props__.__dict__["sso_binding"] = sso_binding
        __props__.__dict__["sso_destination"] = sso_destination
        __props__.__dict__["sso_url"] = sso_url
        __props__.__dict__["status"] = status
        __props__.__dict__["subject_filter"] = subject_filter
        __props__.__dict__["subject_formats"] = subject_formats
        __props__.__dict__["subject_match_attribute"] = subject_match_attribute
        __props__.__dict__["subject_match_type"] = subject_match_type
        __props__.__dict__["suspended_action"] = suspended_action
        __props__.__dict__["type"] = type
        __props__.__dict__["user_type_id"] = user_type_id
        __props__.__dict__["username_template"] = username_template
        return Saml(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountLinkAction")
    def account_link_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the account linking action for an IdP user. Default: `AUTO`
        """
        return pulumi.get(self, "account_link_action")

    @_builtins.property
    @pulumi.getter(name="accountLinkGroupIncludes")
    def account_link_group_includes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Group memberships to determine link candidates.
        """
        return pulumi.get(self, "account_link_group_includes")

    @_builtins.property
    @pulumi.getter(name="acsBinding")
    def acs_binding(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "acs_binding")

    @_builtins.property
    @pulumi.getter(name="acsType")
    def acs_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of ACS. It can be `INSTANCE` or `ORG`. Default: `INSTANCE`
        """
        return pulumi.get(self, "acs_type")

    @_builtins.property
    @pulumi.getter
    def audience(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "audience")

    @_builtins.property
    @pulumi.getter(name="deprovisionedAction")
    def deprovisioned_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Action for a previously deprovisioned IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "deprovisioned_action")

    @_builtins.property
    @pulumi.getter(name="groupsAction")
    def groups_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provisioning action for IdP user's group memberships. It can be `NONE`, `SYNC`, `APPEND`, or `ASSIGN`. Default: `NONE`
        """
        return pulumi.get(self, "groups_action")

    @_builtins.property
    @pulumi.getter(name="groupsAssignments")
    def groups_assignments(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Okta Group IDs to add an IdP user as a member with the `ASSIGN` `groups_action`.
        """
        return pulumi.get(self, "groups_assignments")

    @_builtins.property
    @pulumi.getter(name="groupsAttribute")
    def groups_attribute(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        """
        return pulumi.get(self, "groups_attribute")

    @_builtins.property
    @pulumi.getter(name="groupsFilters")
    def groups_filters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Whitelist of Okta Group identifiers that are allowed for the `APPEND` or `SYNC` `groups_action`.
        """
        return pulumi.get(self, "groups_filters")

    @_builtins.property
    @pulumi.getter(name="honorPersistentNameId")
    def honor_persistent_name_id(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Determines if the IdP should persist account linking when the incoming assertion NameID format is
        urn:oasis:names:tc:SAML:2.0:nameid-format:persistent
        """
        return pulumi.get(self, "honor_persistent_name_id")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[_builtins.str]:
        """
        URI that identifies the issuer.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter(name="issuerMode")
    def issuer_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL
        """
        return pulumi.get(self, "issuer_mode")

    @_builtins.property
    @pulumi.getter
    def kid(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the signing key.
        """
        return pulumi.get(self, "kid")

    @_builtins.property
    @pulumi.getter(name="maxClockSkew")
    def max_clock_skew(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum allowable clock-skew when processing messages from the IdP.
        """
        return pulumi.get(self, "max_clock_skew")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the IdP
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameFormat")
    def name_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name identifier format to use. By default `urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified`.
        """
        return pulumi.get(self, "name_format")

    @_builtins.property
    @pulumi.getter(name="profileMaster")
    def profile_master(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Determines if the IdP should act as a source of truth for user profile attributes.
        """
        return pulumi.get(self, "profile_master")

    @_builtins.property
    @pulumi.getter(name="provisioningAction")
    def provisioning_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Provisioning action for an IdP user during authentication. Default: `AUTO`
        """
        return pulumi.get(self, "provisioning_action")

    @_builtins.property
    @pulumi.getter(name="requestSignatureAlgorithm")
    def request_signature_algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The XML digital Signature Algorithm used when signing an `AuthnRequest` message. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        """
        return pulumi.get(self, "request_signature_algorithm")

    @_builtins.property
    @pulumi.getter(name="requestSignatureScope")
    def request_signature_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to digitally sign an AuthnRequest messages to the IdP. It can be `REQUEST` or `NONE`. Default: `REQUEST`
        """
        return pulumi.get(self, "request_signature_scope")

    @_builtins.property
    @pulumi.getter(name="responseSignatureAlgorithm")
    def response_signature_algorithm(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The minimum XML digital signature algorithm allowed when verifying a `SAMLResponse` message or Assertion element. It can be `SHA-256` or `SHA-1`. Default: `SHA-256`
        """
        return pulumi.get(self, "response_signature_algorithm")

    @_builtins.property
    @pulumi.getter(name="responseSignatureScope")
    def response_signature_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether to verify a `SAMLResponse` message or Assertion element XML digital signature. It can be `RESPONSE`, `ASSERTION`, or `ANY`. Default: `ANY`
        """
        return pulumi.get(self, "response_signature_scope")

    @_builtins.property
    @pulumi.getter(name="ssoBinding")
    def sso_binding(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The method of making an SSO request. It can be set to `HTTP-POST` or `HTTP-REDIRECT`. Default: `HTTP-POST`
        """
        return pulumi.get(self, "sso_binding")

    @_builtins.property
    @pulumi.getter(name="ssoDestination")
    def sso_destination(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URI reference indicating the address to which the AuthnRequest message is sent.
        """
        return pulumi.get(self, "sso_destination")

    @_builtins.property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of binding-specific endpoint to send an AuthnRequest message to IdP.
        """
        return pulumi.get(self, "sso_url")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Default to `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subjectFilter")
    def subject_filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional regular expression pattern used to filter untrusted IdP usernames.
        """
        return pulumi.get(self, "subject_filter")

    @_builtins.property
    @pulumi.getter(name="subjectFormats")
    def subject_formats(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The name format.
        """
        return pulumi.get(self, "subject_formats")

    @_builtins.property
    @pulumi.getter(name="subjectMatchAttribute")
    def subject_match_attribute(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Okta user profile attribute for matching transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_attribute")

    @_builtins.property
    @pulumi.getter(name="subjectMatchType")
    def subject_match_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default, it is set to `USERNAME`. It can be set to `USERNAME`, `EMAIL`, `USERNAME_OR_EMAIL` or `CUSTOM_ATTRIBUTE`.
        """
        return pulumi.get(self, "subject_match_type")

    @_builtins.property
    @pulumi.getter(name="suspendedAction")
    def suspended_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Action for a previously suspended IdP user during authentication. Can be `NONE` or `REACTIVATE`. Default: `NONE`
        """
        return pulumi.get(self, "suspended_action")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userTypeId")
    def user_type_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "user_type_id")

    @_builtins.property
    @pulumi.getter(name="usernameTemplate")
    def username_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Okta EL Expression to generate or transform a unique username for the IdP user. Default: `idpuser.email`
        """
        return pulumi.get(self, "username_template")

