# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LinkValueArgs', 'LinkValue']

@pulumi.input_type
class LinkValueArgs:
    def __init__(__self__, *,
                 primary_name: pulumi.Input[_builtins.str],
                 primary_user_id: pulumi.Input[_builtins.str],
                 associated_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LinkValue resource.
        :param pulumi.Input[_builtins.str] primary_name: Name of the `primary` relationship being assigned.
        :param pulumi.Input[_builtins.str] primary_user_id: User ID to be assigned to `primary` for the 'associated' user in the specified relationship.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_user_ids: Set of User IDs or login values of the users to be assigned the `associated` relationship.
        """
        pulumi.set(__self__, "primary_name", primary_name)
        pulumi.set(__self__, "primary_user_id", primary_user_id)
        if associated_user_ids is not None:
            pulumi.set(__self__, "associated_user_ids", associated_user_ids)

    @_builtins.property
    @pulumi.getter(name="primaryName")
    def primary_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the `primary` relationship being assigned.
        """
        return pulumi.get(self, "primary_name")

    @primary_name.setter
    def primary_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "primary_name", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserId")
    def primary_user_id(self) -> pulumi.Input[_builtins.str]:
        """
        User ID to be assigned to `primary` for the 'associated' user in the specified relationship.
        """
        return pulumi.get(self, "primary_user_id")

    @primary_user_id.setter
    def primary_user_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "primary_user_id", value)

    @_builtins.property
    @pulumi.getter(name="associatedUserIds")
    def associated_user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of User IDs or login values of the users to be assigned the `associated` relationship.
        """
        return pulumi.get(self, "associated_user_ids")

    @associated_user_ids.setter
    def associated_user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "associated_user_ids", value)


@pulumi.input_type
class _LinkValueState:
    def __init__(__self__, *,
                 associated_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 primary_name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LinkValue resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_user_ids: Set of User IDs or login values of the users to be assigned the `associated` relationship.
        :param pulumi.Input[_builtins.str] primary_name: Name of the `primary` relationship being assigned.
        :param pulumi.Input[_builtins.str] primary_user_id: User ID to be assigned to `primary` for the 'associated' user in the specified relationship.
        """
        if associated_user_ids is not None:
            pulumi.set(__self__, "associated_user_ids", associated_user_ids)
        if primary_name is not None:
            pulumi.set(__self__, "primary_name", primary_name)
        if primary_user_id is not None:
            pulumi.set(__self__, "primary_user_id", primary_user_id)

    @_builtins.property
    @pulumi.getter(name="associatedUserIds")
    def associated_user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Set of User IDs or login values of the users to be assigned the `associated` relationship.
        """
        return pulumi.get(self, "associated_user_ids")

    @associated_user_ids.setter
    def associated_user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "associated_user_ids", value)

    @_builtins.property
    @pulumi.getter(name="primaryName")
    def primary_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the `primary` relationship being assigned.
        """
        return pulumi.get(self, "primary_name")

    @primary_name.setter
    def primary_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_name", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserId")
    def primary_user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User ID to be assigned to `primary` for the 'associated' user in the specified relationship.
        """
        return pulumi.get(self, "primary_user_id")

    @primary_user_id.setter
    def primary_user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_user_id", value)


@pulumi.type_token("okta:index/linkValue:LinkValue")
class LinkValue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 primary_name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages users relationships. Link value operations allow you to create relationships between primary and associated users.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        padishah = okta.LinkDefinition("padishah",
            primary_name="emperor",
            primary_title="Emperor",
            primary_description="Hereditary ruler of the Imperium and the Known Universe",
            associated_name="sardaukar",
            associated_title="Sardaukar",
            associated_description="Elite military force member")
        emperor = okta.user.User("emperor",
            first_name="Shaddam",
            last_name="Corrino IV",
            login="shaddam.corrino.iv@salusa-secundus.planet",
            email="shaddam.corrino.iv@salusa-secundus.planet")
        sardaukars = []
        for range in [{"value": i} for i in range(0, 5)]:
            sardaukars.append(okta.user.User(f"sardaukars-{range['value']}",
                first_name="Amrit",
                last_name=f"Sardaukar_{range['value']}",
                login=f"amritsardaukar_{range['value']}@salusa-secundus.planet",
                email=f"amritsardaukar_{range['value']}@salusa-secundus.planet"))
        example = okta.LinkValue("example",
            primary_name=padishah.primary_name,
            primary_user_id=emperor.id,
            associated_user_ids=[
                sardaukars[0].id,
                sardaukars[1].id,
                sardaukars[2].id,
                sardaukars[3].id,
                sardaukars[4].id,
            ])
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/linkValue:LinkValue example <primary_name>/<primary_user_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_user_ids: Set of User IDs or login values of the users to be assigned the `associated` relationship.
        :param pulumi.Input[_builtins.str] primary_name: Name of the `primary` relationship being assigned.
        :param pulumi.Input[_builtins.str] primary_user_id: User ID to be assigned to `primary` for the 'associated' user in the specified relationship.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkValueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages users relationships. Link value operations allow you to create relationships between primary and associated users.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_okta as okta

        padishah = okta.LinkDefinition("padishah",
            primary_name="emperor",
            primary_title="Emperor",
            primary_description="Hereditary ruler of the Imperium and the Known Universe",
            associated_name="sardaukar",
            associated_title="Sardaukar",
            associated_description="Elite military force member")
        emperor = okta.user.User("emperor",
            first_name="Shaddam",
            last_name="Corrino IV",
            login="shaddam.corrino.iv@salusa-secundus.planet",
            email="shaddam.corrino.iv@salusa-secundus.planet")
        sardaukars = []
        for range in [{"value": i} for i in range(0, 5)]:
            sardaukars.append(okta.user.User(f"sardaukars-{range['value']}",
                first_name="Amrit",
                last_name=f"Sardaukar_{range['value']}",
                login=f"amritsardaukar_{range['value']}@salusa-secundus.planet",
                email=f"amritsardaukar_{range['value']}@salusa-secundus.planet"))
        example = okta.LinkValue("example",
            primary_name=padishah.primary_name,
            primary_user_id=emperor.id,
            associated_user_ids=[
                sardaukars[0].id,
                sardaukars[1].id,
                sardaukars[2].id,
                sardaukars[3].id,
                sardaukars[4].id,
            ])
        ```

        ## Import

        ```sh
        $ pulumi import okta:index/linkValue:LinkValue example <primary_name>/<primary_user_id>
        ```

        :param str resource_name: The name of the resource.
        :param LinkValueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkValueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 primary_name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkValueArgs.__new__(LinkValueArgs)

            __props__.__dict__["associated_user_ids"] = associated_user_ids
            if primary_name is None and not opts.urn:
                raise TypeError("Missing required property 'primary_name'")
            __props__.__dict__["primary_name"] = primary_name
            if primary_user_id is None and not opts.urn:
                raise TypeError("Missing required property 'primary_user_id'")
            __props__.__dict__["primary_user_id"] = primary_user_id
        super(LinkValue, __self__).__init__(
            'okta:index/linkValue:LinkValue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            primary_name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LinkValue':
        """
        Get an existing LinkValue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] associated_user_ids: Set of User IDs or login values of the users to be assigned the `associated` relationship.
        :param pulumi.Input[_builtins.str] primary_name: Name of the `primary` relationship being assigned.
        :param pulumi.Input[_builtins.str] primary_user_id: User ID to be assigned to `primary` for the 'associated' user in the specified relationship.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinkValueState.__new__(_LinkValueState)

        __props__.__dict__["associated_user_ids"] = associated_user_ids
        __props__.__dict__["primary_name"] = primary_name
        __props__.__dict__["primary_user_id"] = primary_user_id
        return LinkValue(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associatedUserIds")
    def associated_user_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Set of User IDs or login values of the users to be assigned the `associated` relationship.
        """
        return pulumi.get(self, "associated_user_ids")

    @_builtins.property
    @pulumi.getter(name="primaryName")
    def primary_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the `primary` relationship being assigned.
        """
        return pulumi.get(self, "primary_name")

    @_builtins.property
    @pulumi.getter(name="primaryUserId")
    def primary_user_id(self) -> pulumi.Output[_builtins.str]:
        """
        User ID to be assigned to `primary` for the 'associated' user in the specified relationship.
        """
        return pulumi.get(self, "primary_user_id")

