# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MfaArgs', 'Mfa']

@pulumi.input_type
class MfaArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duo: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_idps: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 fido_u2f: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fido_webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 google_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hotp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_oie: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 okta_call: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_email: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_password: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_push: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_sms: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_verify: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 onprem_mfa: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 phone_number: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 rsa_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 smart_card_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 symantec_vip: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 yubikey_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Mfa resource.
        :param pulumi.Input[_builtins.str] description: Policy Description
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of Group IDs to Include
        :param pulumi.Input[_builtins.bool] is_oie: Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        :param pulumi.Input[_builtins.str] name: Policy Name
        :param pulumi.Input[_builtins.int] priority: Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[_builtins.str] status: Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duo is not None:
            pulumi.set(__self__, "duo", duo)
        if external_idp is not None:
            warnings.warn("""Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""", DeprecationWarning)
            pulumi.log.warn("""external_idp is deprecated: Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""")
        if external_idp is not None:
            pulumi.set(__self__, "external_idp", external_idp)
        if external_idps is not None:
            pulumi.set(__self__, "external_idps", external_idps)
        if fido_u2f is not None:
            pulumi.set(__self__, "fido_u2f", fido_u2f)
        if fido_webauthn is not None:
            pulumi.set(__self__, "fido_webauthn", fido_webauthn)
        if google_otp is not None:
            pulumi.set(__self__, "google_otp", google_otp)
        if groups_includeds is not None:
            pulumi.set(__self__, "groups_includeds", groups_includeds)
        if hotp is not None:
            pulumi.set(__self__, "hotp", hotp)
        if is_oie is not None:
            pulumi.set(__self__, "is_oie", is_oie)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if okta_call is not None:
            pulumi.set(__self__, "okta_call", okta_call)
        if okta_email is not None:
            pulumi.set(__self__, "okta_email", okta_email)
        if okta_otp is not None:
            pulumi.set(__self__, "okta_otp", okta_otp)
        if okta_password is not None:
            pulumi.set(__self__, "okta_password", okta_password)
        if okta_push is not None:
            pulumi.set(__self__, "okta_push", okta_push)
        if okta_question is not None:
            pulumi.set(__self__, "okta_question", okta_question)
        if okta_sms is not None:
            pulumi.set(__self__, "okta_sms", okta_sms)
        if okta_verify is not None:
            pulumi.set(__self__, "okta_verify", okta_verify)
        if onprem_mfa is not None:
            pulumi.set(__self__, "onprem_mfa", onprem_mfa)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rsa_token is not None:
            pulumi.set(__self__, "rsa_token", rsa_token)
        if security_question is not None:
            pulumi.set(__self__, "security_question", security_question)
        if smart_card_idp is not None:
            pulumi.set(__self__, "smart_card_idp", smart_card_idp)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if symantec_vip is not None:
            pulumi.set(__self__, "symantec_vip", symantec_vip)
        if webauthn is not None:
            pulumi.set(__self__, "webauthn", webauthn)
        if yubikey_token is not None:
            pulumi.set(__self__, "yubikey_token", yubikey_token)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duo(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "duo")

    @duo.setter
    def duo(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "duo", value)

    @_builtins.property
    @pulumi.getter(name="externalIdp")
    @_utilities.deprecated("""Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""")
    def external_idp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "external_idp")

    @external_idp.setter
    def external_idp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_idp", value)

    @_builtins.property
    @pulumi.getter(name="externalIdps")
    def external_idps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]:
        return pulumi.get(self, "external_idps")

    @external_idps.setter
    def external_idps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "external_idps", value)

    @_builtins.property
    @pulumi.getter(name="fidoU2f")
    def fido_u2f(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "fido_u2f")

    @fido_u2f.setter
    def fido_u2f(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fido_u2f", value)

    @_builtins.property
    @pulumi.getter(name="fidoWebauthn")
    def fido_webauthn(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "fido_webauthn")

    @fido_webauthn.setter
    def fido_webauthn(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fido_webauthn", value)

    @_builtins.property
    @pulumi.getter(name="googleOtp")
    def google_otp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "google_otp")

    @google_otp.setter
    def google_otp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "google_otp", value)

    @_builtins.property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Group IDs to Include
        """
        return pulumi.get(self, "groups_includeds")

    @groups_includeds.setter
    def groups_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_includeds", value)

    @_builtins.property
    @pulumi.getter
    def hotp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "hotp")

    @hotp.setter
    def hotp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hotp", value)

    @_builtins.property
    @pulumi.getter(name="isOie")
    def is_oie(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        """
        return pulumi.get(self, "is_oie")

    @is_oie.setter
    def is_oie(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_oie", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oktaCall")
    def okta_call(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_call")

    @okta_call.setter
    def okta_call(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_call", value)

    @_builtins.property
    @pulumi.getter(name="oktaEmail")
    def okta_email(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_email")

    @okta_email.setter
    def okta_email(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_email", value)

    @_builtins.property
    @pulumi.getter(name="oktaOtp")
    def okta_otp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_otp")

    @okta_otp.setter
    def okta_otp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_otp", value)

    @_builtins.property
    @pulumi.getter(name="oktaPassword")
    def okta_password(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_password")

    @okta_password.setter
    def okta_password(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_password", value)

    @_builtins.property
    @pulumi.getter(name="oktaPush")
    def okta_push(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_push")

    @okta_push.setter
    def okta_push(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_push", value)

    @_builtins.property
    @pulumi.getter(name="oktaQuestion")
    def okta_question(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_question")

    @okta_question.setter
    def okta_question(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_question", value)

    @_builtins.property
    @pulumi.getter(name="oktaSms")
    def okta_sms(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_sms")

    @okta_sms.setter
    def okta_sms(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_sms", value)

    @_builtins.property
    @pulumi.getter(name="oktaVerify")
    def okta_verify(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_verify")

    @okta_verify.setter
    def okta_verify(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_verify", value)

    @_builtins.property
    @pulumi.getter(name="onpremMfa")
    def onprem_mfa(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "onprem_mfa")

    @onprem_mfa.setter
    def onprem_mfa(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "onprem_mfa", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "phone_number", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="rsaToken")
    def rsa_token(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "rsa_token")

    @rsa_token.setter
    def rsa_token(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rsa_token", value)

    @_builtins.property
    @pulumi.getter(name="securityQuestion")
    def security_question(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "security_question")

    @security_question.setter
    def security_question(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_question", value)

    @_builtins.property
    @pulumi.getter(name="smartCardIdp")
    def smart_card_idp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "smart_card_idp")

    @smart_card_idp.setter
    def smart_card_idp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "smart_card_idp", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="symantecVip")
    def symantec_vip(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "symantec_vip")

    @symantec_vip.setter
    def symantec_vip(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "symantec_vip", value)

    @_builtins.property
    @pulumi.getter
    def webauthn(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "webauthn")

    @webauthn.setter
    def webauthn(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "webauthn", value)

    @_builtins.property
    @pulumi.getter(name="yubikeyToken")
    def yubikey_token(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "yubikey_token")

    @yubikey_token.setter
    def yubikey_token(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "yubikey_token", value)


@pulumi.input_type
class _MfaState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duo: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_idps: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 fido_u2f: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fido_webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 google_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hotp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_oie: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 okta_call: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_email: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_password: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_push: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_sms: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_verify: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 onprem_mfa: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 phone_number: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 rsa_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 smart_card_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 symantec_vip: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 yubikey_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Mfa resources.
        :param pulumi.Input[_builtins.str] description: Policy Description
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of Group IDs to Include
        :param pulumi.Input[_builtins.bool] is_oie: Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        :param pulumi.Input[_builtins.str] name: Policy Name
        :param pulumi.Input[_builtins.int] priority: Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[_builtins.str] status: Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if duo is not None:
            pulumi.set(__self__, "duo", duo)
        if external_idp is not None:
            warnings.warn("""Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""", DeprecationWarning)
            pulumi.log.warn("""external_idp is deprecated: Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""")
        if external_idp is not None:
            pulumi.set(__self__, "external_idp", external_idp)
        if external_idps is not None:
            pulumi.set(__self__, "external_idps", external_idps)
        if fido_u2f is not None:
            pulumi.set(__self__, "fido_u2f", fido_u2f)
        if fido_webauthn is not None:
            pulumi.set(__self__, "fido_webauthn", fido_webauthn)
        if google_otp is not None:
            pulumi.set(__self__, "google_otp", google_otp)
        if groups_includeds is not None:
            pulumi.set(__self__, "groups_includeds", groups_includeds)
        if hotp is not None:
            pulumi.set(__self__, "hotp", hotp)
        if is_oie is not None:
            pulumi.set(__self__, "is_oie", is_oie)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if okta_call is not None:
            pulumi.set(__self__, "okta_call", okta_call)
        if okta_email is not None:
            pulumi.set(__self__, "okta_email", okta_email)
        if okta_otp is not None:
            pulumi.set(__self__, "okta_otp", okta_otp)
        if okta_password is not None:
            pulumi.set(__self__, "okta_password", okta_password)
        if okta_push is not None:
            pulumi.set(__self__, "okta_push", okta_push)
        if okta_question is not None:
            pulumi.set(__self__, "okta_question", okta_question)
        if okta_sms is not None:
            pulumi.set(__self__, "okta_sms", okta_sms)
        if okta_verify is not None:
            pulumi.set(__self__, "okta_verify", okta_verify)
        if onprem_mfa is not None:
            pulumi.set(__self__, "onprem_mfa", onprem_mfa)
        if phone_number is not None:
            pulumi.set(__self__, "phone_number", phone_number)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rsa_token is not None:
            pulumi.set(__self__, "rsa_token", rsa_token)
        if security_question is not None:
            pulumi.set(__self__, "security_question", security_question)
        if smart_card_idp is not None:
            pulumi.set(__self__, "smart_card_idp", smart_card_idp)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if symantec_vip is not None:
            pulumi.set(__self__, "symantec_vip", symantec_vip)
        if webauthn is not None:
            pulumi.set(__self__, "webauthn", webauthn)
        if yubikey_token is not None:
            pulumi.set(__self__, "yubikey_token", yubikey_token)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def duo(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "duo")

    @duo.setter
    def duo(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "duo", value)

    @_builtins.property
    @pulumi.getter(name="externalIdp")
    @_utilities.deprecated("""Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""")
    def external_idp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "external_idp")

    @external_idp.setter
    def external_idp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "external_idp", value)

    @_builtins.property
    @pulumi.getter(name="externalIdps")
    def external_idps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]:
        return pulumi.get(self, "external_idps")

    @external_idps.setter
    def external_idps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "external_idps", value)

    @_builtins.property
    @pulumi.getter(name="fidoU2f")
    def fido_u2f(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "fido_u2f")

    @fido_u2f.setter
    def fido_u2f(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fido_u2f", value)

    @_builtins.property
    @pulumi.getter(name="fidoWebauthn")
    def fido_webauthn(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "fido_webauthn")

    @fido_webauthn.setter
    def fido_webauthn(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fido_webauthn", value)

    @_builtins.property
    @pulumi.getter(name="googleOtp")
    def google_otp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "google_otp")

    @google_otp.setter
    def google_otp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "google_otp", value)

    @_builtins.property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of Group IDs to Include
        """
        return pulumi.get(self, "groups_includeds")

    @groups_includeds.setter
    def groups_includeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "groups_includeds", value)

    @_builtins.property
    @pulumi.getter
    def hotp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "hotp")

    @hotp.setter
    def hotp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "hotp", value)

    @_builtins.property
    @pulumi.getter(name="isOie")
    def is_oie(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        """
        return pulumi.get(self, "is_oie")

    @is_oie.setter
    def is_oie(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_oie", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oktaCall")
    def okta_call(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_call")

    @okta_call.setter
    def okta_call(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_call", value)

    @_builtins.property
    @pulumi.getter(name="oktaEmail")
    def okta_email(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_email")

    @okta_email.setter
    def okta_email(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_email", value)

    @_builtins.property
    @pulumi.getter(name="oktaOtp")
    def okta_otp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_otp")

    @okta_otp.setter
    def okta_otp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_otp", value)

    @_builtins.property
    @pulumi.getter(name="oktaPassword")
    def okta_password(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_password")

    @okta_password.setter
    def okta_password(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_password", value)

    @_builtins.property
    @pulumi.getter(name="oktaPush")
    def okta_push(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_push")

    @okta_push.setter
    def okta_push(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_push", value)

    @_builtins.property
    @pulumi.getter(name="oktaQuestion")
    def okta_question(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_question")

    @okta_question.setter
    def okta_question(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_question", value)

    @_builtins.property
    @pulumi.getter(name="oktaSms")
    def okta_sms(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_sms")

    @okta_sms.setter
    def okta_sms(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_sms", value)

    @_builtins.property
    @pulumi.getter(name="oktaVerify")
    def okta_verify(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "okta_verify")

    @okta_verify.setter
    def okta_verify(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "okta_verify", value)

    @_builtins.property
    @pulumi.getter(name="onpremMfa")
    def onprem_mfa(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "onprem_mfa")

    @onprem_mfa.setter
    def onprem_mfa(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "onprem_mfa", value)

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "phone_number")

    @phone_number.setter
    def phone_number(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "phone_number", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="rsaToken")
    def rsa_token(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "rsa_token")

    @rsa_token.setter
    def rsa_token(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rsa_token", value)

    @_builtins.property
    @pulumi.getter(name="securityQuestion")
    def security_question(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "security_question")

    @security_question.setter
    def security_question(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_question", value)

    @_builtins.property
    @pulumi.getter(name="smartCardIdp")
    def smart_card_idp(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "smart_card_idp")

    @smart_card_idp.setter
    def smart_card_idp(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "smart_card_idp", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="symantecVip")
    def symantec_vip(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "symantec_vip")

    @symantec_vip.setter
    def symantec_vip(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "symantec_vip", value)

    @_builtins.property
    @pulumi.getter
    def webauthn(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "webauthn")

    @webauthn.setter
    def webauthn(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "webauthn", value)

    @_builtins.property
    @pulumi.getter(name="yubikeyToken")
    def yubikey_token(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "yubikey_token")

    @yubikey_token.setter
    def yubikey_token(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "yubikey_token", value)


@pulumi.type_token("okta:policy/mfa:Mfa")
class Mfa(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duo: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_idps: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 fido_u2f: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fido_webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 google_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hotp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_oie: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 okta_call: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_email: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_password: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_push: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_sms: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_verify: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 onprem_mfa: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 phone_number: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 rsa_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 smart_card_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 symantec_vip: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 yubikey_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import okta:policy/mfa:Mfa example <policy_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Policy Description
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of Group IDs to Include
        :param pulumi.Input[_builtins.bool] is_oie: Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        :param pulumi.Input[_builtins.str] name: Policy Name
        :param pulumi.Input[_builtins.int] priority: Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[_builtins.str] status: Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MfaArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import okta:policy/mfa:Mfa example <policy_id>
        ```

        :param str resource_name: The name of the resource.
        :param MfaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MfaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 duo: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 external_idps: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 fido_u2f: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 fido_webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 google_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 hotp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 is_oie: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 okta_call: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_email: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_password: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_push: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_sms: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 okta_verify: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 onprem_mfa: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 phone_number: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 rsa_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 security_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 smart_card_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 symantec_vip: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 yubikey_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MfaArgs.__new__(MfaArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["duo"] = duo
            __props__.__dict__["external_idp"] = external_idp
            __props__.__dict__["external_idps"] = external_idps
            __props__.__dict__["fido_u2f"] = fido_u2f
            __props__.__dict__["fido_webauthn"] = fido_webauthn
            __props__.__dict__["google_otp"] = google_otp
            __props__.__dict__["groups_includeds"] = groups_includeds
            __props__.__dict__["hotp"] = hotp
            __props__.__dict__["is_oie"] = is_oie
            __props__.__dict__["name"] = name
            __props__.__dict__["okta_call"] = okta_call
            __props__.__dict__["okta_email"] = okta_email
            __props__.__dict__["okta_otp"] = okta_otp
            __props__.__dict__["okta_password"] = okta_password
            __props__.__dict__["okta_push"] = okta_push
            __props__.__dict__["okta_question"] = okta_question
            __props__.__dict__["okta_sms"] = okta_sms
            __props__.__dict__["okta_verify"] = okta_verify
            __props__.__dict__["onprem_mfa"] = onprem_mfa
            __props__.__dict__["phone_number"] = phone_number
            __props__.__dict__["priority"] = priority
            __props__.__dict__["rsa_token"] = rsa_token
            __props__.__dict__["security_question"] = security_question
            __props__.__dict__["smart_card_idp"] = smart_card_idp
            __props__.__dict__["status"] = status
            __props__.__dict__["symantec_vip"] = symantec_vip
            __props__.__dict__["webauthn"] = webauthn
            __props__.__dict__["yubikey_token"] = yubikey_token
        super(Mfa, __self__).__init__(
            'okta:policy/mfa:Mfa',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            duo: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            external_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            external_idps: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
            fido_u2f: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            fido_webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            google_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            groups_includeds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            hotp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            is_oie: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            okta_call: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            okta_email: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            okta_otp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            okta_password: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            okta_push: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            okta_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            okta_sms: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            okta_verify: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            onprem_mfa: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            phone_number: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            rsa_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            security_question: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            smart_card_idp: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            symantec_vip: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            webauthn: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            yubikey_token: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Mfa':
        """
        Get an existing Mfa resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Policy Description
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] groups_includeds: List of Group IDs to Include
        :param pulumi.Input[_builtins.bool] is_oie: Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        :param pulumi.Input[_builtins.str] name: Policy Name
        :param pulumi.Input[_builtins.int] priority: Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        :param pulumi.Input[_builtins.str] status: Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MfaState.__new__(_MfaState)

        __props__.__dict__["description"] = description
        __props__.__dict__["duo"] = duo
        __props__.__dict__["external_idp"] = external_idp
        __props__.__dict__["external_idps"] = external_idps
        __props__.__dict__["fido_u2f"] = fido_u2f
        __props__.__dict__["fido_webauthn"] = fido_webauthn
        __props__.__dict__["google_otp"] = google_otp
        __props__.__dict__["groups_includeds"] = groups_includeds
        __props__.__dict__["hotp"] = hotp
        __props__.__dict__["is_oie"] = is_oie
        __props__.__dict__["name"] = name
        __props__.__dict__["okta_call"] = okta_call
        __props__.__dict__["okta_email"] = okta_email
        __props__.__dict__["okta_otp"] = okta_otp
        __props__.__dict__["okta_password"] = okta_password
        __props__.__dict__["okta_push"] = okta_push
        __props__.__dict__["okta_question"] = okta_question
        __props__.__dict__["okta_sms"] = okta_sms
        __props__.__dict__["okta_verify"] = okta_verify
        __props__.__dict__["onprem_mfa"] = onprem_mfa
        __props__.__dict__["phone_number"] = phone_number
        __props__.__dict__["priority"] = priority
        __props__.__dict__["rsa_token"] = rsa_token
        __props__.__dict__["security_question"] = security_question
        __props__.__dict__["smart_card_idp"] = smart_card_idp
        __props__.__dict__["status"] = status
        __props__.__dict__["symantec_vip"] = symantec_vip
        __props__.__dict__["webauthn"] = webauthn
        __props__.__dict__["yubikey_token"] = yubikey_token
        return Mfa(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Policy Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def duo(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "duo")

    @_builtins.property
    @pulumi.getter(name="externalIdp")
    @_utilities.deprecated("""Since okta now support multiple external_idps, this will be deprecated. Please use `external_idps` instead""")
    def external_idp(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "external_idp")

    @_builtins.property
    @pulumi.getter(name="externalIdps")
    def external_idps(self) -> pulumi.Output[Optional[Sequence[Mapping[str, _builtins.str]]]]:
        return pulumi.get(self, "external_idps")

    @_builtins.property
    @pulumi.getter(name="fidoU2f")
    def fido_u2f(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "fido_u2f")

    @_builtins.property
    @pulumi.getter(name="fidoWebauthn")
    def fido_webauthn(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "fido_webauthn")

    @_builtins.property
    @pulumi.getter(name="googleOtp")
    def google_otp(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "google_otp")

    @_builtins.property
    @pulumi.getter(name="groupsIncludeds")
    def groups_includeds(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of Group IDs to Include
        """
        return pulumi.get(self, "groups_includeds")

    @_builtins.property
    @pulumi.getter
    def hotp(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "hotp")

    @_builtins.property
    @pulumi.getter(name="isOie")
    def is_oie(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the policy using Okta Identity Engine (OIE) with authenticators instead of factors?
        """
        return pulumi.get(self, "is_oie")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Policy Name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oktaCall")
    def okta_call(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "okta_call")

    @_builtins.property
    @pulumi.getter(name="oktaEmail")
    def okta_email(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "okta_email")

    @_builtins.property
    @pulumi.getter(name="oktaOtp")
    def okta_otp(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "okta_otp")

    @_builtins.property
    @pulumi.getter(name="oktaPassword")
    def okta_password(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "okta_password")

    @_builtins.property
    @pulumi.getter(name="oktaPush")
    def okta_push(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "okta_push")

    @_builtins.property
    @pulumi.getter(name="oktaQuestion")
    def okta_question(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "okta_question")

    @_builtins.property
    @pulumi.getter(name="oktaSms")
    def okta_sms(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "okta_sms")

    @_builtins.property
    @pulumi.getter(name="oktaVerify")
    def okta_verify(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "okta_verify")

    @_builtins.property
    @pulumi.getter(name="onpremMfa")
    def onprem_mfa(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "onprem_mfa")

    @_builtins.property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "phone_number")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Policy Priority, this attribute can be set to a valid priority. To avoid endless diff situation we error if an invalid priority is provided. API defaults it to the last (lowest) if not there.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="rsaToken")
    def rsa_token(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "rsa_token")

    @_builtins.property
    @pulumi.getter(name="securityQuestion")
    def security_question(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "security_question")

    @_builtins.property
    @pulumi.getter(name="smartCardIdp")
    def smart_card_idp(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "smart_card_idp")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Policy Status: `ACTIVE` or `INACTIVE`. Default: `ACTIVE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="symantecVip")
    def symantec_vip(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "symantec_vip")

    @_builtins.property
    @pulumi.getter
    def webauthn(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "webauthn")

    @_builtins.property
    @pulumi.getter(name="yubikeyToken")
    def yubikey_token(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "yubikey_token")

