# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RealmArgs', 'Realm']

@pulumi.input_type
class RealmArgs:
    def __init__(__self__, *,
                 realm_type: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Realm resource.
        :param pulumi.Input[_builtins.str] realm_type: The realm type. Valid values: `PARTNER` and `DEFAULT`
        :param pulumi.Input[_builtins.str] name: The name of the Okta Realm.
        """
        pulumi.set(__self__, "realm_type", realm_type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="realmType")
    def realm_type(self) -> pulumi.Input[_builtins.str]:
        """
        The realm type. Valid values: `PARTNER` and `DEFAULT`
        """
        return pulumi.get(self, "realm_type")

    @realm_type.setter
    def realm_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "realm_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Okta Realm.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RealmState:
    def __init__(__self__, *,
                 is_default: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 realm_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Realm resources.
        :param pulumi.Input[_builtins.bool] is_default: Indicates whether the realm is the default realm.
        :param pulumi.Input[_builtins.str] name: The name of the Okta Realm.
        :param pulumi.Input[_builtins.str] realm_type: The realm type. Valid values: `PARTNER` and `DEFAULT`
        """
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if realm_type is not None:
            pulumi.set(__self__, "realm_type", realm_type)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the realm is the default realm.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_default", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Okta Realm.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="realmType")
    def realm_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The realm type. Valid values: `PARTNER` and `DEFAULT`
        """
        return pulumi.get(self, "realm_type")

    @realm_type.setter
    def realm_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "realm_type", value)


@pulumi.type_token("okta:index/realm:Realm")
class Realm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 realm_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Realm resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the Okta Realm.
        :param pulumi.Input[_builtins.str] realm_type: The realm type. Valid values: `PARTNER` and `DEFAULT`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RealmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Realm resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param RealmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RealmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 realm_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RealmArgs.__new__(RealmArgs)

            __props__.__dict__["name"] = name
            if realm_type is None and not opts.urn:
                raise TypeError("Missing required property 'realm_type'")
            __props__.__dict__["realm_type"] = realm_type
            __props__.__dict__["is_default"] = None
        super(Realm, __self__).__init__(
            'okta:index/realm:Realm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_default: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            realm_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Realm':
        """
        Get an existing Realm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] is_default: Indicates whether the realm is the default realm.
        :param pulumi.Input[_builtins.str] name: The name of the Okta Realm.
        :param pulumi.Input[_builtins.str] realm_type: The realm type. Valid values: `PARTNER` and `DEFAULT`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RealmState.__new__(_RealmState)

        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["realm_type"] = realm_type
        return Realm(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the realm is the default realm.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Okta Realm.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="realmType")
    def realm_type(self) -> pulumi.Output[_builtins.str]:
        """
        The realm type. Valid values: `PARTNER` and `DEFAULT`
        """
        return pulumi.get(self, "realm_type")

