from typing import Any, Final

from typing_extensions import TypeAlias

dst: TypeAlias = Any
# BorderTypes
BORDER_CONSTANT: Final[int]
BORDER_REPLICATE: Final[int]
BORDER_REFLECT: Final[int]
BORDER_WRAP: Final[int]
BORDER_REFLECT_101: int
BORDER_TRANSPARENT: Final[int]
BORDER_REFLECT101: int
BORDER_DEFAULT: Final[int]
BORDER_ISOLATED: Final[int]

# ContourApproximationModes
CHAIN_APPROX_NONE: Final[int]
CHAIN_APPROX_SIMPLE: Final[int]
CHAIN_APPROX_TC89_L1: Final[int]
CHAIN_APPROX_TC89_KCOS: Final[int]

# Color conversion codes
COLOR_BGR2BGRA: Final[int]  # Add alpha channel to RGB or BGR image
COLOR_RGB2RGBA: Final[int]
COLOR_BGRA2BGR: Final[int]  # Remove alpha channel from RGB or BGR image
COLOR_RGBA2RGB: Final[int]
COLOR_BGR2RGBA: Final[int]  # Convert between RGB and BGR color spaces (with or without alpha channel)
COLOR_RGB2BGRA: Final[int]
COLOR_RGBA2BGR: Final[int]
COLOR_BGRA2RGB: Final[int]
COLOR_BGR2RGB: Final[int]
COLOR_RGB2BGR: Final[int]
COLOR_BGRA2RGBA: Final[int]
COLOR_RGBA2BGRA: Final[int]
COLOR_BGR2GRAY: Final[int]  # Convert between RGB/BGR and grayscale, color conversions
COLOR_RGB2GRAY: Final[int]
COLOR_GRAY2BGR: Final[int]
COLOR_GRAY2RGB: Final[int]
COLOR_GRAY2BGRA: Final[int]
COLOR_GRAY2RGBA: Final[int]
COLOR_BGRA2GRAY: Final[int]
COLOR_RGBA2GRAY: Final[int]
COLOR_BGR2BGR565: Final[int]  # Convert between RGB/BGR and BGR565 (16-bit images)
COLOR_RGB2BGR565: Final[int]
COLOR_BGR5652BGR: Final[int]
COLOR_BGR5652RGB: Final[int]
COLOR_BGRA2BGR565: Final[int]
COLOR_RGBA2BGR565: Final[int]
COLOR_BGR5652BGRA: Final[int]
COLOR_BGR5652RGBA: Final[int]
COLOR_GRAY2BGR565: Final[int]  # Convert between grayscale to BGR565 (16-bit images)
COLOR_BGR5652GRAY: Final[int]
COLOR_BGR2BGR555: Final[int]  # Convert between RGB/BGR and BGR555 (16-bit images)
COLOR_RGB2BGR555: Final[int]
COLOR_BGR5552BGR: Final[int]
COLOR_BGR5552RGB: Final[int]
COLOR_BGRA2BGR555: Final[int]
COLOR_RGBA2BGR555: Final[int]
COLOR_BGR5552BGRA: Final[int]
COLOR_BGR5552RGBA: Final[int]
COLOR_GRAY2BGR555: Final[int]  # Convert between grayscale and BGR555 (16-bit images)
COLOR_BGR5552GRAY: Final[int]
COLOR_BGR2XYZ: Final[int]  # Convert RGB/BGR to CIE XYZ, color conversions
COLOR_RGB2XYZ: Final[int]
COLOR_XYZ2BGR: Final[int]
COLOR_XYZ2RGB: Final[int]
COLOR_BGR2YCrCb: Final[int]  # Convert RGB/BGR to luma-chroma (aka YCC), color conversions
COLOR_RGB2YCrCb: Final[int]
COLOR_YCrCb2BGR: Final[int]
COLOR_YCrCb2RGB: Final[int]
COLOR_BGR2HSV: Final[int]  # Convert RGB/BGR to HSV (hue saturation value) with H range 0..180 if 8 bit image, color conversions
COLOR_RGB2HSV: Final[int]
COLOR_BGR2Lab: Final[int]  # Convert RGB/BGR to CIE Lab, color conversions
COLOR_RGB2Lab: Final[int]
COLOR_BGR2Luv: Final[int]  # Convert RGB/BGR to CIE Luv, color conversions
COLOR_RGB2Luv: Final[int]
COLOR_BGR2HLS: Final[int]  # Convert RGB/BGR to HLS (hue lightness saturation) with H range 0..180 if 8 bit image, color conversions
COLOR_RGB2HLS: Final[int]
COLOR_HSV2BGR: Final[int]  # backward conversions HSV to RGB/BGR with H range 0..180 if 8 bit image
COLOR_HSV2RGB: Final[int]
COLOR_Lab2BGR: Final[int]
COLOR_Lab2RGB: Final[int]
COLOR_Luv2BGR: Final[int]
COLOR_Luv2RGB: Final[int]
COLOR_HLS2BGR: Final[int]  # backward conversions HLS to RGB/BGR with H range 0..180 if 8 bit image
COLOR_HLS2RGB: Final[int]
COLOR_BGR2HSV_FULL: Final[int]  # Convert RGB/BGR to HSV (hue saturation value) with H range 0..255 if 8 bit image, color conversions
COLOR_RGB2HSV_FULL: Final[int]
COLOR_BGR2HLS_FULL: Final[int]  # Convert RGB/BGR to HLS (hue lightness saturation) with H range 0..255 if 8 bit image, color conversions
COLOR_RGB2HLS_FULL: Final[int]
COLOR_HSV2BGR_FULL: Final[int]  # Backward conversions HSV to RGB/BGR with H range 0..255 if 8 bit image
COLOR_HSV2RGB_FULL: Final[int]
COLOR_HLS2BGR_FULL: Final[int]  # Backward conversions HLS to RGB/BGR with H range 0..255 if 8 bit image
COLOR_HLS2RGB_FULL: Final[int]
COLOR_LBGR2Lab: Final[int]
COLOR_LRGB2Lab: Final[int]
COLOR_LBGR2Luv: Final[int]
COLOR_LRGB2Luv: Final[int]
COLOR_Lab2LBGR: Final[int]
COLOR_Lab2LRGB: Final[int]
COLOR_Luv2LBGR: Final[int]
COLOR_Luv2LRGB: Final[int]
COLOR_BGR2YUV: Final[int]  # Convert between RGB/BGR and YUV
COLOR_RGB2YUV: Final[int]
COLOR_YUV2BGR: Final[int]
COLOR_YUV2RGB: Final[int]
COLOR_YUV2RGB_NV12: Final[int]  # YUV 4:2:0 family to RGB.
COLOR_YUV2BGR_NV12: Final[int]
COLOR_YUV2RGB_NV21: Final[int]
COLOR_YUV2BGR_NV21: Final[int]
COLOR_YUV420sp2RGB: int
COLOR_YUV420sp2BGR: int
COLOR_YUV2RGBA_NV12: Final[int]
COLOR_YUV2BGRA_NV12: Final[int]
COLOR_YUV2RGBA_NV21: Final[int]
COLOR_YUV2BGRA_NV21: Final[int]
COLOR_YUV420sp2RGBA: int
COLOR_YUV420sp2BGRA: int
COLOR_YUV2RGB_YV12: Final[int]
COLOR_YUV2BGR_YV12: Final[int]
COLOR_YUV2RGB_IYUV: Final[int]
COLOR_YUV2BGR_IYUV: Final[int]
COLOR_YUV2RGB_I420: int
COLOR_YUV2BGR_I420: int
COLOR_YUV420p2RGB: int
COLOR_YUV420p2BGR: int
COLOR_YUV2RGBA_YV12: Final[int]
COLOR_YUV2BGRA_YV12: Final[int]
COLOR_YUV2RGBA_IYUV: Final[int]
COLOR_YUV2BGRA_IYUV: Final[int]
COLOR_YUV2RGBA_I420: int
COLOR_YUV2BGRA_I420: int
COLOR_YUV420p2RGBA: int
COLOR_YUV420p2BGRA: int
COLOR_YUV2GRAY_420: int
COLOR_YUV2GRAY_NV21: Final[int]
COLOR_YUV2GRAY_NV12: Final[int]
COLOR_YUV2GRAY_YV12: Final[int]
COLOR_YUV2GRAY_IYUV: Final[int]
COLOR_YUV2GRAY_I420: int
COLOR_YUV420sp2GRAY: int
COLOR_YUV420p2GRAY: int
COLOR_YUV2RGB_UYVY: Final[int]  #  YUV 4:2:2 family to RGB.
COLOR_YUV2BGR_UYVY: Final[int]
COLOR_YUV2RGB_Y422: Final[int]
COLOR_YUV2BGR_Y422: Final[int]
COLOR_YUV2RGB_UYNV: Final[int]
COLOR_YUV2BGR_UYNV: Final[int]
COLOR_YUV2RGBA_UYVY: Final[int]
COLOR_YUV2BGRA_UYVY: Final[int]
COLOR_YUV2RGBA_Y422: Final[int]
COLOR_YUV2BGRA_Y422: Final[int]
COLOR_YUV2RGBA_UYNV: Final[int]
COLOR_YUV2BGRA_UYNV: Final[int]
COLOR_YUV2RGB_YUY2: Final[int]
COLOR_YUV2BGR_YUY2: Final[int]
COLOR_YUV2RGB_YVYU: Final[int]
COLOR_YUV2BGR_YVYU: Final[int]
COLOR_YUV2RGB_YUYV: Final[int]
COLOR_YUV2BGR_YUYV: Final[int]
COLOR_YUV2RGB_YUNV: Final[int]
COLOR_YUV2BGR_YUNV: Final[int]
COLOR_YUV2RGBA_YUY2: Final[int]
COLOR_YUV2BGRA_YUY2: Final[int]
COLOR_YUV2RGBA_YVYU: Final[int]
COLOR_YUV2BGRA_YVYU: Final[int]
COLOR_YUV2RGBA_YUYV: Final[int]
COLOR_YUV2BGRA_YUYV: Final[int]
COLOR_YUV2RGBA_YUNV: Final[int]
COLOR_YUV2BGRA_YUNV: Final[int]
COLOR_YUV2GRAY_UYVY: Final[int]
COLOR_YUV2GRAY_YUY2: Final[int]
COLOR_YUV2GRAY_Y422: Final[int]
COLOR_YUV2GRAY_UYNV: Final[int]
COLOR_YUV2GRAY_YVYU: Final[int]
COLOR_YUV2GRAY_YUYV: Final[int]
COLOR_YUV2GRAY_YUNV: Final[int]
COLOR_RGBA2mRGBA: Final[int]  # Ulpha premultiplication
COLOR_mRGBA2RGBA: Final[int]
COLOR_RGB2YUV_I420: int  # RGB to YUV 4:2:0 family.
COLOR_BGR2YUV_I420: int
COLOR_RGB2YUV_IYUV: Final[int]
COLOR_BGR2YUV_IYUV: Final[int]
COLOR_RGBA2YUV_I420: int
COLOR_BGRA2YUV_I420: int
COLOR_RGBA2YUV_IYUV: Final[int]
COLOR_BGRA2YUV_IYUV: Final[int]
COLOR_RGB2YUV_YV12: Final[int]
COLOR_BGR2YUV_YV12: Final[int]
COLOR_RGBA2YUV_YV12: Final[int]
COLOR_BGRA2YUV_YV12: Final[int]
COLOR_BayerBG2BGR: Final[int]  # Demosaicing, see color conversions (https://docs.opencv.org/4.x/de/d25/imgproc_color_conversions.html#color_convert_bayer) for additional information. Equivalent to RGGB Bayer pattern.
COLOR_BayerGB2BGR: Final[int]  # Equivalent to GRBG Bayer pattern
COLOR_BayerRG2BGR: Final[int]  # Equivalent to BGGR Bayer pattern
COLOR_BayerGR2BGR: Final[int]  # Equivalent to GBRG Bayer pattern
COLOR_BayerRGGB2BGR: Final[int]
COLOR_BayerGRBG2BGR: Final[int]
COLOR_BayerBGGR2BGR: Final[int]
COLOR_BayerGBRG2BGR: Final[int]
COLOR_BayerRGGB2RGB: Final[int]
COLOR_BayerGRBG2RGB: Final[int]
COLOR_BayerBGGR2RGB: Final[int]
COLOR_BayerGBRG2RGB: Final[int]
COLOR_BayerBG2RGB: Final[int]  # Equivalent to RGGB Bayer pattern
COLOR_BayerGB2RGB: Final[int]  # Equivalent to GRBG Bayer pattern
COLOR_BayerRG2RGB: Final[int]  # Equivalent to BGGR Bayer pattern
COLOR_BayerGR2RGB: Final[int]  # Equivalent to GBRG Bayer pattern
COLOR_BayerBG2GRAY: Final[int]  # Equivalent to RGGB Bayer pattern
COLOR_BayerGB2GRAY: Final[int]  # Equivalent to GRBG Bayer pattern
COLOR_BayerRG2GRAY: Final[int]  # Equivalent to BGGR Bayer pattern
COLOR_BayerGR2GRAY: Final[int]  # Equivalent to GBRG Bayer pattern
COLOR_BayerRGGB2GRAY: Final[int]
COLOR_BayerGRBG2GRAY: Final[int]
COLOR_BayerBGGR2GRAY: Final[int]
COLOR_BayerGBRG2GRAY: Final[int]
COLOR_BayerBG2BGR_VNG: Final[int]  # Demosaicing using Variable Number of Gradients. equivalent to RGGB Bayer pattern
COLOR_BayerGB2BGR_VNG: Final[int]  # Equivalent to GRBG Bayer pattern
COLOR_BayerRG2BGR_VNG: Final[int]  # Equivalent to BGGR Bayer pattern
COLOR_BayerGR2BGR_VNG: Final[int]  # Equivalent to GBRG Bayer pattern
COLOR_BayerRGGB2BGR_VNG: Final[int]
COLOR_BayerGRBG2BGR_VNG: Final[int]
COLOR_BayerBGGR2BGR_VNG: Final[int]
COLOR_BayerGBRG2BGR_VNG: Final[int]
COLOR_BayerRGGB2RGB_VNG: Final[int]
COLOR_BayerGRBG2RGB_VNG: Final[int]
COLOR_BayerBGGR2RGB_VNG: Final[int]
COLOR_BayerGBRG2RGB_VNG: Final[int]
COLOR_BayerBG2RGB_VNG: Final[int]  # Equivalent to RGGB Bayer pattern
COLOR_BayerGB2RGB_VNG: Final[int]  # Equivalent to GRBG Bayer pattern
COLOR_BayerRG2RGB_VNG: Final[int]  # Equivalent to BGGR Bayer pattern
COLOR_BayerGR2RGB_VNG: Final[int]  # Equivalent to GBRG Bayer pattern
COLOR_BayerBG2BGR_EA: Final[int]  # Edge-Aware Demosaicing. equivalent to RGGB Bayer pattern
COLOR_BayerGB2BGR_EA: Final[int]  # Equivalent to GRBG Bayer pattern
COLOR_BayerRG2BGR_EA: Final[int]  # Equivalent to BGGR Bayer pattern
COLOR_BayerGR2BGR_EA: Final[int]  # Equivalent to GBRG Bayer pattern
COLOR_BayerRGGB2BGR_EA: Final[int]
COLOR_BayerGRBG2BGR_EA: Final[int]
COLOR_BayerBGGR2BGR_EA: Final[int]
COLOR_BayerGBRG2BGR_EA: Final[int]
COLOR_BayerRGGB2RGB_EA: Final[int]
COLOR_BayerGRBG2RGB_EA: Final[int]
COLOR_BayerBGGR2RGB_EA: Final[int]
COLOR_BayerGBRG2RGB_EA: Final[int]
COLOR_BayerBG2RGB_EA: Final[int]  # Equivalent to RGGB Bayer pattern
COLOR_BayerGB2RGB_EA: Final[int]  # Equivalent to GRBG Bayer pattern
COLOR_BayerRG2RGB_EA: Final[int]  # Equivalent to BGGR Bayer pattern
COLOR_BayerGR2RGB_EA: Final[int]  # Equivalent to GBRG Bayer pattern
COLOR_BayerBG2BGRA: Final[int]  # Demosaicing with alpha channel. equivalent to RGGB Bayer pattern
COLOR_BayerGB2BGRA: Final[int]  # Equivalent to GRBG Bayer pattern
COLOR_BayerRG2BGRA: Final[int]  # Equivalent to BGGR Bayer pattern
COLOR_BayerGR2BGRA: Final[int]  # Equivalent to GBRG Bayer pattern
COLOR_BayerRGGB2BGRA: Final[int]
COLOR_BayerGRBG2BGRA: Final[int]
COLOR_BayerBGGR2BGRA: Final[int]
COLOR_BayerGBRG2BGRA: Final[int]
COLOR_BayerRGGB2RGBA: Final[int]
COLOR_BayerGRBG2RGBA: Final[int]
COLOR_BayerBGGR2RGBA: Final[int]
COLOR_BayerGBRG2RGBA: Final[int]
COLOR_BayerBG2RGBA: Final[int]  # Equivalent to RGGB Bayer pattern
COLOR_BayerGB2RGBA: Final[int]  # Equivalent to GRBG Bayer pattern
COLOR_BayerRG2RGBA: Final[int]  # Equivalent to BGGR Bayer pattern
COLOR_BayerGR2RGBA: Final[int]  # Equivalent to GBRG Bayer pattern
COLOR_COLORCVT_MAX: Final[int]

# ConnectedComponentsTypes
# https://docs.opencv.org/3.4/d3/dc0/group__imgproc__shape.html#gac7099124c0390051c6970a987e7dc5c5
CC_STAT_LEFT: Final[int]  # The leftmost (x) coordinate which is the inclusive start of the bounding box in the horizontal direction.
CC_STAT_TOP: Final[int]  # The topmost (y) coordinate which is the inclusive start of the bounding box in the vertical direction.
CC_STAT_WIDTH: Final[int]  # The horizontal size of the bounding box.
CC_STAT_HEIGHT: Final[int]  # The vertical size of the bounding box.
CC_STAT_AREA: Final[int]  # The total area (in pixels) of the connected component.

# File storage mode
READ: Final[int]  # value, open the file for reading
WRITE: Final[int]  # value, open the file for writing
APPEND: Final[int]  # value, open the file for appending
MEMORY: Final[int]  # flag, read data from source or write data to the internal buffer (which is returned by FileStorage::release)
FORMAT_MASK: Final[int]  # mask for format flags
FORMAT_AUTO: Final[int]  # flag, auto format
FORMAT_XML: Final[int]  # flag, XML format
FORMAT_YAML: Final[int]  # flag, YAML format
FORMAT_JSON: Final[int]  # flag, JSON format
BASE64: Final[int]  # flag, write rawdata in Base64 by default. (consider using WRITE_BASE64)
WRITE_BASE64: Final[int]  # flag, enable both WRITE and BASE64

# File storage State
UNDEFINED: Final[int]
VALUE_EXPECTED: Final[int]
NAME_EXPECTED: Final[int]
INSIDE_MAP: Final[int]

# Fonts
FONT_HERSHEY_COMPLEX: Final[int]
FONT_HERSHEY_COMPLEX_SMALL: Final[int]
FONT_HERSHEY_DUPLEX: Final[int]
FONT_HERSHEY_PLAIN: Final[int]
FONT_HERSHEY_SCRIPT_COMPLEX: Final[int]
FONT_HERSHEY_SCRIPT_SIMPLEX: Final[int]
FONT_HERSHEY_SIMPLEX: Final[int]
FONT_HERSHEY_TRIPLEX: Final[int]
FONT_ITALIC: Final[int]

# MorphShapes
# https://docs.opencv.org/3.4/d4/d86/group__imgproc__filter.html#gac2db39b56866583a95a5680313c314ad
MORPH_RECT: Final[int]
MORPH_CROSS: Final[int]
MORPH_ELLIPSE: Final[int]

# MorphTypes
# https://docs.opencv.org/3.4/d4/d86/group__imgproc__filter.html#ga7be549266bad7b2e6a04db49827f9f32
MORPH_ERODE: Final[int]
MORPH_DILATE: Final[int]
MORPH_OPEN: Final[int]
MORPH_CLOSE: Final[int]
MORPH_GRADIENT: Final[int]
MORPH_TOPHAT: Final[int]
MORPH_BLACKHAT: Final[int]
MORPH_HITMISS: Final[int]

# Number Types
CV_16S: Final[int]
CV_16SC1: Final[int]
CV_16SC2: Final[int]
CV_16SC3: Final[int]
CV_16SC4: Final[int]
CV_16U: Final[int]
CV_16UC1: Final[int]
CV_16UC2: Final[int]
CV_16UC3: Final[int]
CV_16UC4: Final[int]
CV_32F: Final[int]
CV_32FC1: Final[int] = 5
CV_32FC2: Final[int]
CV_32FC3: Final[int]
CV_32FC4: Final[int]
CV_32S: Final[int]
CV_32SC1: Final[int]
CV_32SC2: Final[int]
CV_32SC3: Final[int]
CV_32SC4: Final[int]
CV_64F: Final[int]
CV_64FC1: Final[int] = 6
CV_64FC2: Final[int]
CV_64FC3: Final[int]
CV_64FC4: Final[int]
CV_8S: Final[int]
CV_8SC1: Final[int]
CV_8SC2: Final[int]
CV_8SC3: Final[int]
CV_8SC4: Final[int]
CV_8U: Final[int]
CV_8UC1: Final[int]
CV_8UC2: Final[int]
CV_8UC3: Final[int]
CV_8UC4: Final[int]

# ImreadModes
IMREAD_UNCHANGED: Final[int]  # If set, return the loaded image as is (with alpha channel, otherwise it gets cropped). Ignore EXIF orientation.
IMREAD_GRAYSCALE: Final[int]  # If set, always convert image to the single channel grayscale image (codec internal conversion).
IMREAD_COLOR: Final[int]  # If set, always convert image to the 3 channel BGR color image.
IMREAD_ANYDEPTH: Final[int]  # If set, return 16-bit/32-bit image when the input has the corresponding depth, otherwise convert it to 8-bit.
IMREAD_ANYCOLOR: Final[int]  # If set, the image is read in any possible color format.
IMREAD_LOAD_GDAL: Final[int]  # If set, use the gdal driver for loading the image.
IMREAD_REDUCED_GRAYSCALE_2: Final[int]  # If set, always convert image to the single channel grayscale image and the image size reduced 1/2.
IMREAD_REDUCED_COLOR_2: Final[int]  # If set, always convert image to the 3 channel BGR color image and the image size reduced 1/2.
IMREAD_REDUCED_GRAYSCALE_4: Final[int]  # If set, always convert image to the single channel grayscale image and the image size reduced 1/4.
IMREAD_REDUCED_COLOR_4: Final[int]  # If set, always convert image to the 3 channel BGR color image and the image size reduced 1/4.
IMREAD_REDUCED_GRAYSCALE_8: Final[int]  # If set, always convert image to the single channel grayscale image and the image size reduced 1/8.
IMREAD_REDUCED_COLOR_8: Final[int]  # If set, always convert image to the 3 channel BGR color image and the image size reduced 1/8.
IMREAD_IGNORE_ORIENTATION: Final[int]  # If set, do not rotate the image according to EXIF's orientation flag.

# Imwrite flags.
IMWRITE_JPEG_QUALITY: Final[int]  # For JPEG, it can be a quality from 0 to 100 (the higher is the better). Default value is 95.
IMWRITE_JPEG_PROGRESSIVE: Final[int]  # Enable JPEG features, 0 or 1, default is False.
IMWRITE_JPEG_OPTIMIZE: Final[int]  # Enable JPEG features, 0 or 1, default is False.
IMWRITE_JPEG_RST_INTERVAL: Final[int]  # JPEG restart interval, 0 - 65535, default is 0 - no restart.
IMWRITE_JPEG_LUMA_QUALITY: Final[int]  # Separate luma quality level, 0 - 100, default is -1 - don't use.
IMWRITE_JPEG_CHROMA_QUALITY: Final[int]  # Separate chroma quality level, 0 - 100, default is -1 - don't use.
IMWRITE_JPEG_SAMPLING_FACTOR: Final[int]  # For JPEG, set sampling factor. See cv::ImwriteJPEGSamplingFactorParams.
IMWRITE_PNG_COMPRESSION: Final[int]  # For PNG, it can be the compression level from 0 to 9. A higher value means a smaller size and longer compression time. If specified, strategy is changed to IMWRITE_PNG_STRATEGY_DEFAULT (Z_DEFAULT_STRATEGY). Default value is 1 (best speed setting).
IMWRITE_PNG_STRATEGY: Final[int]  # One of cv::ImwritePNGFlags, default is IMWRITE_PNG_STRATEGY_RLE.
IMWRITE_PNG_BILEVEL: Final[int]  # Binary level PNG, 0 or 1, default is 0.
IMWRITE_PXM_BINARY: Final[int]  # For PPM, PGM, or PBM, it can be a binary format flag, 0 or 1. Default value is 1.
IMWRITE_EXR_TYPE: Final[int]
IMWRITE_WEBP_QUALITY: Final[int]  # override EXR storage type (FLOAT (FP32) is default). For WEBP, it can be a quality from 1 to 100 (the higher is the better). By default (without any parameter) and for quality above 100 the lossless compression is used.
IMWRITE_HDR_COMPRESSION: Final[int]
IMWRITE_PAM_TUPLETYPE: Final[int]  # specify HDR compression. For PAM, sets the TUPLETYPE field to the corresponding string value that is defined for the format
IMWRITE_TIFF_RESUNIT: Final[int]  # For TIFF, use to specify which DPI resolution unit to set; see libtiff documentation for valid values.
IMWRITE_TIFF_XDPI: Final[int]  # For TIFF, use to specify the X direction DPI.
IMWRITE_TIFF_YDPI: Final[int]  # For TIFF, use to specify the Y direction DPI.
IMWRITE_TIFF_COMPRESSION: Final[int]  # For TIFF, use to specify the image compression scheme. See libtiff for integer constants corresponding to compression formats. Note, for images whose depth is CV_32F, only libtiff's SGILOG compression scheme is used. For other supported depths, the compression scheme can be specified by this flag; LZW compression is the default.

# ImwritePAMFlags
IMWRITE_PAM_FORMAT_NULL: Final[int]
IMWRITE_PAM_FORMAT_BLACKANDWHITE: Final[int]
IMWRITE_PAM_FORMAT_GRAYSCALE: Final[int]
IMWRITE_PAM_FORMAT_GRAYSCALE_ALPHA: Final[int]
IMWRITE_PAM_FORMAT_RGB: Final[int]
IMWRITE_PAM_FORMAT_RGB_ALPHA: Final[int]

# InterpolationFlags
INTER_NEAREST: Final[int]  # Nearest neighbor interpolation.
INTER_LINEAR: Final[int]  # Bilinear interpolation.
INTER_CUBIC: Final[int]  # Bicubic interpolation.
INTER_AREA: Final[int]  # Resampling using pixel area relation. It may be a preferred method for image decimation, as it gives moire'-free results. But when the image is zoomed, it is similar to the INTER_NEAREST method.
INTER_LANCZOS4: Final[int]  # Lanczos interpolation over 8x8 neighborhood.
INTER_LINEAR_EXACT: Final[int]  # Bit exact bilinear interpolation.
INTER_NEAREST_EXACT: Final[int]  # Bit exact nearest neighbor interpolation. This will produce same results as the nearest neighbor method in PIL, scikit-image or Matlab.
INTER_MAX: Final[int]  # Mask for interpolation codes.
WARP_FILL_OUTLIERS: Final[int]  # Flag, fills all of the destination image pixels. If some of them correspond to outliers in the source image, they are set to zero.
WARP_INVERSE_MAP: Final[int]  # Flag, inverse transformation. For example, linearPolar or logPolar transforms: flag is not set: dst(ρ,ϕ)=src(x,y) and flag is set: dst(x,y)=src(ρ,ϕ).  # noqa: RUF003

# InterpolationMasks
INTER_BITS: Final[int]
INTER_BITS2: Final[int]
INTER_TAB_SIZE: Final[int]
INTER_TAB_SIZE2: Final[int]

# Line types
FILLED: Final[int]
LINE_4: Final[int]  # 4-connected line
LINE_8: Final[int]  # 8-connected line
LINE_AA: Final[int]  # Antialiased line

# MatcherType
FLANNBASED: Final[int]
BRUTEFORCE: Final[int]
BRUTEFORCE_L1: Final[int]
BRUTEFORCE_HAMMING: Final[int]
BRUTEFORCE_HAMMINGLUT: Final[int]
BRUTEFORCE_SL2: Final[int]

# RetrievalModes
# https://docs.opencv.org/3.4/d3/dc0/group__imgproc__shape.html#ga819779b9857cc2f8601e6526a3a5bc71
RETR_EXTERNAL: Final[int]
RETR_LIST: Final[int]
RETR_CCOMP: Final[int]
RETR_TREE: Final[int]
RETR_FLOODFILL: Final[int]

# seamlessClone algorithm flags
# https://docs.opencv.org/3.4/df/da0/group__photo__clone.html#ga19386064a1bd4e1153262844e6875bcc
NORMAL_CLONE: Final[int]  # The power of the method is fully expressed when inserting objects with complex outlines into a new background
MIXED_CLONE: int  # The classic method, color-based selection and alpha masking might be time consuming and often leaves an undesirable halo. Seamless cloning, even averaged with the original image, is not effective. Mixed seamless cloning based on a loose selection proves effective.
MONOCHROME_TRANSFER: Final[int]  # Monochrome transfer allows the user to easily replace certain features of one object by alternative features.

# ThresholdTypes
THRESH_BINARY: Final[int]
THRESH_BINARY_INV: Final[int]
THRESH_TRUNC: Final[int]
THRESH_TOZERO: Final[int]
THRESH_TOZERO_INV: Final[int]
THRESH_MASK: Final[int]
THRESH_OTSU: Final[int]
THRESH_TRIANGLE: Final[int]

# WarpPolarMode
WARP_POLAR_LINEAR: Final[int]
WARP_POLAR_LOG: Final[int]

# WindowFlags
WINDOW_NORMAL: Final[int]  # The user can resize the window (no constraint) / also use to switch a fullscreen window to a normal size.
WINDOW_AUTOSIZE: Final[int]  # The user cannot resize the window, the size is constrained by the image displayed.
WINDOW_OPENGL: Final[int]  # Window with opengl support.
WINDOW_FULLSCREEN: Final[int]  # Change the window to fullscreen.
WINDOW_FREERATIO: Final[int]  # The image expends as much as it can (no ratio constraint).
WINDOW_KEEPRATIO: Final[int]  # The ratio of the image is respected.
WINDOW_GUI_EXPANDED: Final[int]  # Status bar and tool bar
WINDOW_GUI_NORMAL: Final[int]  # Old fashious way

# WindowPropertyFlags
WND_PROP_FULLSCREEN: Final[int]  # Fullscreen property (can be WINDOW_NORMAL or WINDOW_FULLSCREEN).
WND_PROP_AUTOSIZE: Final[int]  # Autosize property (can be WINDOW_NORMAL or WINDOW_AUTOSIZE).
WND_PROP_ASPECT_RATIO: Final[int]  # Window's aspect ration (can be set to WINDOW_FREERATIO or WINDOW_KEEPRATIO).
WND_PROP_OPENGL: Final[int]  # Opengl support.
WND_PROP_VISIBLE: Final[int]  # Checks whether the window exists and is visible
WND_PROP_TOPMOST: Final[int]  # Property to toggle normal window being topmost or not
WND_PROP_VSYNC: Final[int]

ACCESS_FAST: Final[int]
ACCESS_MASK: Final[int]
ACCESS_READ: Final[int]
ACCESS_RW: Final[int]
ACCESS_WRITE: Final[int]
ADAPTIVE_THRESH_GAUSSIAN_C: Final[int]
ADAPTIVE_THRESH_MEAN_C: Final[int]
AGAST_FEATURE_DETECTOR_AGAST_5_8: Final[int]
AGAST_FEATURE_DETECTOR_AGAST_7_12D: Final[int]
AGAST_FEATURE_DETECTOR_AGAST_7_12S: Final[int]
AGAST_FEATURE_DETECTOR_NONMAX_SUPPRESSION: Final[int]
AGAST_FEATURE_DETECTOR_OAST_9_16: Final[int]
AGAST_FEATURE_DETECTOR_THRESHOLD: Final[int]
AKAZE_DESCRIPTOR_KAZE: Final[int]
AKAZE_DESCRIPTOR_KAZE_UPRIGHT: Final[int]
AKAZE_DESCRIPTOR_MLDB: Final[int]
AKAZE_DESCRIPTOR_MLDB_UPRIGHT: Final[int]
AgastFeatureDetector_AGAST_5_8: Final[int]
AgastFeatureDetector_AGAST_7_12d: Final[int]
AgastFeatureDetector_AGAST_7_12s: Final[int]
AgastFeatureDetector_NONMAX_SUPPRESSION: Final[int]
AgastFeatureDetector_OAST_9_16: Final[int]
AgastFeatureDetector_THRESHOLD: Final[int]
CALIB_CB_ACCURACY: Final[int]
CALIB_CB_ADAPTIVE_THRESH: Final[int]
CALIB_CB_ASYMMETRIC_GRID: Final[int]
CALIB_CB_CLUSTERING: Final[int]
CALIB_CB_EXHAUSTIVE: Final[int]
CALIB_CB_FAST_CHECK: Final[int]
CALIB_CB_FILTER_QUADS: Final[int]
CALIB_CB_LARGER: Final[int]
CALIB_CB_MARKER: Final[int]
CALIB_CB_NORMALIZE_IMAGE: Final[int]
CALIB_CB_SYMMETRIC_GRID: Final[int]
CALIB_FIX_ASPECT_RATIO: Final[int]
CALIB_FIX_FOCAL_LENGTH: Final[int]
CALIB_FIX_INTRINSIC: Final[int]
CALIB_FIX_K1: Final[int]
CALIB_FIX_K2: Final[int]
CALIB_FIX_K3: Final[int]
CALIB_FIX_K4: Final[int]
CALIB_FIX_K5: Final[int]
CALIB_FIX_K6: Final[int]
CALIB_FIX_PRINCIPAL_POINT: Final[int]
CALIB_FIX_S1_S2_S3_S4: Final[int]
CALIB_FIX_TANGENT_DIST: Final[int]
CALIB_FIX_TAUX_TAUY: Final[int]
CALIB_HAND_EYE_ANDREFF: Final[int]
CALIB_HAND_EYE_DANIILIDIS: Final[int]
CALIB_HAND_EYE_HORAUD: Final[int]
CALIB_HAND_EYE_PARK: Final[int]
CALIB_HAND_EYE_TSAI: Final[int]
CALIB_NINTRINSIC: Final[int]
CALIB_RATIONAL_MODEL: Final[int]
CALIB_ROBOT_WORLD_HAND_EYE_LI: Final[int]
CALIB_ROBOT_WORLD_HAND_EYE_SHAH: Final[int]
CALIB_SAME_FOCAL_LENGTH: Final[int]
CALIB_THIN_PRISM_MODEL: Final[int]
CALIB_TILTED_MODEL: Final[int]
CALIB_USE_EXTRINSIC_GUESS: Final[int]
CALIB_USE_INTRINSIC_GUESS: Final[int]
CALIB_USE_LU: Final[int]
CALIB_USE_QR: Final[int]
CALIB_ZERO_DISPARITY: Final[int]
CALIB_ZERO_TANGENT_DIST: Final[int]
CAP_ANDROID: Final[int]
CAP_ANY: Final[int]
CAP_ARAVIS: Final[int]
CAP_AVFOUNDATION: Final[int]
CAP_CMU1394: Final[int]
CAP_DC1394: Final[int]
CAP_DSHOW: Final[int]
CAP_FFMPEG: Final[int]
CAP_FIREWARE: Final[int]
CAP_FIREWIRE: Final[int]
CAP_GIGANETIX: Final[int]
CAP_GPHOTO2: Final[int]
CAP_GSTREAMER: Final[int]
CAP_IEEE1394: Final[int]
CAP_IMAGES: Final[int]
CAP_INTELPERC: Final[int]
CAP_INTELPERC_DEPTH_GENERATOR: Final[int]
CAP_INTELPERC_DEPTH_MAP: Final[int]
CAP_INTELPERC_GENERATORS_MASK: Final[int]
CAP_INTELPERC_IMAGE: Final[int]
CAP_INTELPERC_IMAGE_GENERATOR: Final[int]
CAP_INTELPERC_IR_GENERATOR: Final[int]
CAP_INTELPERC_IR_MAP: Final[int]
CAP_INTELPERC_UVDEPTH_MAP: Final[int]
CAP_INTEL_MFX: Final[int]
CAP_MSMF: Final[int]
CAP_OBSENSOR: Final[int]
CAP_OBSENSOR_BGR_IMAGE: Final[int]
CAP_OBSENSOR_DEPTH_GENERATOR: Final[int]
CAP_OBSENSOR_DEPTH_MAP: Final[int]
CAP_OBSENSOR_GENERATORS_MASK: Final[int]
CAP_OBSENSOR_IMAGE_GENERATOR: Final[int]
CAP_OBSENSOR_IR_GENERATOR: Final[int]
CAP_OBSENSOR_IR_IMAGE: Final[int]
CAP_OPENCV_MJPEG: Final[int]
CAP_OPENNI: Final[int]
CAP_OPENNI2: Final[int]
CAP_OPENNI2_ASTRA: Final[int]
CAP_OPENNI2_ASUS: Final[int]
CAP_OPENNI_ASUS: Final[int]
CAP_OPENNI_BGR_IMAGE: Final[int]
CAP_OPENNI_DEPTH_GENERATOR: Final[int]
CAP_OPENNI_DEPTH_GENERATOR_BASELINE: Final[int]
CAP_OPENNI_DEPTH_GENERATOR_FOCAL_LENGTH: Final[int]
CAP_OPENNI_DEPTH_GENERATOR_PRESENT: Final[int]
CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION: Final[int]
CAP_OPENNI_DEPTH_GENERATOR_REGISTRATION_ON: Final[int]
CAP_OPENNI_DEPTH_MAP: Final[int]
CAP_OPENNI_DISPARITY_MAP: Final[int]
CAP_OPENNI_DISPARITY_MAP_32F: Final[int]
CAP_OPENNI_GENERATORS_MASK: Final[int]
CAP_OPENNI_GRAY_IMAGE: Final[int]
CAP_OPENNI_IMAGE_GENERATOR: Final[int]
CAP_OPENNI_IMAGE_GENERATOR_OUTPUT_MODE: Final[int]
CAP_OPENNI_IMAGE_GENERATOR_PRESENT: Final[int]
CAP_OPENNI_IR_GENERATOR: Final[int]
CAP_OPENNI_IR_GENERATOR_PRESENT: Final[int]
CAP_OPENNI_IR_IMAGE: Final[int]
CAP_OPENNI_POINT_CLOUD_MAP: Final[int]
CAP_OPENNI_QVGA_30HZ: int
CAP_OPENNI_QVGA_60HZ: int
CAP_OPENNI_SXGA_15HZ: Final[int]
CAP_OPENNI_SXGA_30HZ: int
CAP_OPENNI_VALID_DEPTH_MASK: Final[int]
CAP_OPENNI_VGA_30HZ: int
CAP_PROP_APERTURE: Final[int]
CAP_PROP_ARAVIS_AUTOTRIGGER: Final[int]
CAP_PROP_AUDIO_BASE_INDEX: Final[int]
CAP_PROP_AUDIO_DATA_DEPTH: Final[int]
CAP_PROP_AUDIO_POS: Final[int]
CAP_PROP_AUDIO_SAMPLES_PER_SECOND: Final[int]
CAP_PROP_AUDIO_SHIFT_NSEC: Final[int]
CAP_PROP_AUDIO_STREAM: Final[int]
CAP_PROP_AUDIO_SYNCHRONIZE: Final[int]
CAP_PROP_AUDIO_TOTAL_CHANNELS: Final[int]
CAP_PROP_AUDIO_TOTAL_STREAMS: Final[int]
CAP_PROP_AUTOFOCUS: Final[int]
CAP_PROP_AUTO_EXPOSURE: Final[int]
CAP_PROP_AUTO_WB: Final[int]
CAP_PROP_BACKEND: Final[int]
CAP_PROP_BACKLIGHT: Final[int]
CAP_PROP_BITRATE: Final[int]
CAP_PROP_BRIGHTNESS: Final[int]
CAP_PROP_BUFFERSIZE: Final[int]
CAP_PROP_CHANNEL: Final[int]
CAP_PROP_CODEC_EXTRADATA_INDEX: Final[int]
CAP_PROP_CODEC_PIXEL_FORMAT: Final[int]
CAP_PROP_CONTRAST: Final[int]
CAP_PROP_CONVERT_RGB: Final[int]
CAP_PROP_DC1394_MAX: Final[int]
CAP_PROP_DC1394_MODE_AUTO: Final[int]
CAP_PROP_DC1394_MODE_MANUAL: Final[int]
CAP_PROP_DC1394_MODE_ONE_PUSH_AUTO: Final[int]
CAP_PROP_DC1394_OFF: Final[int]
CAP_PROP_EXPOSURE: Final[int]
CAP_PROP_EXPOSUREPROGRAM: Final[int]
CAP_PROP_FOCUS: Final[int]
CAP_PROP_FORMAT: Final[int]
CAP_PROP_FOURCC: Final[int]
CAP_PROP_FPS: Final[int]
CAP_PROP_FRAME_COUNT: Final[int]
CAP_PROP_FRAME_HEIGHT: Final[int]
CAP_PROP_FRAME_TYPE: Final[int]
CAP_PROP_FRAME_WIDTH: Final[int]
CAP_PROP_GAIN: Final[int]
CAP_PROP_GAMMA: Final[int]
CAP_PROP_GIGA_FRAME_HEIGH_MAX: Final[int]
CAP_PROP_GIGA_FRAME_OFFSET_X: Final[int]
CAP_PROP_GIGA_FRAME_OFFSET_Y: Final[int]
CAP_PROP_GIGA_FRAME_SENS_HEIGH: Final[int]
CAP_PROP_GIGA_FRAME_SENS_WIDTH: Final[int]
CAP_PROP_GIGA_FRAME_WIDTH_MAX: Final[int]
CAP_PROP_GPHOTO2_COLLECT_MSGS: Final[int]
CAP_PROP_GPHOTO2_FLUSH_MSGS: Final[int]
CAP_PROP_GPHOTO2_PREVIEW: Final[int]
CAP_PROP_GPHOTO2_RELOAD_CONFIG: Final[int]
CAP_PROP_GPHOTO2_RELOAD_ON_CHANGE: Final[int]
CAP_PROP_GPHOTO2_WIDGET_ENUMERATE: Final[int]
CAP_PROP_GSTREAMER_QUEUE_LENGTH: Final[int]
CAP_PROP_GUID: Final[int]
CAP_PROP_HUE: Final[int]
CAP_PROP_HW_ACCELERATION: Final[int]
CAP_PROP_HW_ACCELERATION_USE_OPENCL: Final[int]
CAP_PROP_HW_DEVICE: Final[int]
CAP_PROP_IMAGES_BASE: Final[int]
CAP_PROP_IMAGES_LAST: Final[int]
CAP_PROP_INTELPERC_DEPTH_CONFIDENCE_THRESHOLD: Final[int]
CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_HORZ: Final[int]
CAP_PROP_INTELPERC_DEPTH_FOCAL_LENGTH_VERT: Final[int]
CAP_PROP_INTELPERC_DEPTH_LOW_CONFIDENCE_VALUE: Final[int]
CAP_PROP_INTELPERC_DEPTH_SATURATION_VALUE: Final[int]
CAP_PROP_INTELPERC_PROFILE_COUNT: Final[int]
CAP_PROP_INTELPERC_PROFILE_IDX: Final[int]
CAP_PROP_IOS_DEVICE_EXPOSURE: Final[int]
CAP_PROP_IOS_DEVICE_FLASH: Final[int]
CAP_PROP_IOS_DEVICE_FOCUS: Final[int]
CAP_PROP_IOS_DEVICE_TORCH: Final[int]
CAP_PROP_IOS_DEVICE_WHITEBALANCE: Final[int]
CAP_PROP_IRIS: Final[int]
CAP_PROP_ISO_SPEED: Final[int]
CAP_PROP_LRF_HAS_KEY_FRAME: Final[int]
CAP_PROP_MODE: Final[int]
CAP_PROP_MONOCHROME: Final[int]
CAP_PROP_N_THREADS: Final[int]
CAP_PROP_OBSENSOR_INTRINSIC_CX: Final[int]
CAP_PROP_OBSENSOR_INTRINSIC_CY: Final[int]
CAP_PROP_OBSENSOR_INTRINSIC_FX: Final[int]
CAP_PROP_OBSENSOR_INTRINSIC_FY: Final[int]
CAP_PROP_OPENNI2_MIRROR: Final[int]
CAP_PROP_OPENNI2_SYNC: Final[int]
CAP_PROP_OPENNI_APPROX_FRAME_SYNC: Final[int]
CAP_PROP_OPENNI_BASELINE: Final[int]
CAP_PROP_OPENNI_CIRCLE_BUFFER: Final[int]
CAP_PROP_OPENNI_FOCAL_LENGTH: Final[int]
CAP_PROP_OPENNI_FRAME_MAX_DEPTH: Final[int]
CAP_PROP_OPENNI_GENERATOR_PRESENT: Final[int]
CAP_PROP_OPENNI_MAX_BUFFER_SIZE: Final[int]
CAP_PROP_OPENNI_MAX_TIME_DURATION: Final[int]
CAP_PROP_OPENNI_OUTPUT_MODE: Final[int]
CAP_PROP_OPENNI_REGISTRATION: Final[int]
CAP_PROP_OPENNI_REGISTRATION_ON: Final[int]
CAP_PROP_OPEN_TIMEOUT_MSEC: Final[int]
CAP_PROP_ORIENTATION_AUTO: Final[int]
CAP_PROP_ORIENTATION_META: Final[int]
CAP_PROP_PAN: Final[int]
CAP_PROP_POS_AVI_RATIO: Final[int]
CAP_PROP_POS_FRAMES: Final[int]
CAP_PROP_POS_MSEC: Final[int]
CAP_PROP_PVAPI_BINNINGX: Final[int]
CAP_PROP_PVAPI_BINNINGY: Final[int]
CAP_PROP_PVAPI_DECIMATIONHORIZONTAL: Final[int]
CAP_PROP_PVAPI_DECIMATIONVERTICAL: Final[int]
CAP_PROP_PVAPI_FRAMESTARTTRIGGERMODE: Final[int]
CAP_PROP_PVAPI_MULTICASTIP: Final[int]
CAP_PROP_PVAPI_PIXELFORMAT: Final[int]
CAP_PROP_READ_TIMEOUT_MSEC: Final[int]
CAP_PROP_RECTIFICATION: Final[int]
CAP_PROP_ROLL: Final[int]
CAP_PROP_SAR_DEN: Final[int]
CAP_PROP_SAR_NUM: Final[int]
CAP_PROP_SATURATION: Final[int]
CAP_PROP_SETTINGS: Final[int]
CAP_PROP_SHARPNESS: Final[int]
CAP_PROP_SPEED: Final[int]
CAP_PROP_STREAM_OPEN_TIME_USEC: Final[int]
CAP_PROP_TEMPERATURE: Final[int]
CAP_PROP_TILT: Final[int]
CAP_PROP_TRIGGER: Final[int]
CAP_PROP_TRIGGER_DELAY: Final[int]
CAP_PROP_VIDEO_STREAM: Final[int]
CAP_PROP_VIDEO_TOTAL_CHANNELS: Final[int]
CAP_PROP_VIEWFINDER: Final[int]
CAP_PROP_WB_TEMPERATURE: Final[int]
CAP_PROP_WHITE_BALANCE_BLUE_U: Final[int]
CAP_PROP_WHITE_BALANCE_RED_V: Final[int]
CAP_PROP_XI_ACQ_BUFFER_SIZE: Final[int]
CAP_PROP_XI_ACQ_BUFFER_SIZE_UNIT: Final[int]
CAP_PROP_XI_ACQ_FRAME_BURST_COUNT: Final[int]
CAP_PROP_XI_ACQ_TIMING_MODE: Final[int]
CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_COMMIT: Final[int]
CAP_PROP_XI_ACQ_TRANSPORT_BUFFER_SIZE: Final[int]
CAP_PROP_XI_AEAG: Final[int]
CAP_PROP_XI_AEAG_LEVEL: Final[int]
CAP_PROP_XI_AEAG_ROI_HEIGHT: Final[int]
CAP_PROP_XI_AEAG_ROI_OFFSET_X: Final[int]
CAP_PROP_XI_AEAG_ROI_OFFSET_Y: Final[int]
CAP_PROP_XI_AEAG_ROI_WIDTH: Final[int]
CAP_PROP_XI_AE_MAX_LIMIT: Final[int]
CAP_PROP_XI_AG_MAX_LIMIT: Final[int]
CAP_PROP_XI_APPLY_CMS: Final[int]
CAP_PROP_XI_AUTO_BANDWIDTH_CALCULATION: Final[int]
CAP_PROP_XI_AUTO_WB: Final[int]
CAP_PROP_XI_AVAILABLE_BANDWIDTH: Final[int]
CAP_PROP_XI_BINNING_HORIZONTAL: Final[int]
CAP_PROP_XI_BINNING_PATTERN: Final[int]
CAP_PROP_XI_BINNING_SELECTOR: Final[int]
CAP_PROP_XI_BINNING_VERTICAL: Final[int]
CAP_PROP_XI_BPC: Final[int]
CAP_PROP_XI_BUFFERS_QUEUE_SIZE: Final[int]
CAP_PROP_XI_BUFFER_POLICY: Final[int]
CAP_PROP_XI_CC_MATRIX_00: int
CAP_PROP_XI_CC_MATRIX_01: int
CAP_PROP_XI_CC_MATRIX_02: int
CAP_PROP_XI_CC_MATRIX_03: int
CAP_PROP_XI_CC_MATRIX_10: int
CAP_PROP_XI_CC_MATRIX_11: Final[int]
CAP_PROP_XI_CC_MATRIX_12: Final[int]
CAP_PROP_XI_CC_MATRIX_13: Final[int]
CAP_PROP_XI_CC_MATRIX_20: int
CAP_PROP_XI_CC_MATRIX_21: Final[int]
CAP_PROP_XI_CC_MATRIX_22: Final[int]
CAP_PROP_XI_CC_MATRIX_23: Final[int]
CAP_PROP_XI_CC_MATRIX_30: int
CAP_PROP_XI_CC_MATRIX_31: Final[int]
CAP_PROP_XI_CC_MATRIX_32: Final[int]
CAP_PROP_XI_CC_MATRIX_33: Final[int]
CAP_PROP_XI_CHIP_TEMP: Final[int]
CAP_PROP_XI_CMS: Final[int]
CAP_PROP_XI_COLOR_FILTER_ARRAY: Final[int]
CAP_PROP_XI_COLUMN_FPN_CORRECTION: Final[int]
CAP_PROP_XI_COOLING: Final[int]
CAP_PROP_XI_COUNTER_SELECTOR: Final[int]
CAP_PROP_XI_COUNTER_VALUE: Final[int]
CAP_PROP_XI_DATA_FORMAT: Final[int]
CAP_PROP_XI_DEBOUNCE_EN: Final[int]
CAP_PROP_XI_DEBOUNCE_POL: Final[int]
CAP_PROP_XI_DEBOUNCE_T0: int
CAP_PROP_XI_DEBOUNCE_T1: Final[int]
CAP_PROP_XI_DEBUG_LEVEL: Final[int]
CAP_PROP_XI_DECIMATION_HORIZONTAL: Final[int]
CAP_PROP_XI_DECIMATION_PATTERN: Final[int]
CAP_PROP_XI_DECIMATION_SELECTOR: Final[int]
CAP_PROP_XI_DECIMATION_VERTICAL: Final[int]
CAP_PROP_XI_DEFAULT_CC_MATRIX: Final[int]
CAP_PROP_XI_DEVICE_MODEL_ID: Final[int]
CAP_PROP_XI_DEVICE_RESET: Final[int]
CAP_PROP_XI_DEVICE_SN: Final[int]
CAP_PROP_XI_DOWNSAMPLING: Final[int]
CAP_PROP_XI_DOWNSAMPLING_TYPE: Final[int]
CAP_PROP_XI_EXPOSURE: Final[int]
CAP_PROP_XI_EXPOSURE_BURST_COUNT: Final[int]
CAP_PROP_XI_EXP_PRIORITY: Final[int]
CAP_PROP_XI_FFS_ACCESS_KEY: Final[int]
CAP_PROP_XI_FFS_FILE_ID: Final[int]
CAP_PROP_XI_FFS_FILE_SIZE: Final[int]
CAP_PROP_XI_FRAMERATE: Final[int]
CAP_PROP_XI_FREE_FFS_SIZE: Final[int]
CAP_PROP_XI_GAIN: Final[int]
CAP_PROP_XI_GAIN_SELECTOR: Final[int]
CAP_PROP_XI_GAMMAC: Final[int]
CAP_PROP_XI_GAMMAY: Final[int]
CAP_PROP_XI_GPI_LEVEL: Final[int]
CAP_PROP_XI_GPI_MODE: Final[int]
CAP_PROP_XI_GPI_SELECTOR: Final[int]
CAP_PROP_XI_GPO_MODE: Final[int]
CAP_PROP_XI_GPO_SELECTOR: Final[int]
CAP_PROP_XI_HDR: Final[int]
CAP_PROP_XI_HDR_KNEEPOINT_COUNT: Final[int]
CAP_PROP_XI_HDR_T1: Final[int]
CAP_PROP_XI_HDR_T2: Final[int]
CAP_PROP_XI_HEIGHT: Final[int]
CAP_PROP_XI_HOUS_BACK_SIDE_TEMP: Final[int]
CAP_PROP_XI_HOUS_TEMP: Final[int]
CAP_PROP_XI_HW_REVISION: Final[int]
CAP_PROP_XI_IMAGE_BLACK_LEVEL: Final[int]
CAP_PROP_XI_IMAGE_DATA_BIT_DEPTH: Final[int]
CAP_PROP_XI_IMAGE_DATA_FORMAT: Final[int]
CAP_PROP_XI_IMAGE_DATA_FORMAT_RGB32_ALPHA: Final[int]
CAP_PROP_XI_IMAGE_IS_COLOR: Final[int]
CAP_PROP_XI_IMAGE_PAYLOAD_SIZE: Final[int]
CAP_PROP_XI_IS_COOLED: Final[int]
CAP_PROP_XI_IS_DEVICE_EXIST: Final[int]
CAP_PROP_XI_KNEEPOINT1: Final[int]
CAP_PROP_XI_KNEEPOINT2: Final[int]
CAP_PROP_XI_LED_MODE: Final[int]
CAP_PROP_XI_LED_SELECTOR: Final[int]
CAP_PROP_XI_LENS_APERTURE_VALUE: Final[int]
CAP_PROP_XI_LENS_FEATURE: Final[int]
CAP_PROP_XI_LENS_FEATURE_SELECTOR: Final[int]
CAP_PROP_XI_LENS_FOCAL_LENGTH: Final[int]
CAP_PROP_XI_LENS_FOCUS_DISTANCE: Final[int]
CAP_PROP_XI_LENS_FOCUS_MOVE: Final[int]
CAP_PROP_XI_LENS_FOCUS_MOVEMENT_VALUE: Final[int]
CAP_PROP_XI_LENS_MODE: Final[int]
CAP_PROP_XI_LIMIT_BANDWIDTH: Final[int]
CAP_PROP_XI_LUT_EN: Final[int]
CAP_PROP_XI_LUT_INDEX: Final[int]
CAP_PROP_XI_LUT_VALUE: Final[int]
CAP_PROP_XI_MANUAL_WB: Final[int]
CAP_PROP_XI_OFFSET_X: Final[int]
CAP_PROP_XI_OFFSET_Y: Final[int]
CAP_PROP_XI_OUTPUT_DATA_BIT_DEPTH: Final[int]
CAP_PROP_XI_OUTPUT_DATA_PACKING: Final[int]
CAP_PROP_XI_OUTPUT_DATA_PACKING_TYPE: Final[int]
CAP_PROP_XI_RECENT_FRAME: Final[int]
CAP_PROP_XI_REGION_MODE: Final[int]
CAP_PROP_XI_REGION_SELECTOR: Final[int]
CAP_PROP_XI_ROW_FPN_CORRECTION: Final[int]
CAP_PROP_XI_SENSOR_BOARD_TEMP: Final[int]
CAP_PROP_XI_SENSOR_CLOCK_FREQ_HZ: Final[int]
CAP_PROP_XI_SENSOR_CLOCK_FREQ_INDEX: Final[int]
CAP_PROP_XI_SENSOR_DATA_BIT_DEPTH: Final[int]
CAP_PROP_XI_SENSOR_FEATURE_SELECTOR: Final[int]
CAP_PROP_XI_SENSOR_FEATURE_VALUE: Final[int]
CAP_PROP_XI_SENSOR_MODE: Final[int]
CAP_PROP_XI_SENSOR_OUTPUT_CHANNEL_COUNT: Final[int]
CAP_PROP_XI_SENSOR_TAPS: Final[int]
CAP_PROP_XI_SHARPNESS: Final[int]
CAP_PROP_XI_SHUTTER_TYPE: Final[int]
CAP_PROP_XI_TARGET_TEMP: Final[int]
CAP_PROP_XI_TEST_PATTERN: Final[int]
CAP_PROP_XI_TEST_PATTERN_GENERATOR_SELECTOR: Final[int]
CAP_PROP_XI_TIMEOUT: Final[int]
CAP_PROP_XI_TRANSPORT_PIXEL_FORMAT: Final[int]
CAP_PROP_XI_TRG_DELAY: Final[int]
CAP_PROP_XI_TRG_SELECTOR: Final[int]
CAP_PROP_XI_TRG_SOFTWARE: Final[int]
CAP_PROP_XI_TRG_SOURCE: Final[int]
CAP_PROP_XI_TS_RST_MODE: Final[int]
CAP_PROP_XI_TS_RST_SOURCE: Final[int]
CAP_PROP_XI_USED_FFS_SIZE: Final[int]
CAP_PROP_XI_WB_KB: Final[int]
CAP_PROP_XI_WB_KG: Final[int]
CAP_PROP_XI_WB_KR: Final[int]
CAP_PROP_XI_WIDTH: Final[int]
CAP_PROP_ZOOM: Final[int]
CAP_PVAPI: Final[int]
CAP_PVAPI_DECIMATION_2OUTOF16: Final[int]
CAP_PVAPI_DECIMATION_2OUTOF4: Final[int]
CAP_PVAPI_DECIMATION_2OUTOF8: Final[int]
CAP_PVAPI_DECIMATION_OFF: Final[int]
CAP_PVAPI_FSTRIGMODE_FIXEDRATE: Final[int]
CAP_PVAPI_FSTRIGMODE_FREERUN: Final[int]
CAP_PVAPI_FSTRIGMODE_SOFTWARE: Final[int]
CAP_PVAPI_FSTRIGMODE_SYNCIN1: Final[int]
CAP_PVAPI_FSTRIGMODE_SYNCIN2: Final[int]
CAP_PVAPI_PIXELFORMAT_BAYER16: Final[int]
CAP_PVAPI_PIXELFORMAT_BAYER8: Final[int]
CAP_PVAPI_PIXELFORMAT_BGR24: Final[int]
CAP_PVAPI_PIXELFORMAT_BGRA32: Final[int]
CAP_PVAPI_PIXELFORMAT_MONO16: Final[int]
CAP_PVAPI_PIXELFORMAT_MONO8: Final[int]
CAP_PVAPI_PIXELFORMAT_RGB24: Final[int]
CAP_PVAPI_PIXELFORMAT_RGBA32: Final[int]
CAP_QT: Final[int]
CAP_REALSENSE: Final[int]
CAP_UEYE: Final[int]
CAP_UNICAP: Final[int]
CAP_V4L: Final[int]
CAP_V4L2: Final[int]
CAP_VFW: Final[int]
CAP_WINRT: Final[int]
CAP_XIAPI: Final[int]
CAP_XINE: Final[int]
CASCADE_DO_CANNY_PRUNING: Final[int]
CASCADE_DO_ROUGH_SEARCH: Final[int]
CASCADE_FIND_BIGGEST_OBJECT: Final[int]
CASCADE_SCALE_IMAGE: Final[int]
CCL_BBDT: Final[int]
CCL_BOLELLI: Final[int]
CCL_DEFAULT: Final[int]
CCL_GRANA: Final[int]
CCL_SAUF: Final[int]
CCL_SPAGHETTI: Final[int]
CCL_WU: Final[int]
CC_STAT_MAX: Final[int]
CIRCLES_GRID_FINDER_PARAMETERS_ASYMMETRIC_GRID: Final[int]
CIRCLES_GRID_FINDER_PARAMETERS_SYMMETRIC_GRID: Final[int]
CMP_EQ: Final[int]
CMP_GE: Final[int]
CMP_GT: Final[int]
CMP_LE: Final[int]
CMP_LT: Final[int]
CMP_NE: Final[int]
COLORMAP_AUTUMN: Final[int]
COLORMAP_BONE: Final[int]
COLORMAP_CIVIDIS: Final[int]
COLORMAP_COOL: Final[int]
COLORMAP_DEEPGREEN: Final[int]
COLORMAP_HOT: Final[int]
COLORMAP_HSV: Final[int]
COLORMAP_INFERNO: Final[int]
COLORMAP_JET: Final[int]
COLORMAP_MAGMA: Final[int]
COLORMAP_OCEAN: Final[int]
COLORMAP_PARULA: Final[int]
COLORMAP_PINK: Final[int]
COLORMAP_PLASMA: Final[int]
COLORMAP_RAINBOW: Final[int]
COLORMAP_SPRING: Final[int]
COLORMAP_SUMMER: Final[int]
COLORMAP_TURBO: Final[int]
COLORMAP_TWILIGHT: Final[int]
COLORMAP_TWILIGHT_SHIFTED: Final[int]
COLORMAP_VIRIDIS: Final[int]
COLORMAP_WINTER: Final[int]
COLOR_BAYER_BG2BGR: Final[int] = 46
COLOR_BAYER_BG2BGRA: Final[int]
COLOR_BAYER_BG2BGR_EA: Final[int]
COLOR_BAYER_BG2BGR_VNG: Final[int]
COLOR_BAYER_BG2GRAY: Final[int]
COLOR_BAYER_BG2RGB: Final[int]
COLOR_BAYER_BG2RGBA: Final[int]
COLOR_BAYER_BG2RGB_EA: Final[int]
COLOR_BAYER_BG2RGB_VNG: Final[int]
COLOR_BAYER_BGGR2BGR: Final[int]
COLOR_BAYER_BGGR2BGRA: Final[int]
COLOR_BAYER_BGGR2BGR_EA: Final[int]
COLOR_BAYER_BGGR2BGR_VNG: Final[int]
COLOR_BAYER_BGGR2GRAY: Final[int]
COLOR_BAYER_BGGR2RGB: Final[int]
COLOR_BAYER_BGGR2RGBA: Final[int]
COLOR_BAYER_BGGR2RGB_EA: Final[int]
COLOR_BAYER_BGGR2RGB_VNG: Final[int]
COLOR_BAYER_GB2BGR: Final[int]
COLOR_BAYER_GB2BGRA: Final[int]
COLOR_BAYER_GB2BGR_EA: Final[int]
COLOR_BAYER_GB2BGR_VNG: Final[int]
COLOR_BAYER_GB2GRAY: Final[int]
COLOR_BAYER_GB2RGB: Final[int]
COLOR_BAYER_GB2RGBA: Final[int]
COLOR_BAYER_GB2RGB_EA: Final[int]
COLOR_BAYER_GB2RGB_VNG: Final[int]
COLOR_BAYER_GBRG2BGR: Final[int]
COLOR_BAYER_GBRG2BGRA: Final[int]
COLOR_BAYER_GBRG2BGR_EA: Final[int]
COLOR_BAYER_GBRG2BGR_VNG: Final[int]
COLOR_BAYER_GBRG2GRAY: Final[int]
COLOR_BAYER_GBRG2RGB: Final[int]
COLOR_BAYER_GBRG2RGBA: Final[int]
COLOR_BAYER_GBRG2RGB_EA: Final[int]
COLOR_BAYER_GBRG2RGB_VNG: Final[int]
COLOR_BAYER_GR2BGR: Final[int]
COLOR_BAYER_GR2BGRA: Final[int]
COLOR_BAYER_GR2BGR_EA: Final[int]
COLOR_BAYER_GR2BGR_VNG: Final[int]
COLOR_BAYER_GR2GRAY: Final[int]
COLOR_BAYER_GR2RGB: Final[int]
COLOR_BAYER_GR2RGBA: Final[int]
COLOR_BAYER_GR2RGB_EA: Final[int]
COLOR_BAYER_GR2RGB_VNG: Final[int]
COLOR_BAYER_GRBG2BGR: Final[int]
COLOR_BAYER_GRBG2BGRA: Final[int]
COLOR_BAYER_GRBG2BGR_EA: Final[int]
COLOR_BAYER_GRBG2BGR_VNG: Final[int]
COLOR_BAYER_GRBG2GRAY: Final[int]
COLOR_BAYER_GRBG2RGB: Final[int]
COLOR_BAYER_GRBG2RGBA: Final[int]
COLOR_BAYER_GRBG2RGB_EA: Final[int]
COLOR_BAYER_GRBG2RGB_VNG: Final[int]
COLOR_BAYER_RG2BGR: Final[int]
COLOR_BAYER_RG2BGRA: Final[int]
COLOR_BAYER_RG2BGR_EA: Final[int]
COLOR_BAYER_RG2BGR_VNG: Final[int]
COLOR_BAYER_RG2GRAY: Final[int]
COLOR_BAYER_RG2RGB: Final[int]
COLOR_BAYER_RG2RGBA: Final[int]
COLOR_BAYER_RG2RGB_EA: Final[int]
COLOR_BAYER_RG2RGB_VNG: Final[int]
COLOR_BAYER_RGGB2BGR: Final[int]
COLOR_BAYER_RGGB2BGRA: Final[int]
COLOR_BAYER_RGGB2BGR_EA: Final[int]
COLOR_BAYER_RGGB2BGR_VNG: Final[int]
COLOR_BAYER_RGGB2GRAY: Final[int]
COLOR_BAYER_RGGB2RGB: Final[int]
COLOR_BAYER_RGGB2RGBA: Final[int]
COLOR_BAYER_RGGB2RGB_EA: Final[int]
COLOR_BAYER_RGGB2RGB_VNG: Final[int]
COLOR_BGR2LAB: Final[int]
COLOR_BGR2LUV: Final[int]
COLOR_BGR2YCR_CB: Final[int]
COLOR_LAB2BGR: Final[int]
COLOR_LAB2LBGR: Final[int]
COLOR_LAB2LRGB: Final[int]
COLOR_LAB2RGB: Final[int]
COLOR_LBGR2LAB: Final[int]
COLOR_LBGR2LUV: Final[int]
COLOR_LRGB2LAB: Final[int]
COLOR_LRGB2LUV: Final[int]
COLOR_LUV2BGR: Final[int]
COLOR_LUV2LBGR: Final[int]
COLOR_LUV2LRGB: Final[int]
COLOR_LUV2RGB: Final[int]
COLOR_M_RGBA2RGBA: Final[int]
COLOR_RGB2LAB: Final[int]
COLOR_RGB2LUV: Final[int]
COLOR_RGB2YCR_CB: Final[int]
COLOR_RGBA2M_RGBA: Final[int]
COLOR_YCR_CB2BGR: Final[int]
COLOR_YCR_CB2RGB: Final[int]
COLOR_YUV420P2BGR: int
COLOR_YUV420P2BGRA: int
COLOR_YUV420P2GRAY: int
COLOR_YUV420P2RGB: int
COLOR_YUV420P2RGBA: int
COLOR_YUV420SP2BGR: int
COLOR_YUV420SP2BGRA: int
COLOR_YUV420SP2GRAY: int
COLOR_YUV420SP2RGB: int
COLOR_YUV420SP2RGBA: int
CONTOURS_MATCH_I1: Final[int]
CONTOURS_MATCH_I2: Final[int]
CONTOURS_MATCH_I3: Final[int]
COVAR_COLS: Final[int]
COVAR_NORMAL: Final[int]
COVAR_ROWS: Final[int]
COVAR_SCALE: Final[int]
COVAR_SCRAMBLED: Final[int]
COVAR_USE_AVG: Final[int]
CirclesGridFinderParameters_ASYMMETRIC_GRID: Final[int]
CirclesGridFinderParameters_SYMMETRIC_GRID: Final[int]
DCT_INVERSE: Final[int]
DCT_ROWS: Final[int]
DECOMP_CHOLESKY: Final[int]
DECOMP_EIG: Final[int]
DECOMP_LU: Final[int]
DECOMP_NORMAL: Final[int]
DECOMP_QR: Final[int]
DECOMP_SVD: Final[int]
DESCRIPTOR_MATCHER_BRUTEFORCE: Final[int]
DESCRIPTOR_MATCHER_BRUTEFORCE_HAMMING: Final[int]
DESCRIPTOR_MATCHER_BRUTEFORCE_HAMMINGLUT: Final[int]
DESCRIPTOR_MATCHER_BRUTEFORCE_L1: Final[int]
DESCRIPTOR_MATCHER_BRUTEFORCE_SL2: Final[int]
DESCRIPTOR_MATCHER_FLANNBASED: Final[int]
DFT_COMPLEX_INPUT: Final[int]
DFT_COMPLEX_OUTPUT: Final[int]
DFT_INVERSE: Final[int]
DFT_REAL_OUTPUT: Final[int]
DFT_ROWS: Final[int]
DFT_SCALE: Final[int]
DISOPTICAL_FLOW_PRESET_FAST: Final[int]
DISOPTICAL_FLOW_PRESET_MEDIUM: Final[int]
DISOPTICAL_FLOW_PRESET_ULTRAFAST: Final[int]
DISOpticalFlow_PRESET_FAST: Final[int]
DISOpticalFlow_PRESET_MEDIUM: Final[int]
DISOpticalFlow_PRESET_ULTRAFAST: Final[int]
DIST_C: Final[int]
DIST_FAIR: Final[int]
DIST_HUBER: Final[int]
DIST_L1: Final[int]
DIST_L12: Final[int]
DIST_L2: Final[int]
DIST_LABEL_CCOMP: Final[int]
DIST_LABEL_PIXEL: Final[int]
DIST_MASK_3: Final[int]
DIST_MASK_5: Final[int]
DIST_MASK_PRECISE: Final[int]
DIST_USER: Final[int]
DIST_WELSCH: Final[int]
DRAW_MATCHES_FLAGS_DEFAULT: Final[int]
DRAW_MATCHES_FLAGS_DRAW_OVER_OUTIMG: Final[int]
DRAW_MATCHES_FLAGS_DRAW_RICH_KEYPOINTS: Final[int]
DRAW_MATCHES_FLAGS_NOT_DRAW_SINGLE_POINTS: Final[int]
DescriptorMatcher_BRUTEFORCE: Final[int]
DescriptorMatcher_BRUTEFORCE_HAMMING: Final[int]
DescriptorMatcher_BRUTEFORCE_HAMMINGLUT: Final[int]
DescriptorMatcher_BRUTEFORCE_L1: Final[int]
DescriptorMatcher_BRUTEFORCE_SL2: Final[int]
DescriptorMatcher_FLANNBASED: Final[int]
DrawMatchesFlags_DEFAULT: Final[int]
DrawMatchesFlags_DRAW_OVER_OUTIMG: Final[int]
DrawMatchesFlags_DRAW_RICH_KEYPOINTS: Final[int]
DrawMatchesFlags_NOT_DRAW_SINGLE_POINTS: Final[int]
EVENT_FLAG_ALTKEY: Final[int]
EVENT_FLAG_CTRLKEY: Final[int]
EVENT_FLAG_LBUTTON: Final[int]
EVENT_FLAG_MBUTTON: Final[int]
EVENT_FLAG_RBUTTON: Final[int]
EVENT_FLAG_SHIFTKEY: Final[int]
EVENT_LBUTTONDBLCLK: Final[int]
EVENT_LBUTTONDOWN: Final[int]
EVENT_LBUTTONUP: Final[int]
EVENT_MBUTTONDBLCLK: Final[int]
EVENT_MBUTTONDOWN: Final[int]
EVENT_MBUTTONUP: Final[int]
EVENT_MOUSEHWHEEL: Final[int]
EVENT_MOUSEMOVE: Final[int]
EVENT_MOUSEWHEEL: Final[int]
EVENT_RBUTTONDBLCLK: Final[int]
EVENT_RBUTTONDOWN: Final[int]
EVENT_RBUTTONUP: Final[int]
FACE_RECOGNIZER_SF_FR_COSINE: Final[int]
FACE_RECOGNIZER_SF_FR_NORM_L2: Final[int]
FAST_FEATURE_DETECTOR_FAST_N: Final[int]
FAST_FEATURE_DETECTOR_NONMAX_SUPPRESSION: Final[int]
FAST_FEATURE_DETECTOR_THRESHOLD: Final[int]
FAST_FEATURE_DETECTOR_TYPE_5_8: Final[int]
FAST_FEATURE_DETECTOR_TYPE_7_12: Final[int]
FAST_FEATURE_DETECTOR_TYPE_9_16: Final[int]
FILE_NODE_EMPTY: Final[int]
FILE_NODE_FLOAT: Final[int]
FILE_NODE_FLOW: Final[int]
FILE_NODE_INT: Final[int]
FILE_NODE_MAP: Final[int]
FILE_NODE_NAMED: Final[int]
FILE_NODE_NONE: Final[int]
FILE_NODE_REAL: Final[int]
FILE_NODE_SEQ: Final[int]
FILE_NODE_STR: Final[int]
FILE_NODE_STRING: Final[int]
FILE_NODE_TYPE_MASK: Final[int]
FILE_NODE_UNIFORM: Final[int]
FILE_STORAGE_APPEND: Final[int]
FILE_STORAGE_BASE64: Final[int]
FILE_STORAGE_FORMAT_AUTO: Final[int]
FILE_STORAGE_FORMAT_JSON: Final[int]
FILE_STORAGE_FORMAT_MASK: Final[int]
FILE_STORAGE_FORMAT_XML: Final[int]
FILE_STORAGE_FORMAT_YAML: Final[int]
FILE_STORAGE_INSIDE_MAP: Final[int]
FILE_STORAGE_MEMORY: Final[int]
FILE_STORAGE_NAME_EXPECTED: Final[int]
FILE_STORAGE_READ: Final[int]
FILE_STORAGE_UNDEFINED: Final[int]
FILE_STORAGE_VALUE_EXPECTED: Final[int]
FILE_STORAGE_WRITE: Final[int]
FILE_STORAGE_WRITE_BASE64: Final[int]
FILTER_SCHARR: Final[int]
FLOODFILL_FIXED_RANGE: Final[int]
FLOODFILL_MASK_ONLY: Final[int]
FM_7POINT: Final[int]
FM_8POINT: Final[int]
FM_LMEDS: Final[int]
FM_RANSAC: Final[int]
FORMATTER_FMT_C: Final[int]
FORMATTER_FMT_CSV: Final[int]
FORMATTER_FMT_DEFAULT: Final[int]
FORMATTER_FMT_MATLAB: Final[int]
FORMATTER_FMT_NUMPY: Final[int]
FORMATTER_FMT_PYTHON: Final[int]
FaceRecognizerSF_FR_COSINE: Final[int]
FaceRecognizerSF_FR_NORM_L2: Final[int]
FastFeatureDetector_FAST_N: Final[int]
FastFeatureDetector_NONMAX_SUPPRESSION: Final[int]
FastFeatureDetector_THRESHOLD: Final[int]
FastFeatureDetector_TYPE_5_8: Final[int]
FastFeatureDetector_TYPE_7_12: Final[int]
FastFeatureDetector_TYPE_9_16: Final[int]
FileNode_EMPTY: Final[int]
FileNode_FLOAT: Final[int]
FileNode_FLOW: Final[int]
FileNode_INT: Final[int]
FileNode_MAP: Final[int]
FileNode_NAMED: Final[int]
FileNode_NONE: Final[int]
FileNode_REAL: Final[int]
FileNode_SEQ: Final[int]
FileNode_STR: Final[int]
FileNode_STRING: Final[int]
FileNode_TYPE_MASK: Final[int]
FileNode_UNIFORM: Final[int]
FileStorage_APPEND: Final[int]
FileStorage_BASE64: Final[int]
FileStorage_FORMAT_AUTO: Final[int]
FileStorage_FORMAT_JSON: Final[int]
FileStorage_FORMAT_MASK: Final[int]
FileStorage_FORMAT_XML: Final[int]
FileStorage_FORMAT_YAML: Final[int]
FileStorage_INSIDE_MAP: Final[int]
FileStorage_MEMORY: Final[int]
FileStorage_NAME_EXPECTED: Final[int]
FileStorage_READ: Final[int]
FileStorage_UNDEFINED: Final[int]
FileStorage_VALUE_EXPECTED: Final[int]
FileStorage_WRITE: Final[int]
FileStorage_WRITE_BASE64: Final[int]
Formatter_FMT_C: Final[int]
Formatter_FMT_CSV: Final[int]
Formatter_FMT_DEFAULT: Final[int]
Formatter_FMT_MATLAB: Final[int]
Formatter_FMT_NUMPY: Final[int]
Formatter_FMT_PYTHON: Final[int]
GC_BGD: Final[int]
GC_EVAL: Final[int]
GC_EVAL_FREEZE_MODEL: Final[int]
GC_FGD: Final[int]
GC_INIT_WITH_MASK: Final[int]
GC_INIT_WITH_RECT: Final[int]
GC_PR_BGD: Final[int]
GC_PR_FGD: Final[int]
GEMM_1_T: Final[int]
GEMM_2_T: Final[int]
GEMM_3_T: Final[int]
GFLUID_KERNEL_KIND_FILTER: Final[int]
GFLUID_KERNEL_KIND_RESIZE: Final[int]
GFLUID_KERNEL_KIND_YUV420TO_RGB: int
GFluidKernel_Kind_Filter: Final[int]
GFluidKernel_Kind_Resize: Final[int]
GFluidKernel_Kind_YUV420toRGB: int
GSHAPE_GARRAY: Final[int]
GSHAPE_GFRAME: Final[int]
GSHAPE_GMAT: Final[int]
GSHAPE_GOPAQUE: Final[int]
GSHAPE_GSCALAR: Final[int]
GShape_GARRAY: Final[int]
GShape_GFRAME: Final[int]
GShape_GMAT: Final[int]
GShape_GOPAQUE: Final[int]
GShape_GSCALAR: Final[int]
HISTCMP_BHATTACHARYYA: Final[int]
HISTCMP_CHISQR: Final[int]
HISTCMP_CHISQR_ALT: Final[int]
HISTCMP_CORREL: Final[int]
HISTCMP_HELLINGER: Final[int]
HISTCMP_INTERSECT: Final[int]
HISTCMP_KL_DIV: Final[int]
HOGDESCRIPTOR_DEFAULT_NLEVELS: Final[int]
HOGDESCRIPTOR_DESCR_FORMAT_COL_BY_COL: Final[int]
HOGDESCRIPTOR_DESCR_FORMAT_ROW_BY_ROW: Final[int]
HOGDESCRIPTOR_L2HYS: Final[int]
HOGDescriptor_DEFAULT_NLEVELS: Final[int]
HOGDescriptor_DESCR_FORMAT_COL_BY_COL: Final[int]
HOGDescriptor_DESCR_FORMAT_ROW_BY_ROW: Final[int]
HOGDescriptor_L2Hys: Final[int]
HOUGH_GRADIENT: Final[int]
HOUGH_GRADIENT_ALT: Final[int]
HOUGH_MULTI_SCALE: Final[int]
HOUGH_PROBABILISTIC: Final[int]
HOUGH_STANDARD: Final[int]
IMWRITE_EXR_COMPRESSION: Final[int]
IMWRITE_EXR_COMPRESSION_B44: Final[int]
IMWRITE_EXR_COMPRESSION_B44A: Final[int]
IMWRITE_EXR_COMPRESSION_DWAA: Final[int]
IMWRITE_EXR_COMPRESSION_DWAB: Final[int]
IMWRITE_EXR_COMPRESSION_NO: Final[int]
IMWRITE_EXR_COMPRESSION_PIZ: Final[int]
IMWRITE_EXR_COMPRESSION_PXR24: Final[int]
IMWRITE_EXR_COMPRESSION_RLE: Final[int]
IMWRITE_EXR_COMPRESSION_ZIP: Final[int]
IMWRITE_EXR_COMPRESSION_ZIPS: Final[int]
IMWRITE_EXR_DWA_COMPRESSION_LEVEL: Final[int]
IMWRITE_EXR_TYPE_FLOAT: Final[int]
IMWRITE_EXR_TYPE_HALF: Final[int]
IMWRITE_HDR_COMPRESSION_NONE: Final[int]
IMWRITE_HDR_COMPRESSION_RLE: Final[int]
IMWRITE_JPEG2000_COMPRESSION_X1000: int
IMWRITE_JPEG_SAMPLING_FACTOR_411: Final[int]
IMWRITE_JPEG_SAMPLING_FACTOR_420: int
IMWRITE_JPEG_SAMPLING_FACTOR_422: Final[int]
IMWRITE_JPEG_SAMPLING_FACTOR_440: int
IMWRITE_JPEG_SAMPLING_FACTOR_444: Final[int]
IMWRITE_PNG_STRATEGY_DEFAULT: Final[int]
IMWRITE_PNG_STRATEGY_FILTERED: Final[int]
IMWRITE_PNG_STRATEGY_FIXED: Final[int]
IMWRITE_PNG_STRATEGY_HUFFMAN_ONLY: Final[int]
IMWRITE_PNG_STRATEGY_RLE: Final[int]
INPAINT_NS: Final[int]
INPAINT_TELEA: Final[int]
INTERSECT_FULL: Final[int]
INTERSECT_NONE: Final[int]
INTERSECT_PARTIAL: Final[int]
KAZE_DIFF_CHARBONNIER: Final[int]
KAZE_DIFF_PM_G1: Final[int]
KAZE_DIFF_PM_G2: Final[int]
KAZE_DIFF_WEICKERT: Final[int]
KMEANS_PP_CENTERS: Final[int]
KMEANS_RANDOM_CENTERS: Final[int]
KMEANS_USE_INITIAL_LABELS: Final[int]
LDR_SIZE: Final[int]
LMEDS: Final[int]
LOCAL_OPTIM_GC: Final[int]
LOCAL_OPTIM_INNER_AND_ITER_LO: Final[int]
LOCAL_OPTIM_INNER_LO: Final[int]
LOCAL_OPTIM_NULL: Final[int]
LOCAL_OPTIM_SIGMA: Final[int]
LSD_REFINE_ADV: Final[int]
LSD_REFINE_NONE: Final[int]
LSD_REFINE_STD: Final[int]
MARKER_CROSS: Final[int]
MARKER_DIAMOND: Final[int]
MARKER_SQUARE: Final[int]
MARKER_STAR: Final[int]
MARKER_TILTED_CROSS: Final[int]
MARKER_TRIANGLE_DOWN: Final[int]
MARKER_TRIANGLE_UP: Final[int]
MAT_AUTO_STEP: Final[int]
MAT_CONTINUOUS_FLAG: Final[int]
MAT_DEPTH_MASK: Final[int]
MAT_MAGIC_MASK: Final[int]
MAT_MAGIC_VAL: Final[int]
MAT_SUBMATRIX_FLAG: Final[int]
MAT_TYPE_MASK: Final[int]
MEDIA_FORMAT_BGR: Final[int]
MEDIA_FORMAT_GRAY: Final[int]
MEDIA_FORMAT_NV12: Final[int]
MEDIA_FRAME_ACCESS_R: Final[int]
MEDIA_FRAME_ACCESS_W: Final[int]
MIXED_CLONE: Final[int]
MOTION_AFFINE: Final[int]
MOTION_EUCLIDEAN: Final[int]
MOTION_HOMOGRAPHY: Final[int]
MOTION_TRANSLATION: Final[int]
Mat_AUTO_STEP: Final[int]
Mat_CONTINUOUS_FLAG: Final[int]
Mat_DEPTH_MASK: Final[int]
Mat_MAGIC_MASK: Final[int]
Mat_MAGIC_VAL: Final[int]
Mat_SUBMATRIX_FLAG: Final[int]
Mat_TYPE_MASK: Final[int]
MediaFormat_BGR: Final[int]
MediaFormat_GRAY: Final[int]
MediaFormat_NV12: Final[int]
MediaFrame_Access_R: Final[int]
MediaFrame_Access_W: Final[int]
NEIGH_FLANN_KNN: Final[int]
NEIGH_FLANN_RADIUS: Final[int]
NEIGH_GRID: Final[int]
NORMCONV_FILTER: Final[int]
NORM_HAMMING: Final[int]
NORM_HAMMING2: Final[int]
NORM_INF: Final[int]
NORM_L1: Final[int]
NORM_L2: Final[int]
NORM_L2SQR: Final[int]
NORM_MINMAX: Final[int]
NORM_RELATIVE: Final[int]
NORM_TYPE_MASK: Final[int]
OPTFLOW_FARNEBACK_GAUSSIAN: Final[int]
OPTFLOW_LK_GET_MIN_EIGENVALS: Final[int]
OPTFLOW_USE_INITIAL_FLOW: Final[int]
ORB_FAST_SCORE: Final[int]
ORB_HARRIS_SCORE: Final[int]
PARAM_ALGORITHM: Final[int]
PARAM_BOOLEAN: Final[int]
PARAM_FLOAT: Final[int]
PARAM_INT: Final[int]
PARAM_MAT: Final[int]
PARAM_MAT_VECTOR: Final[int]
PARAM_REAL: Final[int]
PARAM_SCALAR: Final[int]
PARAM_STRING: Final[int]
PARAM_UCHAR: Final[int]
PARAM_UINT64: Final[int]
PARAM_UNSIGNED_INT: Final[int]
PCA_DATA_AS_COL: Final[int]
PCA_DATA_AS_ROW: Final[int]
PCA_USE_AVG: Final[int]
PROJ_SPHERICAL_EQRECT: Final[int]
PROJ_SPHERICAL_ORTHO: Final[int]
Param_ALGORITHM: Final[int]
Param_BOOLEAN: Final[int]
Param_FLOAT: Final[int]
Param_INT: Final[int]
Param_MAT: Final[int]
Param_MAT_VECTOR: Final[int]
Param_REAL: Final[int]
Param_SCALAR: Final[int]
Param_STRING: Final[int]
Param_UCHAR: Final[int]
Param_UINT64: Final[int]
Param_UNSIGNED_INT: Final[int]
QRCODE_ENCODER_CORRECT_LEVEL_H: Final[int]
QRCODE_ENCODER_CORRECT_LEVEL_L: Final[int]
QRCODE_ENCODER_CORRECT_LEVEL_M: Final[int]
QRCODE_ENCODER_CORRECT_LEVEL_Q: Final[int]
QRCODE_ENCODER_ECI_UTF8: Final[int]
QRCODE_ENCODER_MODE_ALPHANUMERIC: Final[int]
QRCODE_ENCODER_MODE_AUTO: Final[int]
QRCODE_ENCODER_MODE_BYTE: Final[int]
QRCODE_ENCODER_MODE_ECI: Final[int]
QRCODE_ENCODER_MODE_KANJI: Final[int]
QRCODE_ENCODER_MODE_NUMERIC: Final[int]
QRCODE_ENCODER_MODE_STRUCTURED_APPEND: Final[int]
QRCodeEncoder_CORRECT_LEVEL_H: Final[int]
QRCodeEncoder_CORRECT_LEVEL_L: Final[int]
QRCodeEncoder_CORRECT_LEVEL_M: Final[int]
QRCodeEncoder_CORRECT_LEVEL_Q: Final[int]
QRCodeEncoder_ECI_UTF8: Final[int]
QRCodeEncoder_MODE_ALPHANUMERIC: Final[int]
QRCodeEncoder_MODE_AUTO: Final[int]
QRCodeEncoder_MODE_BYTE: Final[int]
QRCodeEncoder_MODE_ECI: Final[int]
QRCodeEncoder_MODE_KANJI: Final[int]
QRCodeEncoder_MODE_NUMERIC: Final[int]
QRCodeEncoder_MODE_STRUCTURED_APPEND: Final[int]
QT_CHECKBOX: Final[int]
QT_FONT_BLACK: Final[int]
QT_FONT_BOLD: Final[int]
QT_FONT_DEMIBOLD: Final[int]
QT_FONT_LIGHT: Final[int]
QT_FONT_NORMAL: Final[int]
QT_NEW_BUTTONBAR: Final[int]
QT_PUSH_BUTTON: Final[int]
QT_RADIOBOX: Final[int]
QT_STYLE_ITALIC: Final[int]
QT_STYLE_NORMAL: Final[int]
QT_STYLE_OBLIQUE: Final[int]
QUAT_ASSUME_NOT_UNIT: Final[int]
QUAT_ASSUME_UNIT: Final[int]
QUAT_ENUM_EULER_ANGLES_MAX_VALUE: Final[int]
QUAT_ENUM_EXT_XYX: Final[int]
QUAT_ENUM_EXT_XYZ: Final[int]
QUAT_ENUM_EXT_XZX: Final[int]
QUAT_ENUM_EXT_XZY: Final[int]
QUAT_ENUM_EXT_YXY: Final[int]
QUAT_ENUM_EXT_YXZ: Final[int]
QUAT_ENUM_EXT_YZX: Final[int]
QUAT_ENUM_EXT_YZY: Final[int]
QUAT_ENUM_EXT_ZXY: Final[int]
QUAT_ENUM_EXT_ZXZ: Final[int]
QUAT_ENUM_EXT_ZYX: Final[int]
QUAT_ENUM_EXT_ZYZ: Final[int]
QUAT_ENUM_INT_XYX: Final[int]
QUAT_ENUM_INT_XYZ: Final[int]
QUAT_ENUM_INT_XZX: Final[int]
QUAT_ENUM_INT_XZY: Final[int]
QUAT_ENUM_INT_YXY: Final[int]
QUAT_ENUM_INT_YXZ: Final[int]
QUAT_ENUM_INT_YZX: Final[int]
QUAT_ENUM_INT_YZY: Final[int]
QUAT_ENUM_INT_ZXY: Final[int]
QUAT_ENUM_INT_ZXZ: Final[int]
QUAT_ENUM_INT_ZYX: Final[int]
QUAT_ENUM_INT_ZYZ: Final[int]
QuatEnum_EULER_ANGLES_MAX_VALUE: Final[int]
QuatEnum_EXT_XYX: Final[int]
QuatEnum_EXT_XYZ: Final[int]
QuatEnum_EXT_XZX: Final[int]
QuatEnum_EXT_XZY: Final[int]
QuatEnum_EXT_YXY: Final[int]
QuatEnum_EXT_YXZ: Final[int]
QuatEnum_EXT_YZX: Final[int]
QuatEnum_EXT_YZY: Final[int]
QuatEnum_EXT_ZXY: Final[int]
QuatEnum_EXT_ZXZ: Final[int]
QuatEnum_EXT_ZYX: Final[int]
QuatEnum_EXT_ZYZ: Final[int]
QuatEnum_INT_XYX: Final[int]
QuatEnum_INT_XYZ: Final[int]
QuatEnum_INT_XZX: Final[int]
QuatEnum_INT_XZY: Final[int]
QuatEnum_INT_YXY: Final[int]
QuatEnum_INT_YXZ: Final[int]
QuatEnum_INT_YZX: Final[int]
QuatEnum_INT_YZY: Final[int]
QuatEnum_INT_ZXY: Final[int]
QuatEnum_INT_ZXZ: Final[int]
QuatEnum_INT_ZYX: Final[int]
QuatEnum_INT_ZYZ: Final[int]
RANSAC: Final[int]
RECURS_FILTER: Final[int]
REDUCE_AVG: Final[int]
REDUCE_MAX: Final[int]
REDUCE_MIN: Final[int]
REDUCE_SUM: Final[int]
RHO: Final[int]
RMAT_ACCESS_R: Final[int]
RMAT_ACCESS_W: Final[int]
RMat_Access_R: Final[int]
RMat_Access_W: Final[int]
RNG_NORMAL: Final[int]
RNG_UNIFORM: Final[int]
ROTATE_180: int
ROTATE_90_CLOCKWISE: int
ROTATE_90_COUNTERCLOCKWISE: int
SAMPLING_NAPSAC: Final[int]
SAMPLING_PROGRESSIVE_NAPSAC: Final[int]
SAMPLING_PROSAC: Final[int]
SAMPLING_UNIFORM: Final[int]
SCORE_METHOD_LMEDS: Final[int]
SCORE_METHOD_MAGSAC: Final[int]
SCORE_METHOD_MSAC: Final[int]
SCORE_METHOD_RANSAC: Final[int]
SOLVELP_MULTI: Final[int]
SOLVELP_SINGLE: Final[int]
SOLVELP_UNBOUNDED: Final[int]
SOLVELP_UNFEASIBLE: Final[int]
SOLVEPNP_AP3P: Final[int]
SOLVEPNP_DLS: Final[int]
SOLVEPNP_EPNP: Final[int]
SOLVEPNP_IPPE: Final[int]
SOLVEPNP_IPPE_SQUARE: Final[int]
SOLVEPNP_ITERATIVE: Final[int]
SOLVEPNP_MAX_COUNT: Final[int]
SOLVEPNP_P3P: Final[int]
SOLVEPNP_SQPNP: Final[int]
SOLVEPNP_UPNP: Final[int]
SORT_ASCENDING: Final[int]
SORT_DESCENDING: Final[int]
SORT_EVERY_COLUMN: Final[int]
SORT_EVERY_ROW: Final[int]
SPARSE_MAT_HASH_BIT: Final[int]
SPARSE_MAT_HASH_SCALE: Final[int]
SPARSE_MAT_MAGIC_VAL: Final[int]
SPARSE_MAT_MAX_DIM: Final[int]
STEREO_BM_PREFILTER_NORMALIZED_RESPONSE: Final[int]
STEREO_BM_PREFILTER_XSOBEL: Final[int]
STEREO_MATCHER_DISP_SCALE: Final[int]
STEREO_MATCHER_DISP_SHIFT: Final[int]
STEREO_SGBM_MODE_HH: Final[int]
STEREO_SGBM_MODE_HH4: Final[int]
STEREO_SGBM_MODE_SGBM: Final[int]
STEREO_SGBM_MODE_SGBM_3WAY: Final[int]
STITCHER_ERR_CAMERA_PARAMS_ADJUST_FAIL: Final[int]
STITCHER_ERR_HOMOGRAPHY_EST_FAIL: Final[int]
STITCHER_ERR_NEED_MORE_IMGS: Final[int]
STITCHER_OK: Final[int]
STITCHER_PANORAMA: Final[int]
STITCHER_SCANS: Final[int]
SUBDIV2D_NEXT_AROUND_DST: Final[int]
SUBDIV2D_NEXT_AROUND_LEFT: Final[int]
SUBDIV2D_NEXT_AROUND_ORG: Final[int]
SUBDIV2D_NEXT_AROUND_RIGHT: Final[int]
SUBDIV2D_PREV_AROUND_DST: Final[int]
SUBDIV2D_PREV_AROUND_LEFT: Final[int]
SUBDIV2D_PREV_AROUND_ORG: Final[int]
SUBDIV2D_PREV_AROUND_RIGHT: Final[int]
SUBDIV2D_PTLOC_ERROR: Final[int]
SUBDIV2D_PTLOC_INSIDE: Final[int]
SUBDIV2D_PTLOC_ON_EDGE: Final[int]
SUBDIV2D_PTLOC_OUTSIDE_RECT: Final[int]
SUBDIV2D_PTLOC_VERTEX: Final[int]
SVD_FULL_UV: Final[int]
SVD_MODIFY_A: Final[int]
SVD_NO_UV: Final[int]
SparseMat_HASH_BIT: Final[int]
SparseMat_HASH_SCALE: Final[int]
SparseMat_MAGIC_VAL: Final[int]
SparseMat_MAX_DIM: Final[int]
StereoBM_PREFILTER_NORMALIZED_RESPONSE: Final[int]
StereoBM_PREFILTER_XSOBEL: Final[int]
StereoMatcher_DISP_SCALE: Final[int]
StereoMatcher_DISP_SHIFT: Final[int]
StereoSGBM_MODE_HH: Final[int]
StereoSGBM_MODE_HH4: Final[int]
StereoSGBM_MODE_SGBM: Final[int]
StereoSGBM_MODE_SGBM_3WAY: Final[int]
Stitcher_ERR_CAMERA_PARAMS_ADJUST_FAIL: Final[int]
Stitcher_ERR_HOMOGRAPHY_EST_FAIL: Final[int]
Stitcher_ERR_NEED_MORE_IMGS: Final[int]
Stitcher_OK: Final[int]
Stitcher_PANORAMA: Final[int]
Stitcher_SCANS: Final[int]
Subdiv2D_NEXT_AROUND_DST: Final[int]
Subdiv2D_NEXT_AROUND_LEFT: Final[int]
Subdiv2D_NEXT_AROUND_ORG: Final[int]
Subdiv2D_NEXT_AROUND_RIGHT: Final[int]
Subdiv2D_PREV_AROUND_DST: Final[int]
Subdiv2D_PREV_AROUND_LEFT: Final[int]
Subdiv2D_PREV_AROUND_ORG: Final[int]
Subdiv2D_PREV_AROUND_RIGHT: Final[int]
Subdiv2D_PTLOC_ERROR: Final[int]
Subdiv2D_PTLOC_INSIDE: Final[int]
Subdiv2D_PTLOC_ON_EDGE: Final[int]
Subdiv2D_PTLOC_OUTSIDE_RECT: Final[int]
Subdiv2D_PTLOC_VERTEX: Final[int]
TERM_CRITERIA_COUNT: Final[int]
TERM_CRITERIA_EPS: Final[int]
TERM_CRITERIA_MAX_ITER: Final[int]
TM_CCOEFF: Final[int]
TM_CCOEFF_NORMED: Final[int]
TM_CCORR: Final[int]
TM_CCORR_NORMED: Final[int]
TM_SQDIFF: Final[int]
TM_SQDIFF_NORMED: Final[int]
TRACKER_KCF_CN: Final[int]
TRACKER_KCF_CUSTOM: Final[int]
TRACKER_KCF_GRAY: Final[int]
TermCriteria_COUNT: Final[int]
TermCriteria_EPS: Final[int]
TermCriteria_MAX_ITER: Final[int]
TrackerKCF_CN: Final[int]
TrackerKCF_CUSTOM: Final[int]
TrackerKCF_GRAY: Final[int]
UMAT_AUTO_STEP: Final[int]
UMAT_CONTINUOUS_FLAG: Final[int]
UMAT_DATA_ASYNC_CLEANUP: Final[int]
UMAT_DATA_COPY_ON_MAP: Final[int]
UMAT_DATA_DEVICE_COPY_OBSOLETE: Final[int]
UMAT_DATA_DEVICE_MEM_MAPPED: Final[int]
UMAT_DATA_HOST_COPY_OBSOLETE: Final[int]
UMAT_DATA_TEMP_COPIED_UMAT: Final[int]
UMAT_DATA_TEMP_UMAT: Final[int]
UMAT_DATA_USER_ALLOCATED: Final[int]
UMAT_DEPTH_MASK: Final[int]
UMAT_MAGIC_MASK: Final[int]
UMAT_MAGIC_VAL: Final[int]
UMAT_SUBMATRIX_FLAG: Final[int]
UMAT_TYPE_MASK: Final[int]
UMatData_ASYNC_CLEANUP: Final[int]
UMatData_COPY_ON_MAP: Final[int]
UMatData_DEVICE_COPY_OBSOLETE: Final[int]
UMatData_DEVICE_MEM_MAPPED: Final[int]
UMatData_HOST_COPY_OBSOLETE: Final[int]
UMatData_TEMP_COPIED_UMAT: Final[int]
UMatData_TEMP_UMAT: Final[int]
UMatData_USER_ALLOCATED: Final[int]
UMat_AUTO_STEP: Final[int]
UMat_CONTINUOUS_FLAG: Final[int]
UMat_DEPTH_MASK: Final[int]
UMat_MAGIC_MASK: Final[int]
UMat_MAGIC_VAL: Final[int]
UMat_SUBMATRIX_FLAG: Final[int]
UMat_TYPE_MASK: Final[int]
USAC_ACCURATE: Final[int]
USAC_DEFAULT: Final[int]
USAC_FAST: Final[int]
USAC_FM_8PTS: Final[int]
USAC_MAGSAC: Final[int]
USAC_PARALLEL: Final[int]
USAC_PROSAC: Final[int]
USAGE_ALLOCATE_DEVICE_MEMORY: Final[int]
USAGE_ALLOCATE_HOST_MEMORY: Final[int]
USAGE_ALLOCATE_SHARED_MEMORY: Final[int]
USAGE_DEFAULT: Final[int]
VIDEOWRITER_PROP_DEPTH: Final[int]
VIDEOWRITER_PROP_FRAMEBYTES: Final[int]
VIDEOWRITER_PROP_HW_ACCELERATION: Final[int]
VIDEOWRITER_PROP_HW_ACCELERATION_USE_OPENCL: Final[int]
VIDEOWRITER_PROP_HW_DEVICE: Final[int]
VIDEOWRITER_PROP_IS_COLOR: Final[int]
VIDEOWRITER_PROP_NSTRIPES: Final[int]
VIDEOWRITER_PROP_QUALITY: Final[int]
VIDEO_ACCELERATION_ANY: Final[int]
VIDEO_ACCELERATION_D3D11: Final[int]
VIDEO_ACCELERATION_MFX: Final[int]
VIDEO_ACCELERATION_NONE: Final[int]
VIDEO_ACCELERATION_VAAPI: Final[int]
