# Contributing to Google SecOps Wrapper SDK

Thank you for your interest in contributing to the Google SecOps Wrapper SDK! 
This document provides an overview of the contribution process.

## Contribution Steps

1. **Create an Issue**
   - Describe the bug or feature you want to address
   - Get feedback on your approach and proposed change

2. **Fork and Branch**
   - Fork the repository and create a branch for your changes

3. **Code and Test**
   - Follow the [AUTHORING_GUIDE](AUTHORING_GUIDE.md) for coding guidelines and best practices.
   - Add tests for new code (see [TESTING](TESTING.md))
   - Keep changes focused and related to the issue

4. **Submit Pull Request**
   - Sign the [Google CLA](https://cla.developers.google.com/clas) if you haven't already
   - Reference related issues in your PR description

## Contributor License Agreements

Before we can take contributions, we have to jump a couple of legal hurdles.

Please fill out either the individual or corporate Contributor License
Agreement (CLA).

  * If you are an individual writing original source code and you're sure you
    own the intellectual property, then you'll need to sign an [individual CLA](https://developers.google.com/open-source/cla/individual).
  * If you work for a company that wants to allow you to contribute your work,
    then you'll need to sign a [corporate CLA](https://developers.google.com/open-source/cla/corporate).

Follow either of the two links above to access the appropriate CLA and
instructions for how to sign and return it. This is a one-time process, after
which you will be free to submit pull requests.
