# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError as core_api_error_ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.internal_server_error import InternalServerError
from ..errors.not_found_error import NotFoundError
from ..types.add_triple_response import AddTripleResponse
from ..types.api_error import ApiError as types_api_error_ApiError
from ..types.clone_graph_response import CloneGraphResponse
from ..types.edge_type import EdgeType
from ..types.entity_type import EntityType
from ..types.entity_type_response import EntityTypeResponse
from ..types.episode import Episode
from ..types.episode_data import EpisodeData
from ..types.fact_rating_instruction import FactRatingInstruction
from ..types.graph import Graph
from ..types.graph_data_type import GraphDataType
from ..types.graph_list_response import GraphListResponse
from ..types.graph_search_results import GraphSearchResults
from ..types.graph_search_scope import GraphSearchScope
from ..types.reranker import Reranker
from ..types.search_filters import SearchFilters
from ..types.success_response import SuccessResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawGraphClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_entity_types(
        self,
        *,
        user_id: typing.Optional[str] = None,
        graph_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[EntityTypeResponse]:
        """
        Returns all entity types for a project, user, or graph.

        Parameters
        ----------
        user_id : typing.Optional[str]
            User ID to get user-specific entity types

        graph_id : typing.Optional[str]
            Graph ID to get graph-specific entity types

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[EntityTypeResponse]
            The list of entity types.
        """
        _response = self._client_wrapper.httpx_client.request(
            "entity-types",
            method="GET",
            params={
                "user_id": user_id,
                "graph_id": graph_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityTypeResponse,
                    parse_obj_as(
                        type_=EntityTypeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    def set_entity_types_internal(
        self,
        *,
        edge_types: typing.Optional[typing.Sequence[EdgeType]] = OMIT,
        entity_types: typing.Optional[typing.Sequence[EntityType]] = OMIT,
        graph_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        user_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SuccessResponse]:
        """
        Sets the entity types for multiple users and graphs, replacing any existing ones.

        Parameters
        ----------
        edge_types : typing.Optional[typing.Sequence[EdgeType]]

        entity_types : typing.Optional[typing.Sequence[EntityType]]

        graph_ids : typing.Optional[typing.Sequence[str]]

        user_ids : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SuccessResponse]
            Entity types set successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            "entity-types",
            method="PUT",
            json={
                "edge_types": convert_and_respect_annotation_metadata(
                    object_=edge_types, annotation=typing.Sequence[EdgeType], direction="write"
                ),
                "entity_types": convert_and_respect_annotation_metadata(
                    object_=entity_types, annotation=typing.Sequence[EntityType], direction="write"
                ),
                "graph_ids": graph_ids,
                "user_ids": user_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SuccessResponse,
                    parse_obj_as(
                        type_=SuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    def add(
        self,
        *,
        data: str,
        type: GraphDataType,
        created_at: typing.Optional[str] = OMIT,
        graph_id: typing.Optional[str] = OMIT,
        source_description: typing.Optional[str] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Episode]:
        """
        Add data to the graph.

        Parameters
        ----------
        data : str

        type : GraphDataType

        created_at : typing.Optional[str]

        graph_id : typing.Optional[str]
            graph_id is the ID of the graph to which the data will be added. If adding to the user graph, please use user_id field instead.

        source_description : typing.Optional[str]

        user_id : typing.Optional[str]
            User ID is the ID of the user to which the data will be added. If not adding to a user graph, please use graph_id field instead.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Episode]
            Added episode
        """
        _response = self._client_wrapper.httpx_client.request(
            "graph",
            method="POST",
            json={
                "created_at": created_at,
                "data": data,
                "graph_id": graph_id,
                "source_description": source_description,
                "type": type,
                "user_id": user_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Episode,
                    parse_obj_as(
                        type_=Episode,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    def add_batch(
        self,
        *,
        episodes: typing.Sequence[EpisodeData],
        graph_id: typing.Optional[str] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[Episode]]:
        """
        Add data to the graph in batch mode, processing episodes concurrently. Use only for data that is insensitive to processing order.

        Parameters
        ----------
        episodes : typing.Sequence[EpisodeData]

        graph_id : typing.Optional[str]
            graph_id is the ID of the graph to which the data will be added. If adding to the user graph, please use user_id field instead.

        user_id : typing.Optional[str]
            User ID is the ID of the user to which the data will be added. If not adding to a user graph, please use graph_id field instead.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[Episode]]
            Added episodes
        """
        _response = self._client_wrapper.httpx_client.request(
            "graph-batch",
            method="POST",
            json={
                "episodes": convert_and_respect_annotation_metadata(
                    object_=episodes, annotation=typing.Sequence[EpisodeData], direction="write"
                ),
                "graph_id": graph_id,
                "user_id": user_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Episode],
                    parse_obj_as(
                        type_=typing.List[Episode],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    def add_fact_triple(
        self,
        *,
        fact: str,
        fact_name: str,
        target_node_name: str,
        created_at: typing.Optional[str] = OMIT,
        expired_at: typing.Optional[str] = OMIT,
        fact_uuid: typing.Optional[str] = OMIT,
        graph_id: typing.Optional[str] = OMIT,
        invalid_at: typing.Optional[str] = OMIT,
        source_node_name: typing.Optional[str] = OMIT,
        source_node_summary: typing.Optional[str] = OMIT,
        source_node_uuid: typing.Optional[str] = OMIT,
        target_node_summary: typing.Optional[str] = OMIT,
        target_node_uuid: typing.Optional[str] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        valid_at: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[AddTripleResponse]:
        """
        Add a fact triple for a user or group

        Parameters
        ----------
        fact : str
            The fact relating the two nodes that this edge represents

        fact_name : str
            The name of the edge to add. Should be all caps using snake case (eg RELATES_TO)

        target_node_name : str
            The name of the target node to add

        created_at : typing.Optional[str]
            The timestamp of the message

        expired_at : typing.Optional[str]
            The time (if any) at which the edge expires

        fact_uuid : typing.Optional[str]
            The uuid of the edge to add

        graph_id : typing.Optional[str]

        invalid_at : typing.Optional[str]
            The time (if any) at which the fact stops being true

        source_node_name : typing.Optional[str]
            The name of the source node to add

        source_node_summary : typing.Optional[str]
            The summary of the source node to add

        source_node_uuid : typing.Optional[str]
            The source node uuid

        target_node_summary : typing.Optional[str]
            The summary of the target node to add

        target_node_uuid : typing.Optional[str]
            The target node uuid

        user_id : typing.Optional[str]

        valid_at : typing.Optional[str]
            The time at which the fact becomes true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AddTripleResponse]
            Resulting triple
        """
        _response = self._client_wrapper.httpx_client.request(
            "graph/add-fact-triple",
            method="POST",
            json={
                "created_at": created_at,
                "expired_at": expired_at,
                "fact": fact,
                "fact_name": fact_name,
                "fact_uuid": fact_uuid,
                "graph_id": graph_id,
                "invalid_at": invalid_at,
                "source_node_name": source_node_name,
                "source_node_summary": source_node_summary,
                "source_node_uuid": source_node_uuid,
                "target_node_name": target_node_name,
                "target_node_summary": target_node_summary,
                "target_node_uuid": target_node_uuid,
                "user_id": user_id,
                "valid_at": valid_at,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AddTripleResponse,
                    parse_obj_as(
                        type_=AddTripleResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    def clone(
        self,
        *,
        source_graph_id: typing.Optional[str] = OMIT,
        source_user_id: typing.Optional[str] = OMIT,
        target_graph_id: typing.Optional[str] = OMIT,
        target_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CloneGraphResponse]:
        """
        Clone a user or group graph.

        Parameters
        ----------
        source_graph_id : typing.Optional[str]
            source_graph_id is the ID of the graph to be cloned. Required if source_user_id is not provided

        source_user_id : typing.Optional[str]
            user_id of the user whose graph is being cloned. Required if source_graph_id is not provided

        target_graph_id : typing.Optional[str]
            target_graph_id is the ID to be set on the cloned graph. Must not point to an existing graph. Required if target_user_id is not provided.

        target_user_id : typing.Optional[str]
            user_id to be set on the cloned user. Must not point to an existing user. Required if target_graph_id is not provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CloneGraphResponse]
            Response object containing graph_id or user_id pointing to the new graph
        """
        _response = self._client_wrapper.httpx_client.request(
            "graph/clone",
            method="POST",
            json={
                "source_graph_id": source_graph_id,
                "source_user_id": source_user_id,
                "target_graph_id": target_graph_id,
                "target_user_id": target_user_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CloneGraphResponse,
                    parse_obj_as(
                        type_=CloneGraphResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    def create(
        self,
        *,
        graph_id: str,
        description: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Graph]:
        """
        Creates a new graph.

        Parameters
        ----------
        graph_id : str

        description : typing.Optional[str]

        fact_rating_instruction : typing.Optional[FactRatingInstruction]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Graph]
            The added graph
        """
        _response = self._client_wrapper.httpx_client.request(
            "graph/create",
            method="POST",
            json={
                "description": description,
                "fact_rating_instruction": convert_and_respect_annotation_metadata(
                    object_=fact_rating_instruction, annotation=FactRatingInstruction, direction="write"
                ),
                "graph_id": graph_id,
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Graph,
                    parse_obj_as(
                        type_=Graph,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    def list_all(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GraphListResponse]:
        """
        Returns all graphs. In order to list users, use user.list_ordered instead

        Parameters
        ----------
        page_number : typing.Optional[int]
            Page number for pagination, starting from 1.

        page_size : typing.Optional[int]
            Number of graphs to retrieve per page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GraphListResponse]
            Successfully retrieved list of graphs.
        """
        _response = self._client_wrapper.httpx_client.request(
            "graph/list-all",
            method="GET",
            params={
                "pageNumber": page_number,
                "pageSize": page_size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GraphListResponse,
                    parse_obj_as(
                        type_=GraphListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    def search(
        self,
        *,
        query: str,
        bfs_origin_node_uuids: typing.Optional[typing.Sequence[str]] = OMIT,
        center_node_uuid: typing.Optional[str] = OMIT,
        graph_id: typing.Optional[str] = OMIT,
        limit: typing.Optional[int] = OMIT,
        min_fact_rating: typing.Optional[float] = OMIT,
        min_score: typing.Optional[float] = OMIT,
        mmr_lambda: typing.Optional[float] = OMIT,
        reranker: typing.Optional[Reranker] = OMIT,
        scope: typing.Optional[GraphSearchScope] = OMIT,
        search_filters: typing.Optional[SearchFilters] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GraphSearchResults]:
        """
        Perform a graph search query.

        Parameters
        ----------
        query : str
            The string to search for (required)

        bfs_origin_node_uuids : typing.Optional[typing.Sequence[str]]
            Nodes that are the origins of the BFS searches

        center_node_uuid : typing.Optional[str]
            Node to rerank around for node distance reranking

        graph_id : typing.Optional[str]
            The graph_id to search in. When searching user graph, please use user_id instead.

        limit : typing.Optional[int]
            The maximum number of facts to retrieve. Defaults to 10. Limited to 50.

        min_fact_rating : typing.Optional[float]
            The minimum rating by which to filter relevant facts

        min_score : typing.Optional[float]
            Deprecated

        mmr_lambda : typing.Optional[float]
            weighting for maximal marginal relevance

        reranker : typing.Optional[Reranker]
            Defaults to RRF

        scope : typing.Optional[GraphSearchScope]
            Defaults to Edges. Communities will be added in the future.

        search_filters : typing.Optional[SearchFilters]
            Search filters to apply to the search

        user_id : typing.Optional[str]
            The user_id when searching user graph. If not searching user graph, please use graph_id instead.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GraphSearchResults]
            Graph search results
        """
        _response = self._client_wrapper.httpx_client.request(
            "graph/search",
            method="POST",
            json={
                "bfs_origin_node_uuids": bfs_origin_node_uuids,
                "center_node_uuid": center_node_uuid,
                "graph_id": graph_id,
                "limit": limit,
                "min_fact_rating": min_fact_rating,
                "min_score": min_score,
                "mmr_lambda": mmr_lambda,
                "query": query,
                "reranker": reranker,
                "scope": scope,
                "search_filters": convert_and_respect_annotation_metadata(
                    object_=search_filters, annotation=SearchFilters, direction="write"
                ),
                "user_id": user_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GraphSearchResults,
                    parse_obj_as(
                        type_=GraphSearchResults,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    def get(self, graph_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[Graph]:
        """
        Returns a graph.

        Parameters
        ----------
        graph_id : str
            The graph_id of the graph to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Graph]
            The graph that was retrieved.
        """
        _response = self._client_wrapper.httpx_client.request(
            f"graph/{jsonable_encoder(graph_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Graph,
                    parse_obj_as(
                        type_=Graph,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    def delete(
        self, graph_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[SuccessResponse]:
        """
        Deletes a graph. If you would like to delete a user graph, make sure to use user.delete instead.

        Parameters
        ----------
        graph_id : str
            Graph ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SuccessResponse]
            Deleted
        """
        _response = self._client_wrapper.httpx_client.request(
            f"graph/{jsonable_encoder(graph_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SuccessResponse,
                    parse_obj_as(
                        type_=SuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    def update(
        self,
        graph_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Graph]:
        """
        Updates information about a graph.

        Parameters
        ----------
        graph_id : str
            Graph ID

        description : typing.Optional[str]

        fact_rating_instruction : typing.Optional[FactRatingInstruction]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Graph]
            The updated graph object
        """
        _response = self._client_wrapper.httpx_client.request(
            f"graph/{jsonable_encoder(graph_id)}",
            method="PATCH",
            json={
                "description": description,
                "fact_rating_instruction": convert_and_respect_annotation_metadata(
                    object_=fact_rating_instruction, annotation=FactRatingInstruction, direction="write"
                ),
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Graph,
                    parse_obj_as(
                        type_=Graph,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )


class AsyncRawGraphClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_entity_types(
        self,
        *,
        user_id: typing.Optional[str] = None,
        graph_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[EntityTypeResponse]:
        """
        Returns all entity types for a project, user, or graph.

        Parameters
        ----------
        user_id : typing.Optional[str]
            User ID to get user-specific entity types

        graph_id : typing.Optional[str]
            Graph ID to get graph-specific entity types

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[EntityTypeResponse]
            The list of entity types.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "entity-types",
            method="GET",
            params={
                "user_id": user_id,
                "graph_id": graph_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    EntityTypeResponse,
                    parse_obj_as(
                        type_=EntityTypeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    async def set_entity_types_internal(
        self,
        *,
        edge_types: typing.Optional[typing.Sequence[EdgeType]] = OMIT,
        entity_types: typing.Optional[typing.Sequence[EntityType]] = OMIT,
        graph_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        user_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SuccessResponse]:
        """
        Sets the entity types for multiple users and graphs, replacing any existing ones.

        Parameters
        ----------
        edge_types : typing.Optional[typing.Sequence[EdgeType]]

        entity_types : typing.Optional[typing.Sequence[EntityType]]

        graph_ids : typing.Optional[typing.Sequence[str]]

        user_ids : typing.Optional[typing.Sequence[str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SuccessResponse]
            Entity types set successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            "entity-types",
            method="PUT",
            json={
                "edge_types": convert_and_respect_annotation_metadata(
                    object_=edge_types, annotation=typing.Sequence[EdgeType], direction="write"
                ),
                "entity_types": convert_and_respect_annotation_metadata(
                    object_=entity_types, annotation=typing.Sequence[EntityType], direction="write"
                ),
                "graph_ids": graph_ids,
                "user_ids": user_ids,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SuccessResponse,
                    parse_obj_as(
                        type_=SuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    async def add(
        self,
        *,
        data: str,
        type: GraphDataType,
        created_at: typing.Optional[str] = OMIT,
        graph_id: typing.Optional[str] = OMIT,
        source_description: typing.Optional[str] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Episode]:
        """
        Add data to the graph.

        Parameters
        ----------
        data : str

        type : GraphDataType

        created_at : typing.Optional[str]

        graph_id : typing.Optional[str]
            graph_id is the ID of the graph to which the data will be added. If adding to the user graph, please use user_id field instead.

        source_description : typing.Optional[str]

        user_id : typing.Optional[str]
            User ID is the ID of the user to which the data will be added. If not adding to a user graph, please use graph_id field instead.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Episode]
            Added episode
        """
        _response = await self._client_wrapper.httpx_client.request(
            "graph",
            method="POST",
            json={
                "created_at": created_at,
                "data": data,
                "graph_id": graph_id,
                "source_description": source_description,
                "type": type,
                "user_id": user_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Episode,
                    parse_obj_as(
                        type_=Episode,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    async def add_batch(
        self,
        *,
        episodes: typing.Sequence[EpisodeData],
        graph_id: typing.Optional[str] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[Episode]]:
        """
        Add data to the graph in batch mode, processing episodes concurrently. Use only for data that is insensitive to processing order.

        Parameters
        ----------
        episodes : typing.Sequence[EpisodeData]

        graph_id : typing.Optional[str]
            graph_id is the ID of the graph to which the data will be added. If adding to the user graph, please use user_id field instead.

        user_id : typing.Optional[str]
            User ID is the ID of the user to which the data will be added. If not adding to a user graph, please use graph_id field instead.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[Episode]]
            Added episodes
        """
        _response = await self._client_wrapper.httpx_client.request(
            "graph-batch",
            method="POST",
            json={
                "episodes": convert_and_respect_annotation_metadata(
                    object_=episodes, annotation=typing.Sequence[EpisodeData], direction="write"
                ),
                "graph_id": graph_id,
                "user_id": user_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[Episode],
                    parse_obj_as(
                        type_=typing.List[Episode],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    async def add_fact_triple(
        self,
        *,
        fact: str,
        fact_name: str,
        target_node_name: str,
        created_at: typing.Optional[str] = OMIT,
        expired_at: typing.Optional[str] = OMIT,
        fact_uuid: typing.Optional[str] = OMIT,
        graph_id: typing.Optional[str] = OMIT,
        invalid_at: typing.Optional[str] = OMIT,
        source_node_name: typing.Optional[str] = OMIT,
        source_node_summary: typing.Optional[str] = OMIT,
        source_node_uuid: typing.Optional[str] = OMIT,
        target_node_summary: typing.Optional[str] = OMIT,
        target_node_uuid: typing.Optional[str] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        valid_at: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[AddTripleResponse]:
        """
        Add a fact triple for a user or group

        Parameters
        ----------
        fact : str
            The fact relating the two nodes that this edge represents

        fact_name : str
            The name of the edge to add. Should be all caps using snake case (eg RELATES_TO)

        target_node_name : str
            The name of the target node to add

        created_at : typing.Optional[str]
            The timestamp of the message

        expired_at : typing.Optional[str]
            The time (if any) at which the edge expires

        fact_uuid : typing.Optional[str]
            The uuid of the edge to add

        graph_id : typing.Optional[str]

        invalid_at : typing.Optional[str]
            The time (if any) at which the fact stops being true

        source_node_name : typing.Optional[str]
            The name of the source node to add

        source_node_summary : typing.Optional[str]
            The summary of the source node to add

        source_node_uuid : typing.Optional[str]
            The source node uuid

        target_node_summary : typing.Optional[str]
            The summary of the target node to add

        target_node_uuid : typing.Optional[str]
            The target node uuid

        user_id : typing.Optional[str]

        valid_at : typing.Optional[str]
            The time at which the fact becomes true

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AddTripleResponse]
            Resulting triple
        """
        _response = await self._client_wrapper.httpx_client.request(
            "graph/add-fact-triple",
            method="POST",
            json={
                "created_at": created_at,
                "expired_at": expired_at,
                "fact": fact,
                "fact_name": fact_name,
                "fact_uuid": fact_uuid,
                "graph_id": graph_id,
                "invalid_at": invalid_at,
                "source_node_name": source_node_name,
                "source_node_summary": source_node_summary,
                "source_node_uuid": source_node_uuid,
                "target_node_name": target_node_name,
                "target_node_summary": target_node_summary,
                "target_node_uuid": target_node_uuid,
                "user_id": user_id,
                "valid_at": valid_at,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AddTripleResponse,
                    parse_obj_as(
                        type_=AddTripleResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    async def clone(
        self,
        *,
        source_graph_id: typing.Optional[str] = OMIT,
        source_user_id: typing.Optional[str] = OMIT,
        target_graph_id: typing.Optional[str] = OMIT,
        target_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CloneGraphResponse]:
        """
        Clone a user or group graph.

        Parameters
        ----------
        source_graph_id : typing.Optional[str]
            source_graph_id is the ID of the graph to be cloned. Required if source_user_id is not provided

        source_user_id : typing.Optional[str]
            user_id of the user whose graph is being cloned. Required if source_graph_id is not provided

        target_graph_id : typing.Optional[str]
            target_graph_id is the ID to be set on the cloned graph. Must not point to an existing graph. Required if target_user_id is not provided.

        target_user_id : typing.Optional[str]
            user_id to be set on the cloned user. Must not point to an existing user. Required if target_graph_id is not provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CloneGraphResponse]
            Response object containing graph_id or user_id pointing to the new graph
        """
        _response = await self._client_wrapper.httpx_client.request(
            "graph/clone",
            method="POST",
            json={
                "source_graph_id": source_graph_id,
                "source_user_id": source_user_id,
                "target_graph_id": target_graph_id,
                "target_user_id": target_user_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CloneGraphResponse,
                    parse_obj_as(
                        type_=CloneGraphResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    async def create(
        self,
        *,
        graph_id: str,
        description: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Graph]:
        """
        Creates a new graph.

        Parameters
        ----------
        graph_id : str

        description : typing.Optional[str]

        fact_rating_instruction : typing.Optional[FactRatingInstruction]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Graph]
            The added graph
        """
        _response = await self._client_wrapper.httpx_client.request(
            "graph/create",
            method="POST",
            json={
                "description": description,
                "fact_rating_instruction": convert_and_respect_annotation_metadata(
                    object_=fact_rating_instruction, annotation=FactRatingInstruction, direction="write"
                ),
                "graph_id": graph_id,
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Graph,
                    parse_obj_as(
                        type_=Graph,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    async def list_all(
        self,
        *,
        page_number: typing.Optional[int] = None,
        page_size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GraphListResponse]:
        """
        Returns all graphs. In order to list users, use user.list_ordered instead

        Parameters
        ----------
        page_number : typing.Optional[int]
            Page number for pagination, starting from 1.

        page_size : typing.Optional[int]
            Number of graphs to retrieve per page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GraphListResponse]
            Successfully retrieved list of graphs.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "graph/list-all",
            method="GET",
            params={
                "pageNumber": page_number,
                "pageSize": page_size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GraphListResponse,
                    parse_obj_as(
                        type_=GraphListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    async def search(
        self,
        *,
        query: str,
        bfs_origin_node_uuids: typing.Optional[typing.Sequence[str]] = OMIT,
        center_node_uuid: typing.Optional[str] = OMIT,
        graph_id: typing.Optional[str] = OMIT,
        limit: typing.Optional[int] = OMIT,
        min_fact_rating: typing.Optional[float] = OMIT,
        min_score: typing.Optional[float] = OMIT,
        mmr_lambda: typing.Optional[float] = OMIT,
        reranker: typing.Optional[Reranker] = OMIT,
        scope: typing.Optional[GraphSearchScope] = OMIT,
        search_filters: typing.Optional[SearchFilters] = OMIT,
        user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GraphSearchResults]:
        """
        Perform a graph search query.

        Parameters
        ----------
        query : str
            The string to search for (required)

        bfs_origin_node_uuids : typing.Optional[typing.Sequence[str]]
            Nodes that are the origins of the BFS searches

        center_node_uuid : typing.Optional[str]
            Node to rerank around for node distance reranking

        graph_id : typing.Optional[str]
            The graph_id to search in. When searching user graph, please use user_id instead.

        limit : typing.Optional[int]
            The maximum number of facts to retrieve. Defaults to 10. Limited to 50.

        min_fact_rating : typing.Optional[float]
            The minimum rating by which to filter relevant facts

        min_score : typing.Optional[float]
            Deprecated

        mmr_lambda : typing.Optional[float]
            weighting for maximal marginal relevance

        reranker : typing.Optional[Reranker]
            Defaults to RRF

        scope : typing.Optional[GraphSearchScope]
            Defaults to Edges. Communities will be added in the future.

        search_filters : typing.Optional[SearchFilters]
            Search filters to apply to the search

        user_id : typing.Optional[str]
            The user_id when searching user graph. If not searching user graph, please use graph_id instead.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GraphSearchResults]
            Graph search results
        """
        _response = await self._client_wrapper.httpx_client.request(
            "graph/search",
            method="POST",
            json={
                "bfs_origin_node_uuids": bfs_origin_node_uuids,
                "center_node_uuid": center_node_uuid,
                "graph_id": graph_id,
                "limit": limit,
                "min_fact_rating": min_fact_rating,
                "min_score": min_score,
                "mmr_lambda": mmr_lambda,
                "query": query,
                "reranker": reranker,
                "scope": scope,
                "search_filters": convert_and_respect_annotation_metadata(
                    object_=search_filters, annotation=SearchFilters, direction="write"
                ),
                "user_id": user_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GraphSearchResults,
                    parse_obj_as(
                        type_=GraphSearchResults,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    async def get(
        self, graph_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Graph]:
        """
        Returns a graph.

        Parameters
        ----------
        graph_id : str
            The graph_id of the graph to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Graph]
            The graph that was retrieved.
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"graph/{jsonable_encoder(graph_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Graph,
                    parse_obj_as(
                        type_=Graph,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    async def delete(
        self, graph_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[SuccessResponse]:
        """
        Deletes a graph. If you would like to delete a user graph, make sure to use user.delete instead.

        Parameters
        ----------
        graph_id : str
            Graph ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SuccessResponse]
            Deleted
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"graph/{jsonable_encoder(graph_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SuccessResponse,
                    parse_obj_as(
                        type_=SuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )

    async def update(
        self,
        graph_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        fact_rating_instruction: typing.Optional[FactRatingInstruction] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Graph]:
        """
        Updates information about a graph.

        Parameters
        ----------
        graph_id : str
            Graph ID

        description : typing.Optional[str]

        fact_rating_instruction : typing.Optional[FactRatingInstruction]

        name : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Graph]
            The updated graph object
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"graph/{jsonable_encoder(graph_id)}",
            method="PATCH",
            json={
                "description": description,
                "fact_rating_instruction": convert_and_respect_annotation_metadata(
                    object_=fact_rating_instruction, annotation=FactRatingInstruction, direction="write"
                ),
                "name": name,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Graph,
                    parse_obj_as(
                        type_=Graph,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        types_api_error_ApiError,
                        parse_obj_as(
                            type_=types_api_error_ApiError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise core_api_error_ApiError(
                status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
            )
        raise core_api_error_ApiError(
            status_code=_response.status_code, headers=dict(_response.headers), body=_response_json
        )
