# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .message import Message
from .role_type import RoleType


class AddThreadMessagesRequest(UniversalBaseModel):
    ignore_roles: typing.Optional[typing.List[RoleType]] = pydantic.Field(default=None)
    """
    Optional list of role types to ignore when adding messages to graph memory.
    The message itself will still be added, retained and used as context for messages
    that are added to a user's graph.
    """

    messages: typing.List[Message] = pydantic.Field()
    """
    A list of message objects, where each message contains a role and content.
    """

    return_context: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Optionally return context block relevant to the most recent messages.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
