# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .role_type import RoleType


class Message(UniversalBaseModel):
    content: str = pydantic.Field()
    """
    The content of the message.
    """

    created_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    The timestamp of when the message was created.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Customizable name of the sender of the message (e.g., "john", "sales_agent").
    """

    processed: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the message has been processed.
    """

    role: RoleType = pydantic.Field()
    """
    The role of message sender (e.g., "user", "system").
    """

    uuid_: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="uuid")] = pydantic.Field(default=None)
    """
    The unique identifier of the message.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
