# This file was auto-generated by Fern from our API Definition.

import typing
from .environment import SynqlyEngineEnvironment
import httpx
from .core.client_wrapper import SyncClientWrapper
from .appsec.client import AppsecClient
from .assets.client import AssetsClient
from .cloudsecurity.client import CloudsecurityClient
from .edr.client import EdrClient
from .hooks.client import HooksClient
from .identity.client import IdentityClient
from .integration_webhooks.client import IntegrationWebhooksClient
from .notifications.client import NotificationsClient
from .operations.client import OperationsClient
from .siem.client import SiemClient
from .sink.client import SinkClient
from .storage.client import StorageClient
from .ticketing.client import TicketingClient
from .vulnerabilities.client import VulnerabilitiesClient
from .core.client_wrapper import AsyncClientWrapper
from .appsec.client import AsyncAppsecClient
from .assets.client import AsyncAssetsClient
from .cloudsecurity.client import AsyncCloudsecurityClient
from .edr.client import AsyncEdrClient
from .hooks.client import AsyncHooksClient
from .identity.client import AsyncIdentityClient
from .integration_webhooks.client import AsyncIntegrationWebhooksClient
from .notifications.client import AsyncNotificationsClient
from .operations.client import AsyncOperationsClient
from .siem.client import AsyncSiemClient
from .sink.client import AsyncSinkClient
from .storage.client import AsyncStorageClient
from .ticketing.client import AsyncTicketingClient
from .vulnerabilities.client import AsyncVulnerabilitiesClient


class SynqlyEngine:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : SynqlyEngineEnvironment
        The environment to use for requests from the client. from .environment import SynqlyEngineEnvironment



        Defaults to SynqlyEngineEnvironment.SYNQLY



    token : typing.Union[str, typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 300 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from synqly import SynqlyEngine

    client = SynqlyEngine(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: SynqlyEngineEnvironment = SynqlyEngineEnvironment.SYNQLY,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 300 if httpx_client is None else None
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(
                timeout=_defaulted_timeout, follow_redirects=follow_redirects
            )
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.appsec = AppsecClient(client_wrapper=self._client_wrapper)
        self.assets = AssetsClient(client_wrapper=self._client_wrapper)
        self.cloudsecurity = CloudsecurityClient(client_wrapper=self._client_wrapper)
        self.edr = EdrClient(client_wrapper=self._client_wrapper)
        self.hooks = HooksClient(client_wrapper=self._client_wrapper)
        self.identity = IdentityClient(client_wrapper=self._client_wrapper)
        self.integration_webhooks = IntegrationWebhooksClient(
            client_wrapper=self._client_wrapper
        )
        self.notifications = NotificationsClient(client_wrapper=self._client_wrapper)
        self.operations = OperationsClient(client_wrapper=self._client_wrapper)
        self.siem = SiemClient(client_wrapper=self._client_wrapper)
        self.sink = SinkClient(client_wrapper=self._client_wrapper)
        self.storage = StorageClient(client_wrapper=self._client_wrapper)
        self.ticketing = TicketingClient(client_wrapper=self._client_wrapper)
        self.vulnerabilities = VulnerabilitiesClient(
            client_wrapper=self._client_wrapper
        )


class AsyncSynqlyEngine:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : SynqlyEngineEnvironment
        The environment to use for requests from the client. from .environment import SynqlyEngineEnvironment



        Defaults to SynqlyEngineEnvironment.SYNQLY



    token : typing.Union[str, typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 300 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from synqly import AsyncSynqlyEngine

    client = AsyncSynqlyEngine(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: SynqlyEngineEnvironment = SynqlyEngineEnvironment.SYNQLY,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 300 if httpx_client is None else None
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(
                timeout=_defaulted_timeout, follow_redirects=follow_redirects
            )
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.appsec = AsyncAppsecClient(client_wrapper=self._client_wrapper)
        self.assets = AsyncAssetsClient(client_wrapper=self._client_wrapper)
        self.cloudsecurity = AsyncCloudsecurityClient(
            client_wrapper=self._client_wrapper
        )
        self.edr = AsyncEdrClient(client_wrapper=self._client_wrapper)
        self.hooks = AsyncHooksClient(client_wrapper=self._client_wrapper)
        self.identity = AsyncIdentityClient(client_wrapper=self._client_wrapper)
        self.integration_webhooks = AsyncIntegrationWebhooksClient(
            client_wrapper=self._client_wrapper
        )
        self.notifications = AsyncNotificationsClient(
            client_wrapper=self._client_wrapper
        )
        self.operations = AsyncOperationsClient(client_wrapper=self._client_wrapper)
        self.siem = AsyncSiemClient(client_wrapper=self._client_wrapper)
        self.sink = AsyncSinkClient(client_wrapper=self._client_wrapper)
        self.storage = AsyncStorageClient(client_wrapper=self._client_wrapper)
        self.ticketing = AsyncTicketingClient(client_wrapper=self._client_wrapper)
        self.vulnerabilities = AsyncVulnerabilitiesClient(
            client_wrapper=self._client_wrapper
        )


def _get_base_url(
    *, base_url: typing.Optional[str] = None, environment: SynqlyEngineEnvironment
) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception(
            "Please pass in either base_url or environment to construct the client"
        )
