# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .resource_type import ResourceType
import pydantic
from .problem_relation import ProblemRelation
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class ResourceReference(UncheckedBaseModel):
    type: ResourceType = pydantic.Field()
    """
    Type of the related resource.
    """

    id: str = pydantic.Field()
    """
    ID of the related resource.
    """

    rel: ProblemRelation = pydantic.Field()
    """
    The way in which the resource relates to the problem.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
