# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...ticketing.types.priority import Priority
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CreateNotificationRequest(UncheckedBaseModel):
    """
    Notification object
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    This field is deprecated and no longer used.
    """

    summary: str = pydantic.Field()
    """
    Notification summary.
    """

    priority: typing.Optional[Priority] = pydantic.Field(default=None)
    """
    Notification priority
    """

    project: typing.Optional[str] = pydantic.Field(default=None)
    """
    Notification project
    """

    status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The current status of the notification.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Notification description.
    """

    issue_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The notification's type.
    """

    creator: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user who created this notification.
    """

    assignee: typing.Optional[str] = pydantic.Field(default=None)
    """
    Who notification is assigned to.
    """

    contact: typing.Optional[str] = pydantic.Field(default=None)
    """
    The notification contact information.
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Associate tags with Notification
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
