# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .agent_type_id import AgentTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Agent(UncheckedBaseModel):
    """
    An Agent (also known as a Sensor) is typically installed on an Operating System (OS) and serves as a specialized software component that can be designed to monitor, detect, collect, archive, or take action. These activities and possible actions are defined by the upstream system controlling the Agent and its intended purpose. For instance, an Agent can include Endpoint Detection & Response (EDR) agents, backup/disaster recovery sensors, Application Performance Monitoring or profiling sensors, and similar software.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the agent or sensor. For example: <code>AWS SSM Agent</code>.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The normalized caption of the type_id value for the agent or sensor. In the case of 'Other' or 'Unknown', it is defined by the event source.
    """

    type_id: typing.Optional[AgentTypeId] = pydantic.Field(default=None)
    """
    The normalized representation of an agent or sensor. E.g., EDR, vulnerability management, APM, backup & recovery, etc.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The UID of the agent or sensor, sometimes known as a Sensor ID or <code>aid</code>.
    """

    uid_alt: typing.Optional[str] = pydantic.Field(default=None)
    """
    An alternative or contextual identifier for the agent or sensor, such as a configuration, organization, or license UID.
    """

    vendor_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The company or author who created the agent or sensor. For example: <code>Crowdstrike</code>.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The semantic version of the agent or sensor, e.g., <code>7.101.50.0</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
