# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .actor import Actor
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Messaging(UncheckedBaseModel):
    """
    The Messaging object encompasses information related to instant messaging, such as sending messages, adding a user to a channel, etc.
    """

    channel_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the channel that the event pertains to.
    """

    channel_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the channel that the event pertains to.
    """

    domains: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of domains participating in the chat session.
    """

    has_foreign_tenant_users: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the event pertains to a channel or group which contains users from a foreign tenant.
    """

    has_guest_users: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the event pertains to a channel or group which contains guest users.
    """

    has_unauthenticated_users: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the event pertains to a channel or group which contains users that are not authenticated.
    """

    members: typing.Optional[typing.List[Actor]] = pydantic.Field(default=None)
    """
    Actors to whom the event pertains.
    """

    message_urls: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    URLs contained in the messages which are relevant to the chat session or event.
    """

    session_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the session that the event pertains to, e.g. a chat specific to a meeting, or a thread within a channel.
    """

    session_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the session.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    UID of the event, e.g. unique message ID.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
