# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.timestamp import Timestamp
import pydantic
import datetime as dt
from .group import Group
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Table(UncheckedBaseModel):
    """
    The table object represents a table within a structured relational database or datastore, which contains columns and rows of data that are able to be create, updated, deleted and queried.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the table was known to have been created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the table was known to have been created.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the table.
    """

    groups: typing.Optional[typing.List[Group]] = pydantic.Field(default=None)
    """
    The group names to which the table belongs.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The most recent time when any changes, updates, or modifications were made within the table.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The most recent time when any changes, updates, or modifications were made within the table.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The table name, ordinarily as assigned by a database administrator.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size of the data table in bytes.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the table.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
