# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class FirewallRule(UncheckedBaseModel):
    """
    The Firewall Rule object represents a specific rule within a firewall policy or event. It contains information about a rule's configuration, properties, and associated actions that define how network traffic is handled by the firewall.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rule category.
    """

    condition: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rule trigger condition for the rule. For example: SQL_INJECTION.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the rule that generated the event.
    """

    duration: typing.Optional[int] = pydantic.Field(default=None)
    """
    The rule response time duration, usually used for challenge completion time.
    """

    match_details: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The data in a request that rule matched. For example: '["10","and","1"]'.
    """

    match_location: typing.Optional[str] = pydantic.Field(default=None)
    """
    The location of the matched data in the source which resulted in the triggered firewall rule. For example: HEADER.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the rule that generated the event.
    """

    rate_limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    The rate limit for a rate-based rule.
    """

    sensitivity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The sensitivity of the firewall rule in the matched event. For example: HIGH.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rule type.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the rule that generated the event.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rule version. For example: <code>1.1</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
