# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .network_connection_info_boundary_id import NetworkConnectionInfoBoundaryId
from .network_connection_info_direction_id import NetworkConnectionInfoDirectionId
from .network_connection_info_protocol_ver_id import NetworkConnectionInfoProtocolVerId
from .session import Session
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class NetworkConnectionInfo(UncheckedBaseModel):
    """
    The Network Connection Information object describes characteristics of a network connection. Defined by D3FEND <a target='_blank' href='https://d3fend.mitre.org/dao/artifact/d3f:NetworkSession/'>d3f:NetworkSession</a>.
    """

    boundary: typing.Optional[str] = pydantic.Field(default=None)
    """
    The boundary of the connection, normalized to the caption of 'boundary_id'. In the case of 'Other', it is defined by the event source. <p> For cloud connections, this translates to the traffic-boundary(same VPC, through IGW, etc.). For traditional networks, this is described as Local, Internal, or External.</p>
    """

    boundary_id: typing.Optional[NetworkConnectionInfoBoundaryId] = pydantic.Field(
        default=None
    )
    """
    <p>The normalized identifier of the boundary of the connection. </p><p> For cloud connections, this translates to the traffic-boundary (same VPC, through IGW, etc.). For traditional networks, this is described as Local, Internal, or External.</p>
    """

    direction: typing.Optional[str] = pydantic.Field(default=None)
    """
    The direction of the initiated connection, traffic, or email, normalized to the caption of the direction_id value. In the case of 'Other', it is defined by the event source.
    """

    direction_id: NetworkConnectionInfoDirectionId = pydantic.Field()
    """
    The normalized identifier of the direction of the initiated connection, traffic, or email.
    """

    protocol_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The TCP/IP protocol name in lowercase, as defined by the Internet Assigned Numbers Authority (IANA). See <a target='_blank' href='https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml'>Protocol Numbers</a>. For example: <code>tcp</code> or <code>udp</code>.
    """

    protocol_num: typing.Optional[int] = pydantic.Field(default=None)
    """
    The TCP/IP protocol number, as defined by the Internet Assigned Numbers Authority (IANA). Use -1 if the protocol is not defined by IANA. See <a target='_blank' href='https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml'>Protocol Numbers</a>. For example: <code>6</code> for TCP and <code>17</code> for UDP.
    """

    protocol_ver: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Internet Protocol version.
    """

    protocol_ver_id: typing.Optional[NetworkConnectionInfoProtocolVerId] = (
        pydantic.Field(default=None)
    )
    """
    The Internet Protocol version identifier.
    """

    session: typing.Optional[Session] = pydantic.Field(default=None)
    """
    The authenticated user or service session.
    """

    tcp_flags: typing.Optional[int] = pydantic.Field(default=None)
    """
    The network connection TCP header flags (i.e., control bits).
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the connection.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
