# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.timestamp import Timestamp
import pydantic
import datetime as dt
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Epss(UncheckedBaseModel):
    """
    The Exploit Prediction Scoring System (EPSS) object describes the estimated probability a vulnerability will be exploited. EPSS is a community-driven effort to combine descriptive information about vulnerabilities (CVEs) with evidence of actual exploitation in-the-wild. (<a target='_blank' href='https://www.first.org/epss/'>EPSS</a>).
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp indicating when the EPSS score was calculated.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp indicating when the EPSS score was calculated.
    """

    percentile: typing.Optional[float] = pydantic.Field(default=None)
    """
    The EPSS score's percentile representing relative importance and ranking of the score in the larger EPSS dataset.
    """

    score: str = pydantic.Field()
    """
    The EPSS score representing the probability [0-1] of exploitation in the wild in the next 30 days (following score publication).
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the EPSS model used to calculate the score.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
