# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .kb_article import KbArticle
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Remediation(UncheckedBaseModel):
    """
    The Remediation object describes the recommended remediation steps to address identified issue(s).
    """

    desc: str = pydantic.Field()
    """
    The description of the remediation strategy.
    """

    kb_article_list: typing.Optional[typing.List[KbArticle]] = pydantic.Field(
        default=None
    )
    """
    A list of KB articles or patches related to an endpoint. A KB Article contains metadata that describes the patch or an update.
    """

    kb_articles: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The KB article/s related to the entity. A KB Article contains metadata that describes the patch or an update.
    """

    references: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of supporting URL/s, references that help describe the remediation strategy.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
