# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .actor_actor_type_id import ActorActorTypeId
from .authorization import Authorization
from .group import Group
from .idp import Idp
from .process import Process
from .session import Session
from .user import User
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Actor(UncheckedBaseModel):
    """
    The Actor object contains details about the user, role, application, service, or process that initiated or performed a specific activity.
    """

    actor_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The actor type, normalized to the caption of the actor_type_id value. In the case of 'Other', it is defined by the data source.
    """

    actor_type_id: typing.Optional[ActorActorTypeId] = pydantic.Field(default=None)
    """
    The normalized identifier of the actor type.
    """

    app_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The client application or service that initiated the activity. This can be in conjunction with the <code>user</code> if present. Note that <code>app_name</code> is distinct from the <code>process</code> if present.
    """

    app_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the client application or service that initiated the activity. This can be in conjunction with the <code>user</code> if present. Note that <code>app_name</code> is distinct from the <code>process.pid</code> or <code>process.uid</code> if present.
    """

    authorizations: typing.Optional[typing.List[Authorization]] = pydantic.Field(
        default=None
    )
    """
    Provides details about an authorization, such as authorization outcome, and any associated policies related to the activity/event.
    """

    groups: typing.Optional[typing.List[Group]] = pydantic.Field(default=None)
    """
    Groups which are pertinent to the action. For example, the team name for Teams, where the user may not necessarily be a member of the group, but it is still relevant to the action taken.
    """

    idp: typing.Optional[Idp] = pydantic.Field(default=None)
    """
    This object describes details about the Identity Provider used.
    """

    invoked_by: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the service that invoked the activity as described in the event.
    """

    process: typing.Optional[Process] = pydantic.Field(default=None)
    """
    The process that initiated the activity.
    """

    session: typing.Optional[Session] = pydantic.Field(default=None)
    """
    The user session from which the activity was initiated.
    """

    user: typing.Optional[User] = pydantic.Field(default=None)
    """
    The user that initiated the activity or the user context from which the activity was initiated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
