# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.timestamp import Timestamp
import pydantic
import datetime as dt
from .related_event import RelatedEvent
from .remediation import Remediation
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Finding(UncheckedBaseModel):
    """
    The Finding object describes metadata related to a security finding generated by a security tool or system.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was created.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the reported finding.
    """

    first_seen_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was first observed.
    """

    first_seen_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was first observed.
    """

    last_seen_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was most recently observed.
    """

    last_seen_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was most recently observed.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was last modified.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was last modified.
    """

    product_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the product that reported the finding.
    """

    related_events: typing.Optional[typing.List[RelatedEvent]] = pydantic.Field(
        default=None
    )
    """
    Describes events and/or other findings related to the finding as identified by the security product.
    """

    remediation: typing.Optional[Remediation] = pydantic.Field(default=None)
    """
    Describes the recommended remediation steps to address identified issue(s).
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The URL pointing to the source of the finding.
    """

    supporting_data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(
        default=None
    )
    """
    Additional data supporting a finding as provided by security tool
    """

    title: str = pydantic.Field()
    """
    A title or a brief phrase summarizing the reported finding.
    """

    types: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    One or more types of the reported finding.
    """

    uid: str = pydantic.Field()
    """
    The unique identifier of the reported finding.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
