# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.timestamp import Timestamp
import pydantic
import datetime as dt
from .group import Group
from .database_type_id import DatabaseTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Database(UncheckedBaseModel):
    """
    The database object is used for databases which are typically datastore services that contain an organized collection of structured and unstructured data or a types of data.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the database was known to have been created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the database was known to have been created.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the database.
    """

    groups: typing.Optional[typing.List[Group]] = pydantic.Field(default=None)
    """
    The group names to which the database belongs.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The most recent time when any changes, updates, or modifications were made within the database.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The most recent time when any changes, updates, or modifications were made within the database.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The database name, ordinarily as assigned by a database administrator.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size of the database in bytes.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The database type.
    """

    type_id: DatabaseTypeId = pydantic.Field()
    """
    The normalized identifier of the database type.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the database.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
